/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests.util;

import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.spi.AbstractCredentialsProvider;
import org.eclipse.userstorage.spi.Credentials;

public class TestCredentialsProvider
extends AbstractCredentialsProvider {
    private static final File CREDENTIALS_FILE = new File(System.getProperty("userstorage.credentials.file", "userstorage.credentials"));

    public Credentials provideCredentials(IStorageService service, boolean reauthentication) {
        if (CREDENTIALS_FILE.exists()) {
            System.out.println("Reading credentials from file " + CREDENTIALS_FILE);
            System.out.println();
            return (Credentials)IOUtil.readObject((File)CREDENTIALS_FILE);
        }
        Credentials credentials = new LoginDialog().getCredentials();
        if (credentials == null) {
            throw new RuntimeException("No credentials entered!");
        }
        System.out.println("Storing credentials in file " + CREDENTIALS_FILE);
        System.out.println();
        IOUtil.writeObject((File)CREDENTIALS_FILE, (Object)credentials);
        return credentials;
    }

    private static class LoginDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private Credentials credentials;

        public LoginDialog() {
            this.setTitle("Login");
            this.setModal(true);
            final JTextField userField = new JTextField(15);
            final JPasswordField passwordField = new JPasswordField(15);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new GridLayout(3, 2));
            contentPane.add(new JLabel("Username:"));
            contentPane.add(userField);
            contentPane.add(new JLabel("Password:"));
            contentPane.add(passwordField);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String username = userField.getText();
                    String password = new String(passwordField.getPassword());
                    if (!LoginDialog.isEmpty(username) && !LoginDialog.isEmpty(password)) {
                        LoginDialog.this.credentials = new Credentials(username, password);
                    }
                    LoginDialog.this.close();
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoginDialog.this.close();
                }
            });
            contentPane.add(okButton);
            contentPane.add(cancelButton);
            userField.setText("eclipse_test_123456789");
            passwordField.requestFocus();
            this.pack();
            this.setCenterLocation();
            this.setVisible(true);
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        private void setCenterLocation() {
            try {
                Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                int n = graphicsDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GraphicsDevice device = graphicsDeviceArray[n2];
                    Rectangle bounds = device.getDefaultConfiguration().getBounds();
                    if (bounds.contains(mousePoint)) {
                        this.setLocation((bounds.width - this.getWidth()) / 2 + bounds.x, (bounds.height - this.getHeight()) / 2 + bounds.y);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void close() {
            this.setVisible(false);
            this.dispose();
        }

        private static boolean isEmpty(String str) {
            return str == null || str.length() == 0;
        }
    }
}

