/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.remotevm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.eclipse.ve.internal.java.remotevm.IBeanPropertyEditorDialog;
import org.eclipse.ve.internal.java.remotevm.IPropertyEditorDialogListener;
import org.eclipse.ve.internal.java.remotevm.PropertyCustomComponentLayout;
import org.eclipse.ve.internal.java.remotevm.RemoteVMMessages;

public final class BeanPropertyEditorJFrame
extends JFrame
implements IBeanPropertyEditorDialog {
    private transient List fListeners = new ArrayList(1);
    private JPanel propertyEditorContainer;
    private Component propertyEditorComponent;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonRow;
    private JPanel buttonGrid;

    public BeanPropertyEditorJFrame() {
        super(RemoteVMMessages.getString("PropertyEditor.Dialog.Title"));
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("customiz.gif")));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(SystemColor.control);
        this.propertyEditorContainer = new JPanel();
        this.propertyEditorContainer.setLayout(new PropertyCustomComponentLayout());
        this.getContentPane().add((Component)this.propertyEditorContainer, "Center");
        this.buttonRow = new JPanel();
        this.buttonRow.setLayout(new FlowLayout(2));
        this.buttonGrid = new JPanel();
        this.buttonRow.add(this.buttonGrid);
        this.buttonGrid.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonGrid.add(this.getOKButton());
        this.buttonGrid.add(this.getCancelButton());
        this.getContentPane().add((Component)this.buttonRow, "South");
        this.getRootPane().setDefaultButton(this.getOKButton());
        this.addWindowListenersToFrame(this);
    }

    public void addListener(IPropertyEditorDialogListener aListener) {
        this.fListeners.add(aListener);
    }

    protected void addWindowListenersToFrame(Window aFrame) {
        aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BeanPropertyEditorJFrame.this.doCancel();
            }
        });
    }

    protected void closeDialog() {
        if (this.propertyEditorComponent != null && this.propertyEditorComponent instanceof IPropertyEditorDialogListener) {
            this.removeListener((IPropertyEditorDialogListener)((Object)this.propertyEditorComponent));
        }
        this.dispose();
    }

    public void doCancel() {
        this.notifyRevertPropertyValue();
        this.closeDialog();
    }

    public void doOK() {
        this.notifySavePropertyValue();
        this.closeDialog();
    }

    protected JButton getCancelButton() {
        if (this.cancelButton != null) {
            return this.cancelButton;
        }
        this.cancelButton = new JButton(RemoteVMMessages.getString("PropertyEditor.Dialog.Button.Cancel"));
        this.cancelButton.setBackground(SystemColor.control);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BeanPropertyEditorJFrame.this.doCancel();
            }
        });
        return this.cancelButton;
    }

    protected JButton getOKButton() {
        if (this.okButton != null) {
            return this.okButton;
        }
        this.okButton = new JButton(RemoteVMMessages.getString("PropertyEditor.Dialog.Button.OK"));
        this.okButton.setBackground(SystemColor.control);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BeanPropertyEditorJFrame.this.doOK();
            }
        });
        return this.okButton;
    }

    protected void notifyRevertPropertyValue() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IPropertyEditorDialogListener aListener = (IPropertyEditorDialogListener)iter.next();
            aListener.revertPropertyValue();
        }
    }

    protected void notifySavePropertyValue() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IPropertyEditorDialogListener aListener = (IPropertyEditorDialogListener)iter.next();
            aListener.savePropertyValue();
        }
    }

    public void removeListener(IPropertyEditorDialogListener aListener) {
        this.fListeners.remove(aListener);
    }

    public void setPropertyEditor(Component aComponent) {
        if (this.propertyEditorComponent != null) {
            this.propertyEditorContainer.remove(this.propertyEditorComponent);
        }
        if (this.propertyEditorComponent instanceof IPropertyEditorDialogListener) {
            this.removeListener((IPropertyEditorDialogListener)((Object)this.propertyEditorComponent));
        }
        this.buttonRow.setBackground(null);
        this.propertyEditorComponent = aComponent;
        if (this.propertyEditorComponent != null) {
            this.propertyEditorContainer.add(this.propertyEditorComponent);
            if (aComponent instanceof IPropertyEditorDialogListener) {
                this.addListener((IPropertyEditorDialogListener)((Object)aComponent));
            }
            if (this.propertyEditorComponent.getBackground() != this.propertyEditorContainer.getBackground()) {
                this.buttonRow.setBackground(this.propertyEditorComponent.getBackground());
            }
            this.buttonGrid.setBackground(this.propertyEditorComponent.getBackground());
        }
    }
}

