/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.adapters.jdom.JavaMethodJDOMAdaptor;
import org.eclipse.jem.internal.java.InheritanceCycleException;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.TypeKind;
import org.eclipse.jem.internal.java.adapters.IJavaClassAdaptor;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdapterFactory;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.plugin.JavaPlugin;

public class JavaClassJDOMAdaptor
extends JDOMAdaptor
implements IJavaClassAdaptor {
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    protected IType sourceType = null;
    protected JavaReflectionAdapterFactory adapterFactory;
    private Map typeResolutionCache = new HashMap(25);

    public JavaClassJDOMAdaptor(Notifier target, IJavaProject workingProject, JavaReflectionAdapterFactory inFactory) {
        super(target, workingProject);
        this.setAdapterFactory(inFactory);
    }

    protected void addFields() {
        try {
            XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
            IField[] fields = this.getSourceType().getFields();
            EList targetFields = this.getJavaClassTarget().getFieldsGen();
            int i = 0;
            while (i < fields.length) {
                targetFields.add(this.createJavaField(fields[i], resource));
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void addMethods() {
        try {
            XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
            IMethod[] methods = this.getSourceType().getMethods();
            EList targetMethods = this.getJavaClassTarget().getMethodsGen();
            Method method = null;
            JavaMethodJDOMAdaptor adaptor = null;
            int i = 0;
            while (i < methods.length) {
                adaptor = null;
                method = this.createJavaMethod(methods[i], resource);
                targetMethods.add(method);
                adaptor = (JavaMethodJDOMAdaptor)ReflectionAdaptor.retrieveAdaptorFrom((EObject)method);
                if (adaptor != null) {
                    adaptor.setSourceMethod(methods[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void clearSource() {
        this.sourceType = null;
    }

    protected boolean flushFields() {
        this.getJavaClassTarget().getFieldsGen().clear();
        return true;
    }

    protected boolean flushImplements() {
        this.getJavaClassTarget().getImplementsInterfacesGen().clear();
        return true;
    }

    protected boolean flushMethods() {
        this.getJavaClassTarget().getMethodsGen().clear();
        return true;
    }

    protected boolean flushModifiers() {
        JavaClass javaClassTarget = (JavaClass)this.getTarget();
        javaClassTarget.setAbstract(false);
        javaClassTarget.setFinal(false);
        javaClassTarget.setPublic(false);
        javaClassTarget.setKind(TypeKind.UNDEFINED_LITERAL);
        return true;
    }

    protected boolean flushInnerClasses() {
        this.getJavaClassTarget().getDeclaredClassesGen().clear();
        return true;
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        if (clearCachedModelObject) {
            this.setSourceType(null);
        }
        this.typeResolutionCache.clear();
        return this.primFlushReflectedValues();
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
        this.getJavaClassTarget().setReflected(false);
        super.postFlushReflectedValuesIfNecessary(isExisting);
    }

    protected boolean flushSuper() {
        EList targetSupers = this.getJavaClassTarget().getESuperTypesGen();
        targetSupers.clear();
        return true;
    }

    protected JavaReflectionAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected IType getBinaryType() {
        return this.getBinaryType(((JavaClass)this.getTarget()).getQualifiedName());
    }

    protected JavaClassImpl getJavaClassTarget() {
        return (JavaClassImpl)this.getTarget();
    }

    public Object getReflectionSource() {
        return this.getSourceType();
    }

    public IType getSourceType() {
        if (this.sourceType == null) {
            JavaClassImpl javaClass = (JavaClassImpl)this.getTarget();
            this.sourceType = JDOMSearchHelper.findType(javaClass.getJavaPackage().getName(), javaClass.primGetName(), this.getSourceProject());
        }
        return this.sourceType;
    }

    protected IType getType() {
        return this.getSourceType();
    }

    protected Map getTypeResolutionCache() {
        return this.typeResolutionCache;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean isSourceTypeFromBinary() {
        if (this.getSourceType() == null) {
            return false;
        }
        return this.getSourceType().isBinary();
    }

    protected boolean primFlushReflectedValues() {
        boolean result = this.flushModifiers();
        result &= this.flushSuper();
        result &= this.flushImplements();
        result &= this.flushMethods();
        result &= this.flushFields();
        return result &= this.flushInnerClasses();
    }

    protected JavaClass reflectJavaClass(String qualifiedName) {
        IType type = JDOMSearchHelper.findType(qualifiedName, true, this.getSourceProject(), this);
        if (type != null) {
            return this.reflectJavaClass(type);
        }
        return this.createJavaClassRef(qualifiedName);
    }

    protected JavaClass reflectJavaClass(IType aType) {
        if (aType != null) {
            JavaClassJDOMAdaptor adaptor;
            JavaClass javaClass = (JavaClass)JavaClassImpl.reflect((String)aType.getFullyQualifiedName(), (EObject)((EObject)this.getTarget()));
            if (javaClass != null && (adaptor = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)javaClass.eAdapters(), (Object)"JavaReflection")) != null) {
                adaptor.setSourceType(aType);
            }
            return javaClass;
        }
        return null;
    }

    public boolean reflectValues() {
        super.reflectValues();
        this.primFlushReflectedValues();
        boolean isHeadless = WorkbenchResourceHelper.isHeadless();
        if (this.getSourceProject() != null && this.getSourceType() != null && this.getSourceType().exists()) {
            this.setModifiers();
            this.setNaming();
            try {
                this.setSuper();
            }
            catch (InheritanceCycleException e) {
                JavaPlugin.getDefault().getMsgLogger().log((Throwable)e);
            }
            this.setImplements();
            this.addMethods();
            this.addFields();
            this.reflectInnerClasses();
            if (isHeadless) {
                this.registerWithFactory();
                return true;
            }
        }
        if (isHeadless) {
            return false;
        }
        this.registerWithFactory();
        return true;
    }

    private void registerWithFactory() {
        this.getAdapterFactory().registerReflection(this.getJavaClassTarget().getQualifiedNameForReflection(), (ReflectionAdaptor)this);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8 && notification.getOldValue() == this && notification.getNotifier() == this.getTarget()) {
            this.getAdapterFactory().unregisterReflection(this.getJavaClassTarget().getQualifiedNameForReflection());
        }
    }

    protected void setAdapterFactory(JavaReflectionAdapterFactory inFactory) {
        this.adapterFactory = inFactory;
    }

    protected void setImplements() {
        try {
            String[] interfaceNames = this.getSourceType().getSuperInterfaceNames();
            EList list = this.getJavaClassTarget().getImplementsInterfacesGen();
            int i = 0;
            while (i < interfaceNames.length) {
                JavaClass ref = this.reflectJavaClass(interfaceNames[i]);
                list.add(ref);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void setModifiers() {
        JavaClass javaClassTarget = (JavaClass)this.getTarget();
        try {
            javaClassTarget.setAbstract(Flags.isAbstract((int)this.getSourceType().getFlags()));
            javaClassTarget.setFinal(Flags.isFinal((int)this.getSourceType().getFlags()));
            javaClassTarget.setPublic(Flags.isPublic((int)this.getSourceType().getFlags()));
            if (this.getSourceType().isClass()) {
                javaClassTarget.setKind(TypeKind.CLASS_LITERAL);
            } else {
                javaClassTarget.setKind(TypeKind.INTERFACE_LITERAL);
            }
        }
        catch (JavaModelException npe) {
            JavaPlugin.getDefault().getMsgLogger().log((Object)ResourceHandler.getString((String)"Error_Introspecting_Flags_ERROR_", (Object[])new Object[]{javaClassTarget.getQualifiedName(), npe.getMessage()}), 5);
        }
    }

    protected void setNaming() {
    }

    protected void setSourceType(IType aType) {
        this.sourceType = aType;
    }

    protected void setSuper() throws InheritanceCycleException {
        String superName = null;
        try {
            if (!this.getSourceType().isInterface()) {
                superName = this.getSourceType().getSuperclassName();
                if (superName == null && !this.getSourceType().getFullyQualifiedName().equals(OBJECT_TYPE_NAME)) {
                    superName = OBJECT_TYPE_NAME;
                }
                if (superName != null) {
                    JavaClass javaClassTarget = (JavaClass)this.getTarget();
                    javaClassTarget.setSupertype(this.reflectJavaClass(superName));
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean sourceTypeExists() {
        return this.getSourceType() != null;
    }

    protected void reflectInnerClasses() {
        IType[] innerClasses = null;
        try {
            innerClasses = this.getSourceType().getTypes();
        }
        catch (JavaModelException javaModelException) {}
        if (innerClasses != null && innerClasses.length != 0) {
            EList declaredClasses = this.getJavaClassTarget().getDeclaredClassesGen();
            ResourceSet set = this.getTargetResource().getResourceSet();
            String packageName = this.getSourceType().getPackageFragment().getElementName();
            int i = 0;
            while (i < innerClasses.length) {
                JavaClass inner = (JavaClass)JavaClassImpl.reflect((String)packageName, (String)innerClasses[i].getTypeQualifiedName(), (ResourceSet)set);
                declaredClasses.add(inner);
                ++i;
            }
        }
    }
}

