/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.adapters.jdom.JavaModelListener;
import org.eclipse.jem.internal.plugin.JavaPlugin;

public class JavaReflectionSynchronizer
extends JavaModelListener {
    private static final IPath CLASSPATH_PATH = new Path(".classpath");
    protected JavaJDOMAdapterFactory fAdapterFactory;
    protected boolean flushedAll = false;
    protected List flushTypes = new ArrayList();
    protected List notifications = new ArrayList();

    public JavaReflectionSynchronizer(JavaJDOMAdapterFactory synchronizee) {
        this.fAdapterFactory = synchronizee;
    }

    protected Notification doFlush(IType element) {
        return this.getAdapterFactory().flushReflectionNoNotification(element.getFullyQualifiedName());
    }

    protected void flush(IType element) {
        if (!this.flushTypes.contains(element)) {
            this.flushTypes.add(element);
        }
    }

    protected void flushPackage(String packageName, boolean noFlushIfSourceFound) {
        this.notifications.addAll(this.getAdapterFactory().flushPackageNoNotification(packageName, true));
    }

    protected JavaJDOMAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    private boolean isClassPathChange(IJavaElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    public void processContentChanged(IJavaElementDelta delta) {
        if (delta == null) {
            return;
        }
        IJavaElement element = delta.getElement();
        if (element.getElementType() == 5 && (delta.getFlags() & 0x3B) != 0) {
            this.getAdapterFactory().notifyContentChanged((ICompilationUnit)element);
        }
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        if (!element.isWorkingCopy()) {
            switch (delta.getKind()) {
                case 4: {
                    try {
                        IType[] flushTypes = element.getAllTypes();
                        int i = 0;
                        while (i < flushTypes.length) {
                            this.flush(flushTypes[i]);
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                case 1: 
                case 2: {
                    this.disAssociateSourcePlusInner(this.getFullNameFromElement((IJavaElement)element));
                    return;
                }
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2) {
                if (element.equals(this.getAdapterFactory().getJavaProject())) {
                    this.stopSynchronizer();
                } else {
                    this.flushAll();
                }
                return;
            }
            if (delta.getKind() == 1 || this.isClasspathResourceChange(delta)) {
                this.flushAll();
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(this.getFullNameFromElement((IJavaElement)element));
            return;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int ii = 0;
        while (ii < children.length) {
            this.processDelta(children[ii]);
            ++ii;
        }
    }

    private boolean isClasspathResourceChange(IJavaElementDelta delta) {
        IResourceDelta[] resources = delta.getResourceDeltas();
        if (resources == null) {
            return false;
        }
        IPath path = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKind() == 4 && (path = resources[i].getProjectRelativePath()).equals((Object)CLASSPATH_PATH)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.flushedAll) {
            return;
        }
        if (this.isClassPathChange(delta)) {
            this.flushAll();
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                if (delta.getAffectedChildren().length != 0) break;
                this.flushPackage(delta.getElement().getElementName(), true);
                break;
            }
            case 2: {
                if (delta.getAffectedChildren().length != 0) break;
                this.getAdapterFactory().flushPackage(delta.getElement().getElementName(), false);
                break;
            }
            default: {
                super.processJavaElementChanged(element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(element.getFullyQualifiedName());
        } else {
            this.flush(element);
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processRemoveOrAdd(ICompilationUnit element) {
        this.disAssociateSource(this.getFullNameFromElement((IJavaElement)element));
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (element == null || name.length() <= 5 || !name.substring(name.length() - 5).equals(".java")) {
            JavaPlugin.getDefault().getMsgLogger().log((Object)("Invalid .java file: " + name), 2);
            int index = name.lastIndexOf(".");
            name = index >= 0 ? String.valueOf(name.substring(0, index)) + ".java" : String.valueOf(name) + ".java";
        }
        if (element.getParent().getElementName() == null || element.getParent().getElementName().length() == 0) {
            return name.substring(0, name.length() - 5);
        }
        return String.valueOf(element.getParent().getElementName()) + "." + name.substring(0, name.length() - 5);
    }

    public void stopSynchronizer() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected boolean isInClasspath(IJavaProject javaProject) {
        IJavaProject adapterJavaProject = this.getAdapterFactory().getJavaProject();
        if (javaProject.equals(adapterJavaProject)) {
            return true;
        }
        return this.isInClasspath(javaProject, adapterJavaProject, true, new HashSet());
    }

    protected boolean isInClasspath(IJavaProject testProject, IJavaProject targetProject, boolean isFirstLevel, Set visited) {
        if (visited.contains(targetProject)) {
            return false;
        }
        visited.add(targetProject);
        IClasspathEntry[] entries = null;
        try {
            entries = targetProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        IJavaProject proj = null;
        ArrayList<IJavaProject> projects = null;
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                IClasspathEntry resEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                proj = this.getJavaProject(entry);
                if (isFirstLevel || resEntry.isExported()) {
                    if (proj.equals(testProject)) {
                        return true;
                    }
                    if (projects == null) {
                        projects = new ArrayList<IJavaProject>();
                    }
                    projects.add(proj);
                }
            }
            ++i;
        }
        return this.isInClasspath(testProject, projects, false, visited);
    }

    protected boolean isInClasspath(IJavaProject testProject, List someJavaProjects, boolean isFirstLevel, Set visited) {
        if (someJavaProjects == null) {
            return false;
        }
        int size = someJavaProjects.size();
        IJavaProject javaProj = null;
        int i = 0;
        if (i < size) {
            javaProj = (IJavaProject)someJavaProjects.get(i);
            return this.isInClasspath(testProject, javaProj, isFirstLevel, visited);
        }
        return false;
    }

    protected IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = this.getWorkspaceRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elementChanged(ElementChangedEvent event) {
        try {
            this.flushTypes.clear();
            this.notifications.clear();
            super.elementChanged(event);
            this.flushTypes();
            this.processNotifications();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.flushedAll = false;
            this.flushTypes.clear();
            this.notifications.clear();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.flushedAll = false;
            this.flushTypes.clear();
            this.notifications.clear();
            return;
        }
    }

    private void flushTypes() {
        if (!this.flushTypes.isEmpty()) {
            IType type = null;
            int i = 0;
            while (i < this.flushTypes.size()) {
                type = (IType)this.flushTypes.get(i);
                Notification not = this.doFlush(type);
                if (not != null) {
                    this.notifications.add(not);
                }
                ++i;
            }
        }
    }

    private void processNotifications() {
        int i = 0;
        while (i < this.notifications.size()) {
            Notification not = (Notification)this.notifications.get(i);
            Notifier notifier = (Notifier)not.getNotifier();
            if (notifier != null) {
                try {
                    notifier.eNotify(not);
                }
                catch (Exception e) {
                    JavaPlugin.getDefault().getMsgLogger().log((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void disAssociateSource(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSource(qualifiedName, false);
        if (not != null) {
            this.notifications.add(not);
        }
    }

    protected void disAssociateSourcePlusInner(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSourcePlusInner(qualifiedName, false);
        if (not != null) {
            this.notifications.add(not);
        }
    }

    protected void flushAll() {
        this.notifications.addAll(this.getAdapterFactory().flushAllNoNotification());
        this.flushedAll = true;
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        if (!this.flushedAll) {
            super.processChildren(element, delta);
        }
    }

    public void processDelta(IJavaElementDelta delta) {
        if (!this.flushedAll) {
            super.processDelta(delta);
        }
    }
}

