/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.plugin;

import com.ibm.etools.emf.workbench.EMFNature;
import com.ibm.etools.emf.workbench.EMFNatureContributor;
import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.WorkbenchURIConverter;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.adapters.JavaXMIFactoryImpl;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.internal.plugin.IJavaMOFNature;
import org.eclipse.jem.internal.plugin.IJavaProjectInfo;
import org.eclipse.jem.internal.plugin.JavaPlugin;
import org.eclipse.jem.internal.plugin.ProjectUtilities;

public abstract class AbstractJavaMOFNatureRuntime
implements IJavaMOFNature,
IProjectNature,
EMFNatureContributor {
    protected static Set REGISTERED_NATURE_IDS = new HashSet();
    protected IProject project;
    protected EMFNature emfNature;
    protected boolean hasConfigured = false;

    protected void addAdapterFactories(ResourceSet aSet) {
        this.addJavaReflectionAdapterFactories(aSet);
    }

    protected void addJavaReflectionAdapterFactories(ResourceSet aSet) {
        AdapterFactory factory;
        EList factories = aSet.getAdapterFactories();
        if (!factories.isEmpty() && (factory = EcoreUtil.getAdapterFactory((List)factories, (Object)"JavaReflection")) != null) {
            factories.remove(factory);
        }
        factories.add(new JavaJDOMAdapterFactory(this.getJavaProject()));
    }

    protected static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        ProjectUtilities.addNatureToProject(proj, natureId);
    }

    public void configure() throws CoreException {
        if (!this.hasConfigured) {
            this.hasConfigured = true;
            this.primConfigure();
        }
    }

    protected void primConfigure() throws CoreException {
    }

    protected void createEmfNature() throws CoreException {
        EMFWorkbenchPlugin.getResourceHelper().createEMFNature(this.getProject(), (EMFNatureContributor)this);
    }

    public void contributeToNature(EMFNature aNature) {
        if (this.emfNature == aNature) {
            return;
        }
        this.emfNature = aNature;
        ProjectResourceSet set = aNature.getResourceSet();
        set.getResourceFactoryRegistry().getProtocolToFactoryMap().put("java", JavaXMIFactoryImpl.INSTANCE);
        WorkbenchURIConverter conv = (WorkbenchURIConverter)set.getURIConverter();
        this.configureURIConverter(conv);
        this.addAdapterFactories((ResourceSet)set);
    }

    public IFolder createFolder(String aProjectRelativePathString) throws CoreException {
        if (aProjectRelativePathString != null && aProjectRelativePathString.length() > 0) {
            return this.createFolder((IPath)new Path(aProjectRelativePathString));
        }
        return null;
    }

    public IFolder createFolder(IPath aProjectRelativePath) throws CoreException {
        if (aProjectRelativePath != null && !aProjectRelativePath.isEmpty()) {
            IFolder folder = this.getWorkspace().getRoot().getFolder(this.getProjectPath().append(aProjectRelativePath));
            if (!folder.exists()) {
                com.ibm.etools.emf.workbench.ProjectUtilities.ensureContainerNotReadOnly((IResource)folder);
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    protected void createFolders() throws CoreException {
        IPath sourcePath = this.getSourcePath();
        if (sourcePath != null) {
            this.createFolder(sourcePath.toString());
            this.createFolder(this.getJavaOutputPath().toString());
        }
    }

    protected void configureURIConverter(WorkbenchURIConverter conv) {
        conv.removeInputContainer((IContainer)this.getProject());
        conv.addInputContainer(this.getMofRoot());
    }

    public void deconfigure() throws CoreException {
    }

    protected void deleteFile(IFile aFile) throws CoreException {
        if (aFile != null && aFile.exists()) {
            aFile.delete(true, null);
        }
    }

    public void deleteResource(Resource aResource) throws CoreException {
        if (aResource != null) {
            this.deleteFile(this.getFile(aResource));
        }
    }

    public boolean fileExists(String aFileName) {
        if (aFileName == null) {
            return false;
        }
        Path path = new Path(aFileName);
        if (path.isAbsolute()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).exists();
        }
        return this.getWorkbenchURIConverter().canGetUnderlyingResource(aFileName);
    }

    public ResourceSet getContext() {
        return this.getResourceSet();
    }

    public ResourceSet getResourceSet() {
        return this.getEmfNature().getResourceSet();
    }

    public boolean hasContext() {
        return this.hasResourceSet();
    }

    public boolean hasResourceSet() {
        return this.emfNature != null && this.emfNature.hasResourceSet();
    }

    protected IPath getSourcePath() {
        return ProjectUtilities.getSourcePathOrFirst(this.getProject(), this.getSourcePathKey());
    }

    protected IPath getDefaultSourcePath() {
        Path path = new Path(this.getProject().getName());
        path = path.append(this.getDefaultSourcePathString());
        path = path.makeAbsolute();
        return path;
    }

    protected String getDefaultSourcePathString() {
        return "source";
    }

    protected EMFNature getEmfNature() {
        if (this.emfNature == null) {
            try {
                this.createEmfNature();
            }
            catch (CoreException ex) {
                JavaPlugin.getDefault().getMsgLogger().log((Throwable)ex);
            }
        }
        return this.emfNature;
    }

    public IFile getFile(Resource aResource) {
        if (aResource == null) {
            return null;
        }
        return EMFWorkbenchPlugin.getResourceHelper().getFile(aResource);
    }

    public IFile getFile(String aFileName) {
        return this.getWorkbenchURIConverter().getFile(aFileName);
    }

    public JavaModel getJavaModel() {
        return ProjectUtilities.getJavaModel();
    }

    public IFolder getJavaOutputFolder() {
        return this.getProject().getFolder(this.getJavaProjectOutputLocation().removeFirstSegments(1));
    }

    protected IPath getJavaOutputPath() {
        return this.getJavaProjectOutputLocation().removeFirstSegments(1);
    }

    public IJavaProject getJavaProject() {
        JavaModel jm = this.getJavaModel();
        return jm.getJavaProject((IResource)this.getProject());
    }

    protected IPath getJavaProjectOutputLocation() {
        try {
            IJavaProject javaProj = this.getJavaProject();
            if (!javaProj.isOpen()) {
                javaProj.open(null);
            }
            return javaProj.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IContainer getMofRoot() {
        return this.getSourceFolder();
    }

    public abstract String getNatureID();

    protected abstract String getPluginID();

    public IProject getProject() {
        return this.project;
    }

    protected IPath getProjectPath() {
        return this.getProject().getFullPath();
    }

    protected String getProjectServerValue(String key) {
        if (key == null) {
            return null;
        }
        try {
            QualifiedName wholeName = this.qualifiedKey(key);
            return this.getProject().getPersistentProperty(wholeName);
        }
        catch (CoreException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static IJavaMOFNature getRegisteredRuntime(IProject project) {
        IJavaMOFNature nature = null;
        if (project != null && project.isAccessible()) {
            Iterator it = REGISTERED_NATURE_IDS.iterator();
            while (it.hasNext()) {
                String natureID = (String)it.next();
                try {
                    nature = (IJavaMOFNature)project.getNature(natureID);
                }
                catch (CoreException coreException) {}
                if (nature == null) continue;
                return nature;
            }
        }
        return nature;
    }

    public static String getRegisteredRuntimeID(IProject project) {
        String natureID = null;
        if (project != null && project.isAccessible()) {
            IJavaMOFNature nature = null;
            Iterator it = REGISTERED_NATURE_IDS.iterator();
            while (it.hasNext()) {
                natureID = (String)it.next();
                try {
                    nature = (IJavaMOFNature)project.getNature(natureID);
                }
                catch (CoreException coreException) {}
                if (nature == null) continue;
                return natureID;
            }
        }
        return null;
    }

    public IFolder getSourceFolder() {
        return (IFolder)ProjectUtilities.getSourceFolderOrFirst(this.getProject(), this.getSourcePathKey());
    }

    public List getSourceFolders() {
        return ProjectUtilities.getSourceContainers(this.getProject());
    }

    protected String getSourcePathKey() {
        return "sourcepath";
    }

    protected WorkbenchURIConverter getWorkbenchURIConverter() {
        return (WorkbenchURIConverter)this.getContext().getURIConverter();
    }

    public IWorkspace getWorkspace() {
        return this.getProject().getWorkspace();
    }

    public Resource getXmiResource(String uri) {
        return this.getResource(URI.createURI((String)uri));
    }

    public Resource getResource(URI uri) {
        try {
            return this.getResourceSet().getResource(uri, true);
        }
        catch (WrappedException ex) {
            if (!EMFWorkbenchPlugin.getResourceHelper().isResourceNotFound(ex)) {
                throw ex;
            }
            return null;
        }
    }

    public ResourceSet getXmiResourceSet() {
        return this.getResourceSet();
    }

    protected void initializeDependentComponents() {
        JavaInit.init();
    }

    public void initializeFromInfo(IJavaProjectInfo info) throws CoreException {
        this.createFolders();
    }

    public Resource makeXmiResource(String uri) {
        return this.createResource(URI.createURI((String)uri));
    }

    public Resource makeXmiResource(String uri, EList anExtent) {
        Resource res = this.makeXmiResource(uri);
        if (res != null) {
            res.getContents().addAll(anExtent);
        }
        return res;
    }

    public Resource createResource(URI uri) {
        return this.getResourceSet().createResource(uri);
    }

    private QualifiedName qualifiedKey(String key) {
        return new QualifiedName(this.getPluginID(), key);
    }

    public static void registerNatureID(String natureID) {
        REGISTERED_NATURE_IDS.add(natureID);
    }

    public void setProject(IProject newProject) {
        this.project = newProject;
    }

    protected void setProjectServerValue(String key, String value) {
        if (key != null) {
            try {
                QualifiedName wholeName = this.qualifiedKey(key);
                this.getProject().setPersistentProperty(wholeName, value);
            }
            catch (CoreException exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    protected void setSourcePath(String uriSegment) {
        this.setProjectServerValue(this.getSourcePathKey(), uriSegment);
    }

    public void shutdown() {
        if (this.getResourceSet() != null) {
            ((ProjectResourceSet)this.getResourceSet()).release();
        }
    }

    public List getLibaryFolders() {
        return ProjectUtilities.getLibaryContainers(this.getProject());
    }

    public JavaClass getJavaClass(IFile aFile) {
        if (aFile == null) {
            return null;
        }
        List folders = this.getSourceFolders();
        folders.addAll(this.getLibaryFolders());
        IFolder folder = null;
        IPath filePath = aFile.getProjectRelativePath();
        if (folders != null) {
            int i = 0;
            while (i < folders.size()) {
                folder = (IFolder)folders.get(i);
                IPath folderPath = folder.getProjectRelativePath();
                int segments = filePath.matchingFirstSegments(folderPath);
                if (segments > 0) {
                    IPath javaPath = filePath.removeFirstSegments(segments);
                    javaPath = javaPath.removeFileExtension();
                    String qualifiedName = javaPath.toString().replace('/', '.');
                    return (JavaClass)JavaClassImpl.reflect((String)qualifiedName, (ResourceSet)this.getContext());
                }
                ++i;
            }
        }
        return null;
    }
}

