/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jem.internal.plugin.AbstractJavaMOFNatureRuntime;
import org.eclipse.jem.internal.plugin.JavaPlugin;

public class ProjectUtilities {
    public static final String DOT_PROJECT = ".project";
    public static final String DOT_CLASSPATH = ".classpath";
    public static final String DOT_WEBSETTINGS = ".websettings";

    public static boolean addToBuildSpec(String builderID, IProject project) throws CoreException {
        return com.ibm.etools.emf.workbench.ProjectUtilities.addToBuildSpec((String)builderID, (IProject)project);
    }

    public static boolean removeFromBuildSpec(String builderID, IProject project) throws CoreException {
        return com.ibm.etools.emf.workbench.ProjectUtilities.removeFromBuildSpec((String)builderID, (IProject)project);
    }

    public static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.addNatureToProject((IProject)proj, (String)natureId);
    }

    public static void addNatureToProjectLast(IProject proj, String natureId) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.addNatureToProjectLast((IProject)proj, (String)natureId);
    }

    public static void addReferenceProjects(IProject project, List toBeAddedProjectsList) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.addReferenceProjects((IProject)project, (List)toBeAddedProjectsList);
    }

    public static void addReferenceProjects(IProject project, IProject projectToBeAdded) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.addReferenceProjects((IProject)project, (IProject)projectToBeAdded);
    }

    public static void appendJavaClassPath(IProject p, List appendClasspathEntries) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (appendClasspathEntries.indexOf(entry) < 0) {
                    newPathList.add(entry);
                }
                ++i;
            }
            newPathList.addAll(appendClasspathEntries);
            IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
            javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = ProjectUtilities.getJavaProject(p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getPath().equals((Object)newEntry.getPath())) {
                return;
            }
            newPathList.add(entry);
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void updateClasspath(IJavaProject javaProject) throws JavaModelException {
        if (javaProject != null) {
            javaProject.setRawClasspath(javaProject.getRawClasspath(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IJavaProject getJavaProject(IProject p) {
        try {
            return (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected static IPath createPath(IProject p, String defaultSourceName) {
        Path path = new Path(p.getName());
        path = path.append(defaultSourceName);
        path = path.makeAbsolute();
        return path;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        try {
            IPath sourcePath = ProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
            if (sourcePath == null) {
                return null;
            }
            if (sourcePath.isEmpty()) {
                return p;
            }
            return p.getFolder(sourcePath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JavaPlugin.getDefault().getMsgLogger().log((Throwable)ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = ProjectUtilities.createPath(p, defaultSourceName);
        }
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static List getSourceFolders(IProject p) {
        try {
            ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
            List sourcePaths = ProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (!path.isEmpty()) {
                        sourceFolders.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceFolders;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getSourceContainers(IProject p) {
        try {
            ArrayList<Object> sourceContainers = new ArrayList<Object>();
            List sourcePaths = ProjectUtilities.getSourcePaths(p);
            if (sourcePaths != null && !sourcePaths.isEmpty()) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IPath path = (IPath)sourcePaths.get(i);
                    if (path.isEmpty()) {
                        sourceContainers.add(p);
                    } else {
                        sourceContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return sourceContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getSourcePaths(IProject p) {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JavaPlugin.getDefault().getMsgLogger().log((Throwable)ex);
            return null;
        }
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3) {
                sourcePaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return sourcePaths;
    }

    public static IPath getJavaProjectOutputLocation(IProject p) {
        try {
            IJavaProject javaProj = ProjectUtilities.getJavaProject(p);
            if (javaProj == null) {
                return null;
            }
            if (!javaProj.isOpen()) {
                javaProj.open(null);
            }
            return javaProj.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IContainer getJavaProjectOutputContainer(IProject p) {
        IPath path = ProjectUtilities.getJavaProjectOutputLocation(p);
        if (path == null) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return p;
        }
        return p.getFolder(path.removeFirstSegments(1));
    }

    public static IPath getJavaProjectOutputAbsoluteLocation(IProject p) {
        IContainer container = ProjectUtilities.getJavaProjectOutputContainer(p);
        if (container != null) {
            return container.getLocation();
        }
        return null;
    }

    public static boolean isBinaryProject(IProject aProject) {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(aProject);
        if (javaProj == null) {
            return false;
        }
        IClasspathEntry[] entries = null;
        try {
            entries = javaProj.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void forceAutoBuild(IProject project, IProgressMonitor progressMonitor) {
        com.ibm.etools.emf.workbench.ProjectUtilities.forceAutoBuild((IProject)project, (IProgressMonitor)progressMonitor);
    }

    public static void forceClasspathReload(IProject project) throws JavaModelException {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(project);
        if (javaProj != null) {
            javaProj.close();
            JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(project, true);
            perProjectInfo.classpath = null;
            perProjectInfo.lastResolvedClasspath = null;
        }
    }

    public static boolean getCurrentAutoBuildSetting() {
        return com.ibm.etools.emf.workbench.ProjectUtilities.getCurrentAutoBuildSetting();
    }

    public static JavaModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static List getSourcePackageFragmentRoots(IJavaProject javaProj) throws JavaModelException {
        ArrayList result = new ArrayList();
        IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                result.add(result);
            }
            ++i;
        }
        return result;
    }

    public static List getFilesAffectedByClasspathChange(IProject p) {
        ArrayList result = new ArrayList(2);
        ProjectUtilities.addFileIfExists(p, result, DOT_CLASSPATH);
        ProjectUtilities.addFileIfExists(p, result, DOT_PROJECT);
        return result;
    }

    protected static void addFileIfExists(IProject p, List aList, String filename) {
        IFile aFile = p.getFile(filename);
        if (aFile != null && aFile.exists()) {
            aList.add(aFile);
        }
    }

    public static IProject getProject(EObject aRefObject) {
        return com.ibm.etools.emf.workbench.ProjectUtilities.getProject((EObject)aRefObject);
    }

    public static String[] getProjectNamesWithoutForwardSlash(String[] projecNames) {
        String[] projNames = new String[projecNames.length];
        List<String> temp = Arrays.asList(projecNames);
        int i = 0;
        while (i < temp.size()) {
            String name = temp.get(i);
            projNames[i] = name.startsWith("/") ? name.substring(1, name.length()) : name;
            ++i;
        }
        return projNames;
    }

    public static List getLocalJARPathsFromClasspath(IProject proj) {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(proj);
        if (javaProj == null) {
            return null;
        }
        IPath projectPath = proj.getFullPath();
        ArrayList<IPath> result = new ArrayList<IPath>();
        try {
            IClasspathEntry[] entries = javaProj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IPath path;
                int segments;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 1 && (segments = (path = entry.getPath()).matchingFirstSegments(projectPath)) > 0) {
                    result.add(path.removeFirstSegments(segments));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.getDefault().getMsgLogger().log((Throwable)e);
        }
        return result;
    }

    public static void makeJ2EENatureFirst(IProject proj) {
        String natureID = AbstractJavaMOFNatureRuntime.getRegisteredRuntimeID(proj);
        if (natureID != null) {
            try {
                IProjectDescription description = proj.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length];
                newNatures[0] = natureID;
                int next = 1;
                int i = 0;
                while (i < prevNatures.length) {
                    if (!prevNatures[i].equals(natureID)) {
                        newNatures[next++] = prevNatures[i];
                    }
                    ++i;
                }
                description.setNatureIds(newNatures);
                proj.setDescription(description, null);
            }
            catch (CoreException e) {
                JavaPlugin.getDefault().getMsgLogger().log((Throwable)e);
            }
        }
    }

    public static void removeFromJavaClassPath(IProject p, IResource res) throws JavaModelException {
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)res.getFullPath(), null, null);
        ProjectUtilities.removeFromJavaClassPath(p, entry);
    }

    public static void removeFromJavaClassPath(IProject p, IPath path) throws JavaModelException {
        IFile f = p.getFile(path);
        ProjectUtilities.removeFromJavaClassPath(p, (IResource)f);
    }

    public static void removeFromJavaClassPath(IProject p, IClasspathEntry entry) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(ProjectUtilities.primRemoveFromJavaClassPath(classpath, entry), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void removeFromJavaClassPath(IProject p, List entries) throws JavaModelException {
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {}
        if (javaProject != null) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            javaProject.setRawClasspath(ProjectUtilities.primRemoveFromJavaClassPath(classpath, entries), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, IClasspathEntry entry) throws JavaModelException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        boolean didRemove = false;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry cpEntry = classpath[i];
            if (!entry.getPath().equals((Object)classpath[i].getPath())) {
                result.add(cpEntry);
            } else {
                didRemove = true;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    protected static IClasspathEntry[] primRemoveFromJavaClassPath(IClasspathEntry[] classpath, List entries) throws JavaModelException {
        List<IClasspathEntry> arrayList = Arrays.asList(classpath);
        ArrayList<IClasspathEntry> removeable = new ArrayList<IClasspathEntry>(arrayList);
        boolean didRemove = false;
        int size = entries.size();
        int i = 0;
        while (i < size) {
            IClasspathEntry entry = (IClasspathEntry)entries.get(i);
            int j = 0;
            while (j < classpath.length) {
                IClasspathEntry cpEntry = classpath[j];
                if (entry.getPath().equals((Object)classpath[j].getPath()) && removeable.remove(cpEntry)) {
                    didRemove = true;
                }
                ++j;
            }
            ++i;
        }
        if (!didRemove) {
            return classpath;
        }
        return removeable.toArray(new IClasspathEntry[removeable.size()]);
    }

    public static void removeReferenceProjects(IProject project, List toBeRemovedProjectList) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.removeReferenceProjects((IProject)project, (List)toBeRemovedProjectList);
    }

    public static void removeReferenceProjects(IProject project, IProject toBeRemovedProject) throws CoreException {
        com.ibm.etools.emf.workbench.ProjectUtilities.removeReferenceProjects((IProject)project, (IProject)toBeRemovedProject);
    }

    public static void turnAutoBuildOff() {
        com.ibm.etools.emf.workbench.ProjectUtilities.turnAutoBuildOff();
    }

    public static void turnAutoBuildOn() {
        com.ibm.etools.emf.workbench.ProjectUtilities.turnAutoBuildOn();
    }

    public static void turnAutoBuildOn(boolean aBoolean) {
        com.ibm.etools.emf.workbench.ProjectUtilities.turnAutoBuildOn((boolean)aBoolean);
    }

    public static void removeNatureFromProject(IProject project, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int size = prevNatures.length;
        int newsize = 0;
        String[] newNatures = new String[size];
        boolean matchfound = false;
        int i = 0;
        while (i < size) {
            if (prevNatures[i].equals(natureId)) {
                matchfound = true;
            } else {
                newNatures[newsize++] = prevNatures[i];
            }
            ++i;
        }
        if (!matchfound) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.etools.java", 0, "The nature id " + natureId + " does not exist on the project " + project.getName(), null));
        }
        String[] temp = newNatures;
        newNatures = new String[newsize];
        System.arraycopy(temp, 0, newNatures, 0, newsize);
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static URL[] getClasspathAsURLArray(IJavaProject javaProject) {
        if (javaProject == null) {
            return null;
        }
        HashSet visited = new HashSet();
        ArrayList urls = new ArrayList(20);
        ProjectUtilities.collectClasspathURLs(javaProject, urls, visited, true);
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }

    private static void collectClasspathURLs(IJavaProject javaProject, List urls, Set visited, boolean isFirstProject) {
        if (visited.contains(javaProject)) {
            return;
        }
        visited.add(javaProject);
        IPath outPath = ProjectUtilities.getJavaProjectOutputAbsoluteLocation(javaProject.getProject());
        outPath = outPath.addTrailingSeparator();
        URL out = ProjectUtilities.createFileURL(outPath);
        urls.add(out);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: 
                case 5: {
                    ProjectUtilities.collectClasspathEntryURL(entry, urls);
                    break;
                }
                case 2: {
                    if (!isFirstProject && !entry.isExported()) break;
                    ProjectUtilities.collectClasspathURLs(ProjectUtilities.getJavaProject(entry), urls, visited, false);
                }
            }
            ++i;
        }
    }

    private static URL createFileURL(IPath path) {
        URL url = null;
        try {
            url = new URL("file://" + path.toOSString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    private static void collectClasspathEntryURL(IClasspathEntry entry, List urls) {
        URL url = ProjectUtilities.createFileURL(entry.getPath());
        if (url != null) {
            urls.add(url);
        }
    }

    private static IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return ProjectUtilities.getJavaProject(proj);
        }
        return null;
    }

    public static List getLibaryContainers(IProject p) {
        try {
            ArrayList<Object> libaryContainers = new ArrayList<Object>();
            List libaryPaths = ProjectUtilities.getLibaryPaths(p);
            if (libaryPaths != null && !libaryPaths.isEmpty()) {
                int i = 0;
                while (i < libaryPaths.size()) {
                    IPath path = (IPath)libaryPaths.get(i);
                    if (path.isEmpty()) {
                        libaryContainers.add(p);
                    } else {
                        libaryContainers.add(p.getFolder(path));
                    }
                    ++i;
                }
            }
            return libaryContainers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_LIST;
        }
    }

    protected static List getLibaryPaths(IProject p) {
        IJavaProject javaProj = ProjectUtilities.getJavaProject(p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JavaPlugin.getDefault().getMsgLogger().log((Throwable)ex);
            return null;
        }
        ArrayList<IPath> libaryPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 1) {
                libaryPaths.add(cp[i].getPath().removeFirstSegments(1));
            }
            ++i;
        }
        return libaryPaths;
    }
}

