/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.core;

import org.eclipse.jem.internal.core.StringPrimitiveLogger;

public class ConsoleLogger
extends StringPrimitiveLogger {
    protected boolean echoToConsole;
    protected int currentLogLevel;

    public ConsoleLogger(boolean echoToConsole, int currentLogLevel) {
        super(false);
        this.echoToConsole = echoToConsole;
        this.currentLogLevel = currentLogLevel;
    }

    protected void primLog(Object object, int logLevel) {
        if (this.echoToConsole || this.doLog(logLevel)) {
            if (logLevel == 6 || logLevel == 5) {
                System.err.println(object);
            } else {
                System.out.println(object);
            }
        }
    }

    protected void primLog(Throwable exc, int logLevel) {
        if (this.echoToConsole || this.doLog(logLevel)) {
            if (logLevel == 6 || logLevel == 5) {
                exc.printStackTrace(System.err);
            } else {
                exc.printStackTrace(System.out);
            }
        }
    }

    protected boolean doLog(int logLevel) {
        return logLevel >= this.currentLogLevel && logLevel < 7;
    }
}

