/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.core.JEMPlugin;
import org.eclipse.jem.internal.core.MsgLogger;
import org.eclipse.jem.internal.core.StringPrimitiveLogger;

public class EclipseLogMsgLogger
extends StringPrimitiveLogger {
    public static final int[] STATUS_LEVEL;
    public static final int[] LEVEL_STATUS;
    public static final String DEBUG_ECHOCONSOLE_OPTION = "/debug/echoconsole";
    public static final String DEBUG_LOG_LEVEL = "/debug/loglevel";
    public static final String DEFAULT_OPTION = "default";
    private Plugin plugin;
    private String pluginID;
    private int currentLogLevel;

    static {
        int[] nArray = new int[8];
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 4;
        STATUS_LEVEL = nArray;
        int maxID = Math.max(0, Math.max(1, Math.max(2, 4)));
        LEVEL_STATUS = new int[maxID + 1];
        EclipseLogMsgLogger.LEVEL_STATUS[0] = 2;
        EclipseLogMsgLogger.LEVEL_STATUS[1] = 4;
        EclipseLogMsgLogger.LEVEL_STATUS[2] = 5;
        EclipseLogMsgLogger.LEVEL_STATUS[4] = 6;
    }

    public static MsgLogger createLogger(Plugin plugin) {
        String pluginOption = Platform.getDebugOption((String)(String.valueOf(plugin.getDescriptor().getUniqueIdentifier()) + DEBUG_ECHOCONSOLE_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(JEMPlugin.getPlugin().getDescriptor().getUniqueIdentifier()) + DEBUG_ECHOCONSOLE_OPTION));
        }
        boolean echoConsole = "true".equalsIgnoreCase(pluginOption);
        pluginOption = Platform.getDebugOption((String)(String.valueOf(plugin.getDescriptor().getUniqueIdentifier()) + DEBUG_LOG_LEVEL));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(JEMPlugin.getPlugin().getDescriptor().getUniqueIdentifier()) + DEBUG_LOG_LEVEL));
        }
        int logLevel = 5;
        if (pluginOption != null) {
            try {
                logLevel = Integer.parseInt(pluginOption);
                if (logLevel < 0 && logLevel > 7) {
                    logLevel = 5;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new EclipseLogMsgLogger(plugin, echoConsole, logLevel);
    }

    public EclipseLogMsgLogger(Plugin plugin, boolean logEchoConsole, int currentLogLevel) {
        super(logEchoConsole);
        this.plugin = plugin;
        this.pluginID = plugin.getDescriptor().getUniqueIdentifier();
        this.currentLogLevel = currentLogLevel;
    }

    protected void primLogStatus(IStatus status, int logLevel) {
        if (logLevel == -1) {
            logLevel = this.getLogLevel(status);
        }
        if (this.doLog(logLevel)) {
            this.getPluginLog().log(status);
        }
    }

    protected void primLogCoreException(CoreException ext, int logLevel) {
        this.primLogStatus(ext.getStatus(), logLevel);
    }

    protected void primLog(Object object, int logLevel) {
        if (object instanceof IStatus) {
            this.primLogStatus((IStatus)object, logLevel);
        } else if (object instanceof CoreException) {
            this.primLogCoreException((CoreException)object, logLevel);
        } else {
            if (logLevel == -1) {
                logLevel = 0;
            }
            if (this.doLog(logLevel)) {
                this.getPluginLog().log((IStatus)new Status(this.getStatusSeverity(logLevel), this.pluginID, 0, object.toString(), null));
            }
        }
    }

    protected void primLog(Throwable exc, int logLevel) {
        if (logLevel == -1) {
            logLevel = 6;
        }
        if (this.doLog(logLevel)) {
            this.getPluginLog().log((IStatus)new Status(this.getStatusSeverity(logLevel), this.pluginID, 0, "Exception", exc));
        }
    }

    protected boolean doLog(int logLevel) {
        return logLevel >= this.currentLogLevel && logLevel < 7;
    }

    public ILog getPluginLog() {
        return this.plugin.getLog();
    }

    protected int getLogLevel(IStatus status) {
        return LEVEL_STATUS[status.getSeverity()];
    }

    protected int getStatusSeverity(int logLevel) {
        return STATUS_LEVEL[logLevel];
    }
}

