/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.impl;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.impl.ESuperAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.Field;
import org.eclipse.jem.internal.java.InheritanceCycleException;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaDataType;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.JavaPackage;
import org.eclipse.jem.internal.java.JavaParameter;
import org.eclipse.jem.internal.java.JavaRefPackage;
import org.eclipse.jem.internal.java.JavaURL;
import org.eclipse.jem.internal.java.JavaVisibilityKind;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.TypeKind;
import org.eclipse.jem.internal.java.adapters.InternalReadAdaptable;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.impl.JavaRefFactoryImpl;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;

public class JavaClassImpl
extends EClassImpl
implements JavaClass,
InternalReadAdaptable {
    protected static final TypeKind KIND_EDEFAULT = TypeKind.UNDEFINED_LITERAL;
    protected TypeKind kind = KIND_EDEFAULT;
    protected static final boolean PUBLIC_EDEFAULT = false;
    protected boolean public_ = false;
    protected static final boolean FINAL_EDEFAULT = false;
    protected boolean final_ = false;
    protected EList implementsInterfaces = null;
    protected EList classImport = null;
    protected EList packageImports = null;
    protected EList fields = null;
    protected EList methods = null;
    protected EList initializers = null;
    protected EList declaredClasses = null;
    protected JavaClass declaringClass = null;
    protected EList events = null;
    protected boolean hasReflected = false;
    protected EList properties;
    private EList allEvents;
    private EList allProperties;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected JavaClassImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getJavaClass();
    }

    protected void collectFieldsExtended(List fields) {
        fields.addAll(this.getFields());
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            ((JavaClassImpl)it.next()).collectFieldsExtended(fields);
        }
    }

    protected void collectMethodsExtended(Map methods, boolean onlyPublic, List excludedClasses, List excludedMethods) {
        Iterator it2 = this.getExtendedLookupIterator();
        while (it2.hasNext()) {
            JavaClassImpl javaClass = (JavaClassImpl)it2.next();
            if (excludedClasses.contains(javaClass)) continue;
            javaClass.collectMethodsExtended(methods, onlyPublic, excludedClasses, excludedMethods);
        }
        Iterator it1 = onlyPublic ? this.getPublicMethods().iterator() : this.getMethods().iterator();
        while (it1.hasNext()) {
            Method nextMethod = (Method)it1.next();
            if (excludedMethods.contains(nextMethod)) continue;
            methods.put(nextMethod.getMethodElementSignature(), nextMethod);
        }
    }

    public static JavaClass createClassRef(String targetName) {
        JavaClass ref = JavaRefFactoryImpl.getActiveFactory().createJavaClass();
        JavaURL javaurl = new JavaURL(targetName);
        ((InternalEObject)ref).eSetProxyURI(URI.createURI((String)javaurl.getFullString()));
        return ref;
    }

    protected Method findClassMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        JavaClassImpl mySuper = (JavaClassImpl)this.getSupertype();
        if (mySuper != null) {
            return mySuper.findClassMethodExtended(methodName, parameterTypes);
        }
        return null;
    }

    protected Method findInterfaceMethodExtended(String methodName, List parameterTypes) {
        Method method = this.getMethod(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        EList list = this.getImplementsInterfaces();
        int i = 0;
        while (i < list.size()) {
            JavaClassImpl superInterface = (JavaClassImpl)list.get(i);
            method = superInterface.findInterfaceMethodExtended(methodName, parameterTypes);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public EList getAllSupertypes() {
        this.getESuperTypes();
        return super.getEAllSuperTypes();
    }

    public EList getClassImport() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getClassImportGen();
    }

    public EList getEAllOperations() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return super.getEAllOperations();
        }
        ESuperAdapter a = this.getESuperAdapter();
        if (this.eAllOperations == null || a.isAllOperationsCollectionModified()) {
            this.eAllOperations = ia.getEAllOperations();
        }
        return this.eAllOperations;
    }

    public EList getEAttributes() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEAttributes();
        }
        return super.getEAttributes();
    }

    public EList getEAttributesGen() {
        return super.getEAttributes();
    }

    public EList getEOperations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEOperations();
        }
        return super.getEOperations();
    }

    public EList getEOperationsGen() {
        return super.getEOperations();
    }

    public EList getEAnnotations() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            adapter.introspectIfNecessary();
        }
        return super.getEAnnotations();
    }

    public EList getEReferences() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEReferences();
        }
        return super.getEReferences();
    }

    public EList getEReferencesGen() {
        return super.getEReferences();
    }

    protected Iterator getExtendedLookupIterator() {
        if (this.isInterface()) {
            return this.getImplementsInterfaces().iterator();
        }
        return this.getESuperTypes().iterator();
    }

    public Field getField(String fieldName) {
        EList fields = this.getFields();
        int i = 0;
        while (i < fields.size()) {
            Field field = (Field)fields.get(i);
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public Field getFieldExtended(String fieldName) {
        Field field = this.getFieldNamed(fieldName);
        if (field != null) {
            return field;
        }
        Iterator it = this.getExtendedLookupIterator();
        while (it.hasNext()) {
            Field result = ((JavaClass)it.next()).getFieldExtended(fieldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Field getFieldNamed(String fieldName) {
        return this.getField(fieldName);
    }

    public EList getFields() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getFieldsGen();
    }

    public List getFieldsExtended() {
        ArrayList fields = new ArrayList();
        this.collectFieldsExtended(fields);
        return fields;
    }

    public EList getImplementsInterfaces() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getImplementsInterfacesGen();
    }

    protected IIntrospectionAdapter getIntrospectionAdapter() {
        return (IIntrospectionAdapter)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)IIntrospectionAdapter.ADAPTER_KEY);
    }

    public String getJavaName() {
        return this.getQualifiedName();
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this.getEPackage();
    }

    public Method getMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, (List)this.getMethods());
    }

    protected Method getMethod(String name, List parameterTypes, List methodList) {
        boolean found = false;
        int i = 0;
        while (i < methodList.size()) {
            JavaParameter[] params;
            Method method = (Method)methodList.get(i);
            if (method.getName().equals(name) && (params = method.listParametersWithoutReturn()).length == parameterTypes.size()) {
                found = true;
                int j = 0;
                while (j < params.length) {
                    JavaHelpers jh = (JavaHelpers)params[j].getEType();
                    if (!jh.getQualifiedName().equals(parameterTypes.get(j))) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    public List getMethodElementSignatures() {
        List methods = this.getMethodsExtended();
        ArrayList<String> sameNames = new ArrayList<String>();
        ArrayList<String> signatures = new ArrayList<String>(methods.size() + 1);
        signatures.add("*");
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method aMethod = (Method)it.next();
            String methodName = aMethod.getName();
            if (sameNames.contains(methodName)) {
                if (!signatures.contains(methodName)) {
                    signatures.add(methodName);
                }
            } else {
                sameNames.add(methodName);
            }
            signatures.add(aMethod.getMethodElementSignature());
        }
        Collections.sort(signatures);
        return signatures;
    }

    public Method getMethodExtended(String methodName, List parameterTypes) {
        if (this.isInterface()) {
            return this.findInterfaceMethodExtended(methodName, parameterTypes);
        }
        return this.findClassMethodExtended(methodName, parameterTypes);
    }

    public EList getMethods() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getMethodsGen();
    }

    public List getMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    public List getMethodsExtendedWithFilters(List excludedClasses, List excludedMethods) {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, false, excludedClasses, excludedMethods);
        return new ArrayList(methods.values());
    }

    public String getName() {
        JavaURL url;
        String result = this.primGetName();
        if (result == null && this.eIsProxy() && (result = (url = new JavaURL(this.eProxyURI().toString())).getClassName()) != null) {
            result = result.replace('$', '.');
        }
        return result;
    }

    public List getOnlySpecificMethods(String aMethodNamePrefix, List excludedNames) {
        List methods = this.getMethodsExtended();
        ArrayList<Method> specific = new ArrayList<Method>(methods.size());
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method aMethod = (Method)it.next();
            String methodName = aMethod.getName();
            if (aMethodNamePrefix == null || !methodName.startsWith(aMethodNamePrefix) || excludedNames == null || excludedNames.contains(methodName)) continue;
            specific.add(aMethod);
        }
        return specific;
    }

    public EList getPackageImports() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getPackageImportsGen();
    }

    public JavaDataType getPrimitive() {
        String primitiveName = this.getPrimitiveName();
        if (primitiveName != null) {
            Resource res = this.eResource();
            return (JavaDataType)JavaClassImpl.reflect(primitiveName, res.getResourceSet());
        }
        return null;
    }

    protected String getPrimitiveName() {
        String myName = this.getQualifiedName();
        if (myName.equals("java.lang.Integer")) {
            return "int";
        }
        if (myName.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (myName.equals("java.lang.Byte")) {
            return "byte";
        }
        if (myName.equals("java.lang.Short")) {
            return "short";
        }
        if (myName.equals("java.lang.Long")) {
            return "long";
        }
        if (myName.equals("java.lang.Float")) {
            return "float";
        }
        if (myName.equals("java.lang.Double")) {
            return "double";
        }
        return null;
    }

    public Method getPublicMethod(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethods());
    }

    public Method getPublicMethodExtended(String methodName, List parameterTypes) {
        return this.getMethod(methodName, parameterTypes, this.getPublicMethodsExtended());
    }

    public List getPublicMethods() {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        EList theMethods = this.getMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (JavaVisibilityKind.PUBLIC_LITERAL == m.getJavaVisibility()) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public List getPublicMethodsExtended() {
        HashMap methods = new HashMap();
        this.collectMethodsExtended(methods, true, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        return new ArrayList(methods.values());
    }

    public List getPublicMethodsExtendedNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethodsExtended();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public List getPublicMethodsNamed(String name) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        List theMethods = this.getPublicMethods();
        int i = 0;
        while (i < theMethods.size()) {
            Method m = (Method)theMethods.get(i);
            if (m.getName().equals(name)) {
                publicMethods.add(m);
            }
            ++i;
        }
        return publicMethods;
    }

    public String getQualifiedName() {
        JavaURL url;
        String internalName;
        String result = null;
        result = this.eIsProxy() ? ((internalName = (url = new JavaURL(this.eProxyURI().toString())).getPackageName()) != null && internalName.length() > 0 ? String.valueOf(internalName) + "." + url.getClassName() : url.getClassName()) : this.primGetQualifiedName();
        if (result != null) {
            result = result.replace('$', '.');
        }
        return result;
    }

    public String getQualifiedNameForReflection() {
        return this.primGetQualifiedName();
    }

    protected ReadAdaptor getReadAdaptor() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)"JavaReflection");
    }

    protected void reflectValues() {
        ReadAdaptor readAdaptor = this.getReadAdaptor();
        if (readAdaptor != null) {
            this.hasReflected = readAdaptor.reflectValuesIfNecessary();
        }
    }

    public JavaClass getSupertype() {
        EList list = this.getESuperTypes();
        if (!list.isEmpty()) {
            return (JavaClass)list.get(0);
        }
        return null;
    }

    public JavaClass getWrapper() {
        return this;
    }

    public boolean implementsInterface(JavaClass interfaceType) {
        if (this == interfaceType) {
            return true;
        }
        EList implemented = this.getImplementsInterfaces();
        int i = 0;
        while (i < implemented.size()) {
            JavaClass anInterface = (JavaClass)implemented.get(i);
            if (anInterface.implementsInterface(interfaceType)) {
                return true;
            }
            ++i;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().implementsInterface(interfaceType);
        }
        return false;
    }

    public String infoString() {
        EList methods;
        StringBuffer out = new StringBuffer();
        if (!this.hasReflected) {
            this.reflectValues();
        }
        out.append("Java class: " + this.getQualifiedName() + "\n");
        out.append("  superclass: " + this.getSupertype() + "\n");
        EList fields = this.getFields();
        if (fields.size() > 0) {
            out.append("  Fields:\n");
            int i = 0;
            while (i < fields.size()) {
                Field field = (Field)fields.get(i);
                out.append("    " + ((JavaHelpers)field.getEType()).getJavaName() + " " + field.getName() + "\n");
                ++i;
            }
        }
        if ((methods = this.getMethods()).size() > 0) {
            out.append("  Methods:\n");
            int i = 0;
            while (i < methods.size()) {
                Method method = (Method)methods.get(i);
                method.isStatic();
                if (method.getReturnType() != null) {
                    out.append("    " + method.getReturnType().getJavaName() + " ");
                } else {
                    out.append("    void ");
                }
                out.append(String.valueOf(method.getName()) + "(");
                EList parms = method.getParameters();
                if (parms.size() > 0) {
                    int ii = 0;
                    while (ii < parms.size()) {
                        JavaParameter parm = (JavaParameter)parms.get(ii);
                        out.append(String.valueOf(((JavaHelpers)parm.getEType()).getJavaName()) + " " + parm.getName());
                        if (ii < parms.size() - 1) {
                            out.append(", ");
                        }
                        ++ii;
                    }
                }
                out.append(")\n");
                ++i;
            }
        }
        return out.toString();
    }

    public boolean inheritsFrom(JavaClass javaClass) {
        if (this == javaClass) {
            return true;
        }
        if (this.getSupertype() != null) {
            return this.getSupertype().inheritsFrom(javaClass);
        }
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignableFrom(EClassifier aClass) {
        if (aClass instanceof JavaClass) {
            JavaClass theClass = (JavaClass)aClass;
            if (this.getKind() == TypeKind.UNDEFINED_LITERAL || theClass.getKind() == TypeKind.UNDEFINED_LITERAL) {
                return false;
            }
            if (this.getKind() != TypeKind.INTERFACE_LITERAL) {
                if (theClass.getKind() != TypeKind.INTERFACE_LITERAL) {
                    return theClass.inheritsFrom(this);
                }
                return this.getQualifiedName().equals("java.lang.Object");
            }
            return theClass.implementsInterface(this);
        }
        return false;
    }

    public boolean isExistingType() {
        return ((JavaReflectionAdaptor)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)"JavaReflection")).hasReflectionSource();
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom(((IInstantiationInstance)o).getJavaType()) : false;
    }

    public boolean isInterface() {
        return this.getKind() == TypeKind.INTERFACE_LITERAL;
    }

    public boolean isNested() {
        return this.getDeclaringClass() != null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public Field[] listFieldExtended() {
        List fields = this.getFieldsExtended();
        Field[] result = new Field[fields.size()];
        fields.toArray(result);
        return result;
    }

    public Method[] listMethodExtended() {
        List methods = this.getMethodsExtended();
        Method[] result = new Method[methods.size()];
        methods.toArray(result);
        return result;
    }

    public String primGetName() {
        return super.getName();
    }

    public String primGetQualifiedName() {
        String result = "";
        JavaPackage pack = this.getJavaPackage();
        result = pack != null && pack.getPackageName().length() != 0 ? String.valueOf(pack.getPackageName()) + "." + this.primGetName() : this.getName();
        return result;
    }

    public static JavaHelpers reflect(String aQualifiedName, EObject relatedObject) {
        ResourceSet rs;
        Resource r = relatedObject.eResource();
        if (r != null && (rs = r.getResourceSet()) != null) {
            return JavaClassImpl.reflect(aQualifiedName, rs);
        }
        return null;
    }

    public static JavaHelpers reflect(String aQualifiedName, ResourceSet set) {
        if (aQualifiedName != null) {
            int index = aQualifiedName.lastIndexOf(".");
            if (index > 0) {
                return JavaClassImpl.reflect(aQualifiedName.substring(0, index), aQualifiedName.substring(index + 1, aQualifiedName.length()), set);
            }
            return JavaClassImpl.reflect("", aQualifiedName, set);
        }
        return null;
    }

    public static JavaHelpers reflect(String aPackageName, String aClassName, ResourceSet set) {
        if (aClassName != null && aPackageName != null) {
            JavaInit.init();
            JavaURL url = new JavaURL(aPackageName, aClassName);
            return (JavaHelpers)set.getEObject(URI.createURI((String)url.getFullString()), true);
        }
        return null;
    }

    public void setSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        this.validateSupertype(aJavaClass);
        EList s = super.getESuperTypes();
        s.clear();
        if (aJavaClass != null) {
            s.add(aJavaClass);
        }
    }

    protected void validateSupertype(JavaClass aJavaClass) throws InheritanceCycleException {
        if (!this.isValidSupertype(aJavaClass)) {
            throw new InheritanceCycleException(this, aJavaClass);
        }
    }

    public boolean isValidSupertype(JavaClass aJavaClass) {
        if (aJavaClass != null) {
            if (this.equals(aJavaClass)) {
                return false;
            }
            return this.extendedIsValidSupertype(this.getSubtypes(), aJavaClass);
        }
        return true;
    }

    private boolean extendedIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        if (!this.basicIsValidSupertype(subtypes, aJavaClass)) {
            return false;
        }
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (!subtype.isValidSupertype(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean basicIsValidSupertype(List subtypes, JavaClass aJavaClass) {
        int i = 0;
        while (i < subtypes.size()) {
            JavaClass subtype = (JavaClass)subtypes.get(i);
            if (subtype.equals(aJavaClass)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List getSubtypes() {
        ESuperAdapter adapter = ESuperAdapter.getESuperAdapter((EClass)this);
        if (adapter != null) {
            return adapter.getSubclasses();
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getQualifiedName() + ")";
    }

    public TypeKind getKind() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getKindGen();
    }

    public void setKind(TypeKind newKind) {
        TypeKind oldKind = this.kind;
        TypeKind typeKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldKind, (Object)this.kind));
        }
    }

    public boolean isPublic() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isPublicGen();
    }

    public void setPublic(boolean newPublic) {
        boolean oldPublic = this.public_;
        this.public_ = newPublic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldPublic, this.public_));
        }
    }

    public boolean isFinal() {
        return this.final_;
    }

    public void setFinal(boolean newFinal) {
        boolean oldFinal = this.final_;
        this.final_ = newFinal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldFinal, this.final_));
        }
    }

    public TypeKind getKindGen() {
        return this.kind;
    }

    public boolean isPublicGen() {
        return this.public_;
    }

    public boolean isFinalGen() {
        return this.final_;
    }

    public EList getInitializers() {
        if (this.initializers == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jem.internal.java.Initializer;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.initializers = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 27, 1);
        }
        return this.initializers;
    }

    public void setDeclaringClass(JavaClass newDeclaringClass) {
        if (newDeclaringClass != this.declaringClass) {
            NotificationChain msgs = null;
            if (this.declaringClass != null) {
                InternalEObject internalEObject = (InternalEObject)this.declaringClass;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 28, (Class)clazz, msgs);
            }
            if (newDeclaringClass != null) {
                InternalEObject internalEObject = (InternalEObject)newDeclaringClass;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 28, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetDeclaringClass(newDeclaringClass, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 29, (Object)newDeclaringClass, (Object)newDeclaringClass));
        }
    }

    public JavaClass getDeclaringClass() {
        if (this.declaringClass != null && this.declaringClass.eIsProxy()) {
            JavaClass oldDeclaringClass = this.declaringClass;
            this.declaringClass = (JavaClass)EcoreUtil.resolve((EObject)this.declaringClass, (EObject)this);
            if (this.declaringClass != oldDeclaringClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 29, (Object)oldDeclaringClass, (Object)this.declaringClass));
            }
        }
        return this.declaringClass;
    }

    public JavaClass basicGetDeclaringClass() {
        return this.declaringClass;
    }

    public NotificationChain basicSetDeclaringClass(JavaClass newDeclaringClass, NotificationChain msgs) {
        JavaClass oldDeclaringClass = this.declaringClass;
        this.declaringClass = newDeclaringClass;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 29, (Object)oldDeclaringClass, (Object)newDeclaringClass);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public EList getDeclaredClasses() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getDeclaredClassesGen();
    }

    public EList getDeclaredClassesGen() {
        if (this.declaredClasses == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declaredClasses = new EObjectWithInverseResolvingEList((Class)clazz, (InternalEObject)this, 28, 29);
        }
        return this.declaredClasses;
    }

    public EList getProperties() {
        if (this.properties == null) {
            this.properties = new PropertiesEList();
        }
        return this.properties;
    }

    public EList getEvents() {
        IIntrospectionAdapter adapter = this.getIntrospectionAdapter();
        if (adapter != null) {
            return adapter.getEvents();
        }
        return this.getEventsGen();
    }

    public EList getEventsGen() {
        if (this.events == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaEvent;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.events = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 31);
        }
        return this.events;
    }

    public EList getAllEvents() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allEvents = ia.getAllEvents();
        return this.allEvents;
    }

    public EList getAllEventsGen() {
        return this.allEvents;
    }

    public EList getAllProperties() {
        IIntrospectionAdapter ia = this.getIntrospectionAdapter();
        if (ia == null) {
            return ECollections.EMPTY_ELIST;
        }
        this.allProperties = ia.getAllProperties();
        return this.allProperties;
    }

    public EList getAllPropertiesGen() {
        return this.allProperties;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ((EModelElementImpl)this).eAnnotations != null && !((EModelElementImpl)this).eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? ((ENamedElementImpl)this).name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(((ENamedElementImpl)this).name);
            }
            case 2: {
                return EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT == null ? ((EClassifierImpl)this).instanceClassName != null : !EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT.equals(((EClassifierImpl)this).instanceClassName);
            }
            case 3: {
                return this.getInstanceClass() != null;
            }
            case 4: {
                return this.getDefaultValue() != null;
            }
            case 5: {
                return this.getEPackage() != null;
            }
            case 6: {
                return this.abstract_;
            }
            case 7: {
                return this.interface_;
            }
            case 8: {
                return this.eSuperTypes != null && !this.eSuperTypes.isEmpty();
            }
            case 9: {
                return this.eOperations != null && !this.eOperations.isEmpty();
            }
            case 10: {
                return !this.getEAllAttributes().isEmpty();
            }
            case 11: {
                return !this.getEAllReferences().isEmpty();
            }
            case 12: {
                return this.eReferences != null && !this.eReferences.isEmpty();
            }
            case 13: {
                return this.eAttributes != null && !this.eAttributes.isEmpty();
            }
            case 14: {
                return !this.getEAllContainments().isEmpty();
            }
            case 15: {
                return !this.getEAllOperations().isEmpty();
            }
            case 16: {
                return !this.getEAllStructuralFeatures().isEmpty();
            }
            case 17: {
                return !this.getEAllSuperTypes().isEmpty();
            }
            case 18: {
                return this.getEIDAttribute() != null;
            }
            case 19: {
                return this.kind != KIND_EDEFAULT;
            }
            case 20: {
                return this.public_;
            }
            case 21: {
                return this.final_;
            }
            case 22: {
                return this.implementsInterfaces != null && !this.implementsInterfaces.isEmpty();
            }
            case 23: {
                return this.classImport != null && !this.classImport.isEmpty();
            }
            case 24: {
                return this.packageImports != null && !this.packageImports.isEmpty();
            }
            case 25: {
                return this.fields != null && !this.fields.isEmpty();
            }
            case 26: {
                return this.methods != null && !this.methods.isEmpty();
            }
            case 27: {
                return this.initializers != null && !this.initializers.isEmpty();
            }
            case 28: {
                return this.declaredClasses != null && !this.declaredClasses.isEmpty();
            }
            case 29: {
                return this.declaringClass != null;
            }
            case 30: {
                return this.basicGetJavaPackage() != null;
            }
            case 31: {
                return this.events != null && !this.events.isEmpty();
            }
            case 32: {
                return !this.getAllEvents().isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 6: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 7: {
                this.setInterface((Boolean)newValue);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                this.getESuperTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getEOperations().clear();
                this.getEOperations().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getEReferences().clear();
                this.getEReferences().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getEAttributes().clear();
                this.getEAttributes().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.setKind((TypeKind)((Object)newValue));
                return;
            }
            case 20: {
                this.setPublic((Boolean)newValue);
                return;
            }
            case 21: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 22: {
                this.getImplementsInterfaces().clear();
                this.getImplementsInterfaces().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.getClassImport().clear();
                this.getClassImport().addAll((Collection)newValue);
                return;
            }
            case 24: {
                this.getPackageImports().clear();
                this.getPackageImports().addAll((Collection)newValue);
                return;
            }
            case 25: {
                this.getFields().clear();
                this.getFields().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.getMethods().clear();
                this.getMethods().addAll((Collection)newValue);
                return;
            }
            case 27: {
                this.getInitializers().clear();
                this.getInitializers().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.getDeclaredClasses().clear();
                this.getDeclaredClasses().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.setDeclaringClass((JavaClass)newValue);
                return;
            }
            case 31: {
                this.getEvents().clear();
                this.getEvents().addAll((Collection)newValue);
                return;
            }
            case 32: {
                this.getAllEvents().clear();
                this.getAllEvents().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setAbstract(false);
                return;
            }
            case 7: {
                this.setInterface(false);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                return;
            }
            case 9: {
                this.getEOperations().clear();
                return;
            }
            case 12: {
                this.getEReferences().clear();
                return;
            }
            case 13: {
                this.getEAttributes().clear();
                return;
            }
            case 19: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 20: {
                this.setPublic(false);
                return;
            }
            case 21: {
                this.setFinal(false);
                return;
            }
            case 22: {
                this.getImplementsInterfaces().clear();
                return;
            }
            case 23: {
                this.getClassImport().clear();
                return;
            }
            case 24: {
                this.getPackageImports().clear();
                return;
            }
            case 25: {
                this.getFields().clear();
                return;
            }
            case 26: {
                this.getMethods().clear();
                return;
            }
            case 27: {
                this.getInitializers().clear();
                return;
            }
            case 28: {
                this.getDeclaredClasses().clear();
                return;
            }
            case 29: {
                this.setDeclaringClass(null);
                return;
            }
            case 31: {
                this.getEvents().clear();
                return;
            }
            case 32: {
                this.getAllEvents().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public EList getImplementsInterfacesGen() {
        if (this.implementsInterfaces == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.implementsInterfaces = new EObjectResolvingEList(clazz, (InternalEObject)this, 22){

                public Object get(int index) {
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().get(index);
                    }
                    return super.get(index);
                }

                public void clear() {
                    super.clear();
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().clear();
                    }
                }

                public Object remove(int index) {
                    Object result = super.remove(index);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().remove(index);
                    }
                    return result;
                }

                public boolean removeAll(Collection collection) {
                    boolean result = super.removeAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().removeAll(collection);
                    }
                    return result;
                }

                public void add(int index, Object object) {
                    super.add(index, object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(index, object);
                    }
                }

                public boolean add(Object object) {
                    boolean result = super.add(object);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().add(object);
                    }
                    return result;
                }

                public boolean addAll(Collection collection) {
                    boolean result = super.addAll(collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(collection);
                    }
                    return result;
                }

                public boolean addAll(int index, Collection collection) {
                    boolean result = super.addAll(index, collection);
                    if (JavaClassImpl.this.isInterface()) {
                        JavaClassImpl.this.getInterfaceSuperTypes().addAll(index, collection);
                    }
                    return result;
                }
            };
        }
        return this.implementsInterfaces;
    }

    private EList getInterfaceSuperTypes() {
        return super.getESuperTypes();
    }

    public EList getClassImportGen() {
        if (this.classImport == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.classImport = new EObjectResolvingEList((Class)clazz, (InternalEObject)this, 23);
        }
        return this.classImport;
    }

    public EList getEAllSuperTypes() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return super.getEAllSuperTypes();
    }

    public EList getESuperTypes() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return super.getESuperTypes();
    }

    public EList getPackageImportsGen() {
        if (this.packageImports == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaPackage;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.packageImports = new EObjectResolvingEList((Class)clazz, (InternalEObject)this, 24);
        }
        return this.packageImports;
    }

    public EList getFieldsGen() {
        if (this.fields == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Lorg.eclipse.jem.internal.java.Field;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fields = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 25, 20);
        }
        return this.fields;
    }

    public EList getMethodsGen() {
        if (this.methods == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("[Lorg.eclipse.jem.internal.java.Method;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.methods = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 26, 15);
        }
        return this.methods;
    }

    public JavaPackage getJavaPackageGen() {
        JavaPackage javaPackage = this.basicGetJavaPackage();
        return javaPackage == null ? null : (JavaPackage)EcoreUtil.resolve((EObject)javaPackage, (EObject)this);
    }

    public JavaPackage basicGetJavaPackage() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        block13: {
            if (featureID < 0) break block13;
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    if (((EObjectImpl)this).eContainer == null) return this.eBasicSetContainer(otherEnd, 5, msgs);
                    msgs = this.eBasicRemoveFromContainer(msgs);
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicAdd((Object)otherEnd, msgs);
                }
                case 25: {
                    return ((InternalEList)this.getFields()).basicAdd((Object)otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getMethods()).basicAdd((Object)otherEnd, msgs);
                }
                case 27: {
                    return ((InternalEList)this.getInitializers()).basicAdd((Object)otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getDeclaredClasses()).basicAdd((Object)otherEnd, msgs);
                }
                case 29: {
                    if (this.declaringClass == null) return this.basicSetDeclaringClass((JavaClass)otherEnd, msgs);
                    InternalEObject internalEObject = (InternalEObject)this.declaringClass;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    msgs = internalEObject.eInverseRemove((InternalEObject)this, 28, (Class)clazz, msgs);
                    return this.basicSetDeclaringClass((JavaClass)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (((EObjectImpl)this).eContainer == null) return this.eBasicSetContainer(otherEnd, featureID, msgs);
        msgs = this.eBasicRemoveFromContainer(msgs);
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicRemove((Object)otherEnd, msgs);
                }
                case 12: {
                    return ((InternalEList)this.getEReferences()).basicRemove((Object)otherEnd, msgs);
                }
                case 13: {
                    return ((InternalEList)this.getEAttributes()).basicRemove((Object)otherEnd, msgs);
                }
                case 25: {
                    return ((InternalEList)this.getFields()).basicRemove((Object)otherEnd, msgs);
                }
                case 26: {
                    return ((InternalEList)this.getMethods()).basicRemove((Object)otherEnd, msgs);
                }
                case 27: {
                    return ((InternalEList)this.getInitializers()).basicRemove((Object)otherEnd, msgs);
                }
                case 28: {
                    return ((InternalEList)this.getDeclaredClasses()).basicRemove((Object)otherEnd, msgs);
                }
                case 29: {
                    return this.basicSetDeclaringClass(null, msgs);
                }
                case 31: {
                    return ((InternalEList)this.getEvents()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (((EObjectImpl)this).eContainerFeatureID < 0) break block6;
            switch (((EObjectImpl)this).eContainerFeatureID) {
                case 5: {
                    Class<?> clazz = class$6;
                    if (clazz == null) {
                        try {
                            clazz = class$6 = Class.forName("[Lorg.eclipse.emf.ecore.EPackage;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, 5, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, -1 - ((EObjectImpl)this).eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                return this.getEPackage();
            }
            case 6: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getESuperTypes();
            }
            case 9: {
                return this.getEOperations();
            }
            case 10: {
                return this.getEAllAttributes();
            }
            case 11: {
                return this.getEAllReferences();
            }
            case 12: {
                return this.getEReferences();
            }
            case 13: {
                return this.getEAttributes();
            }
            case 14: {
                return this.getEAllContainments();
            }
            case 15: {
                return this.getEAllOperations();
            }
            case 16: {
                return this.getEAllStructuralFeatures();
            }
            case 17: {
                return this.getEAllSuperTypes();
            }
            case 18: {
                return this.getEIDAttribute();
            }
            case 19: {
                return this.getKind();
            }
            case 20: {
                return this.isPublic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return this.getImplementsInterfaces();
            }
            case 23: {
                return this.getClassImport();
            }
            case 24: {
                return this.getPackageImports();
            }
            case 25: {
                return this.getFields();
            }
            case 26: {
                return this.getMethods();
            }
            case 27: {
                return this.getInitializers();
            }
            case 28: {
                return this.getDeclaredClasses();
            }
            case 29: {
                if (resolve) {
                    return this.getDeclaringClass();
                }
                return this.basicGetDeclaringClass();
            }
            case 30: {
                if (resolve) {
                    return this.getJavaPackage();
                }
                return this.basicGetJavaPackage();
            }
            case 31: {
                return this.getEvents();
            }
            case 32: {
                return this.getAllEvents();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public String toStringGen() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (kind: ");
        result.append((Object)this.kind);
        result.append(", public: ");
        result.append(this.public_);
        result.append(", final: ");
        result.append(this.final_);
        result.append(')');
        return result.toString();
    }

    public void setReflected(boolean aBoolean) {
        this.hasReflected = aBoolean;
    }

    private class PropertiesEList
    extends AbstractSequentialList
    implements EList {
        PropertiesEList() {
        }

        public void move(int newPosition, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return JavaClassImpl.this.getEAttributes().size() + JavaClassImpl.this.getEReferences().size();
        }

        public boolean isEmpty() {
            return JavaClassImpl.this.getEAttributes().isEmpty() && JavaClassImpl.this.getEReferences().isEmpty();
        }

        public boolean contains(Object o) {
            return JavaClassImpl.this.getEAttributes().contains(o) || JavaClassImpl.this.getEReferences().contains(o);
        }

        public Object[] toArray() {
            Object[] a = JavaClassImpl.this.getEAttributes().toArray();
            Object[] r = JavaClassImpl.this.getEReferences().toArray();
            Object[] p = new Object[a.length + r.length];
            System.arraycopy(a, 0, p, 0, a.length);
            System.arraycopy(r, 0, p, a.length, r.length);
            return p;
        }

        public Object[] toArray(Object[] p) {
            int size = this.size();
            if (p.length < size) {
                p = (Object[])Array.newInstance(p.getClass().getComponentType(), size);
            }
            Object[] a = JavaClassImpl.this.getEAttributes().toArray();
            Object[] r = JavaClassImpl.this.getEReferences().toArray();
            System.arraycopy(a, 0, p, 0, a.length);
            System.arraycopy(r, 0, p, a.length, r.length);
            if (p.length > size) {
                p[size] = null;
            }
            return p;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object get(int index) {
            int asize = JavaClassImpl.this.getEAttributes().size();
            return index < asize ? JavaClassImpl.this.eAttributes.get(index) : JavaClassImpl.this.getEReferences().get(index - asize);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            int n = JavaClassImpl.this.getEAttributes().indexOf(o);
            if (n == -1 && (n = JavaClassImpl.this.getEReferences().indexOf(o)) != -1) {
                n += JavaClassImpl.this.eAttributes.size();
            }
            return n;
        }

        public int lastIndexOf(Object o) {
            int n = JavaClassImpl.this.getEReferences().lastIndexOf(o);
            n = n == -1 ? JavaClassImpl.this.getEAttributes().lastIndexOf(o) : (n += JavaClassImpl.this.getEAttributes().size());
            return n;
        }

        public ListIterator listIterator(int index) {
            return new PropertiesListIterator(index);
        }

        private class PropertiesListIterator
        implements ListIterator {
            private ListIterator currentItr;
            private ListIterator nextItr;
            private boolean attrType;
            private boolean switchIt;

            public PropertiesListIterator(int index) {
                if (index >= JavaClassImpl.this.getEAttributes().size()) {
                    this.attrType = false;
                    this.currentItr = JavaClassImpl.this.getEReferences().listIterator(index - JavaClassImpl.this.eAttributes.size());
                } else {
                    this.attrType = true;
                    this.currentItr = JavaClassImpl.this.eAttributes.listIterator(index);
                }
            }

            public boolean hasNext() {
                if (this.attrType) {
                    if (this.currentItr.hasNext()) {
                        return true;
                    }
                    this.switchIt = true;
                    if (this.nextItr == null) {
                        this.nextItr = JavaClassImpl.this.getEReferences().listIterator();
                    }
                    return this.nextItr.hasNext();
                }
                return this.currentItr.hasNext();
            }

            public Object next() {
                if (this.switchIt) {
                    this.switchIt = false;
                    ListIterator t = this.currentItr;
                    this.currentItr = this.nextItr;
                    this.nextItr = t;
                    this.attrType = false;
                }
                return this.currentItr.next();
            }

            public boolean hasPrevious() {
                if (!this.attrType) {
                    if (this.currentItr.hasPrevious()) {
                        return true;
                    }
                    this.switchIt = true;
                    if (this.nextItr == null) {
                        this.nextItr = JavaClassImpl.this.getEAttributes().listIterator(JavaClassImpl.this.eAttributes.size());
                    }
                    return this.nextItr.hasPrevious();
                }
                return this.currentItr.hasPrevious();
            }

            public Object previous() {
                if (this.switchIt) {
                    this.switchIt = false;
                    ListIterator t = this.currentItr;
                    this.currentItr = this.nextItr;
                    this.nextItr = t;
                    this.attrType = true;
                }
                return this.currentItr.previous();
            }

            public int nextIndex() {
                return this.attrType ? this.currentItr.nextIndex() : this.currentItr.nextIndex() + JavaClassImpl.this.eAttributes.size();
            }

            public int previousIndex() {
                return this.attrType ? this.currentItr.previousIndex() : this.currentItr.previousIndex() + JavaClassImpl.this.eAttributes.size();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

