/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.impl.EOperationImpl;
import org.eclipse.emf.ecore.impl.ETypedElementImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.Block;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.JavaParameter;
import org.eclipse.jem.internal.java.JavaRefPackage;
import org.eclipse.jem.internal.java.JavaVisibilityKind;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;

public class MethodImpl
extends EOperationImpl
implements Method {
    protected String signature;
    protected static final boolean ABSTRACT_EDEFAULT = false;
    protected boolean abstract_ = false;
    protected static final boolean NATIVE_EDEFAULT = false;
    protected boolean native_ = false;
    protected static final boolean SYNCHRONIZED_EDEFAULT = false;
    protected boolean synchronized_ = false;
    protected static final boolean FINAL_EDEFAULT = false;
    protected boolean final_ = false;
    protected static final boolean CONSTRUCTOR_EDEFAULT = false;
    protected boolean constructor = false;
    protected static final boolean STATIC_EDEFAULT = false;
    protected boolean static_ = false;
    protected static final JavaVisibilityKind JAVA_VISIBILITY_EDEFAULT = JavaVisibilityKind.PUBLIC_LITERAL;
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private transient boolean isGenerated = false;
    protected JavaVisibilityKind javaVisibility = JAVA_VISIBILITY_EDEFAULT;
    protected EList parameters = null;
    protected EList javaExceptions = null;
    protected Block source = null;
    protected boolean hasReflected = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected MethodImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getMethod();
    }

    public boolean isAbstractGen() {
        return this.abstract_;
    }

    public void setAbstract(boolean newAbstract) {
        boolean oldAbstract = this.abstract_;
        this.abstract_ = newAbstract;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldAbstract, this.abstract_));
        }
    }

    public boolean isNativeGen() {
        return this.native_;
    }

    public void setNative(boolean newNative) {
        boolean oldNative = this.native_;
        this.native_ = newNative;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldNative, this.native_));
        }
    }

    public boolean isSynchronizedGen() {
        return this.synchronized_;
    }

    public void setSynchronized(boolean newSynchronized) {
        boolean oldSynchronized = this.synchronized_;
        this.synchronized_ = newSynchronized;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldSynchronized, this.synchronized_));
        }
    }

    public boolean isFinalGen() {
        return this.final_;
    }

    public void setFinal(boolean newFinal) {
        boolean oldFinal = this.final_;
        this.final_ = newFinal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldFinal, this.final_));
        }
    }

    public boolean isConstructorGen() {
        return this.constructor;
    }

    public void setConstructor(boolean newConstructor) {
        boolean oldConstructor = this.constructor;
        this.constructor = newConstructor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldConstructor, this.constructor));
        }
    }

    public boolean isStaticGen() {
        return this.static_;
    }

    public void setStatic(boolean newStatic) {
        boolean oldStatic = this.static_;
        this.static_ = newStatic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldStatic, this.static_));
        }
    }

    public JavaClass getContainingJavaClass() {
        return this.getJavaClass();
    }

    public boolean isAbstract() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isAbstractGen();
    }

    public boolean isConstructor() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isConstructorGen();
    }

    public boolean isFinal() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isFinalGen();
    }

    public boolean isNative() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isNativeGen();
    }

    public boolean isStatic() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isStaticGen();
    }

    public boolean isSynchronized() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.isSynchronizedGen();
    }

    public EList getJavaExceptions() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getJavaExceptionsGen();
    }

    public JavaVisibilityKind getJavaVisibility() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getJavaVisibilityGen();
    }

    public EList getParameters() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getParametersGen();
    }

    public EClassifier getEType() {
        if (!this.hasReflected) {
            this.reflectValues();
        }
        return this.getETypeGen();
    }

    public EClassifier getETypeGen() {
        return super.getEType();
    }

    public String getMethodElementSignature() {
        StringBuffer sb = new StringBuffer(75);
        sb.append(this.getName());
        sb.append("(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int commaTest = 0;
        int j = 0;
        while (j < parmSize) {
            if (j > commaTest) {
                sb.append(",");
            }
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            ++j;
        }
        sb.append(")");
        return sb.toString();
    }

    public JavaParameter getParameter(String parameterName) {
        EList parms = this.getParameters();
        int parmSize = parms.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter parm = (JavaParameter)parms.get(j);
            if (parm.getName().equals(parameterName)) {
                return parm;
            }
            ++j;
        }
        return null;
    }

    protected ReadAdaptor getReadAdaptor() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter((EObject)this, (Object)"JavaReflection");
    }

    protected void reflectValues() {
        ReadAdaptor readAdaptor = this.getReadAdaptor();
        if (readAdaptor != null) {
            this.hasReflected = readAdaptor.reflectValuesIfNecessary();
        }
    }

    public JavaHelpers getReturnType() {
        return (JavaHelpers)this.getEType();
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.doGetSignature();
        }
        return this.signature;
    }

    protected String doGetSignature() {
        StringBuffer sb = new StringBuffer();
        switch (this.getJavaVisibility().getValue()) {
            case 0: {
                sb.append("Public ");
                break;
            }
            case 2: {
                sb.append("Protected ");
                break;
            }
            case 1: {
                sb.append("Private ");
                break;
            }
            case 3: {
                sb.append("Package ");
            }
        }
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        if (this.isSynchronized()) {
            sb.append("synchronized ");
        }
        if (this.isNative()) {
            sb.append("native ");
        }
        if (this.isVoid()) {
            sb.append("void ");
        } else {
            sb.append(String.valueOf(this.getReturnType().getQualifiedName()) + " ");
        }
        sb.append(String.valueOf(this.getContainingJavaClass().getJavaName()) + ".");
        sb.append(String.valueOf(this.getName()) + "(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            if (j < params.size() - 1) {
                sb.append(",");
            }
            ++j;
        }
        sb.append(")");
        EList exceptions = this.getJavaExceptions();
        if (exceptions.size() > 0) {
            sb.append(" throws ");
            int k = 0;
            while (k < exceptions.size()) {
                JavaClass exception = (JavaClass)exceptions.get(k);
                sb.append(exception.getJavaName());
                if (k < exceptions.size() - 1) {
                    sb.append(",");
                }
                ++k;
            }
        }
        return sb.toString();
    }

    public boolean isGenerated() {
        return false;
    }

    public boolean isVoid() {
        return this.getReturnType() == null || "void".equals(this.getReturnType().getName());
    }

    public JavaParameter[] listParametersWithoutReturn() {
        EList v = this.getParameters();
        JavaParameter[] result = new JavaParameter[v.size()];
        v.toArray(result);
        return result;
    }

    public EList eContents() {
        BasicEList results = new BasicEList();
        results.addAll(this.getParametersGen());
        return results;
    }

    public void setIsGenerated(boolean generated) {
        this.isGenerated = generated;
    }

    public void setReturnType(JavaHelpers type) {
        this.setEType(type);
    }

    public JavaVisibilityKind getJavaVisibilityGen() {
        return this.javaVisibility;
    }

    public void setJavaVisibility(JavaVisibilityKind newJavaVisibility) {
        JavaVisibilityKind oldJavaVisibility = this.javaVisibility;
        JavaVisibilityKind javaVisibilityKind = this.javaVisibility = newJavaVisibility == null ? JAVA_VISIBILITY_EDEFAULT : newJavaVisibility;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldJavaVisibility, (Object)this.javaVisibility));
        }
    }

    public JavaClass getJavaClass() {
        if (((EObjectImpl)this).eContainerFeatureID != 15) {
            return null;
        }
        return (JavaClass)((EObjectImpl)this).eContainer;
    }

    public void setJavaClass(JavaClass newJavaClass) {
        if (newJavaClass != ((EObjectImpl)this).eContainer || ((EObjectImpl)this).eContainerFeatureID != 15 && newJavaClass != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newJavaClass)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (((EObjectImpl)this).eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newJavaClass != null) {
                InternalEObject internalEObject = (InternalEObject)newJavaClass;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 26, (Class)clazz, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newJavaClass, 15, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newJavaClass, (Object)newJavaClass));
        }
    }

    public Block getSource() {
        if (this.source != null && this.source.eIsProxy()) {
            Block oldSource = this.source;
            this.source = (Block)EcoreUtil.resolve((EObject)this.source, (EObject)this);
            if (this.source != oldSource && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 16, (Object)oldSource, (Object)this.source));
            }
        }
        return this.source;
    }

    public Block basicGetSource() {
        return this.source;
    }

    public void setSource(Block newSource) {
        Block oldSource = this.source;
        this.source = newSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldSource, (Object)this.source));
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ((EModelElementImpl)this).eAnnotations != null && !((EModelElementImpl)this).eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? ((ENamedElementImpl)this).name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(((ENamedElementImpl)this).name);
            }
            case 2: {
                return ((ETypedElementImpl)this).eType != null;
            }
            case 3: {
                return this.getEContainingClass() != null;
            }
            case 4: {
                return this.eParameters != null && !this.eParameters.isEmpty();
            }
            case 5: {
                return this.eExceptions != null && !this.eExceptions.isEmpty();
            }
            case 6: {
                return this.abstract_;
            }
            case 7: {
                return this.native_;
            }
            case 8: {
                return this.synchronized_;
            }
            case 9: {
                return this.final_;
            }
            case 10: {
                return this.constructor;
            }
            case 11: {
                return this.static_;
            }
            case 12: {
                return this.javaVisibility != JAVA_VISIBILITY_EDEFAULT;
            }
            case 13: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
            case 14: {
                return this.javaExceptions != null && !this.javaExceptions.isEmpty();
            }
            case 15: {
                return this.getJavaClass() != null;
            }
            case 16: {
                return this.source != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setEType((EClassifier)newValue);
                return;
            }
            case 4: {
                this.getEParameters().clear();
                this.getEParameters().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getEExceptions().clear();
                this.getEExceptions().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 7: {
                this.setNative((Boolean)newValue);
                return;
            }
            case 8: {
                this.setSynchronized((Boolean)newValue);
                return;
            }
            case 9: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 10: {
                this.setConstructor((Boolean)newValue);
                return;
            }
            case 11: {
                this.setStatic((Boolean)newValue);
                return;
            }
            case 12: {
                this.setJavaVisibility((JavaVisibilityKind)((Object)newValue));
                return;
            }
            case 13: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getJavaExceptions().clear();
                this.getJavaExceptions().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setJavaClass((JavaClass)newValue);
                return;
            }
            case 16: {
                this.setSource((Block)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setEType(null);
                return;
            }
            case 4: {
                this.getEParameters().clear();
                return;
            }
            case 5: {
                this.getEExceptions().clear();
                return;
            }
            case 6: {
                this.setAbstract(false);
                return;
            }
            case 7: {
                this.setNative(false);
                return;
            }
            case 8: {
                this.setSynchronized(false);
                return;
            }
            case 9: {
                this.setFinal(false);
                return;
            }
            case 10: {
                this.setConstructor(false);
                return;
            }
            case 11: {
                this.setStatic(false);
                return;
            }
            case 12: {
                this.setJavaVisibility(JAVA_VISIBILITY_EDEFAULT);
                return;
            }
            case 13: {
                this.getParameters().clear();
                return;
            }
            case 14: {
                this.getJavaExceptions().clear();
                return;
            }
            case 15: {
                this.setJavaClass(null);
                return;
            }
            case 16: {
                this.setSource(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (abstract: ");
        result.append(this.abstract_);
        result.append(", native: ");
        result.append(this.native_);
        result.append(", synchronized: ");
        result.append(this.synchronized_);
        result.append(", final: ");
        result.append(this.final_);
        result.append(", constructor: ");
        result.append(this.constructor);
        result.append(", static: ");
        result.append(this.static_);
        result.append(", javaVisibility: ");
        result.append((Object)this.javaVisibility);
        result.append(')');
        return result.toString();
    }

    public EList getParametersGen() {
        if (this.parameters == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaParameter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameters = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 13);
        }
        return this.parameters;
    }

    public EList getJavaExceptionsGen() {
        if (this.javaExceptions == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.javaExceptions = new EObjectResolvingEList((Class)clazz, (InternalEObject)this, 14);
        }
        return this.javaExceptions;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 3: {
                    if (((EObjectImpl)this).eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getEParameters()).basicAdd((Object)otherEnd, msgs);
                }
                case 15: {
                    if (((EObjectImpl)this).eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 15, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (((EObjectImpl)this).eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getEParameters()).basicRemove((Object)otherEnd, msgs);
                }
                case 13: {
                    return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
                }
                case 15: {
                    return this.eBasicSetContainer(null, 15, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block10: {
            if (((EObjectImpl)this).eContainerFeatureID < 0) break block10;
            switch (((EObjectImpl)this).eContainerFeatureID) {
                case 3: {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("[Lorg.eclipse.emf.ecore.EClass;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, 9, (Class)clazz, msgs);
                }
                case 15: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.jem.internal.java.JavaClass;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, 26, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, -1 - ((EObjectImpl)this).eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                if (resolve) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
            case 3: {
                return this.getEContainingClass();
            }
            case 4: {
                return this.getEParameters();
            }
            case 5: {
                return this.getEExceptions();
            }
            case 6: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isNative() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.isSynchronized() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return this.isConstructor() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.isStatic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.getJavaVisibility();
            }
            case 13: {
                return this.getParameters();
            }
            case 14: {
                return this.getJavaExceptions();
            }
            case 15: {
                return this.getJavaClass();
            }
            case 16: {
                if (resolve) {
                    return this.getSource();
                }
                return this.basicGetSource();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }
}

