/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.beaninfo.vm;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class BaseBeanInfo
extends SimpleBeanInfo {
    public static ResourceBundle RESBUNDLE = ResourceBundle.getBundle("org.eclipse.jem.beaninfo.vm.basebeaninfonls");
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String PROPERTYEDITORCLASS = "propertyEditorClass";
    public static final String READMETHOD = "readMethod";
    public static final String WRITEMETHOD = "writeMethod";
    public static final String DISPLAYNAME = "displayName";
    public static final String EXPERT = "expert";
    public static final String HIDDEN = "hidden";
    public static final String PREFERRED = "preferred";
    public static final String SHORTDESCRIPTION = "shortDescription";
    public static final String CUSTOMIZERCLASS = "customizerClass";
    public static final String CATEGORY = "category";
    public static final String INDEFAULTEVENTSET = "inDefaultEventSet";
    public static final String ENUMERATIONVALUES = "enumerationValues";
    public static final String OBSCURE = "ivjObscure";
    public static final String DESIGNTIMEPROPERTY = "ivjDesignTimeProperty";
    public static final String EVENTADAPTERCLASS = "eventAdapterClass";
    public static final String ICONCOLOR16X16URL = "ICON_COLOR_16x16";
    public static final String ICONCOLOR32X32URL = "ICON_COLOR_32x32";
    public static final String ICONMONO16X16URL = "ICON_MONO_16x16";
    public static final String ICONMONO32X32URL = "ICON_MONO_32x32";
    public static final boolean JVM_1_3 = System.getProperty("java.version", "").startsWith("1.3");

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public BeanDescriptor createBeanDescriptor(Class cls, Object[] args) {
        Class customizerClass = null;
        int i = 0;
        while (i < args.length) {
            if (CUSTOMIZERCLASS.equals((String)args[i])) {
                customizerClass = (Class)args[i + 1];
                break;
            }
            i += 2;
        }
        BeanDescriptor bd = new BeanDescriptor(cls, customizerClass);
        int i2 = 0;
        while (i2 < args.length) {
            String key = (String)args[i2];
            Object value = args[i2 + 1];
            this.setFeatureDescriptorValue(bd, key, value);
            i2 += 2;
        }
        return bd;
    }

    public EventSetDescriptor createEventSetDescriptor(Class cls, String name, Object[] args, MethodDescriptor[] lmds, Class listenerType, String addListenerName, String removeListenerName) {
        EventSetDescriptor esd = null;
        Class[] paramTypes = new Class[]{listenerType};
        try {
            Method addMethod = null;
            Method removeMethod = null;
            try {
                addMethod = cls.getMethod(addListenerName, paramTypes);
            }
            catch (Exception ie) {
                this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), addListenerName));
            }
            try {
                removeMethod = cls.getMethod(removeListenerName, paramTypes);
            }
            catch (Exception ie) {
                this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), removeListenerName));
            }
            esd = new EventSetDescriptor(name, listenerType, lmds, addMethod, removeMethod);
        }
        catch (Exception ie) {
            this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_E1_EXC_"), name));
        }
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            if (INDEFAULTEVENTSET.equals(key)) {
                esd.setInDefaultEventSet((Boolean)value);
            } else {
                this.setFeatureDescriptorValue(esd, key, value);
            }
            i += 2;
        }
        return esd;
    }

    public MethodDescriptor createMethodDescriptor(Class cls, String name, Object[] args, ParameterDescriptor[] params, Class[] paramTypes) {
        MethodDescriptor md = null;
        try {
            Method aMethod = null;
            try {
                aMethod = cls.getMethod(name, paramTypes);
            }
            catch (Exception ie) {
                this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_get_the_meth1_EXC_"), name));
            }
            md = paramTypes.length > 0 ? new MethodDescriptor(aMethod, params) : new MethodDescriptor(aMethod);
        }
        catch (Exception ie) {
            this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_Method_EXC_"), name));
        }
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            this.setFeatureDescriptorValue(md, key, value);
            i += 2;
        }
        return md;
    }

    private PropertyDescriptor createOtherPropertyDescriptor(String name, Class cls) throws IntrospectionException {
        Method readMethod = null;
        Method writeMethod = null;
        String base = BaseBeanInfo.capitalize(name);
        Class[] parameters = new Class[]{};
        try {
            readMethod = cls.getMethod("is" + base, parameters);
        }
        catch (Exception exception) {}
        if (readMethod == null) {
            try {
                readMethod = cls.getMethod("get" + base, parameters);
            }
            catch (Exception exception) {
                readMethod = BaseBeanInfo.findMethod(cls, "get" + base, 0);
            }
        }
        if (readMethod == null) {
            writeMethod = BaseBeanInfo.findMethod(cls, "set" + base, 1);
        } else {
            parameters = new Class[]{readMethod.getReturnType()};
            try {
                writeMethod = cls.getMethod("set" + base, parameters);
            }
            catch (Exception exception) {}
        }
        if (readMethod != null || writeMethod != null) {
            return new PropertyDescriptor(name, readMethod, writeMethod);
        }
        throw new IntrospectionException(MessageFormat.format(RESBUNDLE.getString("Cannot_find_the_acc1_EXC_"), name));
    }

    public ParameterDescriptor createParameterDescriptor(String name, Object[] args) {
        ParameterDescriptor pd = null;
        try {
            pd = new ParameterDescriptor();
        }
        catch (Exception ie) {
            this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_Param1_EXC_"), name));
        }
        pd.setName(name);
        int i = 0;
        while (i < args.length) {
            String key = (String)args[i];
            Object value = args[i + 1];
            this.setFeatureDescriptorValue(pd, key, value);
            i += 2;
        }
        return pd;
    }

    public PropertyDescriptor createPropertyDescriptor(Class cls, String name, Object[] args) {
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(name, cls);
        }
        catch (IntrospectionException introspectionException) {
            try {
                pd = this.createOtherPropertyDescriptor(name, cls);
            }
            catch (IntrospectionException ie) {
                this.throwError(ie, MessageFormat.format(RESBUNDLE.getString("Cannot_create_the_P1_EXC_"), name));
            }
        }
        this.setFeatureDescriptorValue(pd, DISPLAYNAME, name);
        int i = 0;
        while (i < args.length) {
            block20: {
                Method method;
                String methodName;
                String key = (String)args[i];
                Object value = args[i + 1];
                if (BOUND.equals(key)) {
                    pd.setBound((Boolean)value);
                } else if (CONSTRAINED.equals(key)) {
                    pd.setConstrained((Boolean)value);
                } else if (PROPERTYEDITORCLASS.equals(key)) {
                    pd.setPropertyEditorClass((Class)value);
                } else if (READMETHOD.equals(key)) {
                    methodName = (String)value;
                    try {
                        method = cls.getMethod(methodName, new Class[0]);
                        pd.setReadMethod(method);
                    }
                    catch (Exception e) {
                        this.throwError(e, MessageFormat.format(RESBUNDLE.getString("{0}_no_read_method_EXC_"), cls, methodName));
                    }
                } else if (WRITEMETHOD.equals(key)) {
                    methodName = (String)value;
                    try {
                        if (methodName == null) {
                            pd.setWriteMethod(null);
                            break block20;
                        }
                        Class<?> type = pd.getPropertyType();
                        method = cls.getMethod(methodName, type);
                        pd.setWriteMethod(method);
                    }
                    catch (Exception e) {
                        this.throwError(e, MessageFormat.format(RESBUNDLE.getString("{0}_no_write_method_EXC_"), cls, methodName));
                    }
                } else {
                    this.setFeatureDescriptorValue(pd, key, value);
                }
            }
            i += 2;
        }
        return pd;
    }

    public static Method findMethod(Class aClass, String methodName, int parameterCount) {
        try {
            Method[] methods = aClass.getMethods();
            int index = 0;
            while (index < methods.length) {
                Method method = methods[index];
                if (method.getParameterTypes().length == parameterCount && method.getName().equals(methodName)) {
                    return method;
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[]{Introspector.getBeanInfo(this.getBeanClass().getSuperclass())};
        }
        catch (IntrospectionException introspectionException) {
            return new BeanInfo[0];
        }
    }

    public abstract Class getBeanClass();

    public void handleException(Throwable exception) {
        System.err.println(RESBUNDLE.getString("UNCAUGHT_EXC_"));
        exception.printStackTrace();
    }

    private void setFeatureDescriptorValue(FeatureDescriptor fd, String key, Object value) {
        if (DISPLAYNAME.equals(key)) {
            fd.setDisplayName((String)value);
        } else if (EXPERT.equals(key)) {
            fd.setExpert((Boolean)value);
        } else if (HIDDEN.equals(key)) {
            fd.setHidden((Boolean)value);
        } else if (PREFERRED.equals(key)) {
            fd.setPreferred((Boolean)value);
            if (JVM_1_3) {
                fd.setValue(PREFERRED, value);
            }
        } else if (SHORTDESCRIPTION.equals(key)) {
            fd.setShortDescription((String)value);
        } else {
            fd.setValue(key, value);
        }
    }

    protected void throwError(Exception e, String s) {
        throw new Error(String.valueOf(e.toString()) + " " + s);
    }
}

