/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.vm;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.jem.internal.beaninfo.vm.BeanDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.EventSetDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.IndexedPropertyDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.MethodDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.ParameterDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.PropertyDescriptorEquality;

public class FeatureDescriptorEquality {
    protected FeatureDescriptor fFeature;
    private HashMap fValues;
    private int fHashCode = 0;
    protected static HashMap MAP_EQUALITY = new HashMap(10);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        try {
            Class<?> clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[Ljava.beans.FeatureDescriptor;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jem.internal.beaninfo.vm.FeatureDescriptorEquality;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("[Ljava.beans.FeatureDescriptor;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            MAP_EQUALITY.put(clazz2, clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        BeanDescriptorEquality.INIT();
        EventSetDescriptorEquality.INIT();
        IndexedPropertyDescriptorEquality.INIT();
        MethodDescriptorEquality.INIT();
        ParameterDescriptorEquality.INIT();
        PropertyDescriptorEquality.INIT();
    }

    public static FeatureDescriptorEquality createEquality(FeatureDescriptor descr) {
        try {
            return (FeatureDescriptorEquality)((Constructor)MAP_EQUALITY.get(descr.getClass())).newInstance(descr);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public FeatureDescriptorEquality() {
    }

    public FeatureDescriptorEquality(FeatureDescriptor feature) {
        this.setFeature(feature);
    }

    public final void setFeature(FeatureDescriptor feature) {
        this.clearFeature();
        this.fFeature = feature;
    }

    protected void clearFeature() {
        this.fValues = null;
        this.fHashCode = 0;
    }

    public final int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = this.calculateHashCode();
        }
        return this.fHashCode;
    }

    protected final HashMap values() {
        if (this.fValues == null) {
            this.fValues = new HashMap(5);
            Enumeration<String> keys = this.fFeature.attributeNames();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.fValues.put(key, this.fFeature.getValue(key));
            }
        }
        return this.fValues;
    }

    protected int calculateHashCode() {
        int hashcode = 0;
        if (this.fFeature.getName() != null) {
            hashcode += this.fFeature.getName().hashCode();
        }
        if (this.fFeature.getDisplayName() != this.fFeature.getName()) {
            hashcode += this.fFeature.getDisplayName().hashCode();
        }
        if (this.fFeature.getShortDescription() != this.fFeature.getDisplayName()) {
            hashcode += this.fFeature.getShortDescription().hashCode();
        }
        hashcode += (this.fFeature.isExpert() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        hashcode += (this.fFeature.isHidden() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        hashcode += (this.fFeature.isPreferred() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        return hashcode += this.values().hashCode();
    }

    public boolean equals(Object obj) {
        if (this.identityTest(obj)) {
            return true;
        }
        if (!(obj instanceof FeatureDescriptorEquality)) {
            return false;
        }
        FeatureDescriptorEquality ofe = (FeatureDescriptorEquality)obj;
        FeatureDescriptor of = ofe.fFeature;
        if (this.fFeature.getClass() != of.getClass()) {
            return false;
        }
        if (!this.fFeature.getName().equals(of.getName())) {
            return false;
        }
        if (!this.fFeature.getDisplayName().equals(of.getDisplayName())) {
            return false;
        }
        if (!this.fFeature.getShortDescription().equals(of.getShortDescription())) {
            return false;
        }
        if (this.fFeature.isExpert() != of.isExpert() || this.fFeature.isHidden() != of.isHidden() || this.fFeature.isPreferred() != of.isPreferred()) {
            return false;
        }
        return this.values().equals(ofe.values());
    }

    protected boolean identityTest(Object obj) {
        if (!(obj instanceof FeatureDescriptorEquality)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return ((FeatureDescriptorEquality)obj).fFeature == this.fFeature;
    }
}

