/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet.command;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class SetPropertyValueCommand
extends AbstractCommand {
    protected Object propertyValue;
    protected Object propertyId;
    protected Object undoValue;
    protected boolean resetOnUndo;
    protected IPropertySource target;

    public SetPropertyValueCommand() {
    }

    public SetPropertyValueCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        boolean bl = this.resetOnUndo = !this.getTarget().isPropertySet(this.propertyId);
        if (!this.resetOnUndo) {
            this.undoValue = this.getTarget().getPropertyValue(this.propertyId);
            if (this.undoValue instanceof IPropertySource) {
                this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
            }
        } else {
            this.undoValue = null;
        }
        this.getTarget().setPropertyValue(this.propertyId, this.propertyValue);
    }

    public IPropertySource getTarget() {
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    public void setPropertyId(Object pId) {
        this.propertyId = pId;
    }

    public void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void undo() {
        if (this.resetOnUndo) {
            this.getTarget().resetPropertyValue(this.propertyId);
        } else {
            this.getTarget().setPropertyValue(this.propertyId, this.undoValue);
        }
    }
}

