/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.beaninfo.adapters.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.adapters.IReader;
import org.eclipse.jem.internal.beaninfo.adapters.SearchpathEntry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeaninfoEntry
implements IBeaninfosDocEntry {
    static final String sBeaninfo = "beaninfo";
    public static final int BIE_PLUGIN = 100;
    protected IClasspathEntry entry;
    protected IPath pluginPath;
    protected boolean isExported;
    protected SearchpathEntry[] searchpaths;

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("plugin")) {
            return 100;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 100: {
                return "plugin";
            }
        }
        return "unknown";
    }

    public static IClasspathEntry createEntry(int kind, IPath path, IProject project, boolean isExported) {
        switch (kind) {
            case 1: {
                if (!path.isAbsolute()) break;
                return JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)isExported);
            }
            case 3: {
                if (!path.isAbsolute()) break;
                String projSegment = path.segment(0);
                if (project != null && projSegment != null && projSegment.equals(project.getName())) {
                    return JavaCore.newSourceEntry((IPath)path);
                }
                return JavaCore.newProjectEntry((IPath)path, (boolean)isExported);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, null, null, (boolean)isExported);
            }
        }
        return null;
    }

    public static BeaninfoEntry readEntry(IReader reader, Object element, IProject project) {
        String elementKind = reader.getAttribute(element, "kind");
        String pathStr = reader.getAttribute(element, "path");
        Path path = new Path(pathStr);
        int kind = BeaninfoEntry.kindFromString(elementKind);
        if (kind != 4 && kind != 100 && !path.isAbsolute()) {
            path = project != null ? project.getFullPath().append((IPath)path) : path.makeAbsolute();
        }
        String exportedString = reader.getAttribute(element, "exported");
        boolean isExported = "true".equalsIgnoreCase(exportedString);
        IClasspathEntry cpEntry = null;
        Path pluginPath = null;
        if (kind != 100) {
            cpEntry = BeaninfoEntry.createEntry(kind, (IPath)path, project, isExported);
        } else if (path.isAbsolute()) {
            pluginPath = path;
        }
        ArrayList<SearchpathEntry> searchpaths = new ArrayList<SearchpathEntry>();
        Object children = reader.getChildren(element);
        int childrenLength = reader.getLength(children);
        int i = 0;
        while (i < childrenLength) {
            Object child = reader.getItem(children, i);
            if (reader.isNodeTypeElement(child)) {
                SearchpathEntry entry = null;
                if (reader.getNodeName(child).equalsIgnoreCase("searchpath")) {
                    entry = SearchpathEntry.readEntry(reader, child, project, true);
                }
                if (entry != null) {
                    searchpaths.add(entry);
                }
            }
            ++i;
        }
        if (cpEntry != null) {
            return new BeaninfoEntry(cpEntry, searchpaths.toArray(new SearchpathEntry[searchpaths.size()]), isExported);
        }
        if (pluginPath != null) {
            return new BeaninfoEntry((IPath)pluginPath, searchpaths.toArray(new SearchpathEntry[searchpaths.size()]), isExported);
        }
        return null;
    }

    public BeaninfoEntry(IPath pluginPath, SearchpathEntry[] searchpaths, boolean isExported) {
        this(searchpaths, isExported);
        this.pluginPath = pluginPath;
    }

    public BeaninfoEntry(IClasspathEntry entry, SearchpathEntry[] searchpaths, boolean isExported) {
        this(searchpaths, isExported);
        this.entry = entry;
    }

    protected BeaninfoEntry(SearchpathEntry[] searchpaths, boolean isExported) {
        this.isExported = isExported;
        this.searchpaths = searchpaths != null ? searchpaths : new SearchpathEntry[]{};
    }

    public SearchpathEntry[] getSearchPaths() {
        return this.searchpaths;
    }

    public void setSearchPaths(SearchpathEntry[] searchpaths) {
        this.searchpaths = searchpaths;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public void setIsExported(boolean isExported) {
        this.isExported = isExported;
    }

    public Node writeEntry(Document doc, IProject project) {
        Element element = doc.createElement(sBeaninfo);
        IPath path = null;
        if (this.entry != null) {
            element.setAttribute("kind", BeaninfoEntry.kindToString(this.entry.getEntryKind()));
            path = this.entry.getPath();
            if (this.entry.getEntryKind() != 4 && path.isAbsolute()) {
                if (path.segment(0).equals(project.getFullPath().segment(0))) {
                    path = path.removeFirstSegments(1);
                    path = path.makeRelative();
                } else {
                    path = path.makeAbsolute();
                }
            }
        } else {
            element.setAttribute("kind", BeaninfoEntry.kindToString(100));
            path = this.pluginPath;
        }
        element.setAttribute("path", path.toString());
        if (this.isExported()) {
            element.setAttribute("exported", "true");
        }
        int i = 0;
        while (i < this.searchpaths.length) {
            SearchpathEntry spe = this.searchpaths[i];
            element.appendChild(spe.writeEntry(doc, project));
            ++i;
        }
        return element;
    }

    public IClasspathEntry getClasspathEntry() {
        return this.entry;
    }

    public Object getClasspath() {
        block11: {
            block12: {
                if (this.entry == null) break block12;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.entry);
                switch (resolvedEntry.getEntryKind()) {
                    case 2: {
                        IProject reqProject = (IProject)root.findMember(resolvedEntry.getPath().lastSegment());
                        if (reqProject != null && reqProject.isOpen()) {
                            return reqProject;
                        }
                        return null;
                    }
                    case 3: {
                        IProject reqProject = (IProject)root.findMember(resolvedEntry.getPath().segment(0));
                        IJavaProject javaProject = JavaCore.create((IProject)reqProject);
                        if (javaProject != null) {
                            try {
                                IPath outputLocation = javaProject.getOutputLocation();
                                IResource resource = root.findMember(outputLocation);
                                if (resource != null) {
                                    return resource.getLocation().toString();
                                }
                                break block11;
                            }
                            catch (JavaModelException javaModelException) {
                                break;
                            }
                        }
                        break block11;
                    }
                    case 1: {
                        IResource library = root.findMember(resolvedEntry.getPath());
                        return library != null ? library.getLocation().toString() : resolvedEntry.getPath().toString();
                    }
                }
                break block11;
            }
            IPluginDescriptor descr = Platform.getPluginRegistry().getPluginDescriptor(this.pluginPath.segment(0));
            if (descr != null) {
                return ProxyPlugin.getPlugin().localizeFromPluginDescriptorAndFragments(descr, this.pluginPath.removeFirstSegments(1).toString());
            }
        }
        return null;
    }

    public int getKind() {
        return this.entry != null ? this.entry.getEntryKind() : 100;
    }

    public IPath getPath() {
        return this.entry != null ? this.entry.getPath() : this.pluginPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeaninfoEntry)) {
            return false;
        }
        BeaninfoEntry otherEntry = (BeaninfoEntry)other;
        if (this.isExported != otherEntry.isExported) {
            return false;
        }
        if (this.entry != null) {
            return this.entry.equals(otherEntry.entry);
        }
        return this.pluginPath.equals((Object)otherEntry.pluginPath);
    }

    public int hashCode() {
        if (this.entry != null) {
            return this.entry.hashCode() ^ (this.isExported ? Boolean.TRUE : Boolean.FALSE).hashCode();
        }
        return this.pluginPath.hashCode() ^ (this.isExported ? Boolean.TRUE : Boolean.FALSE).hashCode();
    }
}

