/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import com.ibm.etools.emf.workbench.ResourceHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoJavaReflectionKeyExtension;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoModelSynchronizer;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoRegistration;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoSearchPathEntry;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.adapters.DOMReader;
import org.eclipse.jem.internal.beaninfo.adapters.IBeaninfoSupplier;
import org.eclipse.jem.internal.beaninfo.adapters.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.adapters.Init;
import org.eclipse.jem.internal.beaninfo.adapters.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.adapters.SpecialResourceSet;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jem.internal.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.internal.java.adapters.JavaXMIFactoryImpl;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.internal.plugin.AbstractJavaMOFNatureRuntime;
import org.eclipse.jem.internal.plugin.IJavaMOFNature;
import org.eclipse.jem.internal.plugin.JavaMOFNatureRuntime;
import org.eclipse.jem.internal.proxy.core.IClasspathContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BeaninfoNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.jem.beaninfo.BeanInfoNature";
    public static final String P_BEANINFO_SEARCH_PATH = ".beaninfoConfig";
    private ResourceTracker resourceTracker;
    private ProxyFactoryRegistry.IRegistryListener registryListener = new ProxyFactoryRegistry.IRegistryListener(){

        public void registryTerminated(ProxyFactoryRegistry registry) {
            BeaninfoNature.this.markAllStale();
        }
    };
    private IProject fProject;
    protected ProxyFactoryRegistry fRegistry;
    protected ResourceSet javaRSet;
    protected BeaninfoModelSynchronizer fSynchronizer;
    protected static BeaninfoJavaReflectionKeyExtension fReflectionKeyExtension;
    private static final String ENCODING = "UTF-8";
    private static final String sSearchPathElementName = "searchPath";
    static final String sBeaninfos = "beaninfos";
    private static final IPath JRE_LIB_VARIABLE_PATH;

    static {
        JRE_LIB_VARIABLE_PATH = new Path("JRE_LIB");
    }

    public static BeaninfoNature getRuntime(IProject project) throws CoreException {
        if (project.hasNature(NATURE_ID)) {
            return (BeaninfoNature)project.getNature(NATURE_ID);
        }
        return BeaninfoNature.createRuntime(project);
    }

    public static boolean isValidProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static BeaninfoNature createRuntime(IProject project) throws CoreException {
        if (!BeaninfoNature.isValidProject(project)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jem.beaninfo", 0, MessageFormat.format(BeaninfoPlugin.getPlugin().getDescriptor().getResourceString("%INTROSPECT_FAILED_EXC_ Introspection failed on class \"{0}.\""), project.getName()), null));
        }
        BeaninfoNature.addNatureToProject(project, NATURE_ID);
        return (BeaninfoNature)project.getNature(NATURE_ID);
    }

    private static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        this.removeSharedProperty(P_BEANINFO_SEARCH_PATH, null);
        this.cleanup(true);
    }

    public ResourceSet newResourceSet() {
        SpecialResourceSet rset = new SpecialResourceSet();
        rset.add(new ResourceHandler(){

            public EObject getEObjectFailed(ResourceSet originatingResourceSet, URI uri, boolean loadOnDemand) {
                return null;
            }

            public Resource getResource(ResourceSet originatingResourceSet, URI uri) {
                return BeaninfoNature.this.getResourceSet().getResource(uri, false);
            }

            public Resource createResource(ResourceSet originatingResourceSet, URI uri) {
                if ("java".equals(uri.scheme())) {
                    return BeaninfoNature.this.getResourceSet().getResource(uri, true);
                }
                return null;
            }
        });
        return rset;
    }

    protected void cleanup(boolean clearResults) {
        this.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceTracker);
        this.resourceTracker = null;
        this.fSynchronizer.stopSynchronizer(clearResults);
        Init.cleanup(this.javaRSet, clearResults);
        if (this.fRegistry != null) {
            this.fRegistry.terminateRegistry();
        }
        this.javaRSet = null;
        this.fRegistry = null;
        this.fProject = null;
        this.fSynchronizer = null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
        try {
            IJavaMOFNature javaNature = JavaMOFNatureRuntime.createRuntime((IProject)this.fProject);
            JavaInit.init();
            if (fReflectionKeyExtension == null) {
                fReflectionKeyExtension = new BeaninfoJavaReflectionKeyExtension();
                JavaXMIFactoryImpl.INSTANCE.registerReflectionKeyExtension((IJavaReflectionKeyExtension)fReflectionKeyExtension);
            }
            this.javaRSet = javaNature.getContext();
            Init.initialize(this.javaRSet, new IBeaninfoSupplier(){

                public ProxyFactoryRegistry getRegistry() {
                    return BeaninfoNature.this.getRegistry();
                }

                public boolean isRegistryCreated() {
                    return BeaninfoNature.this.isRegistryCreated();
                }

                public void closeRegistry() {
                    BeaninfoNature.this.closeRegistry();
                }
            });
            this.fSynchronizer = new BeaninfoModelSynchronizer((BeaninfoAdapterFactory)EcoreUtil.getAdapterFactory((List)this.javaRSet.getAdapterFactories(), (Object)IIntrospectionAdapter.ADAPTER_KEY), ((AbstractJavaMOFNatureRuntime)javaNature).getJavaProject());
            this.resourceTracker = new ResourceTracker();
            project.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceTracker);
        }
        catch (CoreException e) {
            BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)e.getStatus());
        }
    }

    public ProxyFactoryRegistry getRegistry() {
        return this.getRegistry((IProgressMonitor)new NullProgressMonitor());
    }

    protected void closeRegistry() {
        ProxyFactoryRegistry reg = null;
        BeaninfoNature beaninfoNature = this;
        synchronized (beaninfoNature) {
            reg = this.fRegistry;
            this.fRegistry = null;
        }
        if (reg != null) {
            reg.removeRegistryListener(this.registryListener);
            reg.terminateRegistry();
        }
    }

    public synchronized ProxyFactoryRegistry getRegistry(IProgressMonitor pm) {
        if (this.fRegistry == null) {
            try {
                this.fRegistry = ProxyPlugin.getPlugin().startImplementation(this.fProject, "Beaninfo", new IConfigurationContributor[]{this.getConfigurationContributor()}, pm);
                this.fRegistry.addRegistryListener(this.registryListener);
            }
            catch (CoreException e) {
                BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)e.getStatus());
            }
        }
        return this.fRegistry;
    }

    public synchronized boolean isRegistryCreated() {
        return this.fRegistry != null;
    }

    public boolean isValidNature() {
        return this.fProject != null;
    }

    protected void setProxySearchPath(ProxyFactoryRegistry registry, List searchPaths) {
        if (searchPaths != null) {
            String[] stringSearchPath = searchPaths.toArray(new String[searchPaths.size()]);
            Utilities.setBeanInfoSearchPath(registry, stringSearchPath);
        } else {
            Utilities.setBeanInfoSearchPath(registry, null);
        }
    }

    private BeaninfoSearchPathEntry[] getOldFormatSearchPath(Element root) {
        NodeList children = root.getChildNodes();
        int childrenLength = children.getLength();
        ArrayList<BeaninfoSearchPathEntry> childrenList = new ArrayList<BeaninfoSearchPathEntry>(childrenLength);
        int i = 0;
        while (i < childrenLength) {
            Node child = children.item(i);
            BeaninfoSearchPathEntry bentry = BeaninfoSearchPathEntry.readEntry(child);
            if (bentry != null) {
                childrenList.add(bentry);
            }
            ++i;
        }
        return childrenList.toArray(new BeaninfoSearchPathEntry[childrenList.size()]);
    }

    private BeaninfosDoc convertOldFormatSearchPath(Element root) {
        BeaninfoSearchPathEntry[] entries = this.getOldFormatSearchPath(root);
        try {
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            IClasspathEntry[] cpEntries = jp.getRawClasspath();
            HashMap<IPath, Integer> resolvedEntries = new HashMap<IPath, Integer>(cpEntries.length);
            int i = 0;
            while (i < cpEntries.length) {
                IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cpEntries[i]);
                if (resolved != null) {
                    resolvedEntries.put(resolved.getPath(), new Integer(i));
                }
                ++i;
            }
            ArrayList<SearchpathEntry> newentries = new ArrayList<SearchpathEntry>(entries.length);
            int i2 = 0;
            while (i2 < entries.length) {
                Path pkgPath = new Path(entries[i2].getPackageName().replace('.', '/'));
                try {
                    IPackageFragmentRoot froot;
                    Integer index;
                    IPackageFragment frag = (IPackageFragment)jp.findElement((IPath)pkgPath);
                    if (frag != null && (index = (Integer)resolvedEntries.get((froot = (IPackageFragmentRoot)frag.getParent()).getPath())) != null) {
                        IClasspathEntry cpe = cpEntries[index];
                        newentries.add(new SearchpathEntry(cpe.getEntryKind(), cpe.getPath(), frag.getElementName()));
                    }
                }
                catch (ClassCastException classCastException) {}
                ++i2;
            }
            return new BeaninfosDoc(newentries.toArray(new IBeaninfosDocEntry[newentries.size()]));
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BeaninfosDoc getSearchPath() {
        BeaninfosDoc bdoc = null;
        try {
            InputStream property = this.getSharedProperty(P_BEANINFO_SEARCH_PATH);
            if (property == null) return bdoc;
            try {
                DocumentBuilderFactoryImpl bldrFactory = new DocumentBuilderFactoryImpl();
                Document doc = bldrFactory.newDocumentBuilder().parse(new InputSource(new InputStreamReader(property, ENCODING)));
                Element root = doc.getDocumentElement();
                if (root != null && root.getNodeName().equalsIgnoreCase(sSearchPathElementName)) {
                    bdoc = this.convertOldFormatSearchPath(root);
                    this.setSearchPath(bdoc);
                } else if (root != null && root.getNodeName().equalsIgnoreCase(sBeaninfos)) {
                    bdoc = BeaninfosDoc.readEntry(new DOMReader(), root, this.getProject());
                }
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    property.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return bdoc;
            }
            property.close();
            return bdoc;
        }
        catch (CoreException e) {
            BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)e.getStatus());
            return bdoc;
        }
        catch (Exception e) {
            BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "", (Throwable)e));
        }
        return bdoc;
    }

    public void setSearchPath(BeaninfosDoc searchPath) throws CoreException {
        this.setSearchPath(searchPath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSearchPath(BeaninfosDoc searchPath, IProgressMonitor monitor) throws CoreException {
        String property = null;
        if (searchPath != null && searchPath.getSearchpath().length > 0) {
            try {
                DocumentBuilderFactoryImpl bldrFactory = new DocumentBuilderFactoryImpl();
                Document doc = bldrFactory.newDocumentBuilder().newDocument();
                Element root = doc.createElement(sBeaninfos);
                IBeaninfosDocEntry[] entries = searchPath.getSearchpath();
                int i = 0;
                while (true) {
                    if (i >= entries.length) {
                        doc.appendChild(root);
                        OutputFormat format = new OutputFormat(doc);
                        format.setIndenting(true);
                        StringWriter strWriter = new StringWriter();
                        Serializer serial = SerializerFactory.getSerializerFactory((String)format.getMethod()).makeSerializer((Writer)strWriter, format);
                        serial.asDOMSerializer().serialize(doc.getDocumentElement());
                        property = strWriter.toString();
                        break;
                    }
                    root.appendChild(entries[i].writeEntry(doc, this.getProject()));
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        if (property == null) {
            this.removeSharedProperty(P_BEANINFO_SEARCH_PATH, monitor);
            return;
        }
        InputStream is = this.getSharedProperty(P_BEANINFO_SEARCH_PATH);
        if (is != null) {
            Object var9_11;
            block19: {
                try {
                    try {
                        InputStreamReader reader = new InputStreamReader(is, ENCODING);
                        char[] chars = new char[1000];
                        StringBuffer oldProperty = new StringBuffer(1000);
                        int read = reader.read(chars);
                        while (true) {
                            if (read == -1) {
                                if (!oldProperty.toString().equals(property)) break block19;
                                var9_11 = null;
                                break;
                            }
                            oldProperty.append(chars, 0, read);
                            read = reader.read(chars);
                        }
                    }
                    catch (IOException iOException) {
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
                return;
            }
            var9_11 = null;
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        this.setSharedProperty(P_BEANINFO_SEARCH_PATH, property, monitor);
    }

    public ResourceSet getResourceSet() {
        return this.javaRSet;
    }

    protected void markAllStale() {
        if (this.fRegistry != null) {
            this.fSynchronizer.getAdapterFactory().markAllStale();
        }
    }

    protected String computeSharedPropertyFileName(QualifiedName qName) {
        return qName.getLocalName();
    }

    protected InputStream getSharedProperty(String propertyFileName) throws CoreException {
        IFile rscFile = this.getProject().getFile(propertyFileName);
        if (rscFile.exists()) {
            return rscFile.getContents(true);
        }
        return null;
    }

    protected void setSharedProperty(String propertyName, String value, IProgressMonitor monitor) throws CoreException {
        try {
            IFile rscFile = this.getProject().getFile(propertyName);
            ByteArrayInputStream input = new ByteArrayInputStream(value.getBytes(ENCODING));
            if (rscFile.exists()) {
                rscFile.setContents((InputStream)input, true, false, null);
            } else {
                rscFile.create((InputStream)input, true, monitor);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    protected void removeSharedProperty(String propertyName, IProgressMonitor monitor) throws CoreException {
        IFile rscFile = this.getProject().getFile(propertyName);
        rscFile.delete(true, true, monitor);
    }

    public IConfigurationContributor getConfigurationContributor() {
        return new ConfigurationContributor(this.getSearchPath());
    }

    private class ResourceTracker
    implements IResourceChangeListener {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResource eventResource;
            if ((e.getType() == 2 || e.getType() == 4) && (eventResource = e.getResource()).getName().equals(BeaninfoNature.this.getProject().getName()) && eventResource.equals((Object)BeaninfoNature.this.getProject())) {
                BeaninfoNature.this.cleanup(false);
                return;
            }
        }
    }

    private class ConfigurationContributor
    implements IConfigurationContributor {
        BeaninfosDoc doc;
        List computedSearchPath = new ArrayList();
        HashSet visitedVariablepaths;
        List variableContributors = new ArrayList(0);

        public ConfigurationContributor(BeaninfosDoc doc) {
            this.doc = doc;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void contributeClasspaths(List classPaths, IClasspathContributionController controller) throws CoreException {
            ListIterator<IConfigurationContributor> itr;
            HashSet visitedProjects = new HashSet();
            this.visitedVariablepaths = new HashSet();
            try {
                this.contributeClasspathsForProject(classPaths, controller, BeaninfoNature.this.getProject(), visitedProjects, this.doc);
                controller.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromPluginDescriptorAndFragments(BeaninfoPlugin.getPlugin().getDescriptor(), "vm/beaninfovm.jar"), classPaths, -1);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.visitedVariablepaths = null;
                throw throwable;
            }
            {
                Object var4_7 = null;
                this.visitedVariablepaths = null;
                itr = this.variableContributors.listIterator();
            }
            while (itr.hasNext()) {
                IConfigurationElement v = (IConfigurationElement)itr.next();
                IConfigurationContributor contrib = null;
                try {
                    contrib = (IConfigurationContributor)v.createExecutableExtension("contributor");
                }
                catch (ClassCastException e) {
                    BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "", (Throwable)e));
                }
                itr.set(contrib);
                if (contrib == null) continue;
                contrib.contributeClasspaths(classPaths, controller);
            }
            return;
        }

        private IClasspathEntry get(IClasspathEntry[] array, InternalCPEntry cpe) {
            int i = 0;
            while (i < array.length) {
                if (cpe.equals(array[i])) {
                    return array[i];
                }
                ++i;
            }
            return null;
        }

        protected void contributeClasspathsForProject(List classPaths, IClasspathContributionController controller, IProject project, HashSet visitedProjects, BeaninfosDoc doc) throws CoreException {
            IBeaninfosDocEntry entry;
            BeaninfosDoc adoc;
            if (visitedProjects.contains(project)) {
                return;
            }
            visitedProjects.add(project);
            IJavaProject jProject = JavaCore.create((IProject)project);
            IClasspathEntry[] rawPath = jProject.getRawClasspath();
            ArrayList<InternalCPEntry> contributedICPEs = new ArrayList<InternalCPEntry>();
            InternalCPEntry working = new InternalCPEntry();
            IBeaninfosDocEntry[] entries = null;
            entries = doc != null ? doc.getSearchpath() : ((adoc = BeaninfoNature.getRuntime(project).getSearchPath()) != null ? adoc.getSearchpath() : new IBeaninfosDocEntry[]{});
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < entries.length) {
                block16: {
                    String pkg;
                    SearchpathEntry se;
                    block21: {
                        InternalCPEntry icpe;
                        int cndx;
                        block20: {
                            IClasspathEntry cpe;
                            block15: {
                                BeaninfoEntry be;
                                block18: {
                                    Object cp;
                                    block19: {
                                        block17: {
                                            entry = entries[i];
                                            if (!(entry instanceof BeaninfoEntry)) break block15;
                                            be = (BeaninfoEntry)entry;
                                            if (doc == null && !be.isExported()) break block16;
                                            cp = be.getClasspath();
                                            if (!(cp instanceof IProject)) break block17;
                                            controller.contributeProject((IProject)cp, classPaths, -1);
                                            break block18;
                                        }
                                        if (!(cp instanceof String)) break block19;
                                        controller.contributeClasspath((String)cp, classPaths, -1);
                                        break block18;
                                    }
                                    if (!(cp instanceof String[])) break block16;
                                    controller.contributeClasspath((String[])cp, classPaths, -1);
                                }
                                SearchpathEntry[] sees = be.getSearchPaths();
                                int j = 0;
                                while (j < sees.length) {
                                    SearchpathEntry searchpathEntry = sees[j];
                                    if (!this.computedSearchPath.contains(searchpathEntry.getPackage())) {
                                        this.computedSearchPath.add(searchpathEntry.getPackage());
                                    }
                                    ++j;
                                }
                                break block16;
                            }
                            se = (SearchpathEntry)entry;
                            working.setEntry(se.getKind(), se.getPath());
                            cndx = contributedICPEs.indexOf(working);
                            if (cndx != -1) break block20;
                            icpe = new InternalCPEntry(working.getKind(), working.getPath());
                            contributedICPEs.add(icpe);
                            if (doc != null || (cpe = this.get(rawPath, icpe)) != null && (cpe.getEntryKind() == 3 || cpe.isExported())) break block21;
                            icpe.setIsExported(false);
                            break block16;
                        }
                        icpe = (InternalCPEntry)contributedICPEs.get(cndx);
                        if (doc == null && !icpe.isExported()) break block16;
                    }
                    if ((pkg = se.getPackage()) != null) {
                        if (!this.computedSearchPath.contains(pkg)) {
                            this.computedSearchPath.add(pkg);
                        }
                    } else {
                        this.processImplicitSearchPath(classPaths, controller, visitedProjects, root, se.getKind(), se.getPath());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < rawPath.length) {
                entry = rawPath[i];
                working.setEntry((IClasspathEntry)entry);
                if (!contributedICPEs.contains(working)) {
                    this.processImplicitSearchPath(classPaths, controller, visitedProjects, root, entry.getEntryKind(), entry.getPath());
                }
                ++i;
            }
        }

        protected void processImplicitSearchPath(List classPaths, IClasspathContributionController controller, HashSet visitedProjects, IWorkspaceRoot root, int kind, IPath path) throws CoreException {
            if (kind == 2) {
                IProject reqProject = (IProject)root.findMember(path.lastSegment());
                if (reqProject != null && reqProject.isOpen()) {
                    this.contributeClasspathsForProject(classPaths, controller, reqProject, visitedProjects, null);
                }
            } else if (kind == 4) {
                BeaninfoRegistration[] registrations;
                IPath varpath;
                if (path == null || path.segmentCount() == 0) {
                    return;
                }
                IPath iPath = varpath = path.segmentCount() == 1 ? path : path.removeLastSegments(path.segmentCount() - 1);
                if (!this.visitedVariablepaths.contains(varpath)) {
                    this.visitedVariablepaths.add(varpath);
                    registrations = BeaninfoPlugin.getPlugin().getRegistrations(varpath);
                    if (registrations != null) {
                        this.processBeaninfoRegistrations(registrations, classPaths, controller);
                    }
                }
                if (path.segmentCount() > 1 && !this.visitedVariablepaths.contains(path)) {
                    this.visitedVariablepaths.add(path);
                    registrations = BeaninfoPlugin.getPlugin().getRegistrations(path);
                    if (registrations != null) {
                        this.processBeaninfoRegistrations(registrations, classPaths, controller);
                    }
                }
            } else if (kind == 5) {
                if (path == null || path.segmentCount() == 0) {
                    return;
                }
                if (path.segment(0).equals(JavaRuntime.JRE_CONTAINER) && !this.visitedVariablepaths.contains(JRE_LIB_VARIABLE_PATH)) {
                    this.visitedVariablepaths.add(JRE_LIB_VARIABLE_PATH);
                    BeaninfoRegistration[] registrations = BeaninfoPlugin.getPlugin().getRegistrations(JRE_LIB_VARIABLE_PATH);
                    if (registrations != null) {
                        this.processBeaninfoRegistrations(registrations, classPaths, controller);
                    }
                }
            }
        }

        protected void processBeaninfoRegistrations(BeaninfoRegistration[] registrations, List classPaths, IClasspathContributionController controller) throws CoreException {
            int i = 0;
            while (i < registrations.length) {
                this.processBeaninfoRegistration(registrations[i], classPaths, controller);
                ++i;
            }
        }

        protected void processBeaninfoRegistration(BeaninfoRegistration registration, List classPaths, IClasspathContributionController controller) throws CoreException {
            BeaninfosDoc doc = registration.getDoc();
            if (doc == null) {
                return;
            }
            IConfigurationElement varElement = registration.getVariableElement();
            if (varElement != null) {
                this.variableContributors.add(varElement);
            }
            IBeaninfosDocEntry[] entries = doc.getSearchpath();
            int i = 0;
            while (i < entries.length) {
                block12: {
                    IBeaninfosDocEntry entry;
                    block8: {
                        BeaninfoEntry be;
                        block10: {
                            Object cp;
                            block11: {
                                block9: {
                                    entry = entries[i];
                                    if (!(entry instanceof BeaninfoEntry)) break block8;
                                    be = (BeaninfoEntry)entry;
                                    cp = be.getClasspath();
                                    if (!(cp instanceof IProject)) break block9;
                                    controller.contributeProject((IProject)cp, classPaths, -1);
                                    break block10;
                                }
                                if (!(cp instanceof String)) break block11;
                                controller.contributeClasspath((String)cp, classPaths, -1);
                                break block10;
                            }
                            if (!(cp instanceof String[])) break block12;
                            controller.contributeClasspath((String[])cp, classPaths, -1);
                        }
                        SearchpathEntry[] sees = be.getSearchPaths();
                        int j = 0;
                        while (j < sees.length) {
                            SearchpathEntry searchpathEntry = sees[j];
                            if (!this.computedSearchPath.contains(searchpathEntry.getPackage())) {
                                this.computedSearchPath.add(searchpathEntry.getPackage());
                            }
                            ++j;
                        }
                        break block12;
                    }
                    String pkg = ((SearchpathEntry)entry).getPackage();
                    if (pkg != null && !this.computedSearchPath.contains(pkg)) {
                        this.computedSearchPath.add(pkg);
                    }
                }
                ++i;
            }
        }

        public void contributeToConfiguration(VMRunnerConfiguration config) {
            int i = 0;
            while (i < this.variableContributors.size()) {
                IConfigurationContributor contrib = (IConfigurationContributor)this.variableContributors.get(i);
                if (contrib != null) {
                    contrib.contributeToConfiguration(config);
                }
                ++i;
            }
        }

        public void contributeToRegistry(ProxyFactoryRegistry registry) {
            BeaninfoNature.this.setProxySearchPath(registry, this.computedSearchPath);
            int i = 0;
            while (i < this.variableContributors.size()) {
                IConfigurationContributor contrib = (IConfigurationContributor)this.variableContributors.get(i);
                if (contrib != null) {
                    contrib.contributeToRegistry(registry);
                }
                ++i;
            }
        }
    }

    private static class InternalCPEntry {
        int kind;
        IPath path;
        boolean isExported = true;

        public InternalCPEntry(int kind, IPath path) {
            this.setEntry(kind, path);
        }

        public InternalCPEntry() {
        }

        public boolean isExported() {
            return this.isExported;
        }

        public void setIsExported(boolean isExported) {
            this.isExported = isExported;
        }

        public int getKind() {
            return this.kind;
        }

        public IPath getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IClasspathEntry) {
                IClasspathEntry ce = (IClasspathEntry)o;
                return this.kind == ce.getEntryKind() && this.path.equals((Object)ce.getPath());
            }
            if (o instanceof InternalCPEntry) {
                InternalCPEntry ice = (InternalCPEntry)o;
                return this.kind == ice.kind && this.path.equals((Object)ice.path);
            }
            return false;
        }

        public void setEntry(IClasspathEntry entry) {
            this.setEntry(entry.getEntryKind(), entry.getPath());
        }

        public void setEntry(int kind, IPath path) {
            this.kind = kind;
            this.path = path;
        }
    }
}

