/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoRegistration;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfosDoc;
import org.eclipse.jem.internal.beaninfo.adapters.ConfigurationElementReader;
import org.eclipse.jem.internal.core.EclipseLogMsgLogger;
import org.eclipse.jem.internal.core.MsgLogger;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;

public class BeaninfoPlugin
extends Plugin {
    public static final String PI_BEANINFO = "org.eclipse.jem.beaninfo";
    public static final String PI_BEANINFO_REGISTRATIONS = "registrations";
    public static final String PI_BEANINFO_OVERRIDES = "overrides";
    public static final String PI_VARIABLE = "variable";
    public static final String PI_PATH = "path";
    public static final String PI_CONTRIBUTOR = "contributor";
    public static final String PI_PACKAGE = "package";
    private static BeaninfoPlugin BEANINFO_PLUGIN = null;
    private HashMap beaninfos = new HashMap();
    private IPath[][] fragments;
    private String[][][] paths;
    private MsgLogger msgLogger;

    public BeaninfoPlugin(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        BEANINFO_PLUGIN = this;
    }

    public static BeaninfoPlugin getPlugin() {
        return BEANINFO_PLUGIN;
    }

    public OverridePathSearch getOverrideSearch(String packageName) {
        return new OverridePathSearch((IPath)new Path(packageName.replace('.', '/')));
    }

    public MsgLogger getMsgLogger() {
        if (this.msgLogger == null) {
            this.msgLogger = EclipseLogMsgLogger.createLogger((Plugin)this);
        }
        return this.msgLogger;
    }

    public void registerBeaninfoRegistration(IPath path, BeaninfoRegistration registration) {
        BeaninfoRegistration[] registered = (BeaninfoRegistration[])this.beaninfos.get(path);
        if (registered == null) {
            registered = new BeaninfoRegistration[]{registration};
        } else {
            BeaninfoRegistration[] old = registered;
            registered = new BeaninfoRegistration[old.length + 1];
            System.arraycopy(old, 0, registered, 0, old.length);
            registered[old.length] = registration;
        }
        this.beaninfos.put(path, registered);
    }

    public void registerBeaninfoRegistration(IPath path, BeaninfoRegistration[] registrations) {
        BeaninfoRegistration[] registered = (BeaninfoRegistration[])this.beaninfos.get(path);
        if (registered == null) {
            registered = new BeaninfoRegistration[registrations.length];
            System.arraycopy(registrations, 0, registered, 0, registrations.length);
        } else {
            BeaninfoRegistration[] old = registered;
            registered = new BeaninfoRegistration[old.length + registrations.length];
            System.arraycopy(old, 0, registered, 0, old.length);
            System.arraycopy(registrations, 0, registered, old.length, registrations.length);
        }
        this.beaninfos.put(path, registered);
    }

    public BeaninfoRegistration[] getRegistrations(IPath path) {
        return (BeaninfoRegistration[])this.beaninfos.get(path);
    }

    public void startup() throws CoreException {
        super.startup();
        this.processRegistrationExtensionPoint();
        this.processOverridesExtensionPoint();
    }

    protected void processRegistrationExtensionPoint() {
        HashMap registrations = new HashMap();
        IExtension[] extensions = this.getDescriptor().getExtensionPoint(PI_BEANINFO_REGISTRATIONS).getExtensions();
        HashMap<IPluginDescriptor, IExtension[]> pluginsToExtensions = new HashMap<IPluginDescriptor, IExtension[]>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IPluginDescriptor desc = extensions[i].getDeclaringPluginDescriptor();
            IExtension[] ext = (IExtension[])pluginsToExtensions.get(desc);
            if (ext == null) {
                pluginsToExtensions.put(desc, new IExtension[]{extensions[i]});
            } else {
                IExtension[] newExt = new IExtension[ext.length + 1];
                System.arraycopy(ext, 0, newExt, 0, ext.length);
                newExt[newExt.length - 1] = extensions[i];
                pluginsToExtensions.put(desc, newExt);
            }
            ++i;
        }
        IPluginDescriptor[] ordered = ProxyPlugin.orderPlugins(pluginsToExtensions.keySet());
        int i2 = 0;
        while (i2 < ordered.length) {
            IExtension[] exts = (IExtension[])pluginsToExtensions.get(ordered[i2]);
            int j = 0;
            while (j < exts.length) {
                IConfigurationElement[] configs = exts[j].getConfigurationElements();
                int k = 0;
                while (k < configs.length) {
                    IConfigurationElement iConfigurationElement = configs[k];
                    if (PI_VARIABLE.equals(iConfigurationElement.getName())) {
                        boolean hasContributor = iConfigurationElement.getAttributeAsIs(PI_CONTRIBUTOR) != null || iConfigurationElement.getChildren(PI_CONTRIBUTOR).length > 0;
                        String varpathstr = iConfigurationElement.getAttributeAsIs(PI_PATH);
                        if (varpathstr != null) {
                            Path varpath = new Path(varpathstr);
                            ArrayList<BeaninfoRegistration> varentry = (ArrayList<BeaninfoRegistration>)registrations.get(varpath);
                            if (varentry == null) {
                                varentry = new ArrayList<BeaninfoRegistration>(1);
                                registrations.put(varpath, varentry);
                            }
                            IConfigurationElement[] beaninfos = iConfigurationElement.getChildren("beaninfos");
                            int l = 0;
                            while (l < beaninfos.length) {
                                IConfigurationElement root = beaninfos[l];
                                BeaninfoRegistration reg = new BeaninfoRegistration(BeaninfosDoc.readEntry(new ConfigurationElementReader(), root, null));
                                if (hasContributor) {
                                    reg.setVariableElement(iConfigurationElement);
                                    hasContributor = false;
                                }
                                varentry.add(reg);
                                ++l;
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        Iterator regItr = registrations.entrySet().iterator();
        while (regItr.hasNext()) {
            Map.Entry entry = regItr.next();
            List registrationsList = (List)entry.getValue();
            this.registerBeaninfoRegistration((IPath)entry.getKey(), registrationsList.toArray(new BeaninfoRegistration[registrationsList.size()]));
        }
    }

    protected void processOverridesExtensionPoint() {
        IExtension[] extensions = this.getDescriptor().getExtensionPoint(PI_BEANINFO_OVERRIDES).getExtensions();
        HashMap<IPluginDescriptor, IExtension[]> pluginsToExtensions = new HashMap<IPluginDescriptor, IExtension[]>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IPluginDescriptor desc = extensions[i].getDeclaringPluginDescriptor();
            IExtension[] ext = (IExtension[])pluginsToExtensions.get(desc);
            if (ext == null) {
                pluginsToExtensions.put(desc, new IExtension[]{extensions[i]});
            } else {
                IExtension[] newExt = new IExtension[ext.length + 1];
                System.arraycopy(ext, 0, newExt, 0, ext.length);
                newExt[newExt.length - 1] = extensions[i];
                pluginsToExtensions.put(desc, newExt);
            }
            ++i;
        }
        HashMap<Path, String[]> overrideMap = new HashMap<Path, String[]>();
        IPluginDescriptor[] ordered = ProxyPlugin.orderPlugins(pluginsToExtensions.keySet());
        this.fragments = new IPath[ordered.length][];
        this.paths = new String[ordered.length][][];
        int i2 = 0;
        while (i2 < ordered.length) {
            IExtension[] exts = (IExtension[])pluginsToExtensions.get(ordered[i2]);
            overrideMap.clear();
            int j = 0;
            while (j < exts.length) {
                IConfigurationElement[] configs = exts[j].getConfigurationElements();
                int k = 0;
                while (k < configs.length) {
                    IConfigurationElement iConfigurationElement = configs[k];
                    String packageName = iConfigurationElement.getAttributeAsIs(PI_PACKAGE);
                    String path = iConfigurationElement.getAttributeAsIs(PI_PATH);
                    if (packageName != null && packageName.length() > 0 && path != null && path.length() > 0) {
                        String[] sofar;
                        Path packPath = new Path(packageName.replace('.', '/'));
                        if (path.charAt(path.length() - 1) != '/' && path.charAt(path.length() - 1) != '\\') {
                            path = String.valueOf(path) + '/';
                        }
                        if ((sofar = (String[])overrideMap.get(packPath)) == null) {
                            sofar = new String[]{path};
                        } else {
                            String[] old = sofar;
                            sofar = new String[old.length + 1];
                            System.arraycopy(old, 0, sofar, 0, old.length);
                            sofar[old.length] = path;
                        }
                        overrideMap.put(packPath, sofar);
                    }
                    ++k;
                }
                ++j;
            }
            int size = overrideMap.size();
            this.fragments[i2] = new IPath[size];
            this.paths[i2] = new String[size][];
            Iterator itr = overrideMap.entrySet().iterator();
            int ii = -1;
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                this.fragments[i2][++ii] = (IPath)entry.getKey();
                this.paths[i2][ii] = (String[])entry.getValue();
            }
            ++i2;
        }
    }

    static /* synthetic */ String[][][] access$1(BeaninfoPlugin beaninfoPlugin) {
        return beaninfoPlugin.paths;
    }

    public class OverridePathSearch {
        protected IPath packagePath;
        protected int nextPlugin = 0;
        protected int nextIndex = 0;
        protected int matchIndex = -1;

        protected OverridePathSearch(IPath packagePath) {
            this.packagePath = packagePath;
        }

        /*
         * Unable to fully structure code
         */
        public String[] getNextPath() {
            ** GOTO lbl10
            {
                ++this.nextIndex;
                this.matchIndex = this.matchIndex;
                if (BeaninfoPlugin.access$0(BeaninfoPlugin.this)[this.nextPlugin][this.matchIndex].isPrefixOf(this.packagePath)) {
                    return BeaninfoPlugin.access$1(BeaninfoPlugin.this)[this.nextPlugin][this.matchIndex];
                }
                do {
                    if (this.nextIndex < BeaninfoPlugin.access$0(BeaninfoPlugin.this)[this.nextPlugin].length) continue block0;
                    ++this.nextPlugin;
                    this.nextIndex = 0;
lbl10:
                    // 2 sources

                } while (this.nextPlugin < BeaninfoPlugin.access$0(BeaninfoPlugin.this).length);
            }
            this.matchIndex = -1;
            return null;
        }

        public String getUnmatchedPath() {
            if (this.matchIndex != -1) {
                IPath match = BeaninfoPlugin.this.fragments[this.nextPlugin][this.matchIndex];
                return this.packagePath.removeFirstSegments(match.segmentCount()).toString();
            }
            return null;
        }
    }
}

