/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BeaninfoSearchPathEntry {
    protected String fPackageName;
    private static final String sSearchPathEntryElementName = "pathEntry";
    private static final String sPackageElementName = "package";

    public BeaninfoSearchPathEntry(String packageName) {
        this.fPackageName = packageName;
    }

    public String getPackageName() {
        return this.fPackageName;
    }

    static BeaninfoSearchPathEntry readOldEntry(Node node) {
        Element beElement;
        if (node.getNodeType() == 1 && (beElement = (Element)node).getNodeName().equalsIgnoreCase(sSearchPathEntryElementName)) {
            String pkgName = beElement.getAttribute(sPackageElementName);
            return new BeaninfoSearchPathEntry(pkgName);
        }
        return null;
    }

    public static BeaninfoSearchPathEntry readEntry(Node node) {
        Element beElement;
        if (node.getNodeType() == 1 && (beElement = (Element)node).getNodeName().equalsIgnoreCase(sSearchPathEntryElementName)) {
            String pkgName = beElement.getAttribute(sPackageElementName);
            return new BeaninfoSearchPathEntry(pkgName);
        }
        return null;
    }

    public Element writeEntry(Document doc) {
        Element entry = doc.createElement(sSearchPathEntryElementName);
        entry.setAttribute(sPackageElementName, this.getPackageName());
        return entry;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeaninfoSearchPathEntry)) {
            return false;
        }
        BeaninfoSearchPathEntry otherEntry = (BeaninfoSearchPathEntry)other;
        return this.fPackageName.equals(otherEntry.fPackageName);
    }
}

