/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.jfc.core.BorderLayoutPolicyHelper;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.ObjectComboBoxCellEditor;

public class BorderLayoutConstraintsPropertyEditor
extends ObjectComboBoxCellEditor
implements ISourced,
INeedData {
    private IJavaObjectInstance fCurrentMOFConstraint;
    protected String fCurrentStringConstraint;
    protected Object[] fSources;
    protected EObject firstConstraintComponent;
    protected String[] fTags;
    protected EditDomain fEditDomain;
    protected int fOrientation = 0;

    public BorderLayoutConstraintsPropertyEditor(Composite aComposite) {
        super(aComposite, null);
    }

    protected Object doGetObject(int index) {
        if (index == -1) {
            return null;
        }
        String selectedConstraint = this.fTags[index];
        return BeanUtilities.createJavaObject((String)"java.lang.String", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), (String)BorderLayoutPolicyHelper.CODEGEN_TAGS[BorderLayoutPolicyHelper.DISPLAY_TAGS.indexOf(selectedConstraint)]);
    }

    protected void doSetObject(Object value) {
        if (this.isValueValid() && value instanceof IJavaObjectInstance) {
            this.fCurrentMOFConstraint = (IJavaObjectInstance)value;
            IStringBeanProxy constraintProxy = (IStringBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fCurrentMOFConstraint);
            this.fCurrentStringConstraint = (String)BorderLayoutPolicyHelper.DISPLAY_TAGS.get(BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(constraintProxy.stringValue()));
        }
        if (this.firstConstraintComponent.eContainer() != null) {
            this.fOrientation = BorderLayoutPolicyHelper.getComponentOrientation((IJavaObjectInstance)this.firstConstraintComponent.eContainer());
        }
        if (this.fTags == null) {
            this.setItems(this.getTags());
        }
    }

    protected int doGetIndex(Object value) {
        int i = 0;
        while (i < this.getTags().length) {
            if (this.fTags[i].equals(this.fCurrentStringConstraint)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected List getOccupiedTags() {
        ArrayList<String> result = new ArrayList<String>(BorderLayoutPolicyHelper.DISPLAY_TAGS.size());
        IJavaObjectInstance containerBean = (IJavaObjectInstance)this.firstConstraintComponent.eContainer();
        if (containerBean == null) {
            return result;
        }
        EStructuralFeature constraintSF = null;
        List containerComponents = (List)containerBean.eGet(JavaInstantiation.getSFeature((IJavaObjectInstance)containerBean, (URI)JFCConstants.SF_CONTAINER_COMPONENTS));
        Iterator iter = containerComponents.iterator();
        while (iter.hasNext()) {
            IJavaObjectInstance constraintsValue;
            EObject constraintComponent = (EObject)iter.next();
            if (constraintSF == null) {
                constraintSF = constraintComponent.eClass().getEStructuralFeature("constraint");
            }
            if ((constraintsValue = (IJavaObjectInstance)constraintComponent.eGet(constraintSF)) != null) {
                IBeanProxy constraintsValueProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)constraintsValue);
                if (!(constraintsValueProxy instanceof IStringBeanProxy)) continue;
                result.add(((IStringBeanProxy)constraintsValueProxy).stringValue());
                continue;
            }
            result.add("Center");
        }
        HashMap tapmap = BorderLayoutPolicyHelper.getInternalTagMap(this.fOrientation);
        int i = 0;
        while (i < result.size()) {
            String constraint = (String)result.get(i);
            String equalConstraint = (String)tapmap.get(constraint);
            if (!result.contains(equalConstraint)) {
                result.add(equalConstraint);
            }
            ++i;
        }
        return result;
    }

    protected String[] getTags() {
        if (this.fTags != null) {
            return this.fTags;
        }
        ArrayList potentialTags = new ArrayList(BorderLayoutPolicyHelper.DISPLAY_TAGS.size());
        int i = 0;
        while (i < BorderLayoutPolicyHelper.DISPLAY_TAGS.size()) {
            potentialTags.add(BorderLayoutPolicyHelper.DISPLAY_TAGS.get(i));
            ++i;
        }
        Iterator occupiedTags = this.getOccupiedTags().iterator();
        while (occupiedTags.hasNext()) {
            int index = BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(occupiedTags.next());
            if (index <= -1) continue;
            ((AbstractCollection)potentialTags).remove(BorderLayoutPolicyHelper.DISPLAY_TAGS.get(index));
        }
        if (this.fCurrentStringConstraint != null) {
            potentialTags.add(this.fCurrentStringConstraint);
            String correspondingTag = (String)BorderLayoutPolicyHelper.getDisplayTagMap(this.fOrientation).get(this.fCurrentStringConstraint);
            if (!potentialTags.contains(correspondingTag)) {
                potentialTags.add(correspondingTag);
            }
        }
        this.fTags = new String[potentialTags.size()];
        int i2 = 0;
        while (i2 < potentialTags.size()) {
            this.fTags[i2] = (String)potentialTags.get(i2);
            ++i2;
        }
        return this.fTags;
    }

    public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
        this.fSources = sources;
        this.firstConstraintComponent = (EObject)sources[0];
        this.fTags = null;
    }

    public String isCorrectObject(Object anObject) {
        String ansString = null;
        if (anObject instanceof IJavaObjectInstance) {
            IBeanProxy constraintProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaObjectInstance)anObject));
            if (constraintProxy instanceof IStringBeanProxy) {
                String str = ((IStringBeanProxy)constraintProxy).stringValue();
                if (!BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.contains(str)) {
                    ansString = str;
                }
            } else {
                ansString = ansString != null ? constraintProxy.toBeanString() : "";
            }
        } else if (anObject != null) {
            ansString = anObject.toString();
        }
        return ansString == null ? null : MessageFormat.format(JavaMessages.getString((String)"CellEditors.InvalidSetting"), ansString);
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }

    public static class BorderLayoutConstraintsLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            String internalTag = null;
            if (element instanceof IJavaInstance) {
                IBeanProxy proxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)element));
                internalTag = proxy == null ? "" : proxy.toBeanString();
            } else {
                return super.getText(element);
            }
            int index = BorderLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(internalTag);
            return index > -1 ? (String)BorderLayoutPolicyHelper.DISPLAY_TAGS.get(index) : "";
        }
    }
}

