/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jfc.core.ApplyNullLayoutConstraintCommand;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class ComponentModelAdapter
implements IConstraintHandler {
    protected IJavaObjectInstance component;
    protected EStructuralFeature sfComponentLocation;
    protected EStructuralFeature sfComponentSize;
    protected EStructuralFeature sfComponentBounds;

    public ComponentModelAdapter(Object component) {
        this.component = (IJavaObjectInstance)component;
        this.sfComponentLocation = JavaInstantiation.getSFeature((IJavaObjectInstance)this.component, (URI)JFCConstants.SF_COMPONENT_LOCATION);
        this.sfComponentSize = JavaInstantiation.getSFeature((IJavaObjectInstance)this.component, (URI)JFCConstants.SF_COMPONENT_SIZE);
        this.sfComponentBounds = JavaInstantiation.getSFeature((IJavaObjectInstance)this.component, (URI)JFCConstants.SF_COMPONENT_BOUNDS);
    }

    public boolean isResizeable() {
        return true;
    }

    public Command contributeOrphanChildCommand() {
        IBeanProxyHost h = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.component);
        RuledCommandBuilder cb = new RuledCommandBuilder(h.getBeanProxyDomain().getEditDomain());
        if (this.component.eIsSet(this.sfComponentBounds)) {
            cb.cancelAttributeSetting((EObject)this.component, this.sfComponentBounds);
        }
        if (this.component.eIsSet(this.sfComponentSize)) {
            cb.cancelAttributeSetting((EObject)this.component, this.sfComponentSize);
        }
        if (this.component.eIsSet(this.sfComponentLocation)) {
            cb.cancelAttributeSetting((EObject)this.component, this.sfComponentLocation);
        }
        return cb.getCommand();
    }

    public void contributeFigureSize(Rectangle figureConstraint) {
    }

    public Command contributeSizeCommand(int width, int height, EditDomain domain) {
        ApplyNullLayoutConstraintCommand cmd = new ApplyNullLayoutConstraintCommand();
        cmd.setTarget(this.component);
        cmd.setDomain(domain);
        cmd.setConstraint(new Rectangle(0, 0, width, height), false, true);
        return cmd;
    }

    public void contributeModelSize(org.eclipse.ve.internal.cdm.model.Rectangle modelConstraint) {
    }

    public void addConstraintHandlerListener(IConstraintHandler.IConstraintHandlerListener listener) {
    }

    public void removeConstraintHandlerListener(IConstraintHandler.IConstraintHandlerListener listener) {
    }
}

