/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.TreeContainerEditPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentTreeEditPart;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JSplitPaneChildTreeLabelDecorator;
import org.eclipse.ve.internal.jfc.core.JSplitPaneContainerPolicy;
import org.eclipse.ve.internal.jfc.core.NonBoundsBeanPropertySource;

public class JSplitPaneTreeEditPart
extends ComponentTreeEditPart {
    private Adapter containerAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 8) {
                JSplitPaneTreeEditPart.this.refreshChildren();
            }
        }
    };
    protected EStructuralFeature sfLeftComponent;
    protected EStructuralFeature sfRightComponent;
    protected EStructuralFeature sfTopComponent;
    protected EStructuralFeature sfBottomComponent;
    protected EStructuralFeature sfOrientation;
    protected EStructuralFeature sf_constraintComponent;
    protected EStructuralFeature sf_containerComponents;

    public JSplitPaneTreeEditPart(Object model) {
        super(model);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("TreeContainerEditPolicy", (EditPolicy)new TreeContainerEditPolicy((ContainerPolicy)new JSplitPaneContainerPolicy(EditDomain.getEditDomain((EditPart)this))));
    }

    protected EditPart createChildEditPart(Object model) {
        EditPart ep = super.createChildEditPart(model);
        ((ComponentTreeEditPart)ep).setPropertySource(new NonBoundsBeanPropertySource((Notifier)((EObject)model)));
        ((ComponentTreeEditPart)ep).setLabelDecorator(new JSplitPaneChildTreeLabelDecorator());
        return ep;
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add(this.containerAdapter);
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove(this.containerAdapter);
    }

    public List getChildJavaBeans() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object leftComponent = ((EObject)this.getModel()).eGet(this.sfLeftComponent);
        Object topComponent = ((EObject)this.getModel()).eGet(this.sfTopComponent);
        Object rightComponent = ((EObject)this.getModel()).eGet(this.sfRightComponent);
        Object bottomComponent = ((EObject)this.getModel()).eGet(this.sfBottomComponent);
        if (leftComponent != null) {
            result.add(leftComponent);
        } else if (topComponent != null) {
            result.add(topComponent);
        }
        if (rightComponent != null) {
            result.add(rightComponent);
        } else if (bottomComponent != null) {
            result.add(bottomComponent);
        }
        List componentList = this.getConstraintComponentsModelChildren();
        if (!componentList.isEmpty()) {
            int i = 0;
            while (i < componentList.size()) {
                result.add(componentList.get(i));
                ++i;
            }
        }
        return result;
    }

    protected List getConstraintComponentsModelChildren() {
        List constraintChildren = (List)((EObject)this.getModel()).eGet(this.sf_containerComponents);
        ArrayList<Object> children = new ArrayList<Object>(constraintChildren.size());
        Iterator itr = constraintChildren.iterator();
        while (itr.hasNext()) {
            EObject con = (EObject)itr.next();
            IJavaInstance component = (IJavaInstance)con.eGet(this.sf_constraintComponent);
            if (BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component).getErrorStatus() == 3) continue;
            children.add(con.eGet(this.sf_constraintComponent));
        }
        return children;
    }

    public void setModel(Object model) {
        super.setModel(model);
        ResourceSet rset = ((EObject)model).eResource().getResourceSet();
        this.sfLeftComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_LEFTCOMPONENT);
        this.sfRightComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_RIGHTCOMPONENT);
        this.sfBottomComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_BOTTOMCOMPONENT);
        this.sfTopComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_TOPCOMPONENT);
        this.sfOrientation = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_ORIENTATION);
        this.sf_constraintComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sf_containerComponents = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
    }
}

