/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.ContainerGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JTabbedPaneLayoutEditPolicy;
import org.eclipse.ve.internal.jfc.core.JTabbedPaneProxyAdapter;

public class JTabbedPaneGraphicalEditPart
extends ContainerGraphicalEditPart {
    private EditPartListener pageListener;
    protected IJavaObjectInstance fSelectedPage;
    protected boolean fSelectingPage = false;
    protected JTabbedPaneProxyAdapter tabbedpaneAdapter;
    protected EReference sfTabs;
    protected EReference sfComponent;
    private Adapter containerAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == JTabbedPaneGraphicalEditPart.this.sfTabs) {
                JTabbedPaneGraphicalEditPart.this.refreshChildren();
                int selectedIndex = JTabbedPaneGraphicalEditPart.this.getJTabbedPaneProxyAdapter().getSelectedIndex();
                if (selectedIndex != -1 && selectedIndex < JTabbedPaneGraphicalEditPart.this.getChildren().size() && (IJavaObjectInstance)((EditPart)JTabbedPaneGraphicalEditPart.this.getChildren().get(selectedIndex)).getModel() != JTabbedPaneGraphicalEditPart.this.fSelectedPage) {
                    List childen = JTabbedPaneGraphicalEditPart.this.getChildren();
                    int i = 0;
                    while (i < ((AbstractEditPart)JTabbedPaneGraphicalEditPart.this).children.size()) {
                        GraphicalEditPart ep = (GraphicalEditPart)childen.get(i);
                        if (i == selectedIndex) {
                            if (!ep.getFigure().isVisible()) {
                                JTabbedPaneGraphicalEditPart.this.setPageVisible((EditPart)ep, true);
                                JTabbedPaneGraphicalEditPart.this.fSelectedPage = (IJavaObjectInstance)ep.getModel();
                            }
                        } else if (ep.getFigure().isVisible()) {
                            JTabbedPaneGraphicalEditPart.this.setPageVisible((EditPart)ep, false);
                        }
                        ++i;
                    }
                }
            }
        }
    };
    static /* synthetic */ Class class$0;

    public JTabbedPaneGraphicalEditPart(Object model) {
        super(model);
    }

    public void activate() {
        this.setListener(this.createPageListener());
        super.activate();
        ((EObject)this.getModel()).eAdapters().add(this.containerAdapter);
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart page = (EditPart)children.get(i);
            this.addPageListenerToChildren(page);
            if (i == 0) {
                this.setPageVisible(page, true);
                this.pageSelected((EditPart)this.getChildren().get(0));
            } else {
                this.setPageVisible(page, false);
            }
            ++i;
        }
    }

    protected void addPageListenerToChildren(EditPart ep) {
        ep.addEditPartListener(this.pageListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.addPageListenerToChildren((EditPart)childen.next());
        }
    }

    public void deactivate() {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            this.removePageListenerFromChildren((EditPart)children.next());
        }
        ((EObject)this.getModel()).eAdapters().remove(this.containerAdapter);
        this.setListener(null);
        super.deactivate();
    }

    protected void removePageListenerFromChildren(EditPart ep) {
        ep.removeEditPartListener(this.pageListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.removePageListenerFromChildren((EditPart)childen.next());
        }
    }

    protected void createLayoutEditPolicy() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new JTabbedPaneLayoutEditPolicy(EditDomain.getEditDomain((EditPart)this)));
    }

    protected EditPartListener createPageListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart editpart, int index) {
                JTabbedPaneGraphicalEditPart.this.addPageListenerToChildren(editpart);
            }

            public void removingChild(EditPart editpart, int index) {
                JTabbedPaneGraphicalEditPart.this.removePageListenerFromChildren(editpart);
            }

            public void selectedStateChanged(EditPart editpart) {
                EditPart page;
                if (editpart == null || editpart == JTabbedPaneGraphicalEditPart.this) {
                    return;
                }
                if (editpart != null && (editpart.getSelected() == 1 || editpart.getSelected() == 2) && (page = JTabbedPaneGraphicalEditPart.this.getPageOfSelectedEditpart(editpart)) != null && page.getModel() != JTabbedPaneGraphicalEditPart.this.fSelectedPage) {
                    EditPart currentPage = JTabbedPaneGraphicalEditPart.this.getEditPartFromModel(JTabbedPaneGraphicalEditPart.this.fSelectedPage);
                    JTabbedPaneGraphicalEditPart.this.setPageVisible(currentPage, false);
                    BeanAwtUtilities.hideGrids(currentPage);
                    JTabbedPaneGraphicalEditPart.this.setPageVisible(page, true);
                    JTabbedPaneGraphicalEditPart.this.pageSelected(page);
                }
            }
        };
    }

    protected EditPart getEditPartFromModel(IJavaObjectInstance pageModel) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            EditPart page = (EditPart)children.next();
            if ((IJavaObjectInstance)page.getModel() != pageModel) continue;
            return page;
        }
        return null;
    }

    protected JTabbedPaneProxyAdapter getJTabbedPaneProxyAdapter() {
        if (this.tabbedpaneAdapter == null) {
            IBeanProxyHost tabbedpaneProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getModel()));
            this.tabbedpaneAdapter = (JTabbedPaneProxyAdapter)tabbedpaneProxyHost;
        }
        return this.tabbedpaneAdapter;
    }

    protected List getModelChildren() {
        List jtabComponents = (List)((EObject)this.getModel()).eGet((EStructuralFeature)this.sfTabs);
        ArrayList<Object> children = new ArrayList<Object>(jtabComponents.size());
        Iterator itr = jtabComponents.iterator();
        while (itr.hasNext()) {
            EObject component = (EObject)itr.next();
            children.add(component.eGet((EStructuralFeature)this.sfComponent));
        }
        return children;
    }

    protected EditPart getPageOfSelectedEditpart(EditPart ep) {
        if (ep == null || ep.getParent() == this) {
            return ep;
        }
        return this.getPageOfSelectedEditpart(ep.getParent());
    }

    protected void setPageVisible(EditPart page, boolean bool) {
        if (page != null) {
            ((GraphicalEditPart)page).getFigure().setVisible(bool);
            IFigure fig = ((GraphicalEditPart)page).getFigure();
            Iterator children = page.getChildren().iterator();
            while (children.hasNext()) {
                ((GraphicalEditPart)children.next()).getFigure().setVisible(bool);
            }
            fig.revalidate();
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        ResourceSet rset = ((EObject)model).eResource().getResourceSet();
        this.sfTabs = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JTABBEDPANE_TABS);
        this.sfComponent = JavaInstantiation.getReference((ResourceSet)rset, (URI)JFCConstants.SF_JTABCOMPONENT_COMPONENT);
    }

    protected void setListener(EditPartListener listener) {
        if (this.pageListener != null) {
            this.removeEditPartListener(this.pageListener);
        }
        this.pageListener = listener;
        if (this.pageListener != null) {
            this.addEditPartListener(this.pageListener);
        }
    }

    protected void pageSelected(EditPart page) {
        this.fSelectedPage = (IJavaObjectInstance)page.getModel();
        this.fSelectingPage = true;
        this.getJTabbedPaneProxyAdapter().setSelectedComponent((IJavaObjectInstance)page.getModel());
        this.fSelectingPage = false;
    }

    public int getCurrentPageIndex() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((EditPart)children.get(i)).getModel() == this.fSelectedPage) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectNextPage() {
        if (this.fSelectedPage != null) {
            List children = this.getChildren();
            int cp = this.getCurrentPageIndex();
            if (++cp < children.size()) {
                EditPart nextpage = (EditPart)children.get(cp);
                this.selectPage(nextpage);
            }
        }
    }

    public void selectPreviousPage() {
        if (this.fSelectedPage != null) {
            List children = this.getChildren();
            int cp = this.getCurrentPageIndex();
            if (--cp >= 0) {
                EditPart prevpage = (EditPart)children.get(cp);
                this.selectPage(prevpage);
            }
        }
    }

    public void selectPage(EditPart page) {
        this.getRoot().getViewer().setSelection((ISelection)new StructuredSelection((Object)page));
    }

    protected void setPropertySource(ComponentGraphicalEditPart childEP, EObject child) {
        EObject eObject = InverseMaintenanceAdapter.getFirstReferencedBy((Notifier)child, (EReference)this.sfComponent);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        childEP.setPropertySource((IPropertySource)EcoreUtil.getRegisteredAdapter((EObject)eObject, (Object)clazz));
    }
}

