/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ILayoutPolicyFactory;
import org.eclipse.ve.internal.jfc.core.LayoutManagerLabelProvider;
import org.eclipse.ve.internal.jfc.core.VisualMessages;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ObjectComboBoxCellEditor;

public class LayoutManagerCellEditor
extends ObjectComboBoxCellEditor
implements IJavaCellEditor,
INeedData {
    protected EditDomain fEditDomain;
    protected static String[] fItems = new String[]{VisualMessages.getString("Layout.NullLayout"), VisualMessages.getString("Layout.BorderLayout"), VisualMessages.getString("Layout.BoxLayoutX_AXIS"), VisualMessages.getString("Layout.BoxLayoutY_AXIS"), VisualMessages.getString("Layout.CardLayout"), VisualMessages.getString("Layout.FlowLayout"), VisualMessages.getString("Layout.GridBagLayout"), VisualMessages.getString("Layout.GridLayout")};
    protected static String[] fClassNames = new String[]{"", "java.awt.BorderLayout", "javax.swing.BoxLayoutX_Axis", "javax.swing.BoxLayoutY_Axis", "java.awt.CardLayout", "java.awt.FlowLayout", "java.awt.GridBagLayout", "java.awt.GridLayout"};

    public LayoutManagerCellEditor(Composite aComposite) {
        super(aComposite, fItems);
    }

    protected Object doGetObject(int index) {
        JavaHelpers javaClass;
        if (index == -1 || index == 0) {
            return null;
        }
        String layoutManagerClassName = fClassNames[index];
        ResourceSet rset = EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain);
        if ((layoutManagerClassName.equals("javax.swing.BoxLayoutX_Axis") || layoutManagerClassName.equals("javax.swing.BoxLayoutY_Axis")) && (javaClass = JavaClassImpl.reflect((String)"javax.swing.BoxLayout", (ResourceSet)rset)) != null) {
            ((JavaClass)javaClass).getEAnnotations();
        }
        javaClass = JavaClassImpl.reflect((String)layoutManagerClassName, (ResourceSet)rset);
        ILayoutPolicyFactory factory = BeanAwtUtilities.getLayoutPolicyFactoryFromLayoutManger((EClassifier)javaClass, this.fEditDomain);
        return factory.getLayoutManagerInstance(javaClass, rset);
    }

    protected int doGetIndex(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        if (anObject instanceof IJavaObjectInstance) {
            String className = LayoutManagerLabelProvider.getQualifiedName((IJavaObjectInstance)anObject);
            int i = 1;
            while (i < fClassNames.length) {
                if (className.equals(fClassNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getJavaInitializationString() {
        Object v = this.doGetValue();
        if (v == null) {
            return "null";
        }
        IJavaObjectInstance jv = (IJavaObjectInstance)v;
        return "new " + jv.getJavaType().getQualifiedName() + "()";
    }

    public static String getDisplayName(String className) {
        String dispName = null;
        int i = 0;
        while (i < fClassNames.length) {
            if (fClassNames[i].equals(className)) {
                dispName = fItems[i];
                break;
            }
            ++i;
        }
        if (dispName == null) {
            return "";
        }
        return dispName;
    }

    public String isCorrectObject(Object anObject) {
        return null;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }
}

