/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetTextPropertyObjectActionDelegate
implements IObjectActionDelegate {
    private static final Request DIRECT_EDIT_REQUEST = new Request((Object)"direct edit");
    private EditPart fEditPart;
    private String propertyName = null;

    public SetTextPropertyObjectActionDelegate(String prop) {
        this.propertyName = prop;
    }

    public void run(IAction action) {
        if (this.fEditPart == null) {
            return;
        }
        this.fEditPart.performRequest(DIRECT_EDIT_REQUEST);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.propertyName == null || this.propertyName.length() <= 0) {
            action.setEnabled(false);
            return;
        }
        EStructuralFeature sfProperty = null;
        this.fEditPart = null;
        if (((IStructuredSelection)selection).size() != 1) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
            this.fEditPart = (EditPart)((IStructuredSelection)selection).getFirstElement();
            IJavaObjectInstance component = (IJavaObjectInstance)this.fEditPart.getModel();
            JavaClass modelType = (JavaClass)component.eClass();
            sfProperty = modelType.getEStructuralFeature(this.propertyName);
            if (sfProperty == null) {
                action.setEnabled(false);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }
}

