/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.CollectionBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ListIteratorBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public class ListBeanProxyWrapper
extends CollectionBeanProxyWrapper {
    public ListBeanProxyWrapper(IBeanProxy aListProxy) {
        super(aListProxy);
        if (!aListProxy.getTypeProxy().isKindOf(aListProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.util.List"))) {
            throw new ClassCastException(MessageFormat.format(ProxyMessages.getString("ClassCast_EXC_.IncorrectType"), aListProxy.getTypeProxy().getTypeName(), "java.util.List"));
        }
    }

    public void add(int index, IBeanProxy object) throws ThrowableProxy {
        this.fConstants.getListAddWithInt().invoke(this.fCollection, new IBeanProxy[]{this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index), object});
    }

    public boolean addAll(int index, IBeanProxy aCollection) throws ThrowableProxy {
        return ((IBooleanBeanProxy)this.fConstants.getListAddAllWithInt().invoke(this.fCollection, new IBeanProxy[]{this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index), aCollection})).booleanValue();
    }

    public IBeanProxy get(int index) throws ThrowableProxy {
        return this.fConstants.getListGet().invoke(this.fCollection, this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index));
    }

    public int indexOf(IBeanProxy object) {
        try {
            return ((IIntegerBeanProxy)this.fConstants.getListIndexOf().invoke(this.fCollection, object)).intValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return -1;
        }
    }

    public int lastIndexOf(IBeanProxy object) {
        try {
            return ((IIntegerBeanProxy)this.fConstants.getListLastIndexOf().invoke(this.fCollection, object)).intValue();
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return -1;
        }
    }

    public ListIteratorBeanProxyWrapper listIterator() {
        try {
            IBeanProxy itr = this.fConstants.getListListIterator().invoke(this.fCollection);
            if (itr != null) {
                return new ListIteratorBeanProxyWrapper(itr);
            }
            return null;
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return null;
        }
    }

    public ListIteratorBeanProxyWrapper listIterator(int index) {
        try {
            IBeanProxy itr = this.fConstants.getListListIteratorWithInt().invoke(this.fCollection, this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index));
            if (itr != null) {
                return new ListIteratorBeanProxyWrapper(itr);
            }
            return null;
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, ProxyMessages.getString("UnexpectedException_EXC_"), (Throwable)e));
            return null;
        }
    }

    public IBeanProxy remove(int index, IBeanProxy object) throws ThrowableProxy {
        return this.fConstants.getListSet().invoke(this.fCollection, this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index));
    }

    public IBeanProxy set(int index, IBeanProxy object) throws ThrowableProxy {
        return this.fConstants.getListRemoveInt().invoke(this.fCollection, new IBeanProxy[]{this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(index), object});
    }

    public ListBeanProxyWrapper subList(int fromIndex, int toIndex) throws ThrowableProxy {
        IBeanProxy list = this.fConstants.getListSubList().invoke(this.fCollection, new IBeanProxy[]{this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(fromIndex), this.fCollection.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(toIndex)});
        if (list != null) {
            return new ListBeanProxyWrapper(list);
        }
        return null;
    }
}

