/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.internal.plugins.IPluginVisitor;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.core.EclipseLogMsgLogger;
import org.eclipse.jem.internal.core.MsgLogger;
import org.eclipse.jem.internal.proxy.core.IClasspathContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IRegistration;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;

public class ProxyPlugin
extends Plugin {
    private static ProxyPlugin PROXY_PLUGIN = null;
    public static final String DEBUG_DEV = "/dev";
    public static final String IMPLEMENTATIONS_EXT_PI = "proxyimplementations";
    public static final String IMPLEMENTATIONS_VMTYPE_ID = "vmtypeid";
    public static final String IMPLEMENTATIONS_VMNAME = "vmname";
    public static final String IMPLEMENTATIONS_AWT = "awt";
    public static final String IMPLEMENTATIONS_REGISTRATION = "registration";
    public static final String ENVIRONMENT_VARIABLE = "environment_variable";
    private boolean devMode;
    private MsgLogger msgLogger;

    public ProxyPlugin(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        PROXY_PLUGIN = this;
        this.devMode = BootLoader.inDevelopmentMode();
    }

    public static ProxyPlugin getPlugin() {
        return PROXY_PLUGIN;
    }

    public MsgLogger getMsgLogger() {
        if (this.msgLogger == null) {
            this.msgLogger = EclipseLogMsgLogger.createLogger((Plugin)this);
        }
        return this.msgLogger;
    }

    public ProxyFactoryRegistry startImplementation(IProject project, String vmTitle, IConfigurationContributor[] aContribs, IProgressMonitor pm) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            this.getMsgLogger().log((Object)new Status(2, this.getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(ProxyMessages.getString("Not_Java_Project_WARN_"), project.getName()), null));
            return null;
        }
        JavaRuntime.getVMInstallTypes();
        IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vm == null) {
            vm = JavaRuntime.getDefaultVMInstall();
        }
        String vmTypeID = vm.getVMInstallType().getId();
        String vmName = vm.getName();
        if (javaProject == null) {
            this.getMsgLogger().log((Object)new Status(2, this.getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(ProxyMessages.getString("No_VM_WARN_"), project.getName()), null));
            return null;
        }
        IExtensionPoint xp = this.getDescriptor().getExtensionPoint(IMPLEMENTATIONS_EXT_PI);
        if (xp != null) {
            IConfigurationElement defaultImplementation = null;
            IConfigurationElement matchedImplementation = null;
            IExtension[] extensions = xp.getExtensions();
            int i = 0;
            while (matchedImplementation == null && i < extensions.length) {
                IConfigurationElement[] ces = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    IConfigurationElement ce = ces[i];
                    String evmTypeID = ce.getAttributeAsIs(IMPLEMENTATIONS_VMTYPE_ID);
                    if (vmTypeID.equals(evmTypeID)) {
                        String evmName = ce.getAttributeAsIs(IMPLEMENTATIONS_VMNAME);
                        if (evmName == null) {
                            if (defaultImplementation == null) {
                                defaultImplementation = ce;
                                break;
                            }
                        } else if (evmName.equals(vmName)) {
                            matchedImplementation = ce;
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (matchedImplementation == null) {
                matchedImplementation = defaultImplementation;
            }
            if (matchedImplementation != null) {
                String awtParm = matchedImplementation.getAttributeAsIs(IMPLEMENTATIONS_AWT);
                boolean attachAWT = awtParm == null || awtParm.equals("y");
                IRegistration reg = (IRegistration)matchedImplementation.createExecutableExtension(IMPLEMENTATIONS_REGISTRATION);
                IConfigurationContributor[] contribs = new IConfigurationContributor[1 + (aContribs != null ? aContribs.length : 0)];
                contribs[0] = new ProxyContributor();
                if (aContribs != null) {
                    System.arraycopy(aContribs, 0, contribs, 1, aContribs.length);
                }
                return reg.startImplementation(contribs, attachAWT, project, vmTitle, pm);
            }
        }
        this.getMsgLogger().log((Object)new Status(2, this.getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(ProxyMessages.getString("No_Implementation_WARN_"), project.getName()), null));
        return null;
    }

    public String localizeFromPlugin(Plugin plugin, String fileNameWithinPlugin) {
        return this.localizeFromPluginDescriptor(plugin.getDescriptor(), fileNameWithinPlugin);
    }

    public String localizeFromPluginDescriptor(IPluginDescriptor pluginDescriptor, String filenameWithinPlugin) {
        URL url = this.urlLocalizeFromPluginDescriptor(pluginDescriptor, filenameWithinPlugin);
        return url != null ? url.getFile() : ".";
    }

    public String[] localizeFromPluginDescriptorAndFragments(IPluginDescriptor pluginDescriptor, String filenameWithinPlugin) {
        URL[] urls = this.urlLocalizeFromPluginDescriptorAndFragments(pluginDescriptor, filenameWithinPlugin);
        String[] result = new String[urls.length];
        int i = 0;
        while (i < urls.length) {
            result[i] = urls[i].getFile();
            ++i;
        }
        return result;
    }

    public URL[] urlLocalizeFromPluginDescriptorAndFragments(IPluginDescriptor pluginDescriptor, String filenameWithinPlugin) {
        PluginFragmentModel[] fragments = ((PluginDescriptorModel)pluginDescriptor).getFragments();
        if (fragments == null || fragments.length == 0) {
            URL[] uRLArray;
            URL result = this.urlLocalizeFromPluginDescriptor(pluginDescriptor, filenameWithinPlugin);
            if (result != null) {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = result;
            } else {
                uRLArray = new URL[]{};
            }
            return uRLArray;
        }
        ArrayList<URL> urls = new ArrayList<URL>(fragments.length + 1);
        URL url = this.urlLocalizeFromPluginDescriptor(pluginDescriptor, filenameWithinPlugin);
        if (url != null) {
            urls.add(url);
        }
        int i = 0;
        while (i < fragments.length) {
            LibraryModel[] libraries;
            PluginFragmentModel fragment = fragments[i];
            url = this.urlLocalizeFromFragment(fragment, filenameWithinPlugin);
            if (url != null) {
                urls.add(url);
            }
            if ((libraries = fragment.getRuntime()) != null && libraries.length > 0) {
                int extndx = filenameWithinPlugin.lastIndexOf(46);
                String libFile = null;
                libFile = extndx != -1 ? String.valueOf(filenameWithinPlugin.substring(0, extndx)) + '.' + fragment.getId() + filenameWithinPlugin.substring(extndx) : String.valueOf(filenameWithinPlugin) + '.' + fragment.getId();
                int j = 0;
                while (j < libraries.length) {
                    if (libFile.equals(libraries[j].getName())) {
                        url = this.urlLocalizeFromFragment(fragment, libFile);
                        if (url == null) break;
                        urls.add(url);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private URL urlLocalizeFromFragment(PluginFragmentModel fragmentDescriptor, String filenameWithinPlugin) {
        try {
            URL installURL = new URL("platform:/fragment/" + fragmentDescriptor.toString() + "/");
            return this.urlLocalize(installURL, filenameWithinPlugin, true);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL urlLocalizeFromPluginDescriptor(IPluginDescriptor pluginDescriptor, String filenameWithinPlugin) {
        return this.urlLocalize(pluginDescriptor.getInstallURL(), filenameWithinPlugin, false);
    }

    /*
     * Exception decompiling
     */
    private URL urlLocalize(URL installURL, String filenameWithinPlugin, boolean mustExist) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 75->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IPluginDescriptor[] orderPlugins(final Set pluginsToOrder) {
        PluginRegistry registry = (PluginRegistry)Platform.getPluginRegistry();
        final int[] ndx = new int[]{pluginsToOrder.size()};
        final IPluginDescriptor[] result = new IPluginDescriptor[ndx[0]];
        IPluginVisitor visitor = new IPluginVisitor(){

            public void visit(IPluginDescriptor descriptor) {
                if (pluginsToOrder.contains(descriptor)) {
                    ndx[0] = ndx[0] - 1;
                    result[ndx[0]] = descriptor;
                }
            }
        };
        registry.accept(visitor, false);
        return result;
    }

    public static Process exec(String[] cmdLine, File workingDirectory, String[] environmentProperties) throws CoreException {
        Process p = null;
        try {
            p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, environmentProperties) : Runtime.getRuntime().exec(cmdLine, environmentProperties, workingDirectory);
        }
        catch (IOException iOException) {
            if (p != null) {
                p.destroy();
            }
            throw new CoreException(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        return p;
    }

    class ProxyContributor
    implements IConfigurationContributor {
        ProxyContributor() {
        }

        public void contributeClasspaths(List classPaths, IClasspathContributionController controller) {
            controller.contributeClasspath(ProxyPlugin.this.localizeFromPlugin(ProxyPlugin.this, "proxycommon.jar"), classPaths, -1);
            controller.contributeClasspath(ProxyPlugin.this.urlLocalizeFromPluginDescriptorAndFragments(ProxyPlugin.this.getDescriptor(), "initparser.jar"), classPaths, -1);
        }

        public void contributeToConfiguration(VMRunnerConfiguration config) {
        }

        public void contributeToRegistry(ProxyFactoryRegistry registry) {
        }
    }
}

