/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMServer;

public class ComponentManager
implements ICallback,
ComponentListener,
HierarchyBoundsListener,
HierarchyListener {
    protected IVMServer fServer;
    protected int fCallbackID;
    protected Component fComponent;
    protected Container fParent;

    public void initializeCallback(IVMServer server, int callbackID) {
        this.fServer = server;
        this.fCallbackID = callbackID;
    }

    public void setComponent(Component aComponent) {
        if (this.fComponent != null) {
            this.fComponent.removeComponentListener(this);
            this.fComponent.removeHierarchyBoundsListener(this);
            this.fComponent.removeHierarchyListener(this);
        }
        this.fComponent = aComponent;
        this.fParent = null;
        if (this.fComponent != null) {
            this.fComponent.addComponentListener(this);
            this.fComponent.addHierarchyListener(this);
            this.queueRefresh();
        }
    }

    public void setRelativeParentComponent(Container aContainer) {
        this.fComponent.removeHierarchyBoundsListener(this);
        this.fParent = aContainer;
        if (aContainer != null && aContainer != this.fComponent.getParent()) {
            this.fComponent.addHierarchyBoundsListener(this);
        }
        this.queueRefresh();
    }

    public Object[] getLocation() {
        int x = 0;
        int y = 0;
        Component c = this.fComponent;
        x = c.getX();
        y = c.getY();
        if (this.fParent != null) {
            Container cntr = c.getParent();
            while (cntr != null && cntr != this.fParent) {
                x += cntr.getX();
                y += cntr.getY();
                cntr = cntr.getParent();
            }
        }
        return new Object[]{new Integer(x), new Integer(y)};
    }

    public void componentResized(final ComponentEvent e) {
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        Component c = e.getComponent();
                        return handler.callbackWithParms(ComponentManager.this.fCallbackID, 2, new Object[]{new Integer(c.getWidth()), new Integer(c.getHeight())});
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void componentMoved(ComponentEvent e) {
        this.fireMoved();
    }

    protected void fireMoved() {
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ComponentManager.this.fCallbackID, 3, ComponentManager.this.getLocation());
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void componentShown(ComponentEvent e) {
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ComponentManager.this.fCallbackID, 1, null);
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void componentHidden(ComponentEvent e) {
        if (this.fServer != null) {
            try {
                this.fServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ComponentManager.this.fCallbackID, 0, null);
                    }
                });
            }
            catch (CommandException commandException) {}
        }
    }

    public void queueRefresh() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (ComponentManager.this.fServer != null) {
                    try {
                        ComponentManager.this.fServer.doCallback(new ICallbackRunnable(this){
                            final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run(ICallbackHandler handler) throws CommandException {
                                return handler.callbackWithParms(5.access$0(this.this$1).fCallbackID, 4, null);
                            }
                        });
                    }
                    catch (CommandException commandException) {}
                }
            }

            static /* synthetic */ ComponentManager access$0(5 var0) {
                return var0.ComponentManager.this;
            }
        });
    }

    public void ancestorMoved(HierarchyEvent e) {
        Component cMoved = e.getChanged();
        if (cMoved != this.fComponent) {
            Container cntr = this.fComponent.getParent();
            while (cntr != null && cntr != this.fParent) {
                if (cntr == cMoved) {
                    this.fireMoved();
                    break;
                }
                cntr = cntr.getParent();
            }
        }
    }

    public void ancestorResized(HierarchyEvent e) {
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && this.fComponent.isShowing()) {
            this.queueRefresh();
        }
    }
}

