/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.internal.java.codegen.core.ITransientErrorEvent;
import org.eclipse.ve.internal.java.codegen.core.ITransientErrorListener;
import org.eclipse.ve.internal.java.codegen.core.TransientErrorEvent;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.ICancelMonitor;

public class TransientErrorManager {
    protected List fTransientErrorListeners = null;
    protected List fTransientErrorHistoryHolder = new ArrayList();

    public void addTransientErrorListener(ITransientErrorListener listener) {
        if (this.fTransientErrorListeners == null) {
            this.fTransientErrorListeners = new ArrayList();
        }
        if (listener != null) {
            this.fTransientErrorListeners.add(listener);
        }
    }

    public void removeTransientErrorListener(ITransientErrorListener listener) {
        if (this.fTransientErrorListeners != null && listener != null) {
            this.fTransientErrorListeners.remove(listener);
        }
    }

    protected void fireTransientError(ITransientErrorEvent event) {
        if (this.fTransientErrorListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.fTransientErrorListeners.size()) {
            String eType = event.getErrorType();
            if (eType.equals("typeCorrectedBean") || eType.equals("typeCorrectedFeature") || eType.equals("typeInformation")) {
                ((ITransientErrorListener)this.fTransientErrorListeners.get(i)).correctionOccured(event);
            } else {
                ((ITransientErrorListener)this.fTransientErrorListeners.get(i)).errorOccured(event);
            }
            ++i;
        }
    }

    public void handleLocalToSharedChanged(IBeanDeclModel fBeanModel, ICancelMonitor monitor) {
        this.fireCorrections(fBeanModel, monitor, false);
    }

    public void handleSharedToLocalChanges(IBeanDeclModel fBeanModel, List errors, ICancelMonitor monitor) {
        List errorsInCodeDelta = errors;
        boolean parseError = false;
        if (errorsInCodeDelta != null && errorsInCodeDelta.size() > 0) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            int error = 0;
            while (error < errorsInCodeDelta.size()) {
                TransientErrorEvent event = (TransientErrorEvent)errorsInCodeDelta.get(error);
                this.primRegisterError(event);
                if (event.getErrorType().equals("typeParserFatal")) {
                    parseError = true;
                }
                ++error;
            }
        }
        this.fireCorrections(fBeanModel, monitor, parseError);
    }

    protected void primRegisterError(TransientErrorEvent event) {
        this.fireTransientError(event);
    }

    protected void fireCorrections(IBeanDeclModel fBeanModel, ICancelMonitor monitor, boolean isInParseError) {
        if (fBeanModel != null) {
            BeanPart bp;
            ArrayList<BeanPart> inErrorBeans = new ArrayList<BeanPart>();
            Iterator itr = fBeanModel.getBeans().iterator();
            while (itr.hasNext()) {
                boolean beanPartInError = false;
                bp = (BeanPart)itr.next();
                if (isInParseError) {
                    inErrorBeans.add(bp);
                    continue;
                }
                Iterator expressions = bp.getRefExpressions().iterator();
                while (expressions.hasNext()) {
                    CodeExpressionRef exp = (CodeExpressionRef)expressions.next();
                    if (!exp.isStateSet(128)) continue;
                    beanPartInError = true;
                    break;
                }
                if (!beanPartInError) continue;
                inErrorBeans.add(bp);
            }
            Iterator prevErrBeans = this.fTransientErrorHistoryHolder.iterator();
            while (prevErrBeans.hasNext()) {
                bp = (BeanPart)prevErrBeans.next();
                if (inErrorBeans.contains(bp)) continue;
                this.fireTransientError(new TransientErrorEvent("typeCorrectedBean", bp.getEObject(), bp.getUniqueName()));
            }
            this.fTransientErrorHistoryHolder.clear();
            this.fTransientErrorHistoryHolder.addAll(inErrorBeans);
        }
    }

    public void clear() {
        this.fTransientErrorHistoryHolder.clear();
    }
}

