/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.EventDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoder;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoderHelper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.IEventSrcGenerator;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;
import org.eclipse.ve.internal.jcm.Callback;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.Listener;
import org.eclipse.ve.internal.jcm.ListenerType;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;
import org.eclipse.ve.internal.jcm.PropertyEvent;

public abstract class EventDecoderHelper
implements IEventDecoderHelper {
    IEventDecoder fOwner = null;
    Statement fExpr;
    String fExprSig;
    BeanPart fbeanPart = null;
    String fdebugString = null;
    AbstractEventInvocation fEventInvocation = null;
    BeanSubclassComposition fbsc = null;
    IEventSrcGenerator fSrcGenerator = null;
    String fIndentFiller = null;
    EventDecoderAdapter feventAdapter = null;
    EStructuralFeature fEventSF = null;

    protected abstract IEventSrcGenerator getSrcGenerator(Object[] var1);

    protected abstract List getCallBackList();

    public EventDecoderHelper(BeanPart bean, Statement exp, IEventDecoder owner) {
        this.fOwner = owner;
        this.fbeanPart = bean;
        this.fExpr = exp;
        if (this.fExpr != null) {
            this.fdebugString = this.fExpr.toString();
        }
    }

    protected BeanSubclassComposition getBSC() {
        if (this.fbsc != null) {
            return this.fbsc;
        }
        this.fbsc = this.fbeanPart.getModel().getCompositionModel().getModelRoot();
        return this.fbsc;
    }

    protected boolean isValidReceiver(MessageSend exp) {
        if (exp.receiver instanceof MessageSend) {
            MessageSend r = (MessageSend)exp.receiver;
            if (this.fbeanPart.getInitMethod() != null && this.fbeanPart.getInitMethod().getMethodName().equals(new String(r.selector))) {
                return true;
            }
        } else if (exp.receiver instanceof SingleNameReference || exp.receiver instanceof ThisReference) {
            String receiver = exp.receiver.toString();
            if (this.fbeanPart.getSimpleName().equals(receiver)) {
                return true;
            }
        }
        CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Receiver", true);
        return false;
    }

    protected abstract boolean isValidSelector(String var1);

    protected abstract boolean isValidArguments(Expression[] var1);

    protected JavaClass getAllocatedType(TypeReference type) {
        String name = null;
        if (type instanceof QualifiedTypeReference) {
            name = CodeGenUtil.tokensToString(((QualifiedTypeReference)type).tokens);
        } else if (type instanceof SingleTypeReference) {
            name = this.fbeanPart.getModel().resolve(new String(((SingleTypeReference)type).token));
        }
        if (name != null) {
            return (JavaClass)JavaClassImpl.reflect((String)name, (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        }
        return null;
    }

    protected boolean sameString(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return true;
            }
            return s2.length() == 0;
        }
        if (s2 == null) {
            return s1.length() == 0;
        }
        return s1.equals(s2);
    }

    protected boolean sameClass(JavaClass c1, JavaClass c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    protected boolean sameArray(Object[] a1, Object[] a2) {
        if (a1 == null) {
            if (a2 == null) {
                return true;
            }
            return a2.length <= 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a2.length) {
            if (!a1[i].equals(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected ListenerType getListenerType(String name, boolean thisPart, JavaClass extend, Object[] imp, JavaClass is) {
        EList lst = this.getBSC().getListenerTypes();
        ListenerType result = null;
        int i = 0;
        while (i < lst.size()) {
            ListenerType lt = (ListenerType)lst.get(i);
            if (this.sameString(lt.getName(), name)) {
                if (name != null && name.length() > 0) {
                    result = lt;
                    break;
                }
                if (lt.isThisPart() == thisPart && this.sameClass(lt.getExtends(), extend) && this.sameArray(lt.getImplements().toArray(), imp)) {
                    result = lt;
                    break;
                }
            }
            ++i;
        }
        if (result == null) {
            result = JCMFactory.eINSTANCE.createListenerType();
            if (name != null) {
                result.setName(name);
            }
            result.setThisPart(thisPart);
            if (extend != null) {
                result.setExtends(extend);
            }
            if (imp != null && imp.length > 0) {
                i = 0;
                while (i < imp.length) {
                    result.getImplements().add(imp[i]);
                    ++i;
                }
            }
        }
        return result;
    }

    protected Listener getAnonymousListener(JavaClass extend, Object[] imp) {
        Listener l = JCMFactory.eINSTANCE.createListener();
        ListenerType lt = this.getListenerType(null, false, extend, imp, null);
        l.setListenerType(lt);
        return l;
    }

    EStructuralFeature getEventSF() {
        if (this.fEventSF != null) {
            return this.fEventSF;
        }
        this.fEventSF = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)this.fbeanPart.getEObject()), (String)"events");
        return this.fEventSF;
    }

    protected void addInvocationToModel(AbstractEventInvocation ee, int index) {
        ListenerType lt = ee.getListener().getListenerType();
        if (lt.eContainer() == null) {
            BeanSubclassComposition bsc = this.getBSC();
            bsc.getListenerTypes().add(lt);
        }
        if (ee.eContainer() == null) {
            EStructuralFeature sf = this.getEventSF();
            if (index >= 0) {
                ((List)this.fbeanPart.getEObject().eGet(sf)).add(index, ee);
            } else {
                ((List)this.fbeanPart.getEObject().eGet(sf)).add(ee);
            }
        }
    }

    protected int removeInvocationToModel(AbstractEventInvocation ee) {
        ListenerType lt = ee.getListener().getListenerType();
        if (lt != null) {
            lt.getListeners().remove(ee.getListener());
        }
        EStructuralFeature sf = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)this.fbeanPart.getEObject()), (String)"events");
        List eeList = (List)this.fbeanPart.getEObject().eGet(sf);
        int index = eeList.indexOf(ee);
        eeList.remove(ee);
        ee.getCallbacks().clear();
        if (ee instanceof PropertyChangeEventInvocation) {
            ((PropertyChangeEventInvocation)ee).getProperties().clear();
        }
        return index;
    }

    protected String getInnerName(JavaClass c) {
        if (!this.isInnerClass(c)) {
            return null;
        }
        return c.getName().substring(c.getName().indexOf(36) + 1);
    }

    IType getInnerType(JavaClass c) throws JavaModelException {
        ICompilationUnit cu = this.fbeanPart.getModel().getWorkingCopyProvider().getSharedWorkingCopy();
        IType[] types = cu.getAllTypes();
        IType cType = null;
        String cName = c.getName();
        if (!cName.startsWith(c.getEPackage().getName())) {
            cName = String.valueOf(c.getEPackage().getName()) + "." + cName;
        }
        int i = 0;
        while (i < types.length) {
            if (types[i].getFullyQualifiedName('$').equals(cName)) {
                cType = types[i];
                break;
            }
            ++i;
        }
        return cType;
    }

    IType getMainType() throws JavaModelException {
        ICompilationUnit cu = this.fbeanPart.getModel().getWorkingCopyProvider().getSharedWorkingCopy();
        return cu.getTypes()[0];
    }

    protected Listener getInnerListener(JavaClass c) {
        ListenerType lt = this.getListenerType(c.getName().replace('$', '.'), false, null, null, null);
        Listener l = null;
        if (lt.getListeners().size() > 0) {
            l = (Listener)lt.getListeners().get(0);
        } else {
            l = JCMFactory.eINSTANCE.createListener();
            l.setListenerType(lt);
        }
        try {
            JavaClass it;
            IType cType = this.getInnerType(c);
            if (cType == null) {
                this.getBSC().getListenerTypes().remove(lt);
                return null;
            }
            String[] interfaces = cType.getSuperInterfaceNames();
            int i = 0;
            while (i < interfaces.length) {
                it = (JavaClass)JavaClassImpl.reflect((String)interfaces[i], (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
                if (it != null && it.isExistingType() && it.isInterface() && !lt.getImplements().contains(it)) {
                    lt.getImplements().add(it);
                }
                ++i;
            }
            String superClass = this.fbeanPart.getModel().resolve(cType.getSuperclassName());
            if (superClass != null && superClass.length() > 0) {
                it = (JavaClass)JavaClassImpl.reflect((String)superClass, (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
                cType.getSuperclassName();
                if (it != null && it.isExistingType() && lt.getExtends() != it) {
                    lt.setExtends(it);
                }
            }
            if (lt.eContainer() == null) {
                this.getBSC().getListenerTypes().add(lt);
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return l;
    }

    protected boolean isInnerClass(JavaClass c) {
        try {
            return this.getInnerType(c) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected Listener getIsClassListener(JavaClass c) {
        if (this.isInnerClass(c)) {
            return this.getInnerListener(c);
        }
        ListenerType lt = this.getListenerType(c.getName().replace('$', '.'), false, null, null, c);
        Listener l = null;
        if (lt.getListeners().size() > 0) {
            l = (Listener)lt.getListeners().get(0);
        } else {
            l = JCMFactory.eINSTANCE.createListener();
            l.setListenerType(lt);
        }
        return l;
    }

    protected abstract boolean processEvent(MessageSend var1);

    public boolean decode() throws CodeGenException {
        MessageSend exp;
        if (this.fExpr != null && this.fExpr instanceof MessageSend && this.isValidReceiver(exp = (MessageSend)this.fExpr) && this.isValidSelector(new String(exp.selector)) && this.isValidArguments(exp.arguments)) {
            return this.processEvent(exp);
        }
        return false;
    }

    public String generate(Object[] args) throws CodeGenException {
        this.getSrcGenerator(args).setSeperator(this.fbeanPart.getModel().getLineSeperator());
        String result = this.getSrcGenerator(args).generateEvent();
        return result;
    }

    public void delete() {
        this.cleanUpPreviousIfNedded();
    }

    public String primRefreshFromComposition(String exprSig) throws CodeGenException {
        return null;
    }

    public boolean primIsDeleted() {
        return this.fEventInvocation.getListener() == null;
    }

    public void adaptToCompositionModel(IEventDecoder decoder) {
        EventDecoderAdapter adapter;
        this.unadaptToCompositionModel();
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fbeanPart.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        this.feventAdapter = adapter = new EventDecoderAdapter(decoder);
        a.addSettingAdapter(a.getEventsSF(), adapter);
        this.fEventInvocation.eAdapters().add(adapter);
        EList callbacks = this.fEventInvocation.getCallbacks();
        int i = 0;
        while (i < callbacks.size()) {
            Callback c = (Callback)callbacks.get(i);
            this.adaptCallBack(c);
            ++i;
        }
    }

    protected void adaptCallBack(Callback c) {
        if (this.feventAdapter != null) {
            c.eAdapters().add(this.feventAdapter.getCallBackSourceRangeAdapter(c));
        } else {
            JavaVEPlugin.log((Object)"EventDecoderHelper.adaptCallBack: NoAdapter", (int)5);
        }
    }

    protected void unadaptCallBack(Callback c) {
        ICodeGenAdapter ca = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)c, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        if (ca != null) {
            c.eAdapters().remove(ca);
        }
    }

    public AbstractEventInvocation getEventInvocation() {
        return this.fEventInvocation;
    }

    public void setEventInvocation(AbstractEventInvocation ei) {
        if (this.fEventInvocation != null && this.fEventInvocation != ei) {
            this.cleanUpPreviousIfNedded();
        }
        this.fEventInvocation = ei;
    }

    protected Callback addMethod(AbstractEventInvocation ee, Method m, boolean sharedMethod) {
        Callback c = JCMFactory.eINSTANCE.createCallback();
        c.setSharedScope(sharedMethod);
        c.setMethod(m);
        ee.getCallbacks().add(c);
        return c;
    }

    public String getFiller(String filler) {
        return this.fIndentFiller;
    }

    public void setFiller(String filler) {
        this.fIndentFiller = filler;
        if (this.fSrcGenerator != null) {
            this.fSrcGenerator.setIndent(this.fIndentFiller);
        }
    }

    public void unadaptToCompositionModel() {
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fbeanPart.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        a.removeSettingAdapter(a.getEventsSF(), this.feventAdapter);
        if (this.feventAdapter != null) {
            this.fEventInvocation.eAdapters().remove(this.feventAdapter);
        }
        EList callbacks = this.fEventInvocation.getCallbacks();
        int i = 0;
        while (i < callbacks.size()) {
            Callback c = (Callback)callbacks.get(i);
            this.unadaptCallBack(c);
            ++i;
        }
        this.feventAdapter = null;
    }

    protected int cleanUpPreviousIfNedded() {
        if (this.fEventInvocation.getListener() != null) {
            this.unadaptToCompositionModel();
            return this.removeInvocationToModel(this.fEventInvocation);
        }
        return -1;
    }

    protected int getInvocationIndex() {
        int index = 0;
        boolean sanityCheck = false;
        CodeEventRef exp = (CodeEventRef)this.fOwner.getExprRef();
        Object events = exp.getMethod().getEventExpressions();
        while (events.hasNext()) {
            CodeEventRef e = (CodeEventRef)events.next();
            if (e == exp) {
                sanityCheck = true;
                break;
            }
            if (!e.getBean().equals(this.fbeanPart)) continue;
            ++index;
        }
        events = (List)this.fbeanPart.getEObject().eGet(this.getEventSF());
        return (sanityCheck &= events.size() >= index) ? index : -1;
    }

    public void setDecodingContent(Statement exp) {
        this.fExpr = exp;
    }

    public ICodeGenSourceRange getPropertyEventSourceRange(PropertyEvent pe) {
        return null;
    }

    protected BeanPart findABean(String simpleName) {
        List l = this.fbeanPart.getModel().getBeans();
        int i = 0;
        while (i < l.size()) {
            if (((BeanPart)l.get(i)).getSimpleName().equals(simpleName) && ((BeanPart)l.get(i)).getInitMethod() == this.fbeanPart.getInitMethod()) {
                return (BeanPart)l.get(i);
            }
            ++i;
        }
        return null;
    }

    protected JavaClass resolveInstance(char[] instanceName) {
        try {
            IType t = this.getMainType();
            if (t == null) {
                return null;
            }
            IField[] fields = t.getFields();
            String targetName = new String(instanceName);
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getElementName().equals(targetName)) {
                    String type = Signature.toString((String)fields[i].getTypeSignature());
                    type = this.fbeanPart.getModel().resolve(type);
                    return (JavaClass)JavaClassImpl.reflect((String)type, (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
                }
                ++i;
            }
            IType[] tps = t.getCompilationUnit().getTypes();
            int i2 = 1;
            while (i2 < tps.length) {
                if (tps[i2].getElementName().equals(targetName)) {
                    String type = tps[i2].getFullyQualifiedName();
                    type = this.fbeanPart.getModel().resolve(type);
                    return (JavaClass)JavaClassImpl.reflect((String)type, (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {}
        BeanPart bp = this.findABean(new String(instanceName));
        if (bp != null) {
            return (JavaClass)JavaClassImpl.reflect((String)bp.getType(), (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        }
        return null;
    }

    protected String getEventArgName() {
        String result = null;
        if (this.fExpr != null && this.fExpr instanceof MessageSend) {
            MessageSend ms = (MessageSend)this.fExpr;
            if (ms.arguments != null && ms.arguments.length > 0 && ms.arguments[0] instanceof QualifiedAllocationExpression) {
                QualifiedAllocationExpression alt = (QualifiedAllocationExpression)ms.arguments[0];
                if (alt.anonymousType instanceof AnonymousLocalTypeDeclaration) {
                    AnonymousLocalTypeDeclaration lt = alt.anonymousType;
                    if (lt.methods != null && lt.methods.length > 0) {
                        MethodDeclaration md = (MethodDeclaration)lt.methods[0];
                        if (md.arguments != null && md.arguments.length > 0 && md.arguments[0] instanceof Argument) {
                            Argument arg = md.arguments[0];
                            return arg.name();
                        }
                    }
                }
            }
        }
        return result;
    }

    protected List getExplicitTypeEventMethods(JavaClass c) {
        if (this.isInnerClass(c)) {
            return this.getInnerTypeEventMethods(c);
        }
        return Collections.EMPTY_LIST;
    }

    protected List getInnerTypeEventMethods(JavaClass c) {
        ArrayList<Method> ml = new ArrayList<Method>();
        try {
            IType t = this.getInnerType(c);
            if (t == null) {
                return null;
            }
            IMethod[] iMethods = t.getMethods();
            List listenMethods = this.getCallBackList();
            int i = 0;
            while (i < iMethods.length) {
                Iterator listenIter = listenMethods.iterator();
                while (listenIter.hasNext()) {
                    Method lM;
                    Object element = listenIter.next();
                    Method method = lM = element instanceof MethodProxy ? ((MethodProxy)element).getMethod() : (Method)element;
                    if (!iMethods[i].getElementName().equals(lM.getName()) || iMethods[i].getNumberOfParameters() != lM.getParameters().size()) continue;
                    ml.add(lM);
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return ml;
    }

    public abstract Object getPriorityOfExpression();

    public abstract String getCurrentExpression();

    public abstract void removeCallBack(Callback var1);

    public abstract void addCallBack(Callback var1);

    public abstract void addPropertyEvent(PropertyEvent var1);

    public abstract void removePropertyEvent(PropertyEvent var1);

    public abstract ICodeGenSourceRange getCallBackSourceRange(Callback var1);
}

