/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaEvent;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.EventMethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IEventProcessingRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class EventsParser {
    IBeanDeclModel fModel;
    CompilationUnitDeclaration fDom;
    HashMap faddListeners = new HashMap();
    AbstractMethodDeclaration[] domMethods;
    IMethod[] cuMethods;

    public EventsParser(IBeanDeclModel m, CompilationUnitDeclaration dom) {
        this.fModel = m;
        this.fDom = dom;
        this.domMethods = this.fDom.types[0].methods;
        this.cuMethods = TypeVisitor.getCUMethods(this.domMethods, CodeGenUtil.getMethods(this.fModel.getCompilationUnit()), this.fModel);
    }

    private List getAddSignitures(JavaClass h) {
        ArrayList<EventSetDecorator> l = (ArrayList<EventSetDecorator>)this.faddListeners.get(h);
        if (l == null) {
            EList events = null;
            try {
                events = h.getAllEvents();
            }
            catch (Throwable t) {
                JavaVEPlugin.log((Throwable)t);
            }
            l = new ArrayList<EventSetDecorator>();
            if (events != null && events.size() > 0) {
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    JavaEvent e = (JavaEvent)iter.next();
                    EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                    if (ed == null) continue;
                    l.add(ed);
                }
            }
            this.faddListeners.put(h, l);
        }
        return l;
    }

    private CodeMethodRef getMethodRef(MethodDeclaration md, IMethod im) throws JavaModelException {
        CodeMethodRef m;
        String handle = im.getHandleIdentifier();
        CodeTypeRef tr = this.fModel.getTypeRef();
        Iterator itr = tr.getMethods();
        while (itr.hasNext()) {
            m = (CodeMethodRef)itr.next();
            if (!handle.equals(m.getMethodHandle())) continue;
            return m;
        }
        m = new CodeMethodRef((AbstractMethodDeclaration)md, tr, handle, im.getSourceRange(), im.getSource());
        return m;
    }

    protected void analyze(BeanPart b, JavaClass h) {
        List addSignitures = this.getAddSignitures(h);
        if (addSignitures == null || addSignitures.size() == 0) {
            return;
        }
        IEventProcessingRule rule = (IEventProcessingRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleEventProcessing");
        int idx = 0;
        while (idx < this.domMethods.length) {
            if (rule.parseForEvents(this.domMethods[idx], b)) {
                MethodVisitor v = null;
                if (b.isInitMethod(this.domMethods[idx])) {
                    v = new EventMethodVisitor(b, this.fModel, addSignitures, this.fDom);
                } else {
                    try {
                        MethodDeclaration md = (MethodDeclaration)this.domMethods[idx];
                        CodeMethodRef mref = this.getMethodRef(md, this.cuMethods[idx]);
                        v = new EventMethodVisitor((AbstractMethodDeclaration)md, mref, b, this.fModel, addSignitures, this.fDom);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (v != null) {
                    v.visit();
                }
            }
            ++idx;
        }
    }

    public void addEvents(BeanPart b) {
        String t;
        JavaHelpers h;
        CodeMethodRef m = b.getInitMethod();
        if (m != null && (h = JavaClassImpl.reflect((String)(t = b.getType()), (ResourceSet)this.fModel.getCompositionModel().getModelResourceSet())) instanceof JavaClass) {
            this.analyze(b, (JavaClass)h);
        }
    }
}

