/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ExpressionVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;
    CodeExpressionRef fExpression = null;

    ExpressionVisitor(CodeMethodRef method, Statement stmt, IBeanDeclModel model, List reTryList) {
        super((AstNode)stmt, model, reTryList);
        this.fMethod = method;
        this.fExpression = new CodeExpressionRef(stmt, this.fMethod);
    }

    BeanPart processSingleNameReference(MessageSend stmt) {
        String name = new String(((SingleNameReference)stmt.receiver).token);
        BeanPart b = this.fModel.getABean(BeanDeclModel.constructUniqueName(this.fMethod, name));
        if (b == null) {
            b = this.fModel.getABean(name);
        }
        return b;
    }

    BeanPart processRefToMessageSend(MessageSend stmt) {
        String selector = null;
        if (((MessageSend)stmt.receiver).receiver instanceof ThisReference) {
            if (this.fReTryLater != null) {
                this.fReTryLater.add(this);
                JavaVEPlugin.log((Object)("\t[Expression] - postponing: " + stmt), (int)2);
                return null;
            }
            selector = new String(((MessageSend)stmt.receiver).selector);
        }
        if (selector != null) {
            return this.fModel.getBeanReturned(selector);
        }
        return null;
    }

    BeanPart processRefToThis(MessageSend stmt) {
        if (this.fModel.getABean("this") == null) {
            return null;
        }
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
        if (thisRule != null) {
            ISourceVisitor override = thisRule.overideThisReferenceVisit(this.fMethod.getDeclMethod(), stmt, this.fModel);
            if (override != null) {
                override.visit();
                return null;
            }
            if (thisRule.shouldProcess(this.fMethod.getDeclMethod(), stmt)) {
                BeanPart bean = null;
                BeanPartFactory bpg = new BeanPartFactory(this.fModel, null);
                bean = bpg.createThisBeanPartIfNeeded(this.fMethod);
                return bean;
            }
        }
        return null;
    }

    protected void processAMessageSend() {
        MessageSend stmt = (MessageSend)this.fExpression.getExpression();
        if (stmt == null) {
            return;
        }
        BeanPart bean = null;
        if (stmt.receiver instanceof SingleNameReference) {
            bean = this.processSingleNameReference(stmt);
        } else if (stmt.receiver instanceof MessageSend) {
            bean = this.processRefToMessageSend(stmt);
            if (bean == null && this.fReTryLater != null) {
                return;
            }
        } else if (stmt.receiver instanceof ThisReference) {
            bean = this.processRefToThis(stmt);
        }
        if (bean != null) {
            this.fExpression.setBean(bean);
            bean.addRefExpression(this.fExpression);
        } else {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAMessageSend() did not process: " + stmt), (int)2);
        }
    }

    protected boolean isStaticCall(String resolvedReciever, String selector, int argc) {
        EClassifier rClass = CodeGenUtil.getMetaClass(resolvedReciever, this.fModel.getCompositionModel());
        if (rClass != null && rClass instanceof JavaClassImpl) {
            JavaClassImpl Clazz = (JavaClassImpl)rClass;
            Iterator itr = Clazz.getPublicMethods().iterator();
            while (itr.hasNext()) {
                Method element = (Method)itr.next();
                if (!element.getName().equals(selector) || !element.isStatic()) continue;
                if (element.getReturnType() == null) {
                    return false;
                }
                if (element.getParameters().size() != argc) continue;
                return true;
            }
        }
        return false;
    }

    protected void processAssignmment() {
        Assignment stmt = (Assignment)this.fExpression.getExpression();
        if (stmt.lhs instanceof SingleNameReference) {
            String name = new String(((SingleNameReference)stmt.lhs).token);
            BeanPart bean = this.fModel.getABean(BeanDeclModel.constructUniqueName(this.fMethod, name));
            if (bean == null) {
                bean = this.fModel.getABean(name);
            }
            if (bean != null) {
                this.fExpression.setBean(bean);
                boolean initExpr = false;
                if (stmt.expression instanceof AllocationExpression || stmt.expression instanceof CastExpression && ((CastExpression)stmt.expression).expression instanceof AllocationExpression) {
                    initExpr = true;
                } else if (stmt.expression instanceof MessageSend || stmt.expression instanceof CastExpression && ((CastExpression)stmt.expression).expression instanceof MessageSend) {
                    MessageSend m = (MessageSend)(stmt.expression instanceof MessageSend ? stmt.expression : ((CastExpression)stmt.expression).expression);
                    String resolvedReciver = null;
                    resolvedReciver = m.receiver instanceof QualifiedNameReference ? m.receiver.toString() : this.fModel.resolve(m.receiver.toString());
                    if (this.isStaticCall(resolvedReciver, new String(m.selector), m.arguments == null ? 0 : m.arguments.length)) {
                        initExpr = true;
                    }
                }
                if (initExpr) {
                    bean.addInitMethod(this.fMethod);
                    this.fExpression.setState(4, true);
                    this.fExpression.setState(8, true);
                    this.fExpression.setState(1024, true);
                } else {
                    JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAssignmment() did not process: " + stmt), (int)2);
                }
            }
        } else if (stmt.lhs instanceof QualifiedNameReference) {
            char[][] tokens = ((QualifiedNameReference)stmt.lhs).tokens;
            String bName = new String(tokens[tokens.length - 2]);
            BeanPart bean = this.fModel.getABean(BeanDeclModel.constructUniqueName(this.fMethod, bName));
            if (bean == null) {
                bean = this.fModel.getABean(bName);
            }
            if (bean != null) {
                this.fExpression.setBean(bean);
                bean.addRefExpression(this.fExpression);
            }
        } else {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAssignmment() did not process: " + stmt), (int)2);
        }
    }

    protected void processDeclarations() {
        LocalDeclaration stmt = (LocalDeclaration)this.fExpression.getExpression();
        if (stmt.initialization instanceof AllocationExpression || stmt.initialization instanceof ArrayAllocationExpression || stmt.initialization instanceof CastExpression || stmt.initialization instanceof MessageSend) {
            String name = new String(stmt.name);
            BeanPart bean = this.fModel.getABean(BeanDeclModel.constructUniqueName(this.fMethod, name));
            if (bean == null) {
                bean = this.fModel.getABean(name);
            }
            this.fExpression.setBean(bean);
            bean.addInitMethod(this.fMethod);
            this.fExpression.setState(4, true);
            this.fExpression.setState(8, true);
            this.fExpression.setState(1024, true);
            bean.addRefExpression(this.fExpression);
            bean.getModel().addMethodInitializingABean(this.fMethod);
        }
    }

    public void visit() {
        if (this.fExpression.getExpression() instanceof MessageSend) {
            this.processAMessageSend();
        } else if (this.fExpression.getExpression() instanceof Assignment) {
            this.processAssignmment();
        } else if (this.fExpression.getExpression() instanceof LocalDeclaration) {
            this.processDeclarations();
        } else {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor: *** did not process Expression:" + this.fVisitedNode), (int)2);
        }
    }
}

