/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.codegen.core.IDiagramModelInstance;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.EventHandlerVisitor;
import org.eclipse.ve.internal.java.codegen.java.EventsParser;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenSyntaxError;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class JavaBeanModelBuilder {
    String fFileName = null;
    char[] fFileContent = null;
    char[][] fPackageName = null;
    CompilationUnitDeclaration fJDOM = null;
    IBeanDeclModel fModel = null;
    org.eclipse.jdt.core.ICompilationUnit fCU = null;
    IWorkingCopyProvider fWCP = null;
    IDiagramModelInstance fDiagram = null;
    EditDomain fDomain = null;

    public JavaBeanModelBuilder(EditDomain d, String fileName, char[][] packageName) {
        this.fFileName = fileName;
        this.fPackageName = packageName;
        this.fDomain = d;
    }

    public void setDiagram(IDiagramModelInstance diag) {
        this.fDiagram = diag;
    }

    public JavaBeanModelBuilder(EditDomain d, IWorkingCopyProvider wcp, String filePath, char[][] packageName) {
        this(d, filePath, packageName);
        this.fCU = wcp.getLocalWorkingCopy();
        this.fWCP = wcp;
    }

    protected char[] getFileContents() throws CodeGenException {
        char[] result = null;
        try {
            if (this.fCU == null) {
                throw new CodeGenException("Could not get a valid source text");
            }
            result = this.fCU.getSource().toCharArray();
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    protected void ParseJavaCode() throws CodeGenException {
        String encoding = (String)JavaCore.getOptions().get("org.eclipse.jdt.core.encoding");
        if ("".equals(encoding)) {
            encoding = null;
        }
        BasicCompilationUnit sourceUnit = new BasicCompilationUnit(this.fFileContent, this.fPackageName, this.fFileName, encoding);
        ProblemReporter reporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), new CompilerOptions(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        CompilationResult result = new CompilationResult((ICompilationUnit)sourceUnit, 1, 1, 20);
        this.fJDOM = this.getModelFromParser(reporter, result, sourceUnit);
        if (result.hasErrors()) {
            IProblem[] problems = result.getProblems();
            int i = 0;
            while (i < problems.length) {
                if (problems[i].isError()) {
                    throw new CodeGenSyntaxError("JVE Parsing Error: " + problems[i].getMessage() + " - Line: " + Integer.toString(problems[i].getSourceLineNumber()));
                }
                ++i;
            }
        }
    }

    protected CompilationUnitDeclaration getModelFromParser(ProblemReporter reporter, CompilationResult result, BasicCompilationUnit cu) {
        Parser aParser = new Parser(reporter, true, true);
        return aParser.parse((ICompilationUnit)cu, result);
    }

    protected void CreateBeanDeclModel() throws CodeGenException {
        this.fModel = this.createDefaultModel(this.fDomain);
        this.fModel.setJDOM(this.fJDOM);
        this.fModel.setWorkingCopyProvider(this.fWCP);
        if (this.fJDOM.types == null) {
            throw new CodeGenException("No Type to work on");
        }
        this.fModel.setTypeDecleration(this.fJDOM.types[0]);
        this.fModel.setCompositionModel(this.fDiagram);
    }

    protected IBeanDeclModel createDefaultModel(EditDomain d) {
        BeanDeclModel m = new BeanDeclModel();
        m.setDomain(d);
        CodeGenUtil.getDecoderFactory(m).setResourceSet(this.fDiagram.getModelResourceSet());
        return m;
    }

    void setLineSeperator() {
        this.fModel.setLineSeperator(System.getProperty("line.separator"));
        int i = 0;
        while (i < this.fFileContent.length) {
            if (this.fFileContent[i] == '\r' || this.fFileContent[i] == '\n') {
                if (this.fFileContent[i] == '\r') {
                    if (i + 1 < this.fFileContent.length && this.fFileContent[i + 1] == '\n') {
                        this.fModel.setLineSeperator("\r\n");
                        break;
                    }
                    this.fModel.setLineSeperator("\r");
                    break;
                }
                this.fModel.setLineSeperator("\n");
                break;
            }
            ++i;
        }
    }

    protected void cleanModel() {
        Iterator itr = this.fModel.getBeans().iterator();
        ArrayList<BeanPart> err = new ArrayList<BeanPart>();
        while (itr.hasNext()) {
            BeanPart bean = (BeanPart)itr.next();
            boolean removeFlag = false;
            if (!bean.getSimpleName().equals("this") && BeanPartFactory.getInstanceInitializationExpr(bean) == null && !bean.isInstanceInstantiation()) {
                JavaVEPlugin.log((Object)("*Discarting a beanPart " + bean), (int)2);
                removeFlag = true;
            }
            if (!removeFlag) continue;
            err.add(bean);
            Iterator bItr = bean.getChildren();
            if (bItr == null) continue;
            while (bItr.hasNext()) {
                err.add((BeanPart)bItr.next());
            }
        }
        int i = 0;
        while (i < err.size()) {
            ((BeanPart)err.get(i)).dispose();
            ++i;
        }
    }

    private String getSharedHandlerName(CodeEventRef eRef) {
        String result = null;
        String name = null;
        Statement s = eRef.getExpression();
        if (s instanceof MessageSend) {
            MessageSend ms = (MessageSend)s;
            if (ms.arguments != null && ms.arguments.length == 1 && ms.arguments[0] instanceof SingleNameReference) {
                name = new String(((SingleNameReference)ms.arguments[0]).token);
            }
        }
        if (name != null && this.fJDOM.types != null && this.fJDOM.types.length > 0 && this.fJDOM.types[0].fields != null) {
            int i = 0;
            while (i < this.fJDOM.types[0].fields.length) {
                FieldDeclaration f = this.fJDOM.types[0].fields[i];
                if (new String(f.name).equals(name)) {
                    result = f.type.toString();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected List mineForSharedListeners() {
        ArrayList<String> l = new ArrayList<String>();
        Iterator itr = this.fModel.getAllMethods();
        while (itr.hasNext()) {
            CodeMethodRef m = (CodeMethodRef)itr.next();
            Iterator exp = m.getEventExpressions();
            while (exp.hasNext()) {
                CodeEventRef eRef = (CodeEventRef)exp.next();
                String instance = this.getSharedHandlerName(eRef);
                if (l.contains(instance)) continue;
                l.add(instance);
            }
        }
        return l;
    }

    protected void analyzeEvents() {
        Iterator itr = this.fModel.getBeans().iterator();
        EventsParser p = new EventsParser(this.fModel, this.fJDOM);
        while (itr.hasNext()) {
            BeanPart b = (BeanPart)itr.next();
            p.addEvents(b);
        }
        List sharedListeners = this.mineForSharedListeners();
        if (this.fJDOM.types != null && this.fJDOM.types[0].memberTypes != null) {
            int i = 0;
            while (i < this.fJDOM.types[0].memberTypes.length) {
                String name = new String(this.fJDOM.types[0].memberTypes[i].name);
                if (sharedListeners.contains(name)) {
                    new EventHandlerVisitor((TypeDeclaration)this.fJDOM.types[0].memberTypes[i], this.fModel, false).visit();
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanDeclModel build() throws CodeGenException {
        JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build() starting .... ", (int)2);
        if (this.fFileName == null) throw new CodeGenException("null Input Source");
        if (this.fFileName.length() == 0) {
            throw new CodeGenException("null Input Source");
        }
        this.fFileContent = this.getFileContents();
        this.ParseJavaCode();
        this.CreateBeanDeclModel();
        this.setLineSeperator();
        try {
            try {
                ArrayList tryAgain = new ArrayList();
                if (this.fJDOM.types[0] == null) {
                    throw new CodeGenException(".. no type was parsed ...");
                }
                this.visitType(this.fJDOM.types[0], this.fModel, this.fFileContent, tryAgain);
                int i = 0;
                while (true) {
                    if (i >= tryAgain.size()) break;
                    ISourceVisitor visitor = (ISourceVisitor)tryAgain.get(i);
                    visitor.setNoRetry();
                    visitor.visit();
                    ++i;
                }
                this.analyzeEvents();
                Iterator itr = this.fModel.getBeans().iterator();
                while (true) {
                    if (!itr.hasNext()) {
                        this.cleanModel();
                    }
                    BeanPart bean = (BeanPart)itr.next();
                    bean.setModel(this.fModel);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (int)2);
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (int)2);
        return this.fModel;
    }

    protected void visitType(TypeDeclaration type, IBeanDeclModel model, char[] content, List tryAgain) {
        new TypeVisitor(type, model, tryAgain, false).visit();
    }
}

