/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.codegen.core.ICodeGenStatus;
import org.eclipse.ve.internal.java.codegen.core.JavaSourceTranslator;
import org.eclipse.ve.internal.java.codegen.java.ISynchronizerListener;
import org.eclipse.ve.internal.java.codegen.java.SynchronizerWorkItem;
import org.eclipse.ve.internal.java.codegen.util.IBackGroundWorkStrategy;
import org.eclipse.ve.internal.java.codegen.util.ICancelMonitor;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.codegen.util.StrategyWorker;
import org.eclipse.ve.internal.java.codegen.util.WorkerPool;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class JavaSourceSynchronizer {
    public static final int NO_OF_UPDATE_WORKERS = 2;
    public static final int DEFAULT_SYNC_DELAY = 500;
    public static int L2R_DELAY_FACTOR = 2;
    private Object fSyncPoint;
    private BackgroundThread fThread;
    private int fDelay = 500;
    IWorkingCopyProvider fWorkingCopyProvider;
    volatile Vector fList = new Vector();
    Display fDisplay = null;
    IBackGroundWorkStrategy fSharedUpdatingLocalStrategy = null;
    IBackGroundWorkStrategy fLocalUpdatingSharedStrategy = null;
    WorkerPool fStrategyWorkers = new WorkerPool(2);
    Hashtable fSharedUpdatingLocalMonitor = new Hashtable();
    Hashtable fLocalUpdatingSharedMonitor = new Hashtable();
    SharedDocListener fSharedDocListener = null;
    JavaSourceTranslator fsrcTranslator = null;
    ICodeGenStatus fStatus = null;
    int fDelayFactor = L2R_DELAY_FACTOR;

    public void appendReloadRequest(List additionalRequests) {
        SynchronizerWorkItem wi = new SynchronizerWorkItem("<RELOAD>", true);
        ArrayList<SynchronizerWorkItem> elements = new ArrayList<SynchronizerWorkItem>();
        if (additionalRequests != null && additionalRequests.size() > 0) {
            elements.addAll(additionalRequests);
        }
        elements.add(wi);
        this.updateLocalFromShared(elements);
    }

    public JavaSourceSynchronizer(IWorkingCopyProvider wcp, JavaSourceTranslator st) {
        Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
        int newFactor = -1;
        try {
            newFactor = store.getInt("SOURCE_DELAY_FACTOR");
            if (newFactor >= 0) {
                L2R_DELAY_FACTOR = newFactor;
            }
        }
        catch (Exception exception) {
            L2R_DELAY_FACTOR = 2;
        }
        this.fWorkingCopyProvider = wcp;
        this.fsrcTranslator = st;
        this.fDisplay = Display.getCurrent();
        this.install();
    }

    public void setSharedUpdatingLocalStrategy(IBackGroundWorkStrategy strategy) {
        this.fSharedUpdatingLocalStrategy = strategy;
    }

    public void setLocalUpdatingSharedStrategy(IBackGroundWorkStrategy strategy) {
        this.fLocalUpdatingSharedStrategy = strategy;
    }

    private synchronized void install() {
        if (this.fThread != null) {
            return;
        }
        this.fSyncPoint = new Object();
        this.fThread = new BackgroundThread("CodeGen::" + this.getClass().getName() + "[" + this.fWorkingCopyProvider.getFile().getName() + "]");
        this.fThread.start();
        this.connect();
    }

    private Display getDisplay() {
        if (this.fDisplay != null) {
            return this.fDisplay;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            int i = 0;
            while (i < windows.length) {
                if (windows[i].getShell() != null && windows[i].getShell().getDisplay() != null) {
                    this.fDisplay = windows[i].getShell().getDisplay();
                    break;
                }
                ++i;
            }
        }
        return this.fDisplay;
    }

    private void driveStrategy(List workElements, Hashtable monitors, IBackGroundWorkStrategy strategy) throws InterruptedException {
        if (workElements.isEmpty()) {
            return;
        }
        if (this.fStatus != null) {
            this.fStatus.setStatus(1, true);
            if (this.fLocalUpdatingSharedStrategy == strategy) {
                this.fStatus.setStatus(4, true);
            } else if (this.fSharedUpdatingLocalStrategy == strategy) {
                this.fStatus.setStatus(8, true);
            }
        }
        if (strategy == null) {
            JavaVEPlugin.log((Object)"JavaSourceSynchronizer.driveStrategy() - no strategy", (int)5);
            return;
        }
        Iterator itr = workElements.iterator();
        CancelMonitor newMon = new CancelMonitor();
        while (itr.hasNext()) {
            SynchronizerWorkItem wi = (SynchronizerWorkItem)itr.next();
            CancelMonitor m = (CancelMonitor)monitors.get(wi.getChangedElementHandle());
            if (m != null) {
                m.setCancel(false);
            }
            monitors.put(wi.getChangedElementHandle(), newMon);
        }
        StrategyWorker w = this.fStrategyWorkers.grabWorker();
        w.assignStrategy(strategy, workElements.toArray(new SynchronizerWorkItem[workElements.size()]), this.fSharedDocListener, this.getDisplay(), newMon);
    }

    private void process() {
        while (this.fList.size() > 0) {
            ArrayList LocalToSharedDelta = new ArrayList();
            ArrayList SharedToLocalDelta = new ArrayList();
            ArrayList NotificationList = new ArrayList();
            Vector vector = this.fList;
            synchronized (vector) {
                if (this.fList.size() > 0) {
                    int i = this.fList.size() - 1;
                    while (i >= 0) {
                        if (this.fList.get(i) instanceof SynchronizerWorkItem) {
                            SynchronizerWorkItem we = (SynchronizerWorkItem)this.fList.get(i);
                            if (we.isSharedToLocalUpdate()) {
                                SharedToLocalDelta.add(this.fList.remove(i));
                            } else {
                                LocalToSharedDelta.add(this.fList.remove(i));
                            }
                        } else if (this.fList.get(i) instanceof NotifierElement) {
                            NotificationList.add(this.fList.remove(i));
                        }
                        --i;
                    }
                }
            }
            try {
                this.driveStrategy(LocalToSharedDelta, this.fLocalUpdatingSharedMonitor, this.fLocalUpdatingSharedStrategy);
                this.driveStrategy(SharedToLocalDelta, this.fSharedUpdatingLocalMonitor, this.fSharedUpdatingLocalStrategy);
                if (this.fStrategyWorkers != null && !NotificationList.isEmpty()) {
                    this.fStrategyWorkers.waitForAllWorkersToComplete();
                }
                int i = NotificationList.size() - 1;
                while (-1 < i) {
                    try {
                        NotifierElement elm = (NotifierElement)NotificationList.get(i);
                        elm.getListener().markerProcessed(elm.getMarker());
                    }
                    catch (Throwable t) {
                        JavaVEPlugin.log((Throwable)t);
                    }
                    --i;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void notifyOnMarker(ISynchronizerListener listener, String marker, boolean immediate) {
        if (listener == null || this.fThread == null) {
            return;
        }
        NotifierElement elm = new NotifierElement(listener, marker, immediate);
        Vector vector = this.fList;
        synchronized (vector) {
            this.fList.add(elm);
        }
        if (immediate) {
            this.fThread.goNow();
        } else {
            this.fThread.reset();
        }
    }

    public void updateSharedFromLocal(String elementHandle) {
        Vector vector = this.fList;
        synchronized (vector) {
            SynchronizerWorkItem we = new SynchronizerWorkItem(elementHandle, false);
            Enumeration e = this.fList.elements();
            SynchronizerWorkItem oldElement = null;
            while (e.hasMoreElements()) {
                SynchronizerWorkItem w;
                Object o = e.nextElement();
                if (!(o instanceof SynchronizerWorkItem) || (w = (SynchronizerWorkItem)o).isSharedToLocalUpdate() != we.isSharedToLocalUpdate() || !w.getChangedElementHandle().equals(we.getChangedElementHandle())) continue;
                oldElement = w;
                break;
            }
            if (oldElement != null) {
                this.fList.remove(oldElement);
            }
            this.fList.add(we);
        }
        this.fThread.reset();
    }

    public void updateLocalFromShared(SynchronizerWorkItem we) {
        if (we == null) {
            return;
        }
        Vector vector = this.fList;
        synchronized (vector) {
            Enumeration e = this.fList.elements();
            SynchronizerWorkItem oldElement = null;
            while (e.hasMoreElements()) {
                SynchronizerWorkItem w;
                Object o = e.nextElement();
                if (!(o instanceof SynchronizerWorkItem) || !(w = (SynchronizerWorkItem)o).isEquivalent(we)) continue;
                oldElement = w;
                break;
            }
            if (oldElement != null) {
                this.fList.remove(oldElement);
                if (oldElement.getChangedElementHandle().equals("<RELOAD>")) {
                    this.fStatus.setReloadPending(false);
                } else {
                    we.setChangeElementPrevContent(oldElement.getChangeElementPrevContent());
                }
            }
            this.fList.add(we);
            this.fsrcTranslator.fireSnippetProcessing(true);
        }
        this.fThread.reset();
    }

    public void updateLocalFromShared(List workElements) {
        if (workElements == null || workElements.isEmpty()) {
            return;
        }
        Vector vector = this.fList;
        synchronized (vector) {
            Iterator itr = workElements.iterator();
            while (itr.hasNext()) {
                this.updateLocalFromShared((SynchronizerWorkItem)itr.next());
            }
        }
    }

    public void setDelay(int delay) {
        if (delay > 500) {
            this.fDelay = delay;
        }
    }

    public int getDelay() {
        return this.fDelay;
    }

    public synchronized void uninstall() {
        this.disconnect();
        if (this.fThread != null) {
            this.fThread.cancel();
            this.fThread = null;
        }
        if (this.fStrategyWorkers != null) {
            this.fStrategyWorkers.finish();
        }
        this.fStrategyWorkers = null;
    }

    public boolean isWorkQueued() {
        boolean result = false;
        Vector vector = this.fList;
        synchronized (vector) {
            Iterator itr = ((AbstractList)this.fList).iterator();
            while (itr.hasNext()) {
                Object element = itr.next();
                if (!(element instanceof SynchronizerWorkItem)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public synchronized void disconnect() {
        if (this.fSharedDocListener != null) {
            this.fWorkingCopyProvider.getSharedDocument().removeDocumentListener((IDocumentListener)this.fSharedDocListener);
            this.fSharedDocListener = null;
        }
        Vector vector = this.fList;
        synchronized (vector) {
            int i = 0;
            while (i < this.fList.size()) {
                if (this.fList.get(i) instanceof NotifierElement) {
                    NotifierElement elm = (NotifierElement)this.fList.get(i);
                    try {
                        elm.getListener().markerProcessed(elm.getMarker());
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
            this.fList.clear();
        }
    }

    public synchronized void connect() {
        if (this.fSharedDocListener == null) {
            this.fSharedDocListener = new SharedDocListener();
            this.fWorkingCopyProvider.getSharedDocument().addDocumentListener((IDocumentListener)this.fSharedDocListener);
        }
    }

    public void setStatus(ICodeGenStatus fStatus) {
        this.fStatus = fStatus;
    }

    class BackgroundThread
    extends Thread {
        private volatile boolean fCanceled = false;
        private volatile boolean fReset = false;
        private volatile boolean fIsDirty = false;
        private volatile boolean fIsActive = false;
        private volatile boolean fgoNow = false;

        public BackgroundThread(String name) {
            super(name);
            this.setPriority(1);
            this.setDaemon(true);
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void cancel() {
            this.fCanceled = true;
            Object object = JavaSourceSynchronizer.this.fSyncPoint;
            synchronized (object) {
                JavaSourceSynchronizer.this.fSyncPoint.notifyAll();
            }
        }

        public void reset() {
            if (JavaSourceSynchronizer.this.fDelay > 0) {
                BackgroundThread backgroundThread = this;
                synchronized (backgroundThread) {
                    this.fIsDirty = true;
                    if (!this.fgoNow) {
                        this.fReset = true;
                    }
                }
            } else {
                this.goNow();
            }
        }

        public void goNow() {
            BackgroundThread backgroundThread = this;
            synchronized (backgroundThread) {
                this.fIsDirty = true;
                this.fReset = false;
                Object object = JavaSourceSynchronizer.this.fSyncPoint;
                synchronized (object) {
                    this.fgoNow = true;
                    JavaSourceSynchronizer.this.fSyncPoint.notifyAll();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isL2ROnly() {
            if (JavaSourceSynchronizer.this.fList == null) return true;
            if (JavaSourceSynchronizer.this.fList.isEmpty()) {
                return true;
            }
            Vector vector = JavaSourceSynchronizer.this.fList;
            synchronized (vector) {
                Iterator itr = ((AbstractList)JavaSourceSynchronizer.this.fList).iterator();
                do {
                    if (itr.hasNext()) continue;
                    return true;
                } while (itr.next() instanceof SynchronizerWorkItem);
                return false;
            }
        }

        public void run() {
            while (!this.fCanceled) {
                Object object = JavaSourceSynchronizer.this.fSyncPoint;
                synchronized (object) {
                    try {
                        if (!this.fgoNow) {
                            JavaSourceSynchronizer.this.fSyncPoint.wait(JavaSourceSynchronizer.this.fDelay);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fCanceled) break;
                --JavaSourceSynchronizer.this.fDelayFactor;
                object = this;
                synchronized (object) {
                    if (JavaSourceSynchronizer.this.fStatus != null && JavaSourceSynchronizer.this.fList.isEmpty() && JavaSourceSynchronizer.this.fStrategyWorkers.getAvailWorkers() == JavaSourceSynchronizer.this.fStrategyWorkers.getNoOfWorkers()) {
                        JavaSourceSynchronizer.this.fStatus.setStatus(2, false);
                        JavaSourceSynchronizer.this.fStatus.setStatus(1, false);
                        JavaSourceSynchronizer.this.fStatus.setStatus(8, false);
                        JavaSourceSynchronizer.this.fStatus.setStatus(4, false);
                    }
                    if (!this.fIsDirty && !this.fgoNow) {
                        continue;
                    }
                }
                if (JavaSourceSynchronizer.this.fDelayFactor > 0 && this.isL2ROnly()) continue;
                JavaSourceSynchronizer.this.fDelayFactor = L2R_DELAY_FACTOR;
                if (this.fReset) {
                    object = this;
                    synchronized (object) {
                        this.fReset = false;
                    }
                    if (!this.fgoNow) continue;
                }
                this.fIsActive = true;
                JavaSourceSynchronizer.this.process();
                object = this;
                synchronized (object) {
                    this.fIsDirty = JavaSourceSynchronizer.this.fList.size() > 0;
                    this.fgoNow = this.fgoNow && this.fIsDirty;
                }
                this.fIsActive = false;
            }
        }
    }

    class NotifierElement {
        ISynchronizerListener fListener;
        String fMarker;
        boolean fImmediate;

        public NotifierElement(ISynchronizerListener sl, String marker, boolean immediate) {
            this.fListener = sl;
            this.fMarker = marker;
            this.fImmediate = immediate;
        }

        public ISynchronizerListener getListener() {
            return this.fListener;
        }

        public String getMarker() {
            return this.fMarker;
        }

        public boolean isImmediate() {
            return this.fImmediate;
        }
    }

    class SharedDocListener
    implements IDocumentListener {
        List prev = null;
        DocumentEvent prevEvent = null;
        long prevEventTime = System.currentTimeMillis();

        SharedDocListener() {
        }

        private boolean isRepeatedKey(DocumentEvent event, boolean update) {
            long curTime = System.currentTimeMillis();
            boolean result = false;
            if (this.prevEvent != null) {
                int delta = event.getOffset() - this.prevEvent.getOffset();
                if (delta >= 0 && delta <= 2 && curTime - this.prevEventTime < 450L) {
                    result = true;
                }
                JavaSourceSynchronizer.this.fThread.reset();
            }
            if (update) {
                this.prevEventTime = curTime;
            }
            return result;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            try {
                if (this.isRepeatedKey(event, false)) {
                    return;
                }
                if (JavaSourceSynchronizer.this.fStatus != null) {
                    JavaSourceSynchronizer.this.fStatus.setStatus(2, true);
                }
                this.prev = SynchronizerWorkItem.getWorkItemList(event, JavaSourceSynchronizer.this.fWorkingCopyProvider.getSharedWorkingCopy(false), true, true);
                if (this.prev.size() > 100) {
                    JavaVEPlugin.log((Object)("JavaSourceSynchronizer$SharedDocListener.docChanged(): elements: " + this.prev.size()), (int)5);
                }
            }
            catch (Throwable e) {
                JavaVEPlugin.log((Object)"Not processing documentAboutToBeChanged(DocumentEvent) due to exception.", (int)5);
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
        }

        public void documentChanged(DocumentEvent event) {
            try {
                if (this.isRepeatedKey(event, true)) {
                    this.prevEvent = event;
                    return;
                }
                this.prevEvent = event;
                List elements = SynchronizerWorkItem.refreshWorkItemList(this.prev, event, JavaSourceSynchronizer.this.fWorkingCopyProvider.getSharedWorkingCopy(), true, false);
                if (elements.size() > 100) {
                    JavaVEPlugin.log((Object)("JavaSourceSynchronizer$SharedDocListener.docChanged(): elements: " + elements.size()), (int)5);
                }
                this.prev = null;
                if (JavaSourceSynchronizer.this.fStatus.isStatusSet(64) || JavaSourceSynchronizer.this.fStatus.isStatusSet(128)) {
                    JavaSourceSynchronizer.this.fStatus.setReloadPending(true);
                    JavaSourceSynchronizer.this.appendReloadRequest(elements);
                } else {
                    JavaSourceSynchronizer.this.updateLocalFromShared(elements);
                }
            }
            catch (Throwable e) {
                JavaVEPlugin.log((Object)"Not processing documentChanged(DocumentEvent) due to exception.", (int)5);
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
        }
    }

    class CancelMonitor
    implements ICancelMonitor {
        boolean fCancel = false;
        boolean fCompleted = false;

        CancelMonitor() {
        }

        public boolean isCanceled() {
            return this.fCancel;
        }

        public void setCancel(boolean flag) {
            this.fCancel = flag;
        }

        public synchronized void setCompleted() {
            this.fCompleted = true;
            this.notifyAll();
        }

        public synchronized boolean isCompleted(boolean wantToWait) {
            if (wantToWait && !this.fCompleted) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            return this.fCompleted;
        }
    }
}

