/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.EventDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoder;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;
import org.eclipse.ve.internal.jcm.PropertyEvent;

public abstract class PropertyChangeInvocationHelper
extends EventDecoderHelper {
    public static final String DEFAULT_PROPERTY_CHANGED_ADD_METHOD = "addPropertyChangeListener";
    public static final String PROPERTY_CALLBACK_NAME = "propertyChange";
    public static final String PROPERTY_NAME_GETTER = "getPropertyName";
    public static List PropetyChangeCallbacks = null;
    Method fMethod = null;

    public PropertyChangeInvocationHelper(BeanPart bean, Statement exp, IEventDecoder owner) {
        super(bean, exp, owner);
    }

    protected Method getMethodName() {
        if (this.fMethod == null) {
            this.fMethod = ((PropertyChangeEventInvocation)this.fEventInvocation).getAddMethod();
        }
        return this.fMethod;
    }

    protected boolean isValidSelector(String selector) {
        boolean valid = DEFAULT_PROPERTY_CHANGED_ADD_METHOD.equals(selector);
        if (!valid) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Selector", true);
        }
        return valid;
    }

    protected boolean isValidArguments(Expression[] exps) {
        boolean valid;
        boolean bl = valid = exps != null && exps.length > 0 && exps.length <= 2;
        if (!valid) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Arguments", true);
        }
        return valid;
    }

    protected Method getAddMethod(MessageSend event) {
        JavaClass beanClass = (JavaClass)JavaClassImpl.reflect((String)this.fbeanPart.getType(), (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        ArrayList<String> argsList = new ArrayList<String>();
        int i = 0;
        while (i < event.arguments.length) {
            if (event.arguments[i] instanceof StringLiteral) {
                argsList.add("java.lang.String");
            } else if (event.arguments[i] instanceof QualifiedAllocationExpression) {
                String t = ((QualifiedAllocationExpression)event.arguments[i]).type.toString();
                t = this.fbeanPart.getModel().resolve(t);
                argsList.add(t);
            } else if (event.arguments[i] instanceof AllocationExpression) {
                AllocationExpression ae = (AllocationExpression)event.arguments[i];
                String t = ae.type.toString();
                t = this.fbeanPart.getModel().resolve(t);
                if ((event.arguments.length == 1 || event.arguments.length == 2) && ae.type instanceof SingleTypeReference) {
                    argsList.add("java.beans.PropertyChangeListener");
                } else {
                    argsList.add(t);
                }
            } else if (event.arguments[i] instanceof SingleNameReference) {
                argsList.add("java.beans.PropertyChangeListener");
            }
            ++i;
        }
        Method listenRegMethod = null;
        while (listenRegMethod == null && beanClass != null) {
            listenRegMethod = beanClass.getMethod(DEFAULT_PROPERTY_CHANGED_ADD_METHOD, argsList);
            if (listenRegMethod != null) continue;
            beanClass = beanClass.getSupertype();
        }
        return listenRegMethod;
    }

    public void unadaptToCompositionModel() {
        super.unadaptToCompositionModel();
        EList propEevents = ((PropertyChangeEventInvocation)this.fEventInvocation).getProperties();
        int i = 0;
        while (i < propEevents.size()) {
            PropertyEvent pe = (PropertyEvent)propEevents.get(i);
            this.unadaptPropertyEvent(pe);
            ++i;
        }
    }

    public void adaptToCompositionModel(IEventDecoder decoder) {
        super.adaptToCompositionModel(decoder);
        EList propEevents = ((PropertyChangeEventInvocation)this.fEventInvocation).getProperties();
        int i = 0;
        while (i < propEevents.size()) {
            PropertyEvent pe = (PropertyEvent)propEevents.get(i);
            this.adaptPropertyEvent(pe);
            ++i;
        }
    }

    protected void adaptPropertyEvent(PropertyEvent pe) {
        if (this.feventAdapter != null) {
            pe.eAdapters().add(this.feventAdapter.getPropertyEventSourceRangeAdapter(pe));
        } else {
            JavaVEPlugin.log((Object)"PropertyChangedAllocationStyleHellper.adaptPropertyEvent: NoAdapter", (int)5);
        }
    }

    protected void unadaptPropertyEvent(PropertyEvent pe) {
        ICodeGenAdapter ca = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)pe, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        if (ca != null) {
            pe.eAdapters().remove(ca);
        }
    }

    protected List getCallBackList() {
        if (PropetyChangeCallbacks != null) {
            return PropetyChangeCallbacks;
        }
        JavaClass cb = (JavaClass)JavaClassImpl.reflect((String)"java.beans.PropertyChangeListener", (ResourceSet)this.fbeanPart.getModel().getCompositionModel().getModelResourceSet());
        PropetyChangeCallbacks = cb.getMethods();
        return PropetyChangeCallbacks;
    }
}

