/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.ve.internal.java.codegen.java.FreeFormThisAnnotationDecoder;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class SynchronizerWorkItem {
    public static final String UNRESOLVED_HANDLE = "<UNRESOLVED>";
    public static final String RELOAD_HANDLE = "<RELOAD>";
    public static final String THIS_ANNOTATION_HANDLE = "_this_Annotation_handle";
    public static final String INSTANCE_ANNOTATION_HANDLE = "_instance_Annotation_handle";
    public static final String CLASS_IMPLEMENT_EXTENDS_HANDLE = "_class_ImplementsExtends_handle";
    private static final int TYPE_WI_PACKAGE = 1;
    private static final int TYPE_WI_IMPORT = 2;
    private static final int TYPE_WI_FIELD = 8;
    private static final int TYPE_WI_METHOD = 16;
    private static final int TYPE_WI_INNERTYPE = 32;
    private String packageName = null;
    private String extendsClass = null;
    private String[] implementsInterafces = new String[0];
    private ISourceRange packages = null;
    private ISourceRange[] imports = new ISourceRange[0];
    private ISourceRange[] fields = new ISourceRange[0];
    private ISourceRange[] methods = new ISourceRange[0];
    private ISourceRange[] innerTypes = new ISourceRange[0];
    private String PHandle = null;
    private String[] IHandles = null;
    private String[] Fhandles = null;
    private String[] Mhandles = null;
    private String[] MSkeletons = null;
    private String entireClassCode = null;
    private String elementPrevContent = null;
    private String[] innerTypeHandles = null;
    private String[] innerTypeSkeletons = null;
    private String _handle = null;
    private int elementIndex = -1;
    private ICompilationUnit referenceCU = null;
    private int deltaOff = -1;
    private int deltaLen = -1;
    private int type;
    private boolean sharedToLocalUpdate;
    private boolean handleOnly;

    public SynchronizerWorkItem(String handle, boolean isDirectionToLocal) {
        this._handle = handle;
        this.sharedToLocalUpdate = isDirectionToLocal;
        this.handleOnly = true;
    }

    private boolean isIntersect(int cX, int cY, int dX, int dY) {
        if (cX >= dX && cX <= dY) {
            return true;
        }
        if (cY >= dX && dY >= cY) {
            return true;
        }
        if (cX <= dX && cY >= dY) {
            return true;
        }
        return dX <= cX && dY >= cY;
    }

    private boolean isIntersectFields(IField[] f, ICompilationUnit cu, int len, DocumentEvent docDelta) {
        int i = 0;
        while (i < f.length) {
            try {
                if (this.isIntersect(f[i].getSourceRange().getOffset(), f[i].getSourceRange().getOffset() + f[i].getSourceRange().getLength(), docDelta.getOffset(), docDelta.getOffset() + len)) {
                    this._handle = f[i].getHandleIdentifier();
                    return true;
                }
                int rangeFrom = f[i].getSourceRange().getOffset() + f[i].getSourceRange().getLength();
                int rangeTo = cu.getSource().indexOf(13, rangeFrom);
                if (i < f.length - 1 && rangeTo > f[i + 1].getSourceRange().getOffset()) {
                    rangeTo = f[i].getSourceRange().getOffset();
                }
                if (rangeFrom >= 0 && rangeTo >= 0 && rangeFrom <= cu.getSource().length() && rangeTo < cu.getSource().length() && this.isIntersect(rangeFrom, rangeTo, docDelta.getOffset(), docDelta.getOffset() + len)) {
                    this._handle = INSTANCE_ANNOTATION_HANDLE;
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return false;
    }

    private boolean isIntersectThisFFAnnotation(ICompilationUnit cu, int len, DocumentEvent docDelta) {
        ICodeGenSourceRange thisFF = FreeFormThisAnnotationDecoder.getDesignatedAnnotationRange(cu);
        if (thisFF != null && this.isIntersect(thisFF.getOffset(), thisFF.getOffset() + thisFF.getLength(), docDelta.getOffset(), docDelta.getOffset() + len)) {
            this._handle = THIS_ANNOTATION_HANDLE;
            return true;
        }
        return false;
    }

    private boolean isIntersectSuperImplements(ICompilationUnit cu, DocumentEvent docDelta) {
        IType mainType = CodeGenUtil.getMainType(cu);
        try {
            if (mainType != null) {
                String superName = mainType.getSuperclassName();
                String[] superInterfaces = mainType.getSuperInterfaceNames();
                if (superName != null && superName.length() > -1 || superInterfaces != null && superInterfaces.length > 0) {
                    ISourceRange typeNameRange = mainType.getNameRange();
                    int from = typeNameRange.getOffset();
                    int to = typeNameRange.getOffset() + typeNameRange.getLength();
                    int n = from = cu.getSource().lastIndexOf(10, from) < 0 ? from : cu.getSource().lastIndexOf(10, from);
                    if (superName != null && superName.length() > 0) {
                        to = cu.getSource().indexOf(superName, to);
                        to += superName.length();
                    }
                    if (superInterfaces != null) {
                        int cc = 0;
                        while (cc < superInterfaces.length) {
                            if (cu.getSource().indexOf(superInterfaces[cc], to) > to) {
                                to = cu.getSource().indexOf(superInterfaces[cc], to);
                                to += superInterfaces[cc].length();
                            }
                            ++cc;
                        }
                    }
                    if (this.isIntersect(from, to, docDelta.getOffset(), docDelta.getOffset() + docDelta.getLength())) {
                        this._handle = CLASS_IMPLEMENT_EXTENDS_HANDLE;
                        return true;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    protected boolean isMainType(SourceType t) {
        if (t == null) {
            return false;
        }
        IType mainT = CodeGenUtil.getMainType(t.getCompilationUnit());
        return mainT.equals(t);
    }

    protected IJavaElement promoteToInnerTypeElementIfNeeded(IJavaElement elm) {
        if (elm == null) {
            return null;
        }
        IJavaElement result = elm;
        while (!(elm instanceof SourceType) && elm != null) {
            elm = elm.getParent();
        }
        if (elm != null && !this.isMainType((SourceType)elm)) {
            result = elm;
        }
        return result;
    }

    public SynchronizerWorkItem(DocumentEvent docDelta, ICompilationUnit cu, boolean isDirectionToLocal, boolean isBeforeActualChange) {
        try {
            int len;
            int docDeltaTextLength;
            this.sharedToLocalUpdate = isDirectionToLocal;
            this.referenceCU = cu;
            this.setSourceCode(cu.getSource());
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
            IJavaElement elm = null;
            int changeFrom = docDelta.getOffset();
            int changeTo = docDelta.getOffset();
            int n = docDeltaTextLength = docDelta.getText() == null ? 0 : docDelta.getText().length();
            changeTo = isBeforeActualChange ? (changeTo += docDelta.getLength()) : (changeTo += docDeltaTextLength);
            int off = changeFrom;
            while (off < changeTo) {
                elm = cu.getElementAt(off);
                if (!(elm instanceof SourceType) && elm != null) break;
                ++off;
            }
            if (elm == null) {
                elm = this.promoteToInnerTypeElementIfNeeded(cu.getElementAt(docDelta.getOffset()));
            }
            int n2 = len = isBeforeActualChange ? docDelta.getLength() : docDeltaTextLength;
            if (elm instanceof SourceType && this.isMainType((SourceType)elm)) {
                SourceType st = (SourceType)elm;
                IField[] f = st.getFields();
                if (!this.isIntersectFields(f, cu, len, docDelta) && !this.isIntersectThisFFAnnotation(cu, len, docDelta)) {
                    this.isIntersectSuperImplements(cu, docDelta);
                }
            } else if (elm != null) {
                if (elm instanceof IField) {
                    IType mainType = CodeGenUtil.getMainType(cu);
                    IField field = (IField)elm;
                    IField ff = SynchronizerWorkItem.getEncompassingField(mainType.getFields(), field);
                    if (ff != null) {
                        elm = ff;
                    }
                }
                this._handle = elm.getHandleIdentifier();
            } else {
                this.isIntersectThisFFAnnotation(cu, len, docDelta);
            }
        }
        catch (JavaModelException javaModelException) {}
        if (this._handle == null) {
            this._handle = UNRESOLVED_HANDLE;
            return;
        }
        this.processPackage(cu);
        this.processMethods(docDelta, cu);
        this.processInnerTypes(cu);
        this.processFields(cu);
        this.processImports(cu);
        this.processExtends(cu);
        this.processImplements(cu);
        this.deltaOff = docDelta.getOffset();
        this.deltaLen = isBeforeActualChange ? docDelta.getLength() : (docDelta.getText() == null ? 0 : docDelta.getText().length());
        this.handleOnly = false;
    }

    public SynchronizerWorkItem(SynchronizerWorkItem origin, int Index, int wiType, ICompilationUnit cu) {
        this.handleOnly = origin.isHandleOnly();
        this.sharedToLocalUpdate = origin.isSharedToLocalUpdate();
        this.referenceCU = origin.getCompilationUnit();
        this.elementIndex = Index;
        this.setType(wiType);
        this.packageName = origin.getPackageName();
        this.packages = origin.getPackage();
        this.extendsClass = origin.getExtends();
        this.implementsInterafces = origin.getImplements();
        this.imports = origin.getImports();
        this.fields = origin.getFields();
        this.methods = origin.getMethods();
        this.PHandle = origin.getPackageHandle();
        this.IHandles = origin.getImportHandles();
        this.Fhandles = origin.getFieldshandles();
        this.Mhandles = origin.getMethodsHandles();
        this.MSkeletons = origin.getMethodSkeletons();
        this.entireClassCode = origin.getSourceCode();
        this.deltaOff = origin.getdeltaOff();
        this.deltaLen = origin.getdeltaLen();
        this.innerTypeHandles = origin.getInnerTypeHandles();
        this.innerTypes = origin.getInnerTypes();
        this.innerTypeSkeletons = origin.getInnerTypeSkeletons();
    }

    public boolean isEquivalent(SynchronizerWorkItem wi) {
        if (this.getChangedElementHandle() == null && wi.getChangedElementHandle() != null) {
            return false;
        }
        if (this.getChangedElementHandle() != null && wi.getChangedElementHandle() == null) {
            return false;
        }
        return this.isSharedToLocalUpdate() == wi.isSharedToLocalUpdate() && this.getChangedElementHandle().equals(wi.getChangedElementHandle());
    }

    public static SynchronizerWorkItem getMatchingElement(List list, SynchronizerWorkItem wi) {
        if (list == null) {
            return null;
        }
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            SynchronizerWorkItem w = (SynchronizerWorkItem)itr.next();
            if (!w.isEquivalent(wi)) continue;
            return w;
        }
        return null;
    }

    private static int getNextField(ISourceReference m, IField[] f, int deltaEnd) {
        if (m == null || f == null) {
            return -1;
        }
        try {
            int i = 0;
            while (i < f.length) {
                if (f[i].getSourceRange().getOffset() > m.getSourceRange().getOffset() && f[i].getSourceRange().getOffset() < deltaEnd) {
                    return i;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return -1;
    }

    private static int getNextMethod(ISourceReference m, IMethod[] mtd, int deltaEnd) {
        if (m == null || mtd == null) {
            return -1;
        }
        try {
            int i = 0;
            while (i < mtd.length) {
                if (mtd[i].getSourceRange().getOffset() > m.getSourceRange().getOffset() + m.getSourceRange().getLength() && mtd[i].getSourceRange().getOffset() < deltaEnd) {
                    return i;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return -1;
    }

    private static int getNextImport(ISourceReference m, IImportDeclaration[] imps, int deltaEnd) {
        if (m == null || imps == null) {
            return -1;
        }
        try {
            int i = 0;
            while (i < imps.length) {
                if (imps[i].getSourceRange().getOffset() > m.getSourceRange().getOffset() && imps[i].getSourceRange().getOffset() < deltaEnd) {
                    return i;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return -1;
    }

    public static SynchronizerWorkItem getNextMethodWorkItem(SynchronizerWorkItem current, ICompilationUnit cu) {
        try {
            IPackageDeclaration member = null;
            IMethod[] mtds = CodeGenUtil.getMethods(cu);
            IType mainType = CodeGenUtil.getMainType(cu);
            IField[] flds = mainType == null ? null : mainType.getFields();
            IImportDeclaration[] imprts = cu.getImports();
            IPackageDeclaration[] pkgs = cu.getPackageDeclarations();
            int i = 0;
            while (pkgs != null && i < pkgs.length) {
                if (pkgs[i].getHandleIdentifier().equals(current.getChangedElementHandle())) {
                    member = pkgs[i];
                    break;
                }
                ++i;
            }
            i = 0;
            while (mtds != null && i < mtds.length) {
                if (mtds[i].getHandleIdentifier().equals(current.getChangedElementHandle())) {
                    member = mtds[i];
                    break;
                }
                ++i;
            }
            i = 0;
            while (flds != null && i < flds.length) {
                if (flds[i].getHandleIdentifier().equals(current.getChangedElementHandle())) {
                    member = flds[i];
                    break;
                }
                ++i;
            }
            i = 0;
            while (imprts != null && i < imprts.length) {
                if (imprts[i].getHandleIdentifier().equals(current.getChangedElementHandle())) {
                    member = imprts[i];
                    break;
                }
                ++i;
            }
            if (member == null) {
                return null;
            }
            int nextF = SynchronizerWorkItem.getNextField((ISourceReference)member, flds, current.getdeltaOff() + current.getdeltaLen());
            int nextM = SynchronizerWorkItem.getNextMethod((ISourceReference)member, mtds, current.getdeltaOff() + current.getdeltaLen());
            int nextI = SynchronizerWorkItem.getNextImport((ISourceReference)member, imprts, current.getdeltaOff() + current.getdeltaLen());
            IImportDeclaration firstMember = null;
            if (nextI > -1 && nextI < imprts.length) {
                if (firstMember == null) {
                    firstMember = imprts[nextI];
                } else if (firstMember.getSourceRange().getOffset() > imprts[nextI].getSourceRange().getOffset()) {
                    firstMember = imprts[nextI];
                }
            }
            if (nextF > -1 && nextF < flds.length) {
                if (firstMember == null) {
                    firstMember = flds[nextF];
                } else if (firstMember.getSourceRange().getOffset() > flds[nextF].getSourceRange().getOffset()) {
                    firstMember = flds[nextF];
                }
            }
            if (nextM > -1 && nextM < mtds.length) {
                if (firstMember == null) {
                    firstMember = mtds[nextM];
                } else if (firstMember.getSourceRange().getOffset() > mtds[nextM].getSourceRange().getOffset()) {
                    firstMember = mtds[nextM];
                }
            }
            if (firstMember == null) {
                return null;
            }
            if (firstMember instanceof IImportDeclaration) {
                return new SynchronizerWorkItem(current, nextI, 2, cu);
            }
            if (firstMember instanceof IMethod) {
                return new SynchronizerWorkItem(current, nextM, 16, cu);
            }
            if (firstMember instanceof IField) {
                return new SynchronizerWorkItem(current, nextF, 8, cu);
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static List getWorkItemList(DocumentEvent docDelta, ICompilationUnit cu, boolean isDirectionToLocal, boolean isBeforeActualChange) {
        ArrayList<SynchronizerWorkItem> list = new ArrayList<SynchronizerWorkItem>();
        try {
            SynchronizerWorkItem wi = new SynchronizerWorkItem(docDelta, cu, isDirectionToLocal, isBeforeActualChange);
            int totals = 0;
            if (wi != null) {
                if (wi.getFields() != null) {
                    totals += wi.getFields().length;
                }
                if (wi.getMethods() != null) {
                    totals += wi.getMethods().length;
                }
                if (wi.getImports() != null) {
                    totals += wi.getImports().length;
                }
            }
            while (wi != null) {
                if (list.size() > totals) {
                    JavaVEPlugin.log((Object)"SynchronizerWorkItem.getWorkItemList(): looping.", (int)5);
                    break;
                }
                list.add(wi);
                wi = SynchronizerWorkItem.getNextMethodWorkItem(wi, cu);
            }
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
        return list;
    }

    public static List refreshWorkItemList(List oList, DocumentEvent docDelta, ICompilationUnit cu, boolean isDirectionToLocal, boolean isBeforeActualChange) {
        List list = SynchronizerWorkItem.getWorkItemList(docDelta, cu, isDirectionToLocal, isBeforeActualChange);
        ArrayList<SynchronizerWorkItem> nList = new ArrayList<SynchronizerWorkItem>();
        try {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                SynchronizerWorkItem current = (SynchronizerWorkItem)itr.next();
                SynchronizerWorkItem older = SynchronizerWorkItem.getMatchingElement(oList, current);
                if (older != null) {
                    current.setChangeElementPrevContent(older.getChangedElementContent());
                }
                nList.add(current);
            }
            if (oList != null) {
                itr = oList.iterator();
                while (itr.hasNext()) {
                    SynchronizerWorkItem older = (SynchronizerWorkItem)itr.next();
                    SynchronizerWorkItem current = SynchronizerWorkItem.getMatchingElement(list, older);
                    if (current != null) continue;
                    older.refreshContents(cu);
                    nList.add(older);
                }
            }
            if (nList.isEmpty()) {
                nList.add(new SynchronizerWorkItem(docDelta, cu, isDirectionToLocal, isBeforeActualChange));
            }
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
        return nList;
    }

    private void processPackage(ICompilationUnit cu) {
        try {
            if (cu.getPackageDeclarations() != null && cu.getPackageDeclarations().length > 0) {
                this.packageName = cu.getPackageDeclarations()[0].getElementName();
                this.packages = cu.getPackageDeclarations()[0].getSourceRange();
                this.PHandle = cu.getPackageDeclarations()[0].getHandleIdentifier();
                if (this.PHandle != null && this.PHandle.equals(this._handle)) {
                    this.setType(1);
                    this.elementIndex = 0;
                }
            } else {
                this.packageName = null;
            }
        }
        catch (JavaModelException javaModelException) {
            this.packageName = null;
        }
    }

    private void processMethods(DocumentEvent docDelta, ICompilationUnit cu) {
        try {
            IMethod[] all = CodeGenUtil.getMethods(cu);
            if (all == null) {
                return;
            }
            this.methods = new ISourceRange[all.length];
            this.Mhandles = new String[all.length];
            this.MSkeletons = new String[all.length];
            int i = 0;
            while (i < this.methods.length) {
                this.methods[i] = all[i].getSourceRange();
                this.Mhandles[i] = all[i].getHandleIdentifier();
                if (all[i].getHandleIdentifier().equals(this._handle)) {
                    this.setType(16);
                    this.elementIndex = i;
                }
                this.MSkeletons[i] = SynchronizerWorkItem.createSkeleton(all[i]);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void processInnerTypes(ICompilationUnit cu) {
        try {
            IType[] innTypes = CodeGenUtil.getMainType(cu).getTypes();
            if (innTypes != null) {
                this.innerTypes = new ISourceRange[innTypes.length];
                this.innerTypeHandles = new String[innTypes.length];
                this.innerTypeSkeletons = new String[innTypes.length];
                int i = 0;
                while (i < innTypes.length) {
                    this.innerTypes[i] = innTypes[i].getSourceRange();
                    this.innerTypeHandles[i] = innTypes[i].getHandleIdentifier();
                    this.innerTypeSkeletons[i] = SynchronizerWorkItem.createSkeleton(innTypes[i]);
                    if (this._handle.indexOf(innTypes[i].getHandleIdentifier()) >= 0) {
                        this.setType(32);
                        this.elementIndex = i;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static String createSkeleton(IType type) {
        int i;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(Flags.toString((int)type.getFlags()));
        }
        catch (JavaModelException javaModelException) {}
        try {
            if (type.isClass()) {
                sb.append(" class ");
            }
        }
        catch (JavaModelException javaModelException) {}
        try {
            if (type.isInterface()) {
                sb.append(" interface ");
            }
        }
        catch (JavaModelException javaModelException) {}
        sb.append(type.getElementName());
        try {
            if (type.getSuperclassName() != null && type.getSuperclassName().length() > 0) {
                sb.append(" extends " + type.getSuperclassName() + " ");
            }
        }
        catch (JavaModelException javaModelException) {}
        try {
            if (type.getSuperInterfaceNames() != null && type.getSuperInterfaceNames().length > 0) {
                sb.append(" implements ");
                i = 0;
                while (i < type.getSuperInterfaceNames().length) {
                    sb.append(type.getSuperInterfaceNames()[i]);
                    if (i < type.getSuperInterfaceNames().length - 1) {
                        sb.append(". ");
                    } else {
                        sb.append(" ");
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        sb.append("{\n");
        try {
            if (type.getMethods() != null && type.getMethods().length > 0) {
                i = 0;
                while (i < type.getMethods().length) {
                    sb.append(SynchronizerWorkItem.createSkeleton(type.getMethods()[i]));
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        sb.append("}\n");
        return sb.toString();
    }

    private static String createSkeleton(IMethod method) {
        StringBuffer buff = new StringBuffer();
        try {
            int methodFlags = method.getFlags();
            if (Flags.isPublic((int)methodFlags)) {
                buff.append(" public ");
            }
            if (Flags.isProtected((int)methodFlags)) {
                buff.append(" protected ");
            }
            if (Flags.isPrivate((int)methodFlags)) {
                buff.append(" private ");
            }
            if (Flags.isAbstract((int)methodFlags)) {
                buff.append(" abstract ");
            }
            if (Flags.isStatic((int)methodFlags)) {
                buff.append(" static ");
            }
            if (Flags.isFinal((int)methodFlags)) {
                buff.append(" final ");
            }
            if (Flags.isSynchronized((int)methodFlags)) {
                buff.append(" synchronized ");
            }
            if (Flags.isNative((int)methodFlags)) {
                buff.append(" native ");
            }
            if (Flags.isStrictfp((int)methodFlags)) {
                buff.append(" strictfp ");
            }
            String methodSig = method.getSignature();
            String methodName = method.getElementName();
            String[] argNames = method.getParameterNames();
            buff.append(Signature.toCharArray((char[])methodSig.toCharArray(), (char[])methodName.toCharArray(), (char[][])SynchronizerWorkItem.createChars(argNames), (boolean)true, (boolean)true));
            String[] exceptSigs = method.getExceptionTypes();
            if (exceptSigs.length > 0) {
                buff.append(" throws ");
                int i = 0;
                while (i < exceptSigs.length) {
                    buff.append(Signature.toCharArray((char[])exceptSigs[i].toCharArray()));
                    if (i < exceptSigs.length - 1) {
                        buff.append(", ");
                    }
                    ++i;
                }
            }
            String retSig = method.getReturnType();
            buff.append(" { \n");
            if (!"V".equals(retSig)) {
                buff.append("\t return (");
                buff.append(Signature.toCharArray((char[])retSig.toCharArray()));
                buff.append(") ");
                if ("B".equals(retSig) || "C".equals(retSig) || "D".equals(retSig) || "F".equals(retSig) || "I".equals(retSig) || "J".equals(retSig) || "S".equals(retSig)) {
                    buff.append("0");
                } else if ("Z".equals(retSig)) {
                    buff.append("true");
                } else {
                    buff.append("null");
                }
            }
            buff.append(";\n}\n");
        }
        catch (JavaModelException javaModelException) {
            JavaVEPlugin.log((Object)"SyncWI: Error when constructing skeleton", (int)5);
            buff = new StringBuffer();
        }
        return buff.toString();
    }

    private static char[][] createChars(String[] strs) {
        char[][] ret = new char[strs.length][];
        int i = 0;
        while (i < strs.length) {
            ret[i] = strs[i].toCharArray();
            ++i;
        }
        return ret;
    }

    private static IField getEncompassingField(IField[] fieldsList, IField newField) {
        if (newField == null || fieldsList == null || fieldsList.length < 1) {
            return newField;
        }
        IField gtField = newField;
        try {
            int from = newField.getSourceRange().getOffset();
            int to = from + newField.getSourceRange().getLength();
            int i = 0;
            while (i < fieldsList.length) {
                int aFrom = fieldsList[i].getSourceRange().getOffset();
                int aTo = aFrom + fieldsList[i].getSourceRange().getLength();
                if (aFrom <= from && aTo >= to) {
                    gtField = fieldsList[i];
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return gtField;
    }

    private void processFields(ICompilationUnit cu) {
        try {
            IType t = CodeGenUtil.getMainType(cu);
            IField[] f = t.getFields();
            if (f == null || f.length == 0) {
                return;
            }
            this.fields = new ISourceRange[f.length];
            this.Fhandles = new String[f.length];
            int actualFieldCount = 0;
            int i = 0;
            while (i < f.length) {
                IField encompassingField = SynchronizerWorkItem.getEncompassingField(f, f[i]);
                if (encompassingField != null && encompassingField.equals(f[i])) {
                    this.fields[i] = f[i].getSourceRange();
                    this.Fhandles[i] = f[i].getHandleIdentifier();
                    if (f[i].getHandleIdentifier().equals(this._handle)) {
                        this.setType(8);
                        this.elementIndex = actualFieldCount;
                    }
                    ++actualFieldCount;
                }
                ++i;
            }
            if (actualFieldCount != f.length) {
                String[] actualFHandles = new String[actualFieldCount];
                ISourceRange[] actualSrcRanges = new ISourceRange[actualFieldCount];
                int cnt = 0;
                int i2 = 0;
                while (i2 < this.fields.length) {
                    if (this.fields[i2] != null) {
                        actualSrcRanges[cnt] = this.fields[i2];
                        actualFHandles[cnt] = this.Fhandles[i2];
                        ++cnt;
                    }
                    ++i2;
                }
                this.fields = actualSrcRanges;
                this.Fhandles = actualFHandles;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void processImports(ICompilationUnit cu) {
        try {
            IImportDeclaration[] imp = cu.getImports();
            if (imp != null && imp.length > 0) {
                this.imports = new ISourceRange[imp.length];
                this.IHandles = new String[imp.length];
                int i = 0;
                while (i < imp.length) {
                    if (imp[i].getHandleIdentifier().equals(this._handle)) {
                        this.setType(2);
                        this.elementIndex = i;
                    }
                    this.imports[i] = imp[i].getSourceRange();
                    this.IHandles[i] = imp[i].getHandleIdentifier();
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void processExtends(ICompilationUnit cu) {
        try {
            IType mainType = CodeGenUtil.getMainType(cu);
            if (mainType != null) {
                this.extendsClass = mainType.getSuperclassName();
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void processImplements(ICompilationUnit cu) {
        try {
            IType mainType = CodeGenUtil.getMainType(cu);
            if (mainType != null) {
                this.implementsInterafces = mainType.getSuperInterfaceNames();
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void refreshContents(ICompilationUnit cu) {
        try {
            IType t;
            this.elementPrevContent = this.getChangedElementContent();
            this.referenceCU = cu;
            this.setSourceCode(cu.getSource());
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
            if ((t = CodeGenUtil.getMainType(cu)) == null) {
                this._handle = RELOAD_HANDLE;
                this.handleOnly = true;
                return;
            }
            int i = 0;
            while (i < this.methods.length) {
                IMethod m = CodeGenUtil.getMethod(t, this.Mhandles[i]);
                this.methods[i] = m != null ? m.getSourceRange() : null;
                ++i;
            }
            IField[] flds = t.getFields();
            Hashtable<String, IField> fieldTable = new Hashtable<String, IField>();
            int i2 = 0;
            while (i2 < flds.length) {
                fieldTable.put(flds[i2].getHandleIdentifier(), flds[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.fields.length) {
                this.fields[i2] = this.Fhandles[i2] != null && fieldTable.get(this.Fhandles[i2]) != null ? ((IField)fieldTable.get(this.Fhandles[i2])).getSourceRange() : null;
                ++i2;
            }
            IImportDeclaration[] imps = cu.getImports();
            Hashtable<String, IImportDeclaration> importTable = new Hashtable<String, IImportDeclaration>();
            int i3 = 0;
            while (i3 < imps.length) {
                importTable.put(imps[i3].getHandleIdentifier(), imps[i3]);
                ++i3;
            }
            i3 = 0;
            while (i3 < this.imports.length) {
                this.imports[i3] = importTable.get(this.IHandles[i3]) != null ? ((IImportDeclaration)importTable.get(this.IHandles[i3])).getSourceRange() : null;
                ++i3;
            }
            IPackageDeclaration[] pkgsD = cu.getPackageDeclarations();
            Hashtable<String, IPackageDeclaration> pkgTable = new Hashtable<String, IPackageDeclaration>();
            int i4 = 0;
            while (i4 < pkgsD.length) {
                pkgTable.put(pkgsD[i4].getHandleIdentifier(), pkgsD[i4]);
                ++i4;
            }
            if (this.packages != null) {
                this.packages = pkgTable.get(this.PHandle) != null ? ((IPackageDeclaration)pkgTable.get(this.PHandle)).getSourceRange() : null;
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
    }

    private String[] getIRangeSources(ISourceRange[] ranges) {
        String[] sources = new String[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            ISourceRange range = ranges[i];
            sources[i] = this.getIRangeSource(range);
            ++i;
        }
        return sources;
    }

    private String getIRangeSource(ISourceRange range) {
        if (range == null || this.entireClassCode == null) {
            return null;
        }
        return this.getSourceCode().substring(range.getOffset(), range.getOffset() + range.getLength());
    }

    public String[] getImplements() {
        return this.implementsInterafces;
    }

    public String getExtends() {
        return this.extendsClass;
    }

    public ISourceRange[] getImports() {
        return this.imports;
    }

    public String[] getImportSources() {
        return this.getIRangeSources(this.getImports());
    }

    public ISourceRange[] getMethods() {
        return this.methods;
    }

    public ISourceRange[] getInnerTypes() {
        return this.innerTypes;
    }

    public ISourceRange getPackage() {
        return this.packages;
    }

    public String[] getMethodSources() {
        return this.getIRangeSources(this.getMethods());
    }

    public String[] getInnerTypeSources() {
        return this.getIRangeSources(this.getInnerTypes());
    }

    public String[] getMethodSkeletons() {
        return this.MSkeletons;
    }

    public String[] getInnerTypeSkeletons() {
        return this.innerTypeSkeletons;
    }

    public String[] getInnerTypeHandles() {
        return this.innerTypeHandles;
    }

    public String[] getMethodsHandles() {
        return this.Mhandles;
    }

    public String getPackageHandle() {
        return this.PHandle;
    }

    public String getPackageSource() {
        return this.getIRangeSource(this.getPackage());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourceCode() {
        return this.entireClassCode;
    }

    public void setSourceCode(String code) {
        if (code == null) {
            JavaVEPlugin.log((Object)"SynchronizerWorkItem: null code", (int)2);
        }
        this.entireClassCode = code;
    }

    public String getElementContent(String handle) {
        if (handle == null) {
            return null;
        }
        int i = 0;
        while (i < this.Mhandles.length) {
            if (handle.equals(this.Mhandles[i])) {
                return this.getMethodSources()[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.Fhandles.length) {
            if (handle.equals(this.Fhandles[i])) {
                return this.getFieldSources()[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.IHandles.length) {
            if (handle.equals(this.IHandles[i])) {
                return this.getImportSources()[i];
            }
            ++i;
        }
        if (handle.equals(this.PHandle)) {
            return this.getPackageSource();
        }
        return null;
    }

    public ISourceRange[] getFields() {
        return this.fields;
    }

    public String[] getFieldSources() {
        return this.getIRangeSources(this.getFields());
    }

    public String[] getFieldshandles() {
        return this.Fhandles;
    }

    public String[] getImportHandles() {
        return this.IHandles;
    }

    public String getChangedElementHandle() {
        if (this.elementIndex < 0) {
            return this._handle;
        }
        switch (this.type) {
            case 8: {
                return this.Fhandles[this.elementIndex];
            }
            case 2: {
                return this.IHandles[this.elementIndex];
            }
            case 16: {
                return this.Mhandles[this.elementIndex];
            }
            case 1: {
                return this.PHandle;
            }
            case 32: {
                return this.innerTypeHandles[this.elementIndex];
            }
        }
        return null;
    }

    public boolean isSharedToLocalUpdate() {
        return this.sharedToLocalUpdate;
    }

    public String toString() {
        return this.getChangedElementHandle();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.referenceCU;
    }

    public boolean isHandleOnly() {
        return this.handleOnly;
    }

    public int getdeltaOff() {
        return this.deltaOff;
    }

    public int getdeltaLen() {
        return this.deltaLen;
    }

    public boolean isPackage() {
        return this.isType(1);
    }

    public boolean isMethod() {
        return this.isType(16);
    }

    public boolean isInnerClass() {
        return this.isType(32);
    }

    public boolean isField() {
        return this.isType(8);
    }

    public boolean isImport() {
        return this.isType(2);
    }

    public void setType(int newType) {
        this.type = newType;
    }

    private boolean isType(int ofType) {
        return ofType == this.type;
    }

    public String getChangedElementContent() {
        switch (this.type) {
            case 8: {
                return this.getFieldSources()[this.elementIndex];
            }
            case 16: {
                return this.getMethodSources()[this.elementIndex];
            }
            case 2: {
                return this.getImportSources()[this.elementIndex];
            }
            case 1: {
                return this.getPackageSource();
            }
        }
        return null;
    }

    public int getChangedIndex() {
        return this.elementIndex;
    }

    public void setChangeElementPrevContent(String s) {
        this.elementPrevContent = s;
    }

    public String getChangeElementPrevContent() {
        return this.elementPrevContent;
    }
}

