/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IInstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class TypeVisitor
extends SourceVisitor {
    CodeTypeRef fType = null;
    char[] content = null;
    String[] methodHandles = null;
    boolean forceJDOMUsage = false;
    Map fInstanceDeclaredBeans = new HashMap();

    public TypeVisitor(TypeDeclaration node, IBeanDeclModel model, char[] content, String[] methodHandles, List reTryList, boolean forceJDOMUsage) {
        this(node, model, reTryList, forceJDOMUsage);
        this.content = content;
        this.methodHandles = methodHandles;
    }

    public TypeVisitor(TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage) {
        super((AstNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.fType = new CodeTypeRef(node, model);
        model.setTypeRef(this.fType);
    }

    public TypeVisitor(CodeTypeRef tr, TypeDeclaration node, IBeanDeclModel model, List reTryList, boolean forceJDOMUsage) {
        super((AstNode)node, model, reTryList);
        this.forceJDOMUsage = forceJDOMUsage;
        this.fType = tr;
    }

    public static IMethod[] getCUMethods(AbstractMethodDeclaration[] aMethods, IMethod[] elements, IBeanDeclModel model) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        if (elements == null || elements.length == 0) {
            return null;
        }
        int i = 0;
        while (i < aMethods.length) {
            String Name = new String(aMethods[i].selector);
            int Prev = 0;
            int dupCount = 0;
            i = 0;
            while (i < methods.size()) {
                if (methods.get(i) != null && ((IMethod)methods.get(i)).getElementName().equals(Name)) {
                    ++dupCount;
                }
                ++i;
            }
            int j = Prev;
            while (j < elements.length) {
                if (Name.equals(elements[j].getElementName()) && --dupCount < 0) break;
                ++j;
            }
            if (j >= elements.length) {
                methods.add(null);
            } else {
                methods.add(elements[j]);
                Prev = j + 1;
            }
            ++i;
        }
        return methods.toArray(new IMethod[elements.length]);
    }

    protected void createThisIfNecessary() {
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
        String typeName = this.fModel.resolveThis();
        String superName = null;
        if (this.fType.getTypeDecl().superclass != null) {
            superName = this.fModel.resolve(CodeGenUtil.tokensToString(this.fType.getTypeDecl().superclass.getTypeName()));
        }
        ResourceSet rs = this.fModel.getCompositionModel().getModelResourceSet();
        if (superName != null && thisRule.useInheritance(superName, rs) || thisRule.useInheritance(typeName, rs)) {
            BeanPartFactory bpg = new BeanPartFactory(this.fType.getBeanModel(), null);
            bpg.createThisBeanPartIfNeeded(null);
        }
    }

    public void addFieldToMap(BeanPart bp, String method) {
        ArrayList<BeanPart> l = (ArrayList<BeanPart>)this.fInstanceDeclaredBeans.get(method);
        if (l == null) {
            l = new ArrayList<BeanPart>();
            this.fInstanceDeclaredBeans.put(method, l);
        }
        l.add(bp);
    }

    protected void visitAMethod(AbstractMethodDeclaration node, IBeanDeclModel model, List reTryList, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content) {
        String mName = new String(node.selector);
        MethodVisitor v = new MethodVisitor(node, model, reTryList, typeRef, methodHandle, range, content);
        if (this.fInstanceDeclaredBeans.get(mName) != null) {
            Iterator itr = ((List)this.fInstanceDeclaredBeans.get(mName)).iterator();
            while (itr.hasNext()) {
                v.setInitMethodFor((BeanPart)itr.next());
            }
        }
        v.visit();
    }

    public void visit() {
        FieldDeclaration[] fields = this.fType.getTypeDecl().fields;
        IInstanceVariableRule instVarRule = (IInstanceVariableRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleInstanceVariable");
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                if (instVarRule == null || !instVarRule.ignoreVariable((AbstractVariableDeclaration)fields[i], this.fModel, this.fModel.getCompositionModel())) {
                    BeanPart bp = new BeanPart((AbstractVariableDeclaration)fields[i]);
                    this.fModel.addBean(bp);
                    String overidInitMethod = instVarRule.getDefaultInitializationMethod((AbstractVariableDeclaration)fields[i], this.fModel, (TypeDeclaration)this.fVisitedNode);
                    if (overidInitMethod != null) {
                        this.addFieldToMap(bp, overidInitMethod);
                        bp.setInstanceInstantiation(true);
                    }
                }
                ++i;
            }
        }
        this.createThisIfNecessary();
        AbstractMethodDeclaration[] methods = this.fType.getTypeDecl().methods;
        if (this.forceJDOMUsage) {
            if (methods == null || methods.length == 0) {
                return;
            }
            try {
                int methodHandleUseCount = 0;
                int i = 0;
                while (i < methods.length) {
                    if (methods[i] != null && (methods[i] instanceof MethodDeclaration || methods[i] instanceof ConstructorDeclaration)) {
                        String thisMethodHandle = "";
                        if (methods[i] instanceof MethodDeclaration) {
                            thisMethodHandle = this.methodHandles[methodHandleUseCount];
                            ++methodHandleUseCount;
                        }
                        this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, thisMethodHandle, this.getSourceRange(methods[i].declarationSourceStart, methods[i].declarationSourceEnd), new String(this.content).substring(methods[i].declarationSourceStart, methods[i].declarationSourceEnd));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
        } else {
            IMethod[] cuMethods = TypeVisitor.getCUMethods(methods, CodeGenUtil.getMethods(this.fModel.getCompilationUnit()), this.fModel);
            if (cuMethods == null || cuMethods.length < 1) {
                return;
            }
            if (cuMethods.length != methods.length) {
                throw new RuntimeException("methods length error");
            }
            int i = 0;
            try {
                while (i < methods.length) {
                    if (cuMethods[i] != null && (methods[i] instanceof MethodDeclaration || methods[i] instanceof ConstructorDeclaration)) {
                        this.visitAMethod(methods[i], this.fModel, this.fReTryLater, this.fType, cuMethods[i].getHandleIdentifier(), cuMethods[i].getSourceRange(), cuMethods[i].getSource());
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Object)("TypeVisitor.visit() could not visit" + String.valueOf(methods[i].selector) + " : " + e.getMessage()), (int)5);
            }
        }
    }

    protected ISourceRange getSourceRange(int start, int end) {
        final int offset = start;
        final int length = end - start + 1;
        return new ISourceRange(){

            public int getOffset() {
                return offset;
            }

            public int getLength() {
                return length;
            }
        };
    }

    public String toString() {
        return super.toString();
    }
}

