/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;

public class CodeTypeRef {
    protected CompilationUnitDeclaration fdeclCU = null;
    protected TypeDeclaration fdeclType = null;
    protected IType fType = null;
    protected ICompilationUnit fCU = null;
    protected String fName;
    protected IBeanDeclModel fBeanModel;
    protected Vector fMethods = new Vector();
    protected BeanSubclassComposition fbeanComposition = null;

    public CodeTypeRef(String typeName, IBeanDeclModel model) {
        this.fName = typeName;
        this.fBeanModel = model;
        if (model.getCompositionModel() != null) {
            this.fbeanComposition = model.getCompositionModel().getModelRoot();
        }
    }

    public CodeTypeRef(TypeDeclaration declType, IBeanDeclModel model) {
        this.fdeclType = declType;
        this.fName = new String(declType.name);
        this.fBeanModel = model;
        this.fbeanComposition = model.getCompositionModel().getModelRoot();
    }

    public CodeTypeRef(CompilationUnitDeclaration declCU, IBeanDeclModel model) {
        this(declCU.types[0], model);
        this.fdeclCU = declCU;
    }

    public TypeDeclaration getTypeDecl() {
        return this.fdeclType;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.fName;
    }

    public IBeanDeclModel getBeanModel() {
        return this.fBeanModel;
    }

    public void addRefMethod(CodeMethodRef method) {
        if (!this.fMethods.contains(method)) {
            this.fMethods.add(method);
        }
    }

    public void removeRefMethod(CodeMethodRef method) {
        this.fMethods.remove(method);
    }

    public Iterator getMethods() {
        return ((AbstractList)this.fMethods).iterator();
    }

    public String getName() {
        return this.fName;
    }

    public void dispose() {
        if (this.fMethods != null) {
            Object[] tmp = this.fMethods.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeMethodRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fMethods.clear();
    }

    public BeanSubclassComposition getBeanComposition() {
        return this.fbeanComposition;
    }
}

