/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ExpressionParser {
    String fSource;
    int fSourceOff;
    int fSourceLen;
    int fExpOff = -1;
    int fExpLen = -1;
    int fCommentsOff = -1;
    int fCommentsLen = -1;
    int fFillerOff = -1;
    int fFillerLen = -1;

    public ExpressionParser(String sourceSnippet, int expOffset, int expLen) {
        this.fSource = sourceSnippet;
        this.fSourceOff = expOffset;
        this.fSourceLen = expLen;
    }

    public ExpressionParser(IField field) {
        try {
            this.fSource = field.getCompilationUnit().getSource();
            this.fSourceOff = field.getSourceRange().getOffset();
            this.fSourceLen = ExpressionParser.indexOfSemiColon(field.getSource());
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
    }

    protected void clear() {
        this.fExpLen = -1;
        this.fExpOff = -1;
        this.fCommentsLen = -1;
        this.fCommentsOff = -1;
        this.fFillerLen = -1;
        this.fFillerOff = -1;
    }

    public void replaceCode(String code) {
        StringBuffer st = new StringBuffer(this.fSource);
        st.replace(this.getCodeOff(), this.getCodeOff() + this.getCodeLen(), code);
        this.fSource = st.toString();
        this.fSourceLen = code.length();
        this.clear();
    }

    public void replaceComments(String comment) {
        StringBuffer st = new StringBuffer(this.fSource);
        st.replace(this.getCommentOff(), this.getCommentOff() + this.getCommentLen(), comment);
        this.fSource = st.toString();
        this.clear();
    }

    public void replaceFiller(String filler) {
        int delta = filler.length() - this.getFillerLen();
        StringBuffer st = new StringBuffer(this.fSource);
        st.replace(this.getFillerOff(), this.getFillerOff() + this.getFillerLen(), filler);
        this.fSource = st.toString();
        this.fSourceOff += delta;
        this.clear();
    }

    public String getCode() {
        return this.fSource.substring(this.fSourceOff, this.fSourceOff + this.fSourceLen);
    }

    public int getCodeOff() {
        return this.fSourceOff;
    }

    public int getCodeLen() {
        return this.fSourceLen;
    }

    protected int getLineStartOff() {
        int left = this.fSourceOff;
        while (left - 1 >= 0) {
            char ch = this.fSource.charAt(left - 1);
            if (!Character.isWhitespace(ch) || ch == '\r' || ch == '\n') break;
            --left;
        }
        if (left == 0 || this.fSource.charAt(left - 1) == '\r' || this.fSource.charAt(left - 1) == '\n') {
            return left;
        }
        return this.fSourceOff;
    }

    protected int advanceLineSeperator(int position) {
        int index = position;
        while (index < this.fSource.length() && (this.fSource.charAt(index) == '\r' || this.fSource.charAt(index) == '\n')) {
            ++index;
        }
        return index;
    }

    protected int reverseLineSeperator(int position) {
        int index = position - 1;
        while (index > 0 && (this.fSource.charAt(index) == '\r' || this.fSource.charAt(index) == '\n')) {
            --index;
        }
        return index + 1;
    }

    public String getSelectorContent() {
        int token;
        String code = this.getCode();
        Scanner scanner = new Scanner();
        scanner.setSource(code.toCharArray());
        scanner.recordLineSeparator = true;
        scanner.tokenizeWhiteSpace = true;
        scanner.tokenizeComments = true;
        String prevIdentifier = null;
        try {
            token = scanner.getNextToken();
            while (token != 114 && token != 10 && token != 40) {
                if (token == 6) {
                    if (prevIdentifier != null) break;
                    prevIdentifier = new String(scanner.getCurrentTokenSource());
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        if (token == 6 || token == 40) {
            return new String(scanner.getCurrentTokenSource());
        }
        if (prevIdentifier != null) {
            return prevIdentifier;
        }
        return null;
    }

    protected int skipSemiColonifNeeded(int right) {
        int index;
        String targetSrc = this.fSource.substring(this.fSourceOff, right);
        Scanner scanner = new Scanner();
        scanner.setSource(targetSrc.toCharArray());
        scanner.recordLineSeparator = true;
        scanner.tokenizeWhiteSpace = true;
        scanner.tokenizeComments = true;
        try {
            int token = scanner.getNextToken();
            int i = 0;
            while (i < targetSrc.length()) {
                if (token != 114) {
                    if (token == 41) {
                        return right;
                    }
                    token = scanner.getNextToken();
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InvalidInputException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
        return (index = this.fSource.substring(right).indexOf(59)) < 0 ? right : right + index + 1;
    }

    public static int indexOfSemiColon(String targetSrc) {
        Scanner scanner = new Scanner();
        scanner.setSource(targetSrc.toCharArray());
        scanner.recordLineSeparator = false;
        scanner.tokenizeWhiteSpace = true;
        scanner.tokenizeComments = true;
        try {
            int token = scanner.getNextToken();
            int i = 0;
            while (i < targetSrc.length()) {
                if (token != 114) {
                    if (token == 41) {
                        return scanner.currentPosition - 1;
                    }
                    token = scanner.getNextToken();
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InvalidInputException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
        return targetSrc.length();
    }

    protected void primParseExpression() {
        int left = this.getLineStartOff();
        this.primParseComment();
        int right = this.fCommentsOff + this.fCommentsLen;
        if (right < 0) {
            right = this.fSourceOff + this.fSourceLen;
        }
        right = this.skipSemiColonifNeeded(right);
        Scanner scanner = new Scanner();
        scanner.setSource(this.fSource.substring(right).toCharArray());
        scanner.recordLineSeparator = true;
        scanner.tokenizeWhiteSpace = true;
        scanner.tokenizeComments = true;
        try {
            int token = scanner.getNextToken();
            int prevToken = -1;
            int prevStart = -1;
            while (token == 1000) {
                prevToken = token;
                prevStart = scanner.startPosition;
                token = scanner.getNextToken();
            }
            int overide = -1;
            if (prevToken == 1000) {
                int index = prevStart;
                while (index < scanner.startPosition) {
                    if (this.fSource.charAt(right + index) == '\r' || this.fSource.charAt(right + index) == '\n') {
                        overide = right + index;
                        break;
                    }
                    ++index;
                }
                if (overide >= 0) {
                    overide = this.advanceLineSeperator(overide);
                }
            }
            if (scanner.lineEnds.length > 0 && scanner.getLineEnd(1) > 0) {
                right += scanner.getLineEnd(1);
                right = this.advanceLineSeperator(right);
            } else {
                right = token == 114 ? (right += scanner.currentPosition - 1) : (overide > 0 ? overide : (right += scanner.startPosition - 1));
            }
            this.fFillerOff = this.fExpOff = left;
            this.fFillerLen = this.fSourceOff - this.fFillerOff;
            this.fExpLen = right - left;
        }
        catch (InvalidInputException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
    }

    public String getExpression(boolean includeEOL) {
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            this.primParseExpression();
        }
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            return null;
        }
        int right = this.fExpOff + this.fExpLen;
        if (!includeEOL) {
            right = this.reverseLineSeperator(right);
        }
        return this.fSource.substring(this.fExpOff, right);
    }

    public int getExpressionOff() {
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            this.primParseExpression();
        }
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            return -1;
        }
        return this.fExpOff;
    }

    public int getExpressionLen(boolean includeEOL) {
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            this.primParseExpression();
        }
        if (this.fExpLen < 0 || this.fExpOff < 0) {
            return -1;
        }
        int right = this.fExpOff + this.fExpLen;
        if (!includeEOL) {
            right = this.reverseLineSeperator(right);
        }
        return right - this.fExpOff;
    }

    public int getExpressionLen() {
        return this.getExpressionLen(true);
    }

    public String getExpression() {
        return this.getExpression(true);
    }

    protected void primParseComment() {
        Scanner scanner = new Scanner();
        int scanOff = this.fSourceOff + this.fSourceLen;
        String scannerString = this.fSource.substring(scanOff);
        scanner.setSource(scannerString.toCharArray());
        scanner.recordLineSeparator = true;
        scanner.tokenizeComments = true;
        try {
            int token = scanner.getNextToken();
            while (token == 41 || token == 1000) {
                token = scanner.getNextToken();
            }
            if (token == 1001 && (scanner.getLineEnd(1) == 0 || scanner.getLineEnd(1) > 0 && scanner.currentPosition == scanner.getLineEnd(1) + 1 || scanner.getLineEnd(2) > 0 && scanner.currentPosition == scanner.getLineEnd(2) + 1) || (token == 1002 || token == 1003) && (scanner.lineEnds.length == 0 || scanner.getLineEnd(1) <= 0 || scanner.startPosition < scanner.getLineEnd(1))) {
                int endOfComment = scanner.currentPosition;
                if (token == 1001 && scanner.getLineEnd(1) > 0 && (scanner.currentPosition == scanner.getLineEnd(1) + 1 || scanner.currentPosition == scanner.getLineEnd(2) + 1)) {
                    int f = 0;
                    while (f < 2) {
                        if (scannerString.charAt(endOfComment - 1) == '\r' || scannerString.charAt(endOfComment - 1) == '\n') {
                            --endOfComment;
                        }
                        ++f;
                    }
                }
                this.fCommentsOff = scanOff + scanner.commentStarts[0];
                this.fCommentsLen = scanOff + endOfComment - this.fCommentsOff;
            }
        }
        catch (InvalidInputException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
    }

    public String getComment() {
        if (this.fCommentsOff < 0) {
            this.primParseComment();
        }
        if (this.fCommentsOff > 0) {
            return this.fSource.substring(this.fCommentsOff, this.fCommentsOff + this.fCommentsLen);
        }
        return null;
    }

    public int getCommentOff() {
        if (this.fCommentsOff < 0) {
            this.primParseComment();
        }
        if (this.fCommentsOff > 0) {
            return this.fCommentsOff;
        }
        return -1;
    }

    public int getCommentLen() {
        if (this.fCommentsLen < 0) {
            this.primParseComment();
        }
        if (this.fCommentsLen > 0) {
            return this.fCommentsLen;
        }
        return -1;
    }

    public String getFiller() {
        if (this.fFillerOff < 0) {
            this.fFillerOff = this.getLineStartOff();
            this.fFillerLen = this.fSourceOff - this.fFillerOff;
        }
        if (this.fFillerOff < 0 || this.fFillerLen < 0) {
            return null;
        }
        if (this.fFillerLen == 0) {
            return "";
        }
        return this.fSource.substring(this.fFillerOff, this.fFillerOff + this.fFillerLen);
    }

    public int getFillerOff() {
        if (this.fFillerOff < 0) {
            this.fFillerOff = this.getLineStartOff();
            this.fFillerLen = this.fSourceOff - this.fFillerOff;
        }
        if (this.fFillerOff < 0 || this.fFillerLen < 0) {
            return -1;
        }
        return this.fFillerOff;
    }

    public int getFillerLen() {
        if (this.fFillerLen < 0) {
            this.fFillerOff = this.getLineStartOff();
            this.fFillerLen = this.fSourceOff - this.fFillerOff;
        }
        if (this.fFillerOff < 0 || this.fFillerLen < 0) {
            return -1;
        }
        return this.fFillerLen;
    }

    public String toString() {
        if (this.fExpOff > 0 && this.fExpLen > 0) {
            return this.getExpression();
        }
        return super.toString();
    }
}

