/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.Stack;
import org.eclipse.ve.internal.java.codegen.util.StrategyWorker;

public class WorkerPool {
    StrategyWorker[] workers;
    Stack stack;

    public WorkerPool(int numberOfWorkers) {
        this.workers = new StrategyWorker[numberOfWorkers];
        this.stack = new Stack();
        int i = 0;
        while (i < numberOfWorkers) {
            StrategyWorker worker;
            this.workers[i] = worker = new StrategyWorker(this);
            this.stack.push(worker);
            Thread t = new Thread((Runnable)worker, "CodeGen::" + worker.getClass().getName());
            t.setDaemon(true);
            t.setPriority(1);
            t.start();
            ++i;
        }
    }

    public void finish() {
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i].finish();
            ++i;
        }
    }

    public synchronized StrategyWorker grabWorker() throws InterruptedException {
        while (this.stack.empty()) {
            this.wait();
        }
        return (StrategyWorker)this.stack.pop();
    }

    public synchronized void returnWorker(StrategyWorker worker) {
        this.stack.push(worker);
        this.notifyAll();
    }

    public synchronized void waitForAllWorkersToComplete() throws InterruptedException {
        while (this.stack.size() < this.workers.length) {
            this.wait();
        }
    }

    public synchronized int getAvailWorkers() {
        return this.stack.size();
    }

    public int getNoOfWorkers() {
        return this.workers.length;
    }
}

