/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceContributor;
import org.eclipse.ve.internal.java.codegen.wizards.IVisualClassCreationSourceGenerator;
import org.eclipse.ve.internal.java.codegen.wizards.NewVisualClassWizardPage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectFactory;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public class NewVisualClassCreationWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewClassWizardPage fPage;
    private String superClassName = null;
    private IVisualClassCreationSourceContributor contributor = null;
    private Plugin contributorPlugin = null;
    public static final String VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY = "VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY";
    private static String DEFAULT_SUPER_CLASS = "javax.swing.JFrame";
    public static String NEWLINE = System.getProperty("line.separator");

    public NewVisualClassCreationWizard() {
        this.setDefaultPageImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
        this.setDialogSettings(JavaVEPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(CodegenMessages.getString("NewVisualClassCreationWizard.title"));
    }

    protected void updateContributor(String className, IProgressMonitor monitor) {
        IExtensionPoint exp = JavaVEPlugin.getPlugin().getDescriptor().getExtensionPoint("newsource");
        IExtension[] extensions = exp.getExtensions();
        IType superClass = null;
        try {
            superClass = this.fPage.getPackageFragmentRoot().getJavaProject().findType(className);
        }
        catch (JavaModelException e2) {
            JavaVEPlugin.log((Throwable)e2, (int)0);
        }
        if (extensions != null && extensions.length > 0 && superClass != null) {
            boolean contributorFound = false;
            int ec = 0;
            while (ec < extensions.length && !contributorFound) {
                IConfigurationElement[] configElms = extensions[ec].getConfigurationElements();
                int cc = 0;
                while (cc < configElms.length && !contributorFound) {
                    IConfigurationElement celm = configElms[cc];
                    try {
                        String typeName = celm.getAttribute("type");
                        if (superClass.getFullyQualifiedName().equals(typeName)) {
                            this.contributor = (IVisualClassCreationSourceContributor)celm.createExecutableExtension("class");
                            if (this.contributor != null) {
                                this.contributorPlugin = extensions[ec].getDeclaringPluginDescriptor().getPlugin();
                            }
                            contributorFound = true;
                        }
                    }
                    catch (CoreException e) {
                        JavaVEPlugin.log((Throwable)e, (int)0);
                    }
                    ++cc;
                }
                ++ec;
            }
        }
    }

    private IVisualClassCreationSourceGenerator getGeneratorInstance(URL templateLocation) {
        List jdtClassPath = TemplateUtil.getPluginAndPreReqJarPath((String)JavaVEPlugin.getPlugin().getDescriptor().getUniqueIdentifier());
        try {
            jdtClassPath.addAll(TemplateUtil.getPlatformJREPath());
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
        List contributorsPaths = TemplateUtil.getPluginAndPreReqJarPath((String)this.contributorPlugin.getDescriptor().getUniqueIdentifier());
        int i = 0;
        while (i < contributorsPaths.size()) {
            if (!jdtClassPath.contains(contributorsPaths.get(i))) {
                jdtClassPath.add(contributorsPaths.get(i));
            }
            ++i;
        }
        String[] jdtClassPaths = new String[jdtClassPath.size()];
        int i2 = 0;
        while (i2 < jdtClassPath.size()) {
            jdtClassPaths[i2] = (String)jdtClassPath.get(i2);
            ++i2;
        }
        String templatePath = templateLocation.getPath().substring(0, templateLocation.getPath().lastIndexOf(47));
        String[] templatePaths = new String[]{templatePath};
        try {
            return (IVisualClassCreationSourceGenerator)TemplateObjectFactory.getClassInstance((String[])jdtClassPaths, (String[])templatePaths, (String)templateLocation.getPath().substring(templateLocation.getPath().lastIndexOf(47) + 1), (ClassLoader)this.contributor.getClass().getClassLoader(), null, null);
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
            return null;
        }
    }

    protected String removeWhiteSpaces(String input) {
        char[] chars = input.toCharArray();
        char[] noSpaces = new char[chars.length];
        int count = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!Character.isWhitespace(c)) {
                noSpaces[count] = c;
                ++count;
            }
            ++i;
        }
        return new String(noSpaces, 0, count);
    }

    protected void merge(IMethod to, IMethod from, ICodeFormatter formatter, IProgressMonitor monitor) {
        try {
            StringBuffer finalSource = new StringBuffer();
            String toCUSource = to.getCompilationUnit().getSource();
            String fromCUSource = from.getCompilationUnit().getSource();
            int toStart = to.getSourceRange().getOffset();
            int toEnd = to.getSourceRange().getOffset() + to.getSourceRange().getLength();
            toStart = toCUSource.lastIndexOf(10, toStart) + 1;
            toEnd = toCUSource.indexOf(10, toEnd);
            int fromStart = from.getSourceRange().getOffset();
            int fromEnd = from.getSourceRange().getOffset() + from.getSourceRange().getLength();
            fromStart = fromCUSource.lastIndexOf(10, fromStart) + 1;
            fromEnd = fromCUSource.indexOf(10, fromEnd);
            int fromNameOffset = from.getNameRange().getOffset();
            int toNameOffset = to.getNameRange().getOffset();
            int fromBodyStart = fromCUSource.indexOf(123, fromNameOffset) + 1;
            int fromBodyEnd = fromCUSource.lastIndexOf(125, fromEnd) - 1;
            int toBodyStart = toCUSource.indexOf(123, toNameOffset) + 1;
            int toBodyEnd = toCUSource.lastIndexOf(125, toEnd) - 1;
            StringTokenizer toNLs = new StringTokenizer(toCUSource.substring(toBodyStart, toBodyEnd), "\r\n", false);
            StringTokenizer fromNLs = new StringTokenizer(fromCUSource.substring(fromBodyStart, fromBodyEnd), "\r\n", false);
            ArrayList<String> toLines = new ArrayList<String>();
            ArrayList<String> fromLines = new ArrayList<String>();
            int bestToLineIndex = 0;
            while (toNLs.hasMoreTokens()) {
                String token = toNLs.nextToken();
                toLines.add(token);
                if (token.indexOf("return") > -1) break;
                ++bestToLineIndex;
            }
            while (fromNLs.hasMoreTokens()) {
                fromLines.add(fromNLs.nextToken());
            }
            int fc = 0;
            while (fc < fromLines.size()) {
                String fromLine = (String)fromLines.get(fc);
                String fromLineNoSpaces = this.removeWhiteSpaces(fromLine);
                boolean foundInToLines = false;
                boolean fromLineIsSuperConstructorCall = from.isConstructor() && fromLineNoSpaces.indexOf("super(") > -1;
                int tc = 0;
                while (tc < toLines.size()) {
                    boolean toLineIsSuperConstructorCall;
                    String toLine = (String)toLines.get(tc);
                    String toLineNoSpaces = this.removeWhiteSpaces(toLine);
                    boolean bl = toLineIsSuperConstructorCall = to.isConstructor() && toLineNoSpaces.indexOf("super(") > -1;
                    if (toLineNoSpaces.equals(fromLineNoSpaces) || toLineIsSuperConstructorCall && fromLineIsSuperConstructorCall) {
                        foundInToLines = true;
                        break;
                    }
                    ++tc;
                }
                if (!foundInToLines) {
                    toLines.add(bestToLineIndex, fromLine);
                    ++bestToLineIndex;
                }
                ++fc;
            }
            finalSource.append(String.valueOf(toCUSource.substring(toStart, toBodyStart)) + NEWLINE);
            int i = 0;
            while (i < toLines.size()) {
                finalSource.append(toLines.get(i) + NEWLINE);
                ++i;
            }
            finalSource.append(toCUSource.substring(toBodyEnd, toEnd));
            IType declaringType = to.getDeclaringType();
            IJavaElement sibling = null;
            int i2 = 0;
            while (i2 < declaringType.getChildren().length) {
                if (declaringType.getChildren()[i2].equals(to) && i2 < declaringType.getChildren().length - 1) {
                    sibling = declaringType.getChildren()[i2 + 1];
                    break;
                }
                ++i2;
            }
            to.delete(true, monitor);
            String source = finalSource.toString();
            if (formatter != null) {
                source = formatter.format(source, 1, null, NEWLINE);
            }
            declaringType.createMethod(String.valueOf(NEWLINE) + source + NEWLINE, sibling, true, monitor);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
    }

    protected String getCompleteSource(ICompilationUnit cu, ISourceReference srcRef) {
        try {
            String cuSource = cu.getSource();
            int from = srcRef.getSourceRange().getOffset();
            int to = from + srcRef.getSourceRange().getLength();
            int fromNL = cuSource.lastIndexOf(10, from);
            int toNL = cuSource.indexOf(10, to);
            if (fromNL > -1 && fromNL < cuSource.length()) {
                from = fromNL + 1;
            }
            if (toNL > -1 && toNL < cuSource.length()) {
                to = toNL + 1;
            }
            return cuSource.substring(from, to);
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
            return null;
        }
    }

    protected void merge(ICompilationUnit to, ICompilationUnit from, ICodeFormatter formatter, IProgressMonitor monitor) {
        try {
            IType toType = to.getTypes()[0];
            IType fromType = from.getTypes()[0];
            int i = 0;
            while (i < fromType.getChildren().length) {
                String source;
                IJavaElement child = fromType.getChildren()[i];
                if (child instanceof IField) {
                    IField field = (IField)child;
                    source = this.getCompleteSource(field.getCompilationUnit(), (ISourceReference)field);
                    if (formatter != null) {
                        source = formatter.format(source, 1, null, NEWLINE);
                    }
                    toType.createField(String.valueOf(source) + NEWLINE, null, true, monitor);
                }
                if (child instanceof IMethod) {
                    IMethod method = (IMethod)child;
                    IMethod[] targetMethods = null;
                    if (method.isConstructor()) {
                        ArrayList<IMethod> constructors = new ArrayList<IMethod>();
                        IMethod[] allMethods = toType.getMethods();
                        int mc = 0;
                        while (mc < allMethods.length) {
                            if (allMethods[mc].isConstructor()) {
                                constructors.add(allMethods[mc]);
                            }
                            ++mc;
                        }
                        targetMethods = new IMethod[constructors.size()];
                        constructors.toArray(targetMethods);
                    } else {
                        targetMethods = toType.findMethods(method);
                    }
                    if (targetMethods != null && targetMethods.length > 0) {
                        int tmc = 0;
                        while (tmc < targetMethods.length) {
                            this.merge(targetMethods[tmc], method, formatter, monitor);
                            ++tmc;
                        }
                    } else {
                        String source2 = this.getCompleteSource(method.getCompilationUnit(), (ISourceReference)method);
                        if (formatter != null) {
                            source2 = formatter.format(source2, 1, null, NEWLINE);
                        }
                        toType.createMethod(source2, null, true, monitor);
                    }
                }
                if (child instanceof IType) {
                    IType type = (IType)child;
                    source = this.getCompleteSource(type.getCompilationUnit(), (ISourceReference)type);
                    if (formatter != null) {
                        source = formatter.format(source, 0, null, NEWLINE);
                    }
                    toType.createType(source, null, true, monitor);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
    }

    protected void applyContributor(IType type1, String superClassName, IProgressMonitor monitor) {
        IVisualClassCreationSourceGenerator gen = this.getGeneratorInstance(this.contributor.getTemplateLocation());
        try {
            ICompilationUnit originalCU = type1.getCompilationUnit();
            if (originalCU.isWorkingCopy()) {
                originalCU = (ICompilationUnit)originalCU.getOriginal((IJavaElement)originalCU);
            }
            String src = gen.generateSource(originalCU.getTypes()[0].getElementName(), superClassName);
            ICompilationUnit workingCopy = (ICompilationUnit)originalCU.getWorkingCopy();
            workingCopy.getBuffer().setContents(src);
            workingCopy.reconcile();
            ICodeFormatter formatter = this.contributor.needsFormatting() ? ToolFactory.createCodeFormatter() : null;
            this.merge(originalCU, workingCopy, formatter, monitor);
            workingCopy.destroy();
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.superClassName == null && this.fPage.getSuperClass() != null) {
            String sc = this.fPage.getSuperClass();
            boolean found = false;
            NewVisualClassWizardPage page = (NewVisualClassWizardPage)this.fPage;
            int i = 0;
            while (i < page.AWTButtonClasses.length && !found) {
                if (page.AWTButtonClasses[i].equals(sc)) {
                    found = true;
                }
                ++i;
            }
            i = 0;
            while (i < page.swingButtonClasses.length && !found) {
                if (page.swingButtonClasses[i].equals(sc)) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                JavaVEPlugin.getPlugin().getPluginPreferences().setValue(VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY, this.fPage.getSuperClass());
            } else {
                JavaVEPlugin.getPlugin().getPluginPreferences().setValue(VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY, "java.lang.Object");
            }
        }
        this.fPage.createType(monitor);
        ICompilationUnit cu = this.fPage.getCreatedType().getCompilationUnit();
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginal((IJavaElement)cu);
        }
        if (cu != null) {
            IResource resource = cu.getResource();
            this.selectAndReveal(resource);
            this.openResource(resource);
        }
        this.updateContributor(this.fPage.getSuperClass(), monitor);
        if (this.contributor != null) {
            this.applyContributor(this.fPage.getCreatedType(), this.fPage.getSuperClass(), monitor);
        }
    }

    public void addPages() {
        this.fPage = new NewVisualClassWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
        if (this.superClassName != null) {
            this.fPage.setSuperClass(this.superClassName, false);
        } else {
            Preferences preferences = JavaVEPlugin.getPlugin().getPluginPreferences();
            if (!preferences.getDefaultString(VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY).equals(DEFAULT_SUPER_CLASS)) {
                preferences.setDefault(VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY, DEFAULT_SUPER_CLASS);
            }
            this.fPage.setSuperClass(preferences.getString(VISUAL_CLASS_WIZARD_SUPER_CLASS_KEY), true);
        }
    }

    protected void openResource(IResource resource) {
        NewVisualClassCreationWizard.openResourceJVE(resource);
    }

    public static void openResourceJVE(final IResource resource) {
        IWorkbenchPage activePage;
        IWorkbenchWindow window;
        if (resource.getType() == 1 && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = window.getActivePage()) != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        activePage.openEditor((IFile)resource, "org.eclipse.ve.internal.java.codegen.editorpart.JavaVisualEditor");
                    }
                    catch (PartInitException e) {
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
            });
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.superClassName = (String)data;
        }
    }
}

