/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PropertyEditorBeanProxyWrapper;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;

public class BeanCellRenderer
extends LabelProvider
implements IExecutableExtension,
INeedData,
ISourced {
    protected static Image BEAN_IMAGE;
    protected String fJavaBeansPropertyEditorClassName;
    protected PropertyEditorBeanProxyWrapper fPropertyEditorProxyWrapper;
    protected EditDomain editDomain;
    protected IJavaObjectInstance source;
    protected boolean rebuildWrapper = true;

    public BeanCellRenderer() {
    }

    public BeanCellRenderer(String aPropertyEditorClassName) {
        this.fJavaBeansPropertyEditorClassName = aPropertyEditorClassName;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (!(element instanceof IJavaInstance)) {
            return element.toString();
        }
        IBeanProxy elementProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)element, EMFEditDomainHelper.getResourceSet((EditDomain)this.editDomain));
        if (elementProxy == null) {
            return "";
        }
        this.calculateJavaBeanPropertyEditor();
        if (this.fPropertyEditorProxyWrapper == null) {
            return elementProxy.toBeanString();
        }
        this.fPropertyEditorProxyWrapper.setValue(elementProxy);
        return this.fPropertyEditorProxyWrapper.getAsText();
    }

    protected void calculateJavaBeanPropertyEditor() {
        if (this.fPropertyEditorProxyWrapper != null && !this.rebuildWrapper) {
            return;
        }
        this.rebuildWrapper = false;
        if (this.fJavaBeansPropertyEditorClassName != null) {
            IConstructorProxy ctor = null;
            IBeanTypeProxy fPropertyEditorTypeProxy = JavaEditDomainHelper.getBeanProxyDomain(this.editDomain).getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(this.fJavaBeansPropertyEditorClassName);
            try {
                this.fPropertyEditorProxyWrapper = this.source != null ? ((ctor = fPropertyEditorTypeProxy.getConstructorProxy(new String[]{"java.lang.Object"})) != null ? new PropertyEditorBeanProxyWrapper(ctor.newInstance(new IBeanProxy[]{BeanProxyUtilities.getBeanProxy((IJavaInstance)this.source, EMFEditDomainHelper.getResourceSet((EditDomain)this.editDomain))})) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance())) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
            }
            catch (ThrowableProxy exc) {
                if (ctor != null) {
                    try {
                        this.fPropertyEditorProxyWrapper = new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
                    }
                    catch (ThrowableProxy e) {
                        JavaVEPlugin.log(e);
                    }
                }
                JavaVEPlugin.log(exc);
            }
        }
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            this.fJavaBeansPropertyEditorClassName = ((String)initData).trim();
        }
    }

    public void setData(Object data) {
        this.editDomain = (EditDomain)data;
    }

    public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
        if (sources[0] instanceof IJavaObjectInstance) {
            this.rebuildWrapper = !sources[0].equals(this.source);
            this.source = (IJavaObjectInstance)sources[0];
        }
    }
}

