/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaDataType;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanDialogCellEditor;
import org.eclipse.ve.internal.java.core.BeanFeatureComboBoxCellEditor;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanTextCellEditor;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaNls;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PropertyEditorBeanProxyWrapper;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;

public class BeanFeatureEditor
extends CellEditor
implements ISourced,
IExecutableExtension,
INeedData,
IJavaCellEditor {
    protected JavaHelpers fFeatureType;
    protected EditDomain fEditDomain;
    private IWrappedCellEditor fActualCellEditor;
    protected PropertyEditorBeanProxyWrapper fPropertyEditorWrapperProxy;
    protected IJavaObjectInstance source;
    protected boolean rebuildActualCellEditor = true;
    private IJavaInstance fValue;
    protected Composite fComposite;
    private ICellEditorValidator fValidator = null;
    protected IBeanProxy fLastKnownBeanProxy = null;
    protected boolean fValid;
    private boolean fGotANull;
    protected String fJavaBeansPropertyEditorClassName;

    public BeanFeatureEditor(JavaHelpers aFeatureType, Composite aComposite) {
        super(aComposite);
        this.fComposite = aComposite;
        this.fFeatureType = aFeatureType;
    }

    public BeanFeatureEditor(JavaHelpers aFeatureType, Composite aComposite, String aPropertyEditorClassName) {
        this(aFeatureType, aComposite);
        this.fJavaBeansPropertyEditorClassName = aPropertyEditorClassName;
    }

    protected void calculateActualCellEditor() {
        this.rebuildActualCellEditor = false;
        this.getBeanPropertyEditorProxy();
        if (this.fPropertyEditorWrapperProxy.supportsCustomEditor()) {
            this.createDialogCellEditor();
        } else if (this.fPropertyEditorWrapperProxy.getTags() != null) {
            this.createComboCellEditor();
        } else {
            this.createTextCellEditor();
        }
    }

    protected void calculateJavaBeanPropertyEditor() {
        if (this.fJavaBeansPropertyEditorClassName != null) {
            IConstructorProxy ctor = null;
            IBeanTypeProxy fPropertyEditorTypeProxy = this.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(this.fJavaBeansPropertyEditorClassName);
            try {
                this.fPropertyEditorWrapperProxy = this.source != null ? ((ctor = fPropertyEditorTypeProxy.getConstructorProxy(new String[]{"java.lang.Object"})) != null ? new PropertyEditorBeanProxyWrapper(ctor.newInstance(new IBeanProxy[]{BeanProxyUtilities.getBeanProxy((IJavaInstance)this.source, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))})) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance())) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
            }
            catch (ThrowableProxy exc) {
                if (ctor != null) {
                    try {
                        this.fPropertyEditorWrapperProxy = new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
                    }
                    catch (ThrowableProxy e) {
                        JavaVEPlugin.log(e);
                    }
                }
                JavaVEPlugin.log(exc);
            }
        }
        if (this.fPropertyEditorWrapperProxy == null) {
            this.fPropertyEditorWrapperProxy = new PropertyEditorBeanProxyWrapper(null);
        }
    }

    protected ProxyFactoryRegistry getProxyFactoryRegistry() {
        return JavaEditDomainHelper.getBeanProxyDomain(this.fEditDomain).getProxyFactoryRegistry();
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }

    protected void createComboCellEditor() {
        this.setProxyValue(this.fValue);
        final String[] fTags = this.fPropertyEditorWrapperProxy.getTags();
        BeanFeatureComboBoxCellEditor cellEditor = new BeanFeatureComboBoxCellEditor(this.fComposite, fTags);
        cellEditor.newValue(this.getAsText());
        cellEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                String textValue = this.getComboTextValue();
                BeanFeatureEditor.this.setAsText(textValue);
                BeanFeatureEditor.this.fireApplyEditorValue();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                boolean oldVState = BeanFeatureEditor.this.isValueValid();
                BeanFeatureEditor.this.setAsText(this.getComboTextValue());
                BeanFeatureEditor.this.fireEditorValueChanged(oldVState, BeanFeatureEditor.this.isValueValid());
            }

            public void cancelEditor() {
                BeanFeatureEditor.this.fireCancelEditor();
            }

            protected String getComboTextValue() {
                return fTags[(Integer)BeanFeatureEditor.this.getActualCellEditor().getValue()];
            }
        });
        this.fActualCellEditor = cellEditor;
    }

    protected void createDialogCellEditor() {
        this.setProxyValue(this.fValue);
        final BeanDialogCellEditor cellEditor = new BeanDialogCellEditor(this.fComposite, this.fPropertyEditorWrapperProxy, this.getDisplayName());
        cellEditor.newValue(this.getAsText());
        cellEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                BeanFeatureEditor.this.getProxyValueFromPropertyEditor();
                BeanFeatureEditor.this.fPropertyEditorWrapperProxy.setValue(BeanFeatureEditor.this.fPropertyEditorWrapperProxy.getValue());
                cellEditor.newValue(BeanFeatureEditor.this.getAsText());
                BeanFeatureEditor.this.fireApplyEditorValue();
            }

            public void cancelEditor() {
                BeanFeatureEditor.this.fireCancelEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                boolean oldVState = BeanFeatureEditor.this.isValueValid();
                BeanFeatureEditor.this.getProxyValueFromPropertyEditor();
                BeanFeatureEditor.this.fireEditorValueChanged(oldVState, BeanFeatureEditor.this.isValueValid());
            }
        });
        this.fActualCellEditor = cellEditor;
    }

    protected String getDisplayName() {
        return "";
    }

    protected void createTextCellEditor() {
        this.setProxyValue(this.fValue);
        BeanTextCellEditor cellEditor = new BeanTextCellEditor(this.fComposite);
        cellEditor.newValue(this.getAsText());
        cellEditor.addListener(new SetAsTextEditorListener());
        this.fActualCellEditor = cellEditor;
    }

    protected void disposeOfActualCellEditor() {
        if (this.fActualCellEditor != null) {
            ((CellEditor)this.fActualCellEditor).dispose();
            this.fActualCellEditor = null;
        }
        if (this.fPropertyEditorWrapperProxy != null) {
            this.fPropertyEditorWrapperProxy.dispose();
            this.fPropertyEditorWrapperProxy = null;
        }
    }

    public void dispose() {
        this.disposeOfActualCellEditor();
    }

    public void deactivate() {
        if (this.fActualCellEditor != null) {
            ((CellEditor)this.fActualCellEditor).deactivate();
        }
    }

    protected Control createControl(Composite aComposite) {
        return null;
    }

    protected CellEditor getActualCellEditor() {
        if (this.fActualCellEditor == null) {
            this.calculateActualCellEditor();
        }
        return (CellEditor)this.fActualCellEditor;
    }

    protected String getAsText() {
        String res = "";
        boolean bl = this.fGotANull = this.fValue == null;
        if (!this.fGotANull) {
            if (this.fPropertyEditorWrapperProxy != null) {
                try {
                    res = this.fPropertyEditorWrapperProxy.getAsText();
                }
                catch (Throwable exc) {
                    JavaVEPlugin.log(exc, 5);
                }
            } else if (this.fLastKnownBeanProxy != null) {
                res = this.fLastKnownBeanProxy.toBeanString();
            }
            if (res == null) {
                res = "";
            }
        }
        return res;
    }

    protected PropertyEditorBeanProxyWrapper getBeanPropertyEditorProxy() {
        if (this.fPropertyEditorWrapperProxy == null) {
            this.calculateJavaBeanPropertyEditor();
        }
        return this.fPropertyEditorWrapperProxy;
    }

    public String getJavaInitializationString() {
        this.getBeanPropertyEditorProxy();
        this.setProxyValue(this.fValue);
        return this.fValid ? this.fPropertyEditorWrapperProxy.getJavaInitializationString() : null;
    }

    public ICellEditorValidator getValidator() {
        return this.fValidator;
    }

    public Object doGetValue() {
        if (this.fValid) {
            return this.fValue;
        }
        return null;
    }

    public Control getControl() {
        if (this.getActualCellEditor() != null) {
            return this.getActualCellEditor().getControl();
        }
        return null;
    }

    public boolean isValueValid() {
        return this.fValid;
    }

    protected void getProxyValueFromPropertyEditor() {
        IBeanProxy newProxy = this.fPropertyEditorWrapperProxy.getValue();
        if (newProxy != this.fLastKnownBeanProxy) {
            IJavaObjectInstance bean = null;
            if (this.getFeatureType().isPrimitive()) {
                bean = BeanProxyUtilities.wrapperBeanProxyAsPrimitiveType(newProxy, (JavaDataType)this.getFeatureType(), EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), this.fPropertyEditorWrapperProxy.getJavaInitializationString());
            } else {
                bean = (IJavaObjectInstance)BeanProxyUtilities.wrapperBeanProxy(newProxy, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), true);
                if (bean != null) {
                    bean.setInitializationString(this.fPropertyEditorWrapperProxy.getJavaInitializationString());
                }
            }
            this.fValue = bean;
            this.fLastKnownBeanProxy = newProxy;
            this.fValid = true;
        }
    }

    protected JavaHelpers getFeatureType() {
        return this.fFeatureType;
    }

    protected void setAsText(String text) {
        if (this.fGotANull && text.length() == 0) {
            this.fValid = true;
            this.getProxyValueFromPropertyEditor();
        } else {
            try {
                this.fPropertyEditorWrapperProxy.setAsText(text);
                this.setErrorMessage(null);
                this.fValid = true;
                this.fGotANull = false;
                this.getProxyValueFromPropertyEditor();
            }
            catch (IllegalArgumentException e) {
                this.fValid = false;
                if (e.getMessage().equals("")) {
                    this.setErrorMessage(MessageFormat.format(JavaNls.BEANFEATUREEDITOR_ERRSETWITHNOMSG, e.getClass().getName()));
                } else {
                    this.setErrorMessage(MessageFormat.format(JavaNls.BEANFEATUREEDITOR_ERRSETWITHMSG, e.getMessage()));
                }
            }
            catch (Throwable e) {
                this.fValid = false;
                this.setErrorMessage(MessageFormat.format(JavaNls.BEANFEATUREEDITOR_ERRSETWITHNOMSG, e.getClass().getName()));
            }
        }
    }

    public void doSetFocus() {
        this.getActualCellEditor().setFocus();
    }

    protected void setProxyValue(IJavaInstance value) {
        try {
            if (value != null) {
                IBeanProxyHost aBeanProxyHost = BeanProxyUtilities.getBeanProxyHost(value);
                aBeanProxyHost.instantiateBeanProxy();
                this.fLastKnownBeanProxy = aBeanProxyHost.getBeanProxy();
            } else {
                this.fLastKnownBeanProxy = null;
            }
            if (this.getBeanPropertyEditorProxy() != null) {
                this.fPropertyEditorWrapperProxy.setValue(this.fLastKnownBeanProxy);
            }
            this.fValid = true;
            this.setErrorMessage(null);
        }
        catch (IllegalArgumentException e) {
            this.fValid = false;
            this.setErrorMessage(MessageFormat.format(JavaNls.BEANFEATUREEDITOR_ERRSETWITHMSG, e.getMessage()));
        }
        catch (Throwable e) {
            this.fValid = false;
            this.setErrorMessage(MessageFormat.format(JavaNls.BEANFEATUREEDITOR_ERRSETWITHNOMSG, e.getClass().getName()));
        }
    }

    public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
        if (sources[0] instanceof IJavaObjectInstance) {
            this.rebuildActualCellEditor = !sources[0].equals(this.source);
            this.source = (IJavaObjectInstance)sources[0];
        }
    }

    public void setValidator(ICellEditorValidator validator) {
        this.fValidator = validator;
    }

    public void doSetValue(Object value) {
        this.fValue = (IJavaInstance)value;
        this.fValid = true;
        if (this.isActivated()) {
            this.setCellEditorNewValue();
        }
    }

    protected void setCellEditorNewValue() {
        this.setProxyValue(this.fValue);
        this.fActualCellEditor.newValue(this.getAsText());
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            this.fJavaBeansPropertyEditorClassName = ((String)initData).trim();
        }
    }

    public boolean isActivated() {
        if (this.fActualCellEditor != null) {
            return ((CellEditor)this.fActualCellEditor).isActivated();
        }
        return false;
    }

    public void activate() {
        if (this.fActualCellEditor != null && this.rebuildActualCellEditor) {
            this.disposeOfActualCellEditor();
        }
        if (this.getActualCellEditor() != null) {
            this.setCellEditorNewValue();
            this.getActualCellEditor().activate();
        }
    }

    public CellEditor.LayoutData getLayoutData() {
        return this.getActualCellEditor().getLayoutData();
    }

    public interface IWrappedCellEditor {
        public void newValue(String var1);
    }

    protected class SetAsTextEditorListener
    implements ICellEditorListener {
        protected SetAsTextEditorListener() {
        }

        public void applyEditorValue() {
            BeanFeatureEditor.this.setAsText((String)BeanFeatureEditor.this.getActualCellEditor().getValue());
            BeanFeatureEditor.this.fireApplyEditorValue();
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            boolean oldVState = BeanFeatureEditor.this.isValueValid();
            BeanFeatureEditor.this.setAsText((String)BeanFeatureEditor.this.getActualCellEditor().getValue());
            BeanFeatureEditor.this.fireEditorValueChanged(oldVState, BeanFeatureEditor.this.isValueValid());
        }

        public void cancelEditor() {
            BeanFeatureEditor.this.fireCancelEditor();
        }
    }
}

