/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.TypeKind;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyFeatureMediator;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.BeanFeatureDecorator;

public class BeanProxyAdapter
extends AdapterImpl
implements IBeanProxyHost {
    private IBeanProxy fBeanProxy;
    private boolean inInstantiation = false;
    protected boolean fOwnsProxy = false;
    protected HashMap fOrigSettingProxies;
    protected Boolean fIsThis;
    protected List notInstantiatedClasses = null;
    protected IBeanProxyDomain domain;
    protected Throwable fInstantiationError;
    private static final List instantiationFeatures = Arrays.asList("initializationString", "instantiateUsing", "serializeData");
    protected Map keyedErrors = new HashMap(1);
    protected ListenerList fErrorListeners;
    static /* synthetic */ Class class$0;

    public BeanProxyAdapter(IBeanProxyDomain domain) {
        this.domain = domain;
    }

    protected boolean isInstantiationFeature(EStructuralFeature sf) {
        return instantiationFeatures.contains(sf.getName());
    }

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 1: 
            case 3: {
                if (!CDEUtilities.isUnset((Notification)msg)) {
                    try {
                        this.applied((EStructuralFeature)msg.getFeature(), msg.getNewValue(), msg.getPosition());
                    }
                    catch (ReinstantiationNeeded reinstantiationNeeded) {
                        this.reinstantiateBeanProxy();
                    }
                    break;
                }
            }
            case 2: 
            case 4: {
                try {
                    this.canceled((EStructuralFeature)msg.getFeature(), msg.getOldValue(), msg.getPosition());
                }
                catch (ReinstantiationNeeded reinstantiationNeeded) {
                    this.reinstantiateBeanProxy();
                }
                break;
            }
            case 5: {
                try {
                    this.appliedList((EStructuralFeature)msg.getFeature(), (List)msg.getNewValue(), msg.getPosition(), false);
                }
                catch (ReinstantiationNeeded reinstantiationNeeded) {
                    this.reinstantiateBeanProxy();
                }
                break;
            }
            case 6: {
                try {
                    this.canceledList((EStructuralFeature)msg.getFeature(), (List)msg.getOldValue(), msg.getPosition());
                }
                catch (ReinstantiationNeeded reinstantiationNeeded) {
                    this.reinstantiateBeanProxy();
                }
                break;
            }
            case 8: {
                this.removingAdapter();
                this.releaseBeanProxy();
            }
        }
    }

    protected void removingAdapter() {
    }

    protected final synchronized boolean inInstantiation() {
        return this.inInstantiation;
    }

    protected void appliedList(EStructuralFeature sf, List newValues, int position, boolean testValidity) {
        Iterator iter = newValues.iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            if (!testValidity || this.isValidFeature(sf, v)) {
                this.applied(sf, v, position);
            }
            if (position == -1) continue;
            ++position;
        }
    }

    protected void applied(EStructuralFeature sf, Object newValue, int position) {
        if (this.isBeanProxyInstantiated()) {
            if (!this.inInstantiation() && this.isInstantiationFeature(sf)) {
                this.reinstantiateBeanProxy();
                return;
            }
            PropertyDecorator propertyDecorator = Utilities.getPropertyDecorator((EModelElement)((EModelElement)sf));
            if (!this.isThisPart() || !this.isAttributeLocal(sf)) {
                BeanFeatureDecorator featureDecor = null;
                if (propertyDecorator == null || propertyDecorator.getWriteMethod() == null) {
                    EModelElement eModelElement = (EModelElement)sf;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.jcm.BeanFeatureDecorator;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    featureDecor = (BeanFeatureDecorator)Utilities.getDecorator((EModelElement)eModelElement, (Class)clazz);
                }
                if (propertyDecorator != null && propertyDecorator.getWriteMethod() != null || featureDecor != null) {
                    IJavaInstance javaValue = (IJavaInstance)newValue;
                    IBeanProxyHost settingBean = null;
                    if (javaValue != null) {
                        if (javaValue.isPrimitive()) {
                            settingBean = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)javaValue, (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
                            if (settingBean == null) {
                                settingBean = BeanProxyUtilities.getBeanProxyHost(javaValue, this.getEObject().eResource().getResourceSet());
                            }
                        } else {
                            settingBean = (IBeanProxyHost)EcoreUtil.getRegisteredAdapter((EObject)((EObject)javaValue), (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
                        }
                    }
                    BeanProxyAdapter beanProxyAdapter = this;
                    synchronized (beanProxyAdapter) {
                        if (this.fOrigSettingProxies == null || !this.getOriginalSettingsTable().containsKey(sf)) {
                            IBeanProxy origValue = this.getBeanProxyValue(sf, propertyDecorator, featureDecor);
                            this.getOriginalSettingsTable().put(sf, origValue);
                        }
                        if (settingBean != null) {
                            if (javaValue.isPrimitive() || !((IJavaObjectInstance)javaValue).isImplicit()) {
                                settingBean.instantiateBeanProxy();
                            } else if (!settingBean.isBeanProxyInstantiated()) {
                                IBeanProxy valueFromGetMethod = this.getBeanProxyValue(sf, propertyDecorator, featureDecor);
                                settingBean.instantiateBeanProxy(valueFromGetMethod);
                            }
                        }
                        if (settingBean != null && settingBean.getErrorStatus() == 3) {
                            this.processError(sf, ((IErrorHolder.ExceptionError)settingBean.getErrors().get((int)0)).error);
                        } else {
                            this.applyBeanFeature(sf, propertyDecorator, featureDecor, settingBean != null ? settingBean.getBeanProxy() : null);
                        }
                    }
                }
            }
        }
    }

    protected IBeanProxyFeatureMediator getFeatureMediator(BeanFeatureDecorator featureDecor) {
        String beanProxyFeatureMediatorName = featureDecor.getBeanProxyMediatorName();
        if (beanProxyFeatureMediatorName != null) {
            try {
                Class mediatorClass = CDEPlugin.getClassFromString((String)beanProxyFeatureMediatorName);
                return (IBeanProxyFeatureMediator)mediatorClass.newInstance();
            }
            catch (Exception exc) {
                JavaVEPlugin.log(exc, 5);
            }
        }
        return null;
    }

    public void applyBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature, IBeanProxy aproxy) {
        PropertyDecorator propertyDecorator = Utilities.getPropertyDecorator((EModelElement)((EModelElement)aBeanPropertyFeature));
        if (!this.isThisPart() || !this.isAttributeLocal(aBeanPropertyFeature)) {
            BeanFeatureDecorator featureDecor = null;
            if (propertyDecorator == null || propertyDecorator.getWriteMethod() == null) {
                EModelElement eModelElement = (EModelElement)aBeanPropertyFeature;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.jcm.BeanFeatureDecorator;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                featureDecor = (BeanFeatureDecorator)Utilities.getDecorator((EModelElement)eModelElement, (Class)clazz);
            }
            this.applyBeanFeature(aBeanPropertyFeature, propertyDecorator, featureDecor, aproxy);
        }
    }

    protected final void applyBeanFeature(EStructuralFeature sf, PropertyDecorator propDecor, BeanFeatureDecorator featureDecor, IBeanProxy settingBeanProxy) {
        try {
            if (this.getBeanProxy().isValid()) {
                this.primApplyBeanFeature(sf, propDecor, featureDecor, settingBeanProxy);
                this.clearError(sf);
                this.revalidateBeanProxy();
            }
        }
        catch (ReinstantiationNeeded e) {
            throw e;
        }
        catch (Exception exc) {
            this.processError(sf, exc);
        }
    }

    protected void primApplyBeanFeature(EStructuralFeature sf, PropertyDecorator propDecor, BeanFeatureDecorator featureDecor, IBeanProxy settingBeanProxy) throws Exception {
        IBeanProxyFeatureMediator mediator;
        if (propDecor != null) {
            if (propDecor.needIntrospection()) {
                throw new ReinstantiationNeeded();
            }
            if (propDecor.getWriteMethod() != null) {
                BeanProxyUtilities.writeBeanFeature(propDecor, this.getBeanProxy(), settingBeanProxy);
                return;
            }
        }
        if (featureDecor != null && (mediator = this.getFeatureMediator(featureDecor)) != null) {
            mediator.applied(sf, this.getBeanProxy(), settingBeanProxy);
        }
    }

    protected final synchronized void reinstantiateBeanProxy() {
        if (this.inInstantiation) {
            throw new ReinstantiationNeeded();
        }
        this.primReinstantiateBeanProxy();
    }

    protected void primReinstantiateBeanProxy() {
        EObject parent = ((EObject)this.getTarget()).eContainer();
        if (parent != null && parent instanceof IJavaInstance) {
            IBeanProxyHost parentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)parent);
            parentProxyHost.reinstantiateChild(this);
            return;
        }
        this.releaseBeanProxy();
        this.instantiateBeanProxy();
    }

    protected void processError(EStructuralFeature sf, Throwable exc) {
        IErrorHolder.PropertyError error = new IErrorHolder.PropertyError(exc, exc instanceof InstantiationException ? 1 : 2, sf);
        this.processError((Object)sf, error);
        this.reinstantiateBeanProxy();
    }

    protected void processError(Object key, IErrorHolder.ErrorType error) {
        this.keyedErrors.put(key, error);
        this.fireSeverityError(error.getSeverity());
        this.fireAddedError(error);
    }

    protected void processError(EStructuralFeature sf, Throwable exc, Object object) throws ReinstantiationNeeded {
        Object errors = this.keyedErrors.get(sf);
        if (errors == null || !(errors instanceof List)) {
            errors = new ArrayList(1);
            this.keyedErrors.put(sf, errors);
        }
        IErrorHolder.MultiPropertyError error = new IErrorHolder.MultiPropertyError(object, exc, exc instanceof InstantiationException ? 1 : 2, sf);
        ((List)errors).add(error);
        this.fireSeverityError(error.getSeverity());
        this.fireAddedError(error);
        JavaVEPlugin.log(exc, 5);
        throw new ReinstantiationNeeded();
    }

    protected void processInstantiationError(Throwable exc) {
        this.fInstantiationError = exc;
        this.fireSeverityError(3);
    }

    protected void clearError(Object key) {
        Object v = this.keyedErrors.remove(key);
        if (this.keyedErrors.isEmpty() && this.fInstantiationError == null) {
            this.fireSeverityError(0);
        }
        if (v instanceof IErrorHolder.ErrorType) {
            this.fireClearedError((IErrorHolder.ErrorType)v);
        } else if (v instanceof List) {
            List errors = (List)v;
            int i = 0;
            while (i < errors.size()) {
                this.fireClearedError((IErrorHolder.ErrorType)errors.get(i));
                ++i;
            }
        }
    }

    protected void clearError(EStructuralFeature sf, Object object) {
        Object errors = this.keyedErrors.get(sf);
        if (errors != null) {
            if (errors instanceof List) {
                Iterator itr = ((List)errors).iterator();
                while (itr.hasNext()) {
                    IErrorHolder.MultiPropertyError merr = (IErrorHolder.MultiPropertyError)itr.next();
                    if (object != merr.getErrorObject()) continue;
                    itr.remove();
                    this.fireClearedError(merr);
                    break;
                }
                if (((List)errors).isEmpty()) {
                    this.clearError(sf);
                }
            } else {
                this.clearError(sf);
            }
        }
    }

    protected boolean isValidFeature(EStructuralFeature aSF) {
        return this.keyedErrors.get(aSF) == null;
    }

    protected boolean isValidFeature(EStructuralFeature sf, Object object) {
        Object errors = this.keyedErrors.get(sf);
        if (errors != null) {
            if (errors instanceof List) {
                Iterator itr = ((List)errors).iterator();
                while (itr.hasNext()) {
                    IErrorHolder.MultiPropertyError e = (IErrorHolder.MultiPropertyError)itr.next();
                    if (object != e.getErrorObject()) continue;
                    return false;
                }
            } else {
                this.clearError(sf);
            }
        }
        return true;
    }

    protected void fireSeverityError(int severity) {
        if (this.fErrorListeners != null) {
            Object[] listeners = this.fErrorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorStatus(severity);
                ++i;
            }
        }
    }

    protected void fireAddedError(IErrorHolder.ErrorType e) {
        if (this.fErrorListeners != null) {
            Object[] listeners = this.fErrorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorAdded(e);
                ++i;
            }
        }
    }

    protected void fireClearedError(IErrorHolder.ErrorType e) {
        if (this.fErrorListeners != null) {
            Object[] listeners = this.fErrorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorCleared(e);
                ++i;
            }
        }
    }

    protected void applyAllSettings() {
        EObject eTarget = this.getEObject();
        Iterator features = eTarget.eClass().getEAllStructuralFeatures().iterator();
        while (features.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)features.next();
            if (!eTarget.eIsSet(sf)) continue;
            if (sf.isMany()) {
                this.appliedList(sf, (List)eTarget.eGet(sf), -1, true);
                continue;
            }
            if (!this.isValidFeature(sf)) continue;
            this.applied(sf, eTarget.eGet(sf), -1);
        }
    }

    protected void canceledList(EStructuralFeature sf, List oldValues, int position) {
        ListIterator iter = oldValues.listIterator(oldValues.size());
        if (position != -1) {
            position += oldValues.size() - 1;
        }
        while (iter.hasNext()) {
            this.canceled(sf, iter.next(), position);
            if (position == -1) continue;
            --position;
        }
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (this.isBeanProxyInstantiated()) {
            if (!this.inInstantiation() && this.isInstantiationFeature(sf)) {
                this.reinstantiateBeanProxy();
                return;
            }
            PropertyDecorator propertyDecorator = Utilities.getPropertyDecorator((EModelElement)((EModelElement)sf));
            if (!this.isThisPart() || !this.isAttributeLocal(sf)) {
                BeanFeatureDecorator featureDecor = null;
                if (propertyDecorator == null || propertyDecorator.getWriteMethod() == null) {
                    EModelElement eModelElement = (EModelElement)sf;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.jcm.BeanFeatureDecorator;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    featureDecor = (BeanFeatureDecorator)Utilities.getDecorator((EModelElement)eModelElement, (Class)clazz);
                }
                if (propertyDecorator != null && propertyDecorator.getWriteMethod() != null || featureDecor != null) {
                    IBeanProxyHost value = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)oldValue);
                    BeanProxyAdapter beanProxyAdapter = this;
                    synchronized (beanProxyAdapter) {
                        if (this.fOrigSettingProxies != null && this.fOrigSettingProxies.containsKey(sf)) {
                            this.applyBeanFeature(sf, propertyDecorator, featureDecor, (IBeanProxy)this.fOrigSettingProxies.get(sf));
                        }
                        this.clearError(sf);
                    }
                    if (value != null && (sf instanceof EAttribute || ((EReference)sf).isContainment())) {
                        value.releaseBeanProxy();
                    }
                }
            }
        }
    }

    public void releaseBeanProxy() {
        if (this.isBeanProxyInstantiated() || this.getErrorStatus() == 3) {
            ProxyFactoryRegistry registry;
            EObject eTarget = this.getEObject();
            Iterator settings = new BeanProxyUtilities.JavaSettingsEList(eTarget, false).basicIterator();
            while (settings.hasNext()) {
                this.releaseSetting((IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)((Notifier)settings.next()), (Object)IBeanProxyHost.BEAN_PROXY_TYPE));
            }
            if (this.fOwnsProxy && this.isBeanProxyInstantiated() && (registry = this.getBeanProxy().getProxyFactoryRegistry()).isValid()) {
                registry.releaseProxy(this.getBeanProxy());
            }
            this.fBeanProxy = null;
            this.fOwnsProxy = false;
            this.fOrigSettingProxies = null;
            this.notInstantiatedClasses = null;
        }
    }

    private void releaseSetting(IBeanProxyHost proxyHost) {
        if (proxyHost != null) {
            proxyHost.releaseBeanProxy();
        }
    }

    protected void finalize() throws Throwable {
        this.releaseBeanProxy();
    }

    public IJavaInstance getBeanPropertyValue(EStructuralFeature aBeanPropertyAttribute) {
        if (!(!this.isBeanProxyInstantiated() || this.isThisPart() && this.isAttributeLocal(aBeanPropertyAttribute))) {
            IBeanProxy valueProxy = this.getInternalBeanPropertyProxyValue(aBeanPropertyAttribute);
            IJavaInstance bean = BeanProxyUtilities.wrapperBeanProxy(valueProxy, EMFEditDomainHelper.getResourceSet((EditDomain)this.getBeanProxyDomain().getEditDomain()), false);
            if (bean != null && !bean.isPrimitive()) {
                ((IJavaObjectInstance)bean).setImplicit(true);
            }
            return bean;
        }
        return null;
    }

    public IBeanProxy getBeanPropertyProxyValue(EStructuralFeature aBeanPropertyAttribute) {
        if (!(!this.isBeanProxyInstantiated() || this.isThisPart() && this.isAttributeLocal(aBeanPropertyAttribute))) {
            return this.getInternalBeanPropertyProxyValue(aBeanPropertyAttribute);
        }
        return null;
    }

    protected IBeanProxy getInternalBeanPropertyProxyValue(EStructuralFeature aBeanPropertyAttribute) {
        BeanFeatureDecorator featureDecor;
        PropertyDecorator propertyDecorator = Utilities.getPropertyDecorator((EModelElement)((EModelElement)aBeanPropertyAttribute));
        if (propertyDecorator != null && propertyDecorator.getReadMethod() != null) {
            return this.getBeanProxyValue(aBeanPropertyAttribute, propertyDecorator, null);
        }
        EModelElement eModelElement = (EModelElement)aBeanPropertyAttribute;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.jcm.BeanFeatureDecorator;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((featureDecor = (BeanFeatureDecorator)Utilities.getDecorator((EModelElement)eModelElement, (Class)clazz)) != null) {
            return this.getBeanProxyValue(aBeanPropertyAttribute, propertyDecorator, featureDecor);
        }
        return null;
    }

    protected IBeanProxy primReadBeanFeature(PropertyDecorator propDecor, IBeanProxy aSource) throws ThrowableProxy {
        return BeanProxyUtilities.readBeanFeature(propDecor, aSource);
    }

    protected IBeanProxy getBeanProxyValue(EStructuralFeature aBeanPropertyAttribute, PropertyDecorator propertyDecorator, BeanFeatureDecorator featureDecor) {
        IBeanProxyFeatureMediator mediator;
        if (propertyDecorator != null && propertyDecorator.getReadMethod() != null) {
            try {
                return this.primReadBeanFeature(propertyDecorator, this.getBeanProxy());
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log(e, 2);
            }
        }
        if (featureDecor != null && (mediator = this.getFeatureMediator(featureDecor)) != null) {
            try {
                return mediator.getValue(aBeanPropertyAttribute, this.getBeanProxy());
            }
            catch (Exception exc) {
                JavaVEPlugin.log(exc, 2);
            }
        }
        return null;
    }

    public final IBeanProxy getBeanProxy() {
        return this.fBeanProxy;
    }

    public Map getOriginalSettingsTable() {
        if (this.fOrigSettingProxies == null) {
            this.fOrigSettingProxies = new HashMap(20);
        }
        return this.fOrigSettingProxies;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized IBeanProxy instantiateBeanProxy() {
        if (this.isBeanProxyInstantiated()) return this.fBeanProxy;
        this.inInstantiation = true;
        try {
            while (true) {
                try {
                    this.primInstantiateBeanProxy();
                    if (this.getErrorStatus() != 3) {
                        this.applyAllSettings();
                    }
                }
                catch (ReinstantiationNeeded reinstantiationNeeded) {
                    this.releaseBeanProxy();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.inInstantiation = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.inInstantiation = false;
            return this.fBeanProxy;
        }
    }

    public void reinstantiateChild(IBeanProxyHost aChildProxyHost) {
        aChildProxyHost.releaseBeanProxy();
        EObject child = (EObject)aChildProxyHost.getTarget();
        EReference[] sfs = InverseMaintenanceAdapter.getReferencesFrom((EObject)this.getEObject(), (Notifier)child);
        int i = 0;
        while (i < sfs.length) {
            int index = -1;
            EReference sf = sfs[i];
            if (sf.isMany()) {
                List values = (List)this.getEObject().eGet((EStructuralFeature)sf);
                index = values.indexOf(child);
            }
            this.applied((EStructuralFeature)sf, child, index);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized IBeanProxy instantiateBeanProxy(IBeanProxy aBeanProxy) {
        this.inInstantiation = true;
        this.fOwnsProxy = false;
        try {
            while (true) {
                try {
                    this.setupBeanProxy(aBeanProxy);
                    this.applyAllSettings();
                }
                catch (ReinstantiationNeeded reinstantiationNeeded) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.inInstantiation = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.inInstantiation = false;
            return this.fBeanProxy;
        }
    }

    protected void primInstantiateBeanProxy() {
        IBeanTypeProxy targetClass = null;
        this.fIsThis = null;
        String initializationString = null;
        String instantiateUsing = null;
        String serializeData = null;
        this.fInstantiationError = null;
        if (this.domain.getProxyFactoryRegistry().isValid()) {
            if (!this.isThisPart()) {
                String qualifiedClassName = ((JavaClass)((IJavaInstance)this.target).getJavaType()).getQualifiedNameForReflection();
                targetClass = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(qualifiedClassName);
                if (targetClass == null || targetClass.getInitializationError() != null) {
                    ExceptionInInitializerError exc = new ExceptionInInitializerError(targetClass != null ? targetClass.getInitializationError() : MessageFormat.format(JavaMessages.getString("Proxy_Class_has_Errors_ERROR_"), qualifiedClassName));
                    this.processInstantiationError(exc);
                    JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " with initialization string=" + initializationString, 5);
                    JavaVEPlugin.log(exc, 5);
                    return;
                }
                if (((IJavaInstance)this.target).isSetInitializationString()) {
                    initializationString = ((IJavaInstance)this.target).getInitializationString();
                    try {
                        this.fOwnsProxy = true;
                        this.setupBeanProxy(this.instantiateWithString(targetClass, initializationString));
                    }
                    catch (ThrowableProxy exc) {
                        this.processInstantiationError(exc);
                        JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " with initialization string=" + initializationString, 5);
                        JavaVEPlugin.log(exc, 5);
                    }
                    catch (InstantiationException exc) {
                        this.processInstantiationError(exc);
                        JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " with initialization string=" + initializationString, 5);
                        JavaVEPlugin.log(exc, 5);
                    }
                    catch (ClassCastException exc) {
                        this.processInstantiationError(exc);
                        JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " with initialization string=" + initializationString, 5);
                        JavaVEPlugin.log(exc, 5);
                    }
                } else if (this.target instanceof IJavaObjectInstance && ((IJavaObjectInstance)this.target).isSetInstantiateUsing()) {
                    instantiateUsing = ((IJavaObjectInstance)this.target).getInstantiateUsing();
                    IStandardBeanTypeProxyFactory fact = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory();
                    IBeanTypeProxy type = fact.getBeanTypeProxy("java.beans.Beans");
                    IMethodProxy method = type.getMethodProxy("instantiate", new String[]{"java.lang.ClassLoader", "java.lang.String"});
                    try {
                        this.fOwnsProxy = true;
                        IBeanProxy[] iBeanProxyArray = new IBeanProxy[2];
                        iBeanProxyArray[1] = this.domain.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(instantiateUsing);
                        this.setupBeanProxy(method.invoke((IBeanProxy)type, iBeanProxyArray));
                    }
                    catch (ThrowableProxy exc) {
                        this.processInstantiationError(exc);
                        JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " using " + instantiateUsing, 5);
                        JavaVEPlugin.log(exc, 5);
                    }
                } else if (this.target instanceof IJavaObjectInstance && ((IJavaObjectInstance)this.target).isSetSerializeData()) {
                    serializeData = ((IJavaObjectInstance)this.target).getSerializeData();
                    IStandardBeanTypeProxyFactory fact = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory();
                    IBeanTypeProxy remoteDecoder = fact.getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.XMLHelper");
                    IStringBeanProxy stringProxy = this.domain.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(serializeData);
                    IMethodProxy getObjectMethod = remoteDecoder.getMethodProxy("getDecodedObject", new String[]{"java.lang.String"});
                    try {
                        this.fOwnsProxy = true;
                        this.setupBeanProxy(getObjectMethod.invoke((IBeanProxy)remoteDecoder, new IBeanProxy[]{stringProxy}));
                    }
                    catch (Exception e) {
                        this.processInstantiationError(e);
                        JavaVEPlugin.log(e, 5);
                    }
                } else {
                    try {
                        this.fOwnsProxy = true;
                        this.setupBeanProxy(this.defaultInstantiate(targetClass));
                    }
                    catch (ThrowableProxy exc) {
                        this.processInstantiationError(exc);
                        JavaVEPlugin.log("Could not instantiate " + qualifiedClassName + " with default ctor", 5);
                        JavaVEPlugin.log(exc, 5);
                    }
                }
            } else {
                this.notInstantiatedClasses = new ArrayList(2);
                JavaClass thisClass = (JavaClass)((IJavaInstance)this.target).getJavaType();
                this.notInstantiatedClasses.add(thisClass);
                JavaClass superclass = thisClass.getSupertype();
                while (superclass != null && superclass.isAbstract()) {
                    this.notInstantiatedClasses.add(superclass);
                    superclass = superclass.getSupertype();
                }
                if (superclass != null) {
                    targetClass = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(superclass.getQualifiedNameForReflection());
                }
                if (targetClass == null || targetClass.getInitializationError() != null) {
                    ExceptionInInitializerError exc = new ExceptionInInitializerError(targetClass != null ? targetClass.getInitializationError() : MessageFormat.format(JavaMessages.getString("Proxy_Class_has_Errors_ERROR_"), thisClass.getQualifiedName()));
                    this.processInstantiationError(exc);
                    JavaVEPlugin.log("Could not instantiate " + (superclass != null ? superclass.getJavaName() : thisClass.getQualifiedName()) + " with default ctor", 5);
                    JavaVEPlugin.log(exc, 5);
                    return;
                }
                try {
                    this.fOwnsProxy = true;
                    this.setupBeanProxy(this.defaultInstantiate(targetClass));
                }
                catch (ThrowableProxy exc) {
                    this.processInstantiationError(exc);
                    JavaVEPlugin.log("Could not instantiate " + superclass.getJavaName() + " with default ctor", 5);
                    JavaVEPlugin.log(exc, 5);
                }
            }
        }
    }

    protected IBeanProxy defaultInstantiate(IBeanTypeProxy targetClass) throws ThrowableProxy {
        return targetClass.newInstance();
    }

    protected IBeanProxy instantiateWithString(IBeanTypeProxy targetClass, String initString) throws ThrowableProxy, InstantiationException {
        return targetClass.newInstance(initString);
    }

    public boolean isAdapterForType(Object type) {
        return IBeanProxyHost.BEAN_PROXY_TYPE == type || IErrorNotifier.ERROR_NOTIFIER_TYPE == type || IErrorHolder.ERROR_HOLDER_TYPE == type;
    }

    protected boolean isAttributeLocal(EStructuralFeature attr) {
        return this.notInstantiatedClasses != null ? this.notInstantiatedClasses.contains(attr.eContainer()) : false;
    }

    public final boolean isBeanProxyInstantiated() {
        return this.fBeanProxy != null && this.fBeanProxy.isValid();
    }

    protected boolean isThisPart() {
        if (this.fIsThis == null) {
            EReference containersf = this.getEObject().eContainmentFeature();
            this.fIsThis = containersf != null && "thisPart".equals(containersf.getName()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fIsThis;
    }

    public void revalidateBeanProxy() {
        this.invalidateBeanProxy();
        this.validateBeanProxy();
    }

    public void setBeanProxy(IBeanProxy beanProxy) {
        if (this.fBeanProxy == null) {
            this.fOwnsProxy = false;
            this.setupBeanProxy(beanProxy);
        }
    }

    protected void setupBeanProxy(IBeanProxy beanProxy) {
        this.fBeanProxy = beanProxy;
        if (beanProxy != null && !beanProxy.getTypeProxy().isPrimitive()) {
            JavaClass javaClass;
            String qualifiedClassName = beanProxy.getTypeProxy().getTypeName();
            JavaClass currentType = (JavaClass)((IJavaInstance)this.target).getJavaType();
            if (!currentType.getQualifiedNameForReflection().equals(qualifiedClassName) && currentType.isAssignableFrom((EClassifier)(javaClass = (JavaClass)JavaClassImpl.reflect((String)qualifiedClassName, (ResourceSet)currentType.eResource().getResourceSet())))) {
                if (javaClass.getKind() == TypeKind.UNDEFINED_LITERAL) {
                    return;
                }
                ((InternalEObject)this.target).eSetClass((EClass)javaClass);
            }
        }
    }

    public int getErrorStatus() {
        if (this.fInstantiationError != null) {
            return 3;
        }
        if (!this.keyedErrors.isEmpty()) {
            Iterator errors = this.keyedErrors.values().iterator();
            boolean information = false;
            while (errors.hasNext()) {
                Object error = errors.next();
                if (error instanceof List) {
                    List eList = (List)error;
                    int i = 0;
                    while (i < eList.size()) {
                        IErrorHolder.ErrorType eType = (IErrorHolder.ErrorType)eList.get(i);
                        if (eType.getSeverity() == 2) {
                            return 2;
                        }
                        if (eType.getSeverity() == 1) {
                            information = true;
                        }
                        ++i;
                    }
                    continue;
                }
                IErrorHolder.ErrorType eType = (IErrorHolder.ErrorType)error;
                if (eType.getSeverity() == 2) {
                    return 2;
                }
                if (eType.getSeverity() != 1) continue;
                information = true;
            }
            return information ? 1 : 2;
        }
        return 0;
    }

    public List getErrors() {
        ArrayList<IErrorHolder.ExceptionError> result = new ArrayList<IErrorHolder.ExceptionError>(2);
        if (this.fInstantiationError != null) {
            result.add(new IErrorHolder.ExceptionError(this.fInstantiationError, 3));
            return result;
        }
        Iterator iter = this.keyedErrors.values().iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            if (v instanceof List) {
                result.addAll((List)v);
                continue;
            }
            result.add((IErrorHolder.ExceptionError)v);
        }
        return result;
    }

    public void setOwnsProxy(boolean ownsProxy) {
        this.fOwnsProxy = ownsProxy;
    }

    protected EObject getEObject() {
        return (EObject)this.target;
    }

    public final IBeanProxyDomain getBeanProxyDomain() {
        return this.domain;
    }

    public void addErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.fErrorListeners == null) {
            this.fErrorListeners = new ListenerList(2);
        }
        this.fErrorListeners.add((Object)aListener);
    }

    public void removeErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.fErrorListeners != null) {
            this.fErrorListeners.remove((Object)aListener);
        }
    }

    public void invalidateBeanProxy() {
    }

    public void validateBeanProxy() {
    }

    protected class ReinstantiationNeeded
    extends RuntimeException {
    }
}

