/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.propertysheet.BooleanCellEditor;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class BooleanJavaCellEditor
extends BooleanCellEditor
implements IExecutableExtension,
INeedData,
IJavaCellEditor {
    protected EditDomain fEditDomain;
    protected boolean fIsBooleanClass;
    protected JavaHelpers fBooleanHelper;

    public BooleanJavaCellEditor(Composite parent) {
        super(parent);
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        this.fIsBooleanClass = initData instanceof String && "class".equalsIgnoreCase((String)initData);
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        if (!this.fIsBooleanClass) {
            this.fBooleanHelper = JavaClassImpl.reflect((String)"boolean", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain));
            this.setItems(this.getDisplayStrings(), new Object[]{BeanUtilities.createJavaObject(this.fBooleanHelper, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), "true"), BeanUtilities.createJavaObject(this.fBooleanHelper, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), "false")});
        } else {
            this.fBooleanHelper = JavaClassImpl.reflect((String)"java.lang.Boolean", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain));
        }
    }

    protected String isCorrectObject(Object value) {
        if (value == null) {
            if (!this.fIsBooleanClass) {
                return PropertysheetMessages.getString((String)"null_invalid_WARN_");
            }
            return null;
        }
        if (((EClassifier)this.fBooleanHelper).isInstance(value)) {
            return null;
        }
        return PropertysheetMessages.getString((String)"bad_bool_WARN_");
    }

    public String getJavaInitializationString() {
        if (this.getSelectionIndex() == 0) {
            return "true";
        }
        return "false";
    }

    protected int doGetIndex(Object value) {
        if (((EClassifier)this.fBooleanHelper).isInstance(value)) {
            return ((IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)value, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain))).booleanValue() ? 0 : 1;
        }
        return -1;
    }

    protected Object doGetObject(int index) {
        if (!this.fIsBooleanClass) {
            return super.doGetObject(index);
        }
        switch (index) {
            case -1: {
                return null;
            }
            case 0: {
                return BeanUtilities.createJavaObject(this.fBooleanHelper, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), "Boolean.TRUE");
            }
            case 1: {
                return BeanUtilities.createJavaObject(this.fBooleanHelper, EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), "Boolean.FALSE");
            }
        }
        return null;
    }
}

