/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.CustomizeAction;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.ModifyAttributesCommand;
import org.eclipse.ve.internal.java.core.WindowLauncher;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CustomizeXMLPersistenceAction
extends CustomizeAction {
    public static final String ACTION_ID = "jcm.CUSTOMIZE";

    public CustomizeXMLPersistenceAction(IEditorPart anEditorPart) {
        super((IWorkbenchPart)anEditorPart);
        this.setId(ACTION_ID);
        this.setText(JavaMessages.getString("Action.CustomizeXMLPersistence.Text"));
    }

    public void run() {
        try {
            EditPart editPart = (EditPart)this.getSelectedObjects().get(0);
            ProxyFactoryRegistry registry = BeanProxyUtilities.getProxyFactoryRegistry(editPart);
            IBeanTypeProxy customizerTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getCustomizerClassName());
            IBeanProxy customizerProxy = customizerTypeProxy.newInstance();
            final IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)editPart.getModel()));
            IBeanProxy beanProxy = beanProxyHost.getBeanProxy();
            IMethodProxy setObjectMethod = customizerProxy.getTypeProxy().getMethodProxy("setObject", new String[]{"java.lang.Object"});
            setObjectMethod.invoke(customizerProxy, new IBeanProxy[]{beanProxy});
            IBeanTypeProxy helperTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.XMLHelper");
            IMethodProxy launcherMethodProxy = helperTypeProxy.getMethodProxy("getEncodedString", new String[]{"java.lang.Object"});
            IBeanTypeProxy windowLauncherType = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.WindowLauncher");
            IConstructorProxy ctor = windowLauncherType.getConstructorProxy(new String[]{"java.awt.Component"});
            IBeanProxy windowLauncherProxy = ctor.newInstance(new IBeanProxy[]{customizerProxy});
            IStringBeanProxy xmlOfCustomized = null;
            WindowLauncher launcher = new WindowLauncher(windowLauncherProxy, Display.getDefault().getActiveShell());
            launcher.addListener(new WindowLauncher.Listener(){

                public void propertyChange(String eventName) {
                    beanProxyHost.revalidateBeanProxy();
                }
            });
            launcher.waitUntilWindowCloses();
            switch (launcher.getWindowState()) {
                case 2: 
                case 4: {
                    xmlOfCustomized = null;
                    break;
                }
                case 3: {
                    launcherMethodProxy = helperTypeProxy.getMethodProxy("getEncodedString", new String[]{"java.lang.Object"});
                    xmlOfCustomized = (IStringBeanProxy)launcherMethodProxy.invoke((IBeanProxy)helperTypeProxy, new IBeanProxy[]{beanProxy});
                    break;
                }
                default: {
                    xmlOfCustomized = null;
                }
            }
            launcher.dispose();
            windowLauncherProxy = null;
            launcher = null;
            if (xmlOfCustomized == null) {
                return;
            }
            IJavaObjectInstance objectModified = (IJavaObjectInstance)editPart.getModel();
            CompoundCommand finalCommand = new CompoundCommand();
            if (objectModified.isSetInitializationString()) {
                ModifyAttributesCommand removeInitializationStringCommand = new ModifyAttributesCommand("");
                removeInitializationStringCommand.setFeature(JavaInstantiation.getInitializationStringFeature((IJavaObjectInstance)objectModified));
                removeInitializationStringCommand.setOperation(ModifyAttributesCommand.FEATURE_REMOVE);
                removeInitializationStringCommand.setTarget((EObject)objectModified);
                finalCommand.append((Command)removeInitializationStringCommand);
            }
            if (objectModified.isSetInstantiateUsing()) {
                ModifyAttributesCommand removeInstantiationStringCommand = new ModifyAttributesCommand("");
                removeInstantiationStringCommand.setFeature(JavaInstantiation.getInstantiateUsingFeature((IJavaObjectInstance)objectModified));
                removeInstantiationStringCommand.setOperation(ModifyAttributesCommand.FEATURE_REMOVE);
                removeInstantiationStringCommand.setTarget((EObject)objectModified);
                finalCommand.append((Command)removeInstantiationStringCommand);
            }
            finalCommand.unwrap();
            ModifyAttributesCommand applySerializeCommand = new ModifyAttributesCommand("");
            applySerializeCommand.setData(xmlOfCustomized.stringValue());
            applySerializeCommand.setFeature(JavaInstantiation.getSerializeDataFeature((IJavaObjectInstance)objectModified));
            applySerializeCommand.setTarget((EObject)objectModified);
            if (objectModified.isSetSerializeData()) {
                applySerializeCommand.setOperation(ModifyAttributesCommand.FEATURE_MODIFY);
            } else {
                applySerializeCommand.setOperation(ModifyAttributesCommand.FEATURE_ADD);
            }
            if (finalCommand.isEmpty()) {
                this.execute((Command)applySerializeCommand);
            } else {
                finalCommand.append((Command)applySerializeCommand);
                this.execute((Command)finalCommand);
            }
        }
        catch (Exception e) {
            JavaVEPlugin.log(e, 5);
        }
    }
}

