/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.StringTokenizer;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.DefaultJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.InsetsJavaClassLabelProvider;
import org.eclipse.ve.internal.java.core.JavaMessages;

public class InsetsJavaClassCellEditor
extends DefaultJavaClassCellEditor {
    public InsetsJavaClassCellEditor(Composite aComposite) {
        super(aComposite);
    }

    protected String doGetString(Object value) {
        if (this.isInstance(value)) {
            return InsetsJavaClassLabelProvider.toString((IJavaInstance)value);
        }
        return null;
    }

    protected String getJavaInitializationString(String insetsString) {
        StringTokenizer st = new StringTokenizer(insetsString, ",");
        StringBuffer sb = new StringBuffer(insetsString.length());
        sb.append("new java.awt.Insets(");
        sb.append(st.nextToken().trim());
        while (st.hasMoreTokens()) {
            sb.append(',');
            sb.append(st.nextToken().trim());
        }
        sb.append(')');
        return sb.toString();
    }

    protected String isCorrectString(String text) {
        StringTokenizer st = new StringTokenizer(text, ",");
        String[] tokenMsgs = new String[]{JavaMessages.getString("CellEditor.Insets.TopErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Insets.LeftErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Insets.BottomErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Insets.RightErrorMsg_ERROR_")};
        if (st.countTokens() != tokenMsgs.length) {
            return JavaMessages.getString("CellEditor.Insets.ErrorMsg_ERROR_");
        }
        int i = 0;
        while (i < tokenMsgs.length) {
            String field = st.nextToken().trim();
            try {
                Integer.decode(field);
            }
            catch (NumberFormatException numberFormatException) {
                return tokenMsgs[i];
            }
            ++i;
        }
        return null;
    }

    public void setData(Object data) {
        super.setData(data);
        this.setJavaType(JavaClassImpl.reflect((String)"java.awt.Insets", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain)));
    }

    public static String getJavaInitializationString(Insets insets) {
        return InsetsJavaClassCellEditor.getJavaInitializationString(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static String getJavaInitializationString(int top, int left, int bottom, int right) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new java.awt.Insets(");
        buffer.append(String.valueOf(top));
        buffer.append(',');
        buffer.append(String.valueOf(left));
        buffer.append(',');
        buffer.append(String.valueOf(bottom));
        buffer.append(',');
        buffer.append(String.valueOf(right));
        buffer.append(')');
        return buffer.toString();
    }
}

