/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.DefaultTreeEditPart;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.EventCallback;
import org.eclipse.ve.internal.java.core.EventInvocationAndListener;
import org.eclipse.ve.internal.java.core.EventInvocationAndListenerTreeEditPart;
import org.eclipse.ve.internal.java.core.EventMethodTreeEditPart;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorHolder;
import org.eclipse.ve.internal.java.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.IJavaBeanTreeContextMenuContributor;
import org.eclipse.ve.internal.java.core.JavaBeanActionFilter;
import org.eclipse.ve.internal.java.core.JavaBeanEventUtilities;
import org.eclipse.ve.internal.java.core.PropertyEventTreeEditPart;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.BeanComposition;
import org.eclipse.ve.internal.jcm.Callback;
import org.eclipse.ve.internal.jcm.EventInvocation;
import org.eclipse.ve.internal.jcm.JCMPackage;
import org.eclipse.ve.internal.jcm.Listener;
import org.eclipse.ve.internal.jcm.ListenerType;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;
import org.eclipse.ve.internal.jcm.PropertyEvent;

public class JavaBeanTreeEditPart
extends DefaultTreeEditPart
implements IJavaBeanTreeContextMenuContributor {
    protected IErrorNotifier.ErrorListener fErrorListener = new IErrorNotifier.ErrorListenerAdapter(){

        public void errorStatus(int severity) {
            JavaBeanTreeEditPart.this.refreshVisuals();
        }
    };
    protected IJavaObjectInstance javaModel;
    protected EStructuralFeature sfObjectEvents;
    protected Adapter listenerAdapter;
    protected Adapter eventInvocationAdapter;
    protected Adapter propertyChangeEventInvocationAdapter;
    protected List eventInvocationsListenedTo;
    protected List propertyChangeEventInvocationsListenedTo;
    protected Image fOverlayImage;
    protected int fOverlayImageSeverity;
    static /* synthetic */ Class class$0;

    public JavaBeanTreeEditPart(Object aModel) {
        super(aModel);
    }

    public void setModel(Object aModel) {
        super.setModel(aModel);
        this.javaModel = (IJavaObjectInstance)aModel;
        this.sfObjectEvents = JavaInstantiation.getSFeature((IJavaObjectInstance)this.javaModel, (String)"events");
    }

    protected EStructuralFeature getSFObjectEvents() {
        return this.sfObjectEvents;
    }

    public void activate() {
        super.activate();
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
        beanProxyHost.addErrorListener(this.fErrorListener);
        ((EObject)this.getModel()).eAdapters().add(this.getListenerAdapter());
    }

    protected Adapter getListenerAdapter() {
        if (this.listenerAdapter == null) {
            this.listenerAdapter = new Adapter(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == JavaBeanTreeEditPart.this.getSFObjectEvents()) {
                        AbstractEventInvocation eventInvocation;
                        Iterator iter;
                        if (JavaBeanTreeEditPart.this.eventInvocationsListenedTo != null) {
                            iter = JavaBeanTreeEditPart.this.eventInvocationsListenedTo.iterator();
                            while (iter.hasNext()) {
                                eventInvocation = (AbstractEventInvocation)iter.next();
                                eventInvocation.eAdapters().remove(JavaBeanTreeEditPart.this.getEventInvocationAdapter());
                            }
                            JavaBeanTreeEditPart.this.eventInvocationsListenedTo.clear();
                        }
                        if (JavaBeanTreeEditPart.this.propertyChangeEventInvocationsListenedTo != null) {
                            iter = JavaBeanTreeEditPart.this.propertyChangeEventInvocationsListenedTo.iterator();
                            while (iter.hasNext()) {
                                eventInvocation = (AbstractEventInvocation)iter.next();
                                eventInvocation.eAdapters().remove(JavaBeanTreeEditPart.this.getPropertyChangeEventInvocationAdapter());
                            }
                        }
                        JavaBeanTreeEditPart.this.refreshChildren();
                        JavaBeanTreeEditPart.this.refreshVisuals();
                    }
                }

                public Notifier getTarget() {
                    return null;
                }

                public void setTarget(Notifier newTarget) {
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }
            };
        }
        return this.listenerAdapter;
    }

    public void deactivate() {
        ((EObject)this.getModel()).eAdapters().remove(this.getListenerAdapter());
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
        beanProxyHost.removeErrorListener(this.fErrorListener);
        if (this.eventInvocationsListenedTo != null) {
            Iterator iter = this.eventInvocationsListenedTo.iterator();
            while (iter.hasNext()) {
                AbstractEventInvocation eventInvocation = (AbstractEventInvocation)iter.next();
                eventInvocation.eAdapters().remove(this.getEventInvocationAdapter());
            }
            this.eventInvocationsListenedTo.clear();
        }
        super.deactivate();
        if (this.fOverlayImage != null) {
            TreeItem w = (TreeItem)this.getWidget();
            if (!w.isDisposed()) {
                w.setImage(null);
            }
            this.fOverlayImage.dispose();
        }
    }

    protected Image getImage() {
        Image anImage;
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
        int beanProxyStatus = beanProxyHost.getErrorStatus();
        if (beanProxyStatus == 0) {
            return super.getImage();
        }
        if (this.fOverlayImage != null && this.fOverlayImageSeverity != beanProxyStatus) {
            this.fOverlayImage.dispose();
            this.fOverlayImage = null;
        }
        if (this.fOverlayImage == null && (anImage = super.getImage()) != null) {
            this.fOverlayImage = new Image((Device)Display.getCurrent(), new JavaBeansImageDescriptor(anImage, beanProxyStatus).getImageData());
            this.fOverlayImageSeverity = beanProxyStatus;
        }
        return this.fOverlayImage;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ((TreeItem)this.getWidget()).setExpanded(true);
    }

    protected List getChildJavaBeans() {
        return Collections.EMPTY_LIST;
    }

    public final List getModelChildren() {
        int intShowEvents;
        if (this.getParent() == null) {
            return Collections.EMPTY_LIST;
        }
        Integer showEvents = (Integer)((EditDomain)this.getRoot().getViewer().getEditDomain()).getData((Object)"SHOW_EVENTS");
        int n = intShowEvents = showEvents != null ? showEvents : 1;
        if (intShowEvents != 0) {
            List childJavaBeans = this.getChildJavaBeans();
            if (childJavaBeans != null) {
                ArrayList result = new ArrayList(childJavaBeans.size() + 1);
                result.addAll(this.getExistingEvents(intShowEvents));
                result.addAll(childJavaBeans);
                return result;
            }
            ArrayList result = new ArrayList(1);
            result.addAll(this.getExistingEvents(intShowEvents));
            return result;
        }
        return this.getChildJavaBeans();
    }

    public Object getAdapter(Class aKey) {
        Object result = super.getAdapter(aKey);
        if (result != null) {
            return result;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.IActionFilter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (aKey == clazz) {
            return this.getActionFilter();
        }
        Iterator mofAdapters = ((IJavaInstance)this.getModel()).eAdapters().iterator();
        while (mofAdapters.hasNext()) {
            Object mofAdapterAdapter;
            Object mofAdapter = mofAdapters.next();
            if (!(mofAdapter instanceof IAdaptable) || (mofAdapterAdapter = ((IAdaptable)mofAdapter).getAdapter(aKey)) == null) continue;
            return mofAdapterAdapter;
        }
        return null;
    }

    protected IActionFilter getActionFilter() {
        return JavaBeanActionFilter.INSTANCE;
    }

    public List getEditPolicies() {
        ArrayList<EditPolicy> result = new ArrayList<EditPolicy>();
        AbstractEditPart.EditPolicyIterator i = super.getEditPolicyIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    protected List getExistingEvents(int eventDepth) {
        List eventInvocations = (List)this.javaModel.eGet(this.getSFObjectEvents());
        switch (eventDepth) {
            case 1: {
                return this.getBasicEvents(eventInvocations);
            }
            case 2: {
                return this.getExpertEvents(eventInvocations);
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected Adapter getEventInvocationAdapter() {
        if (this.eventInvocationAdapter == null) {
            this.eventInvocationAdapter = new Adapter(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == JCMPackage.eINSTANCE.getAbstractEventInvocation_Callbacks()) {
                        JavaBeanTreeEditPart.this.refreshChildren();
                        JavaBeanTreeEditPart.this.refreshVisuals();
                    }
                }

                public Notifier getTarget() {
                    return null;
                }

                public void setTarget(Notifier newTarget) {
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }
            };
        }
        return this.eventInvocationAdapter;
    }

    protected Adapter getPropertyChangeEventInvocationAdapter() {
        if (this.propertyChangeEventInvocationAdapter == null) {
            this.propertyChangeEventInvocationAdapter = new Adapter(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == JCMPackage.eINSTANCE.getPropertyChangeEventInvocation_Properties()) {
                        JavaBeanTreeEditPart.this.refreshChildren();
                        JavaBeanTreeEditPart.this.refreshVisuals();
                    }
                }

                public Notifier getTarget() {
                    return null;
                }

                public void setTarget(Notifier newTarget) {
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }
            };
        }
        return this.propertyChangeEventInvocationAdapter;
    }

    protected List getBasicEvents(List eventInvocations) {
        if (eventInvocations.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Iterator iter = eventInvocations.iterator();
        ArrayList<Object> result = new ArrayList<Object>(3);
        while (iter.hasNext()) {
            AbstractEventInvocation eventInvocation = (AbstractEventInvocation)iter.next();
            if (eventInvocation instanceof EventInvocation) {
                Iterator callbacks = eventInvocation.getCallbacks().iterator();
                while (callbacks.hasNext()) {
                    Callback callback = (Callback)callbacks.next();
                    result.add(new EventCallback(eventInvocation, callback));
                }
                eventInvocation.eAdapters().add(this.getEventInvocationAdapter());
                if (this.eventInvocationsListenedTo == null) {
                    this.eventInvocationsListenedTo = new ArrayList(eventInvocations.size());
                }
                this.eventInvocationsListenedTo.add(eventInvocation);
                continue;
            }
            if (!(eventInvocation instanceof PropertyChangeEventInvocation)) continue;
            PropertyChangeEventInvocation propChangeEventInvocation = (PropertyChangeEventInvocation)eventInvocation;
            Iterator properties = propChangeEventInvocation.getProperties().iterator();
            while (properties.hasNext()) {
                PropertyEvent propEvent = (PropertyEvent)properties.next();
                result.add(propEvent);
            }
            propChangeEventInvocation.eAdapters().add(this.getPropertyChangeEventInvocationAdapter());
            if (this.propertyChangeEventInvocationsListenedTo == null) {
                this.propertyChangeEventInvocationsListenedTo = new ArrayList(1);
            }
            this.propertyChangeEventInvocationsListenedTo.add(propChangeEventInvocation);
        }
        Collections.sort(result, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object o1, Object o2) {
                if (o1 instanceof EventCallback) {
                    if (o2 instanceof PropertyEvent) {
                        return -1;
                    }
                    return this.coll.compare(((EventCallback)o1).getCallback().getMethod().getName(), ((EventCallback)o2).getCallback().getMethod().getName());
                }
                if (o2 instanceof EventCallback) {
                    return 1;
                }
                return this.coll.compare(((PropertyEvent)o1).getPropertyName(), ((PropertyEvent)o2).getPropertyName());
            }
        });
        return result;
    }

    protected List getExpertEvents(List eventInvocations) {
        ArrayList<EventInvocationAndListener> result = new ArrayList<EventInvocationAndListener>(3);
        if (eventInvocations.isEmpty()) {
            return eventInvocations;
        }
        if (eventInvocations.size() == 1) {
            AbstractEventInvocation eventInvocation = (AbstractEventInvocation)eventInvocations.get(0);
            Listener listener = eventInvocation.getListener();
            result.add(new EventInvocationAndListener(eventInvocation, listener));
            return result;
        }
        Iterator iter = eventInvocations.iterator();
        while (iter.hasNext()) {
            AbstractEventInvocation eventInvocation = (AbstractEventInvocation)iter.next();
            Listener listener = eventInvocation.getListener();
            Iterator iter1 = result.iterator();
            boolean foundExistingListener = false;
            while (iter1.hasNext()) {
                EventInvocationAndListener existing = (EventInvocationAndListener)iter1.next();
                if (existing.getListener() != listener) continue;
                foundExistingListener = true;
                existing.addEventInvocation(eventInvocation);
            }
            if (foundExistingListener) continue;
            result.add(new EventInvocationAndListener(eventInvocation, listener));
        }
        return result;
    }

    protected EditPart createChildEditPart(Object model) {
        return super.createChild(model);
    }

    protected final EditPart createChild(Object model) {
        if (model instanceof EventInvocationAndListener) {
            return new EventInvocationAndListenerTreeEditPart((EventInvocationAndListener)model, this.javaModel, false);
        }
        if (model instanceof EventCallback) {
            return new EventMethodTreeEditPart((EventCallback)model);
        }
        if (model instanceof PropertyEvent) {
            return new PropertyEventTreeEditPart((PropertyEvent)model);
        }
        return this.createChildEditPart(model);
    }

    private void removeEventInvocation(IJavaObjectInstance aJavaModel, AbstractEventInvocation anEventInvocation) {
        anEventInvocation.getCallbacks().clear();
        if (anEventInvocation instanceof PropertyChangeEventInvocation) {
            ((PropertyChangeEventInvocation)anEventInvocation).getProperties().clear();
        }
        ((EList)this.javaModel.eGet(this.getSFObjectEvents())).remove(anEventInvocation);
        Listener listener = anEventInvocation.getListener();
        anEventInvocation.setListener(null);
        if (listener.getListenedBy().isEmpty()) {
            ListenerType listenerType = listener.getListenerType();
            listenerType.getListeners().remove(listener);
            if (listenerType.getListeners().isEmpty()) {
                BeanComposition beanComposition = JavaBeanEventUtilities.getBeanComposition(this.javaModel);
                beanComposition.getListenerTypes().remove(listenerType);
            }
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("JAVABEANS_EVENTS", (EditPolicy)new JavaBeanEventsEditPolicy());
    }

    public static class JavaBeansImageDescriptor
    extends CompositeImageDescriptor {
        Image fBaseImage;
        int fSeverity;

        public JavaBeansImageDescriptor(Image anImage, int severity) {
            this.fBaseImage = anImage;
            this.fSeverity = severity;
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg = this.fBaseImage.getImageData();
            if (bg == null) {
                bg = ImageDescriptor.DEFAULT_IMAGE_DATA;
            }
            this.drawImage(bg, 0, 0);
            Point size = this.getSize();
            ImageData data = null;
            if (this.fSeverity == 3) {
                data = IErrorHolder.ErrorType.getSevereErrorImageOverlay().getImageData();
                this.drawImage(data, 0, size.y - data.height);
            } else if (this.fSeverity == 2) {
                data = IErrorHolder.ErrorType.getWarningErrorImageOverlay().getImageData();
                this.drawImage(data, 0, size.y - data.height);
            } else if (this.fSeverity == 1) {
                data = IErrorHolder.ErrorType.getInformationErrorImageOverlay().getImageData();
                this.drawImage(data, 0, size.y - data.height);
            }
        }

        protected Point getSize() {
            return new Point(this.fBaseImage.getBounds().width, this.fBaseImage.getBounds().height);
        }
    }

    class JavaBeanEventsEditPolicy
    extends AbstractEditPolicy {
        JavaBeanEventsEditPolicy() {
        }

        public Command getCommand(Request request) {
            if ("DELETE_EVENTS".equals(request.getType())) {
                Object childToDelete = ((ForwardedRequest)request).getSender().getModel();
                if (childToDelete instanceof Callback) {
                    if (((Callback)childToDelete).isSharedScope()) {
                        return null;
                    }
                    return new DeleteEventCallbackCommand((Callback)childToDelete);
                }
                if (childToDelete instanceof PropertyEvent) {
                    return new DeletePropertyEventCommand((PropertyEvent)childToDelete);
                }
                if (childToDelete instanceof EventInvocationAndListener) {
                    return new DeleteEventInvocationAndListenerCommand((EventInvocationAndListener)childToDelete);
                }
            }
            return null;
        }
    }

    class DeleteEventInvocationAndListenerCommand
    extends Command {
        EventInvocationAndListener eventInvocationAndListener;
        DeleteEventCallbackCommand deleteEventCallbackCommand;

        DeleteEventInvocationAndListenerCommand(EventInvocationAndListener anEventInvocationAndListener) {
            this.eventInvocationAndListener = anEventInvocationAndListener;
        }

        public void execute() {
            Iterator eventInvocations = this.eventInvocationAndListener.getEventInvocations().iterator();
            while (eventInvocations.hasNext()) {
                AbstractEventInvocation eventInvocation = (AbstractEventInvocation)eventInvocations.next();
                JavaBeanTreeEditPart.this.removeEventInvocation(JavaBeanTreeEditPart.this.javaModel, eventInvocation);
            }
        }
    }

    class DeleteEventCallbackCommand
    extends Command {
        Callback eventCallback;

        DeleteEventCallbackCommand(Callback aCallback) {
            this.eventCallback = aCallback;
        }

        public void execute() {
            AbstractEventInvocation eventInvocation = (AbstractEventInvocation)this.eventCallback.eContainer();
            eventInvocation.getCallbacks().remove(this.eventCallback);
            if (eventInvocation.getCallbacks().isEmpty()) {
                JavaBeanTreeEditPart.this.removeEventInvocation(JavaBeanTreeEditPart.this.javaModel, eventInvocation);
            }
        }
    }

    class DeletePropertyEventCommand
    extends Command {
        PropertyEvent propertyEvent;

        DeletePropertyEventCommand(PropertyEvent aPropertyEvent) {
            this.propertyEvent = aPropertyEvent;
        }

        public void execute() {
            PropertyChangeEventInvocation propertyChangeEventInvocation = (PropertyChangeEventInvocation)this.propertyEvent.eContainer();
            propertyChangeEventInvocation.getProperties().remove(this.propertyEvent);
            if (propertyChangeEventInvocation.getProperties().isEmpty()) {
                JavaBeanTreeEditPart.this.removeEventInvocation(JavaBeanTreeEditPart.this.javaModel, propertyChangeEventInvocation);
            }
        }
    }
}

