/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IClasspathContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class JavaConfigurationContributor
implements IConfigurationContributor {
    List variableContributors = new ArrayList(0);
    public List paletteCats;
    private int firstInsert = 0;
    IProject project;
    private static final IPath JRE_LIB_VARIABLE_PATH = new Path("JRE_LIB");

    public JavaConfigurationContributor(IProject project) {
        this.project = project;
    }

    public void contributeClasspaths(List classPaths, IClasspathContributionController controller) throws CoreException {
        controller.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromPluginDescriptorAndFragments(JavaVEPlugin.getPlugin().getDescriptor(), "vm/javaremotevm.jar"), classPaths, -1);
        HashSet visitedProjects = new HashSet();
        HashSet visitedVariablepaths = new HashSet();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.findContributorsForProject(this.project, root, visitedProjects, visitedVariablepaths);
        ListIterator<IConfigurationContributor> itr = this.variableContributors.listIterator();
        while (itr.hasNext()) {
            String ploc;
            String pcat;
            IConfigurationElement v = (IConfigurationElement)itr.next();
            IConfigurationContributor contrib = null;
            if (v.getAttribute("contributor") != null || v.getChildren("contributor").length > 0) {
                try {
                    contrib = (IConfigurationContributor)v.createExecutableExtension("contributor");
                }
                catch (ClassCastException e) {
                    JavaVEPlugin.log(e, 5);
                }
                catch (CoreException coreException) {}
            }
            itr.set(contrib);
            if (contrib != null) {
                contrib.contributeClasspaths(classPaths, controller);
            }
            if ((pcat = v.getAttributeAsIs("palettecats")) == null || pcat.length() <= 0) continue;
            if (this.paletteCats == null) {
                this.paletteCats = new ArrayList(3);
            }
            if ((ploc = v.getAttributeAsIs("paletteloc")) == null || ploc.equals("first")) {
                this.paletteCats.add(this.firstInsert++, pcat);
                continue;
            }
            this.paletteCats.add(pcat);
        }
    }

    protected void findContributorsForProject(IProject project, IWorkspaceRoot root, HashSet visitedProjects, HashSet visitedVariablePaths) throws CoreException {
        if (visitedProjects.contains(project)) {
            return;
        }
        visitedProjects.add(project);
        IJavaProject jProject = JavaCore.create((IProject)project);
        IClasspathEntry[] rawPath = jProject.getRawClasspath();
        int i = 0;
        while (i < rawPath.length) {
            IClasspathEntry entry = rawPath[i];
            this.processBuildPath(visitedProjects, visitedVariablePaths, root, entry.getEntryKind(), entry.getPath());
            ++i;
        }
    }

    protected void processBuildPath(HashSet visitedProjects, HashSet visitedVariablePaths, IWorkspaceRoot root, int kind, IPath path) throws CoreException {
        if (kind == 2) {
            IProject reqProject = (IProject)root.findMember(path.lastSegment());
            if (reqProject != null && reqProject.isOpen()) {
                this.findContributorsForProject(reqProject, root, visitedProjects, visitedVariablePaths);
            }
        } else if (kind == 4) {
            IConfigurationElement[] registrations;
            IPath varpath;
            if (path == null || path.segmentCount() == 0) {
                return;
            }
            IPath iPath = varpath = path.segmentCount() == 1 ? path : path.removeLastSegments(path.segmentCount() - 1);
            if (!visitedVariablePaths.contains(varpath)) {
                visitedVariablePaths.add(varpath);
                registrations = JavaVEPlugin.getPlugin().getRegistrations(varpath);
                if (registrations != null) {
                    this.processConfigurationRegistrations(registrations);
                }
            }
            if (path.segmentCount() > 1 && !visitedVariablePaths.contains(path)) {
                visitedVariablePaths.add(path);
                registrations = JavaVEPlugin.getPlugin().getRegistrations(path);
                if (registrations != null) {
                    this.processConfigurationRegistrations(registrations);
                }
            }
        } else if (kind == 5) {
            if (path == null || path.segmentCount() == 0) {
                return;
            }
            if (path.segment(0).equals(JavaRuntime.JRE_CONTAINER) && !visitedVariablePaths.contains(JRE_LIB_VARIABLE_PATH)) {
                visitedVariablePaths.add(JRE_LIB_VARIABLE_PATH);
                IConfigurationElement[] registrations = JavaVEPlugin.getPlugin().getRegistrations(JRE_LIB_VARIABLE_PATH);
                if (registrations != null) {
                    this.processConfigurationRegistrations(registrations);
                }
            }
        }
    }

    protected void processConfigurationRegistrations(IConfigurationElement[] registrations) {
        int i = 0;
        while (i < registrations.length) {
            this.variableContributors.add(registrations[i]);
            ++i;
        }
    }

    public void contributeToConfiguration(VMRunnerConfiguration config) {
        int i = 0;
        while (i < this.variableContributors.size()) {
            IConfigurationContributor contrib = (IConfigurationContributor)this.variableContributors.get(i);
            if (contrib != null) {
                contrib.contributeToConfiguration(config);
            }
            ++i;
        }
    }

    public void contributeToRegistry(ProxyFactoryRegistry registry) {
        IBeanTypeProxy aSetupBeanTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.java.remotevm.Setup");
        IMethodProxy setupMethodProxy = aSetupBeanTypeProxy.getMethodProxy("setup");
        setupMethodProxy.invokeCatchThrowableExceptions((IBeanProxy)aSetupBeanTypeProxy);
        int i = 0;
        while (i < this.variableContributors.size()) {
            IConfigurationContributor contrib = (IConfigurationContributor)this.variableContributors.get(i);
            if (contrib != null) {
                contrib.contributeToRegistry(registry);
            }
            ++i;
        }
    }
}

