/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.internal.core.EclipseLogMsgLogger;
import org.eclipse.jem.internal.core.MsgLogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class JavaVEPlugin
extends AbstractUIPlugin {
    public static final String PI_JBCF = "org.eclipse.ve.internal.java.core";
    public static final String PI_JBCF_REGISTRATIONS = "registrations";
    public static final String PI_VARIABLE = "variable";
    public static final String PI_PATH = "path";
    public static final String PI_CONTRIBUTOR = "contributor";
    public static final String PI_PALETTECATS = "palettecats";
    public static final String PI_RUNTIME = "runtime";
    public static final String PI_SOURCE = "source";
    public static final String PI_SOURCEPREFIX = "prefix";
    public static final String PI_EXTEND = "extend";
    private static JavaVEPlugin PLUGIN;
    private static MsgLogger msgLogger;
    public static Image fJavaBeanImage;
    public static Image fAppletImage;
    public static Image CHECK_IMAGE;
    private HashMap variableContributors = new HashMap();
    private static ImageDescriptor WIZARD_TITLE_DESC;
    public static final String SHOW_EVENTS = "SHOW_EVENTS";
    public static final int EVENTS_NONE = 0;
    public static final int EVENTS_BASIC = 1;
    public static final int EVENTS_EXPERT = 2;

    static {
        msgLogger = null;
    }

    public JavaVEPlugin(IPluginDescriptor pd) {
        super(pd);
        PLUGIN = this;
    }

    public static JavaVEPlugin getPlugin() {
        return PLUGIN;
    }

    public void startup() throws CoreException {
        super.startup();
        this.processRegistrationExtensionPoint();
    }

    protected void processRegistrationExtensionPoint() {
        HashMap<Path, ArrayList<IConfigurationElement>> registrations = new HashMap<Path, ArrayList<IConfigurationElement>>();
        IConfigurationElement[] configs = this.getDescriptor().getExtensionPoint(PI_JBCF_REGISTRATIONS).getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            String varpathstr;
            IConfigurationElement iConfigurationElement = configs[i];
            if (PI_VARIABLE.equals(iConfigurationElement.getName()) && (iConfigurationElement.getAttributeAsIs(PI_CONTRIBUTOR) != null || iConfigurationElement.getChildren(PI_CONTRIBUTOR).length > 0 || iConfigurationElement.getAttributeAsIs(PI_PALETTECATS) != null) && (varpathstr = iConfigurationElement.getAttributeAsIs(PI_PATH)) != null) {
                Path varpath = new Path(varpathstr);
                ArrayList<IConfigurationElement> varentry = (ArrayList<IConfigurationElement>)registrations.get(varpath);
                if (varentry == null) {
                    varentry = new ArrayList<IConfigurationElement>(1);
                    registrations.put(varpath, varentry);
                }
                varentry.add(iConfigurationElement);
            }
            ++i;
        }
        Iterator regItr = registrations.entrySet().iterator();
        while (regItr.hasNext()) {
            Map.Entry entry = regItr.next();
            List registrationsList = (List)entry.getValue();
            this.registerRegistration((IPath)entry.getKey(), registrationsList.toArray(new IConfigurationElement[registrationsList.size()]));
        }
    }

    public void registerRegistration(IPath path, IConfigurationElement registration) {
        IConfigurationElement[] registered = (IConfigurationElement[])this.variableContributors.get(path);
        if (registered == null) {
            registered = new IConfigurationElement[]{registration};
        } else {
            IConfigurationElement[] old = registered;
            registered = new IConfigurationElement[old.length + 1];
            System.arraycopy(old, 0, registered, 0, old.length);
            registered[old.length] = registration;
        }
        this.variableContributors.put(path, registered);
    }

    public void registerRegistration(IPath path, IConfigurationElement[] registrations) {
        IConfigurationElement[] registered = (IConfigurationElement[])this.variableContributors.get(path);
        if (registered == null) {
            registered = new IConfigurationElement[registrations.length];
            System.arraycopy(registrations, 0, registered, 0, registrations.length);
        } else {
            IConfigurationElement[] old = registered;
            registered = new IConfigurationElement[old.length + registrations.length];
            System.arraycopy(old, 0, registered, 0, old.length);
            System.arraycopy(registrations, 0, registered, old.length, registrations.length);
        }
        this.variableContributors.put(path, registered);
    }

    public IConfigurationElement[] getRegistrations(IPath path) {
        return (IConfigurationElement[])this.variableContributors.get(path);
    }

    public MsgLogger getMsgLogger() {
        if (msgLogger == null) {
            msgLogger = EclipseLogMsgLogger.createLogger((Plugin)this);
        }
        return msgLogger;
    }

    public static void log(Object obj) {
        JavaVEPlugin.getPlugin().getMsgLogger().log(obj);
    }

    public static void log(Object obj, int level) {
        JavaVEPlugin.getPlugin().getMsgLogger().log(obj, level);
    }

    public static void log(Throwable e) {
        JavaVEPlugin.getPlugin().getMsgLogger().log(e);
    }

    public static void log(Throwable e, int level) {
        JavaVEPlugin.getPlugin().getMsgLogger().log(e, level);
    }

    public static void log(IStatus status) {
        JavaVEPlugin.getPlugin().getMsgLogger().log((Object)status);
    }

    public static void log(IStatus status, int logLevel) {
        JavaVEPlugin.getPlugin().getMsgLogger().log((Object)status, logLevel);
    }

    public static Image getJavaBeanImage() {
        if (fJavaBeanImage == null) {
            fJavaBeanImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/javabean.gif");
        }
        return fJavaBeanImage;
    }

    public static Image getAppletImage() {
        if (fAppletImage == null) {
            fAppletImage = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/applet.gif");
        }
        return fAppletImage;
    }

    public static ImageDescriptor getWizardTitleImageDescriptor() {
        if (WIZARD_TITLE_DESC == null) {
            WIZARD_TITLE_DESC = CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/wizban/javabean_wiz.gif");
        }
        return WIZARD_TITLE_DESC;
    }

    public static Image getCheckImage() {
        if (CHECK_IMAGE == null) {
            CHECK_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/booleantrue.gif");
        }
        return CHECK_IMAGE;
    }

    protected void initializeDefaultPluginPreferences() {
        super.initializeDefaultPluginPreferences();
        this.getPluginPreferences().setDefault(SHOW_EVENTS, 1);
        VCEPreferences.initializeDefaultPluginPreferences(this.getPluginPreferences());
    }

    public void shutdown() throws CoreException {
        this.savePluginPreferences();
    }
}

