/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.StringTokenizer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.DefaultJavaClassCellEditor;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.RectangleJavaClassLabelProvider;

public class RectangleJavaClassCellEditor
extends DefaultJavaClassCellEditor {
    public RectangleJavaClassCellEditor(Composite aComposite) {
        super(aComposite);
    }

    protected String doGetString(Object value) {
        if (this.isInstance(value)) {
            return RectangleJavaClassLabelProvider.toString((IJavaInstance)value);
        }
        return null;
    }

    protected String getJavaInitializationString(String rectString) {
        StringTokenizer st = new StringTokenizer(rectString, ",");
        StringBuffer sb = new StringBuffer(rectString.length());
        sb.append("new java.awt.Rectangle(");
        sb.append(st.nextToken().trim());
        while (st.hasMoreTokens()) {
            sb.append(',');
            sb.append(st.nextToken().trim());
        }
        sb.append(')');
        return sb.toString();
    }

    protected String isCorrectString(String text) {
        StringTokenizer st = new StringTokenizer(text, ",");
        String[] tokenMsgs = new String[]{JavaMessages.getString("CellEditor.Rectangle.XErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.YErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.WidthErrorMsg_ERROR_"), JavaMessages.getString("CellEditor.Rectangle.HeightErrorMsg_ERROR_")};
        if (st.countTokens() != tokenMsgs.length) {
            return JavaMessages.getString("CellEditor.Rectangle.ErrorMsg_ERROR_");
        }
        int i = 0;
        while (i < tokenMsgs.length) {
            String field = st.nextToken().trim();
            try {
                Integer.decode(field);
            }
            catch (NumberFormatException numberFormatException) {
                return tokenMsgs[i];
            }
            ++i;
        }
        return null;
    }

    public void setData(Object data) {
        super.setData(data);
        this.setJavaType(JavaClassImpl.reflect((String)"java.awt.Rectangle", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain)));
    }

    public static String getJavaInitializationString(Rectangle rect) {
        return RectangleJavaClassCellEditor.getJavaInitializationString(rect.x, rect.y, rect.width, rect.height);
    }

    public static String getJavaInitializationString(int x, int y, int width, int height) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new java.awt.Rectangle(");
        buffer.append(String.valueOf(x));
        buffer.append(',');
        buffer.append(String.valueOf(y));
        buffer.append(',');
        buffer.append(String.valueOf(width));
        buffer.append(',');
        buffer.append(String.valueOf(height));
        buffer.append(')');
        return buffer.toString();
    }
}

