/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.rules;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ve.internal.cde.rules.IRule;
import org.eclipse.ve.internal.cde.rules.IRuleRegistry;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.IRuleProvider;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;

public class DefaultRuleProvider
implements IRuleProvider {
    public static final String EXT_ID = "id";
    public static final String EXT_CLASS = "class";
    public static final String RulePath = "Rules";
    protected IRule fRule = null;
    protected IConfigurationElement ce;
    protected String fID;
    protected String fStyleID;
    protected int fTimeStamp = 0;
    protected IRuleRegistry ruleRegistry;
    private boolean noRule;

    public DefaultRuleProvider(IConfigurationElement ce, String styleID, IRuleRegistry registry) {
        this.ce = ce;
        this.fStyleID = styleID;
        this.fID = ce.getAttribute(EXT_ID);
        this.ruleRegistry = registry;
    }

    public IRule getRule() {
        if (this.noRule) {
            return null;
        }
        if (this.fRule == null) {
            try {
                this.fRule = (IRule)this.ce.createExecutableExtension(EXT_CLASS);
                this.fRule.setRegistry(this.ruleRegistry);
            }
            catch (CoreException e) {
                this.noRule = true;
                JavaVEPlugin.log(e);
                return null;
            }
            catch (ClassCastException e) {
                this.noRule = true;
                JavaVEPlugin.log(e);
                return null;
            }
        }
        return this.fRule;
    }

    public long getTimeStamp() {
        return this.fTimeStamp;
    }

    public String getSourceLocation() {
        IRule rule = this.getRule();
        if (rule != null) {
            return TemplateUtil.getPluginInstallPath(this.ce.getDeclaringExtension().getDeclaringPluginDescriptor(), rule.getClass().getName().replace('.', '/'));
        }
        return null;
    }

    public String getStyle() {
        return this.fStyleID;
    }

    public String getRuleID() {
        return this.fID;
    }

    public String toString() {
        return "Default Rule(id=" + this.getRuleID() + "class=" + this.ce.getAttributeAsIs(EXT_CLASS) + ")";
    }

    public String getProviderID() {
        return this.ce.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
    }
}

